/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.table;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.Session;
import info.archinnov.achilles.exception.AchillesInvalidTableException;
import info.archinnov.achilles.internal.context.ConfigurationContext;
import info.archinnov.achilles.internal.cql.TypeMapper;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import info.archinnov.achilles.schemabuilder.Create;
import info.archinnov.achilles.schemabuilder.SchemaBuilder;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableCreator {
    static final String ACHILLES_DDL_SCRIPT = "ACHILLES_DDL_SCRIPT";
    private static final Logger log = LoggerFactory.getLogger(TableCreator.class);
    private static final Logger DML_LOG = LoggerFactory.getLogger((String)"ACHILLES_DDL_SCRIPT");

    public void createTableForEntity(Session session, EntityMeta entityMeta, ConfigurationContext configContext) {
        log.debug("Create table for entity {}", (Object)entityMeta);
        String tableName = entityMeta.config().getQualifiedTableName();
        if (!configContext.isForceColumnFamilyCreation()) {
            throw new AchillesInvalidTableException(String.format("The required table '%s' does not exist for entity '%s'", tableName, entityMeta.getClassName()));
        }
        log.debug("Force creation of table for entityMeta {}", (Object)entityMeta.getClassName());
        this.createTableForEntity(session, entityMeta);
    }

    private void createTableForEntity(Session session, EntityMeta entityMeta) {
        log.debug("Creating table for entityMeta {}", (Object)entityMeta.getClassName());
        if (entityMeta.structure().isClusteredCounter()) {
            this.createTableForClusteredCounter(session, entityMeta);
        } else {
            this.createTable(session, entityMeta);
        }
    }

    public void createTableForCounter(Session session, ConfigurationContext configContext) {
        log.debug("Create table for Achilles counters");
        if (!configContext.isForceColumnFamilyCreation()) {
            throw new AchillesInvalidTableException("The required generic table 'achilles_counter_table' does not exist");
        }
        String createTable = ((Create.Options)SchemaBuilder.createTable("achilles_counter_table").addPartitionKey("fqcn", DataType.text()).addPartitionKey("primary_key", DataType.text()).addClusteringKey("property_name", DataType.text()).addColumn("counter_value", DataType.counter()).withOptions().comment("Create default Achilles counter table \"achilles_counter_table\"")).build();
        session.execute(createTable);
    }

    private void createTable(Session session, EntityMeta entityMeta) {
        String qualifiedTableName = entityMeta.config().getQualifiedTableName();
        LinkedList<String> indexes = new LinkedList<String>();
        Create createTable = SchemaBuilder.createTable(qualifiedTableName);
        for (PropertyMeta pm : entityMeta.getAllMetasExceptIdAndCounters()) {
            String cql3ColumnName = pm.getCQL3ColumnName();
            Class valueClass = pm.config().getCQL3ValueType();
            boolean staticColumn = pm.structure().isStaticColumn();
            switch (pm.type()) {
                case SIMPLE: {
                    createTable.addColumn(cql3ColumnName, TypeMapper.toCQLDataType(valueClass), staticColumn);
                    if (!pm.structure().isIndexed()) break;
                    indexes.add(pm.forTableCreation().createNewIndexScript(entityMeta.config().getTableName()));
                    break;
                }
                case LIST: {
                    createTable.addColumn(cql3ColumnName, DataType.list((DataType)TypeMapper.toCQLDataType(valueClass)), staticColumn);
                    break;
                }
                case SET: {
                    createTable.addColumn(cql3ColumnName, DataType.set((DataType)TypeMapper.toCQLDataType(valueClass)), staticColumn);
                    break;
                }
                case MAP: {
                    Class keyClass = pm.config().getCQL3KeyType();
                    createTable.addColumn(cql3ColumnName, DataType.map((DataType)TypeMapper.toCQLDataType(keyClass), (DataType)TypeMapper.toCQLDataType(valueClass)), staticColumn);
                    break;
                }
            }
        }
        PropertyMeta idMeta = entityMeta.getIdMeta();
        this.buildPrimaryKey(idMeta, createTable);
        Create.Options tableOptions = createTable.withOptions();
        idMeta.forTableCreation().addClusteringOrder(tableOptions);
        String tableComment = entityMeta.config().getTableComment();
        if (StringUtils.isNotBlank((CharSequence)tableComment)) {
            tableOptions.comment(tableComment);
        }
        String createTableScript = tableOptions.build();
        session.execute(createTableScript);
        DML_LOG.debug(createTableScript);
        if (!indexes.isEmpty()) {
            for (String indexScript : indexes) {
                session.execute(indexScript);
                DML_LOG.debug(indexScript);
            }
        }
    }

    private void createTableForClusteredCounter(Session session, EntityMeta meta) {
        log.debug("Creating table for clustered counter entity {}", (Object)meta.getClassName());
        Create createTable = SchemaBuilder.createTable(meta.config().getQualifiedTableName());
        PropertyMeta idMeta = meta.getIdMeta();
        this.buildPrimaryKey(idMeta, createTable);
        for (PropertyMeta counterMeta : meta.getAllCounterMetas()) {
            createTable.addColumn(counterMeta.getCQL3ColumnName(), DataType.counter(), counterMeta.structure().isStaticColumn());
        }
        Create.Options tableOptions = createTable.withOptions();
        idMeta.forTableCreation().addClusteringOrder(tableOptions);
        tableOptions.comment(meta.config().getTableComment());
        String createTableScript = tableOptions.build();
        session.execute(createTableScript);
        DML_LOG.debug(createTableScript);
    }

    private List<Create.Options.ClusteringOrder> buildPrimaryKey(PropertyMeta pm, Create createTable) {
        LinkedList<Create.Options.ClusteringOrder> clusteringOrders = new LinkedList<Create.Options.ClusteringOrder>();
        if (pm.structure().isEmbeddedId()) {
            pm.forTableCreation().addPartitionKeys(createTable);
            pm.forTableCreation().addClusteringKeys(createTable);
        } else {
            String cql3ColumnName = pm.getCQL3ColumnName();
            createTable.addPartitionKey(cql3ColumnName, TypeMapper.toCQLDataType(pm.config().getCQL3ValueType()));
        }
        return clusteringOrders;
    }

    public static enum Singleton {
        INSTANCE;

        private final TableCreator instance = new TableCreator();

        public TableCreator get() {
            return this.instance;
        }
    }
}

