/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.table;

import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.TableMetadata;
import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import info.archinnov.achilles.internal.cql.TypeMapper;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import info.archinnov.achilles.schemabuilder.SchemaBuilder;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableUpdater {
    private static final Logger log = LoggerFactory.getLogger(TableUpdater.class);
    private static final Logger DML_LOG = LoggerFactory.getLogger((String)"ACHILLES_DDL_SCRIPT");
    private static final Function<ColumnMetadata, String> COLUMN_NAME_EXTRACTOR = new Function<ColumnMetadata, String>(){

        public String apply(ColumnMetadata columnMetadata) {
            return columnMetadata.getName();
        }
    };

    public void updateTableForEntity(Session session, EntityMeta entityMeta, TableMetadata tableMetadata) {
        log.debug("Updating table for entityMeta {}", (Object)entityMeta.getClassName());
        if (!entityMeta.config().isSchemaUpdateEnabled()) {
            return;
        }
        List existingColumns = tableMetadata.getColumns();
        List<PropertyMeta> propertyMetas = entityMeta.getAllMetasExceptId();
        ImmutableSet columnNames = FluentIterable.from((Iterable)existingColumns).transform(COLUMN_NAME_EXTRACTOR).toSet();
        this.addNewPropertiesToBuilder(session, entityMeta, propertyMetas, (Set<String>)columnNames);
    }

    private void addNewPropertiesToBuilder(Session session, EntityMeta entityMeta, List<PropertyMeta> propertyMetas, Set<String> columnNames) {
        String tableName = entityMeta.config().getQualifiedTableName();
        for (PropertyMeta propertyMeta : propertyMetas) {
            String cql3ColumnName = propertyMeta.getCQL3ColumnName();
            if (columnNames.contains(cql3ColumnName)) continue;
            Class valueClass = propertyMeta.config().getCQL3ValueType();
            boolean staticColumn = propertyMeta.structure().isStaticColumn();
            String alterTableScript = "";
            switch (propertyMeta.type()) {
                case SIMPLE: {
                    alterTableScript = SchemaBuilder.alterTable(tableName).addColumn(cql3ColumnName, staticColumn).type(TypeMapper.toCQLDataType(valueClass));
                    session.execute(alterTableScript);
                    break;
                }
                case LIST: {
                    alterTableScript = SchemaBuilder.alterTable(tableName).addColumn(cql3ColumnName, staticColumn).type(DataType.list((DataType)TypeMapper.toCQLDataType(valueClass)));
                    session.execute(alterTableScript);
                    break;
                }
                case SET: {
                    alterTableScript = SchemaBuilder.alterTable(tableName).addColumn(cql3ColumnName, staticColumn).type(DataType.set((DataType)TypeMapper.toCQLDataType(valueClass)));
                    session.execute(alterTableScript);
                    break;
                }
                case MAP: {
                    Class keyClass = propertyMeta.config().getCQL3KeyType();
                    alterTableScript = SchemaBuilder.alterTable(tableName).addColumn(cql3ColumnName, staticColumn).type(DataType.map((DataType)TypeMapper.toCQLDataType(keyClass), (DataType)TypeMapper.toCQLDataType(valueClass)));
                    session.execute(alterTableScript);
                    break;
                }
                case COUNTER: {
                    if (!entityMeta.structure().isClusteredCounter()) break;
                    alterTableScript = SchemaBuilder.alterTable(tableName).addColumn(cql3ColumnName, staticColumn).type(DataType.counter());
                    session.execute(alterTableScript);
                    break;
                }
            }
            if (StringUtils.isNotBlank((CharSequence)alterTableScript)) {
                DML_LOG.debug(alterTableScript);
            }
            if (!propertyMeta.structure().isIndexed()) continue;
            String createIndexScript = propertyMeta.forTableCreation().createNewIndexScript(tableName);
            session.execute(createIndexScript);
            DML_LOG.debug(createIndexScript);
        }
    }

    public static enum Singleton {
        INSTANCE;

        private final TableUpdater instance = new TableUpdater();

        public TableUpdater get() {
            return this.instance;
        }
    }
}

