/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.table;

import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.TableMetadata;
import info.archinnov.achilles.internal.context.ConfigurationContext;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import info.archinnov.achilles.internal.metadata.holder.PropertyMetaTableValidator;
import info.archinnov.achilles.internal.table.ColumnMetaDataComparator;
import info.archinnov.achilles.internal.validation.Validator;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableValidator {
    private static final Logger log = LoggerFactory.getLogger(TableValidator.class);
    private ColumnMetaDataComparator columnMetaDataComparator = ColumnMetaDataComparator.Singleton.INSTANCE.get();

    public void validateForEntity(EntityMeta entityMeta, TableMetadata tableMetadata, ConfigurationContext configContext) {
        log.debug("Validate existing table {} for {}", (Object)tableMetadata.getName(), (Object)entityMeta);
        PropertyMeta idMeta = entityMeta.getIdMeta();
        PropertyMetaTableValidator primaryKeyValidator = idMeta.forTableValidation();
        if (entityMeta.structure().isEmbeddedId()) {
            primaryKeyValidator.validatePrimaryKeyComponents(tableMetadata, true);
            primaryKeyValidator.validatePrimaryKeyComponents(tableMetadata, false);
        } else {
            primaryKeyValidator.validateColumn(tableMetadata, entityMeta, configContext);
        }
        for (PropertyMeta pm : entityMeta.getAllMetasExceptIdAndCounters()) {
            PropertyMetaTableValidator columnValidator = pm.forTableValidation();
            switch (pm.type()) {
                case SIMPLE: {
                    columnValidator.validateColumn(tableMetadata, entityMeta, configContext);
                    break;
                }
                case LIST: 
                case SET: 
                case MAP: {
                    columnValidator.validateCollectionAndMapColumn(tableMetadata, entityMeta);
                    break;
                }
            }
        }
        if (entityMeta.structure().isClusteredCounter()) {
            for (PropertyMeta counterMeta : entityMeta.getAllCounterMetas()) {
                counterMeta.forTableValidation().validateClusteredCounterColumn(tableMetadata, entityMeta);
            }
        }
    }

    public void validateAchillesCounter(KeyspaceMetadata keyspaceMetaData, String keyspaceName) {
        log.debug("Validate existing Achilles Counter table");
        DataType.Name textTypeName = DataType.text().getName();
        DataType.Name counterTypeName = DataType.counter().getName();
        TableMetadata tableMetaData = keyspaceMetaData.getTable("achilles_counter_table");
        Validator.validateTableTrue(tableMetaData != null, "Cannot find table '%s' from keyspace '%s'", "achilles_counter_table", keyspaceName);
        ColumnMetadata fqcnColumn = tableMetaData.getColumn("fqcn");
        Validator.validateTableTrue(fqcnColumn != null, "Cannot find column '%s' from table '%s'", "fqcn", "achilles_counter_table");
        Validator.validateTableTrue(fqcnColumn.getType().getName() == textTypeName, "Column '%s' of type '%s' should be of type '%s'", "fqcn", fqcnColumn.getType().getName(), textTypeName);
        Validator.validateBeanMappingTrue(this.hasColumnMeta(tableMetaData.getPartitionKey(), fqcnColumn), "Column '%s' of table '%s' should be a partition key component", "fqcn", "achilles_counter_table");
        ColumnMetadata pkColumn = tableMetaData.getColumn("primary_key");
        Validator.validateTableTrue(pkColumn != null, "Cannot find column '%s' from table '%s'", "primary_key", "achilles_counter_table");
        Validator.validateTableTrue(pkColumn.getType().getName() == textTypeName, "Column '%s' of type '%s' should be of type '%s'", "primary_key", pkColumn.getType().getName(), textTypeName);
        Validator.validateBeanMappingTrue(this.hasColumnMeta(tableMetaData.getPartitionKey(), pkColumn), "Column '%s' of table '%s' should be a partition key component", "primary_key", "achilles_counter_table");
        ColumnMetadata propertyNameColumn = tableMetaData.getColumn("property_name");
        Validator.validateTableTrue(propertyNameColumn != null, "Cannot find column '%s' from table '%s'", "property_name", "achilles_counter_table");
        Validator.validateTableTrue(propertyNameColumn.getType().getName() == textTypeName, "Column '%s' of type '%s' should be of type '%s'", "property_name", propertyNameColumn.getType().getName(), textTypeName);
        Validator.validateBeanMappingTrue(this.hasColumnMeta(tableMetaData.getClusteringColumns(), propertyNameColumn), "Column '%s' of table '%s' should be a clustering key component", "property_name", "achilles_counter_table");
        ColumnMetadata counterValueColumn = tableMetaData.getColumn("counter_value");
        Validator.validateTableTrue(counterValueColumn != null, "Cannot find column '%s' from table '%s'", "counter_value", "achilles_counter_table");
        Validator.validateTableTrue(counterValueColumn.getType().getName() == counterTypeName, "Column '%s' of type '%s' should be of type '%s'", "counter_value", counterValueColumn.getType().getName(), counterTypeName);
    }

    private boolean hasColumnMeta(Collection<ColumnMetadata> columnMetadatas, ColumnMetadata columnMetaToVerify) {
        boolean fqcnColumnMatches = false;
        for (ColumnMetadata columnMetadata : columnMetadatas) {
            fqcnColumnMatches = fqcnColumnMatches || this.columnMetaDataComparator.isEqual(columnMetaToVerify, columnMetadata);
        }
        return fqcnColumnMatches;
    }

    public static enum Singleton {
        INSTANCE;

        private final TableValidator instance = new TableValidator();

        public TableValidator get() {
            return this.instance;
        }
    }
}

