/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationIntrospector;

public enum DefaultJacksonMapper {
    DEFAULT(DefaultJacksonMapper.defaultJacksonMapper()),
    COUNTER(DefaultJacksonMapper.defaultJacksonMapperForCounterKey());

    private final ObjectMapper jacksonMapper;

    private DefaultJacksonMapper(ObjectMapper jacksonMapper) {
        this.jacksonMapper = jacksonMapper;
    }

    public ObjectMapper get() {
        return this.jacksonMapper;
    }

    private static ObjectMapper defaultJacksonMapper() {
        ObjectMapper defaultMapper = new ObjectMapper();
        defaultMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        defaultMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JacksonAnnotationIntrospector primary = new JacksonAnnotationIntrospector();
        JaxbAnnotationIntrospector secondary = new JaxbAnnotationIntrospector(TypeFactory.defaultInstance());
        defaultMapper.setAnnotationIntrospector(AnnotationIntrospector.pair((AnnotationIntrospector)primary, (AnnotationIntrospector)secondary));
        return defaultMapper;
    }

    private static ObjectMapper defaultJacksonMapperForCounterKey() {
        ObjectMapper defaultMapper = new ObjectMapper();
        defaultMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        defaultMapper.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
        defaultMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JacksonAnnotationIntrospector primary = new JacksonAnnotationIntrospector();
        JaxbAnnotationIntrospector secondary = new JaxbAnnotationIntrospector(TypeFactory.defaultInstance());
        defaultMapper.setAnnotationIntrospector(AnnotationIntrospector.pair((AnnotationIntrospector)primary, (AnnotationIntrospector)secondary));
        return defaultMapper;
    }
}

