/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.persistence;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import info.archinnov.achilles.async.AchillesFuture;
import info.archinnov.achilles.internal.async.AsyncUtils;
import info.archinnov.achilles.internal.context.ConfigurationContext;
import info.archinnov.achilles.internal.context.DaoContext;
import info.archinnov.achilles.internal.context.PersistenceContextFactory;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.persistence.CommonBatch;
import info.archinnov.achilles.type.Empty;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncBatch
extends CommonBatch {
    private static final Logger log = LoggerFactory.getLogger(AsyncBatch.class);
    private AsyncUtils asyncUtils = AsyncUtils.Singleton.INSTANCE.get();

    AsyncBatch(Map<Class<?>, EntityMeta> entityMetaMap, PersistenceContextFactory contextFactory, DaoContext daoContext, ConfigurationContext configContext, boolean orderedBatch) {
        super(entityMetaMap, contextFactory, daoContext, configContext, orderedBatch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AchillesFuture<Empty> endBatch() {
        log.debug("Flushing batch asynchronously");
        try {
            ListenableFuture listenableFuture = this.flushContext.flushBatch();
            return listenableFuture;
        }
        finally {
            this.flushContext = this.flushContext.duplicateWithNoData(this.defaultConsistencyLevel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AchillesFuture<Empty> endBatch(FutureCallback<Object> ... asyncListeners) {
        log.debug("Flushing batch asynchronously");
        try {
            ExecutorService executorService = this.configContext.getExecutorService();
            ListenableFuture emptyFuture = this.flushContext.flushBatch();
            this.asyncUtils.maybeAddAsyncListeners(emptyFuture, asyncListeners, executorService);
            AchillesFuture<Empty> achillesFuture = this.asyncUtils.buildInterruptible(emptyFuture);
            return achillesFuture;
        }
        finally {
            this.flushContext = this.flushContext.duplicateWithNoData(this.defaultConsistencyLevel);
        }
    }
}

