/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.persistence;

import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Session;
import info.archinnov.achilles.async.AchillesFuture;
import info.archinnov.achilles.exception.AchillesStaleObjectStateException;
import info.archinnov.achilles.internal.context.ConfigurationContext;
import info.archinnov.achilles.internal.context.DaoContext;
import info.archinnov.achilles.internal.context.PersistenceContextFactory;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.persistence.AsyncBatch;
import info.archinnov.achilles.persistence.CommonAsyncManager;
import info.archinnov.achilles.query.cql.NativeQuery;
import info.archinnov.achilles.query.slice.SliceQueryBuilder;
import info.archinnov.achilles.query.typed.TypedQuery;
import info.archinnov.achilles.type.IndexCondition;
import info.archinnov.achilles.type.Options;
import info.archinnov.achilles.type.OptionsBuilder;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncManager
extends CommonAsyncManager {
    private static final Logger log = LoggerFactory.getLogger(AsyncManager.class);

    protected AsyncManager(Map<Class<?>, EntityMeta> entityMetaMap, PersistenceContextFactory contextFactory, DaoContext daoContext, ConfigurationContext configContext) {
        super(entityMetaMap, contextFactory, daoContext, configContext);
    }

    public <T> AchillesFuture<T> find(Class<T> entityClass, Object primaryKey) {
        log.debug("Find entity class '{}' with primary key '{}'", entityClass, primaryKey);
        return super.asyncFind(entityClass, primaryKey, OptionsBuilder.noOptions());
    }

    public <T> AchillesFuture<T> find(Class<T> entityClass, Object primaryKey, Options options) {
        log.debug("Find entity class '{}' with primary key '{}' and options '{}'", new Object[]{entityClass, primaryKey, options});
        return super.asyncFind(entityClass, primaryKey, options);
    }

    public <T> AchillesFuture<T> getProxy(Class<T> entityClass, Object primaryKey) {
        log.debug("Get reference asynchronously for entity class '{}' with primary key {}", entityClass, primaryKey);
        return super.asyncGetProxy(entityClass, primaryKey, OptionsBuilder.noOptions());
    }

    public <T> AchillesFuture<T> getProxy(Class<T> entityClass, Object primaryKey, Options options) {
        log.debug("Get reference asynchronously for entity class '{}' with primary key {} and options {}", new Object[]{entityClass, primaryKey, options});
        return super.asyncGetProxy(entityClass, primaryKey, options);
    }

    public <T> AchillesFuture<T> refresh(T entity) throws AchillesStaleObjectStateException {
        log.debug("Refreshing entity '{}' asynchronously", this.proxifier.removeProxy(entity));
        return super.asyncRefresh(entity, OptionsBuilder.noOptions());
    }

    public <T> AchillesFuture<T> refresh(T entity, Options options) throws AchillesStaleObjectStateException {
        log.debug("Refreshing entity '{}' asynchronously with options '{}'", this.proxifier.removeProxy(entity), (Object)options);
        return super.asyncRefresh(entity, options);
    }

    @Override
    public <T> T initialize(T entity) {
        log.debug("Force lazy fields initialization for entity {}", this.proxifier.removeProxy(entity));
        return super.initialize(entity);
    }

    public <T> Set<T> initialize(Set<T> entities) {
        return super.initialize(entities);
    }

    public <T> List<T> initialize(List<T> entities) {
        log.debug("Force lazy fields initialization for entity set {}", entities);
        return super.initialize(entities);
    }

    public <T> T initAndRemoveProxy(T entity) {
        return super.removeProxy(super.initialize(entity));
    }

    public <T> Set<T> initAndRemoveProxy(Set<T> entities) {
        return super.removeProxy(super.initialize(entities));
    }

    public <T> List<T> initAndRemoveProxy(List<T> entities) {
        return super.removeProxy(super.initialize(entities));
    }

    @Override
    public <T> T removeProxy(T proxy) {
        return super.removeProxy(proxy);
    }

    @Override
    public <T> List<T> removeProxy(List<T> proxies) {
        log.debug("Removing proxy for a list of entities {}", proxies);
        return super.removeProxy(proxies);
    }

    @Override
    public <T> Set<T> removeProxy(Set<T> proxies) {
        log.debug("Removing proxy for a set of entities {}", proxies);
        return super.removeProxy(proxies);
    }

    @Override
    public <T> SliceQueryBuilder<T> sliceQuery(Class<T> entityClass) {
        log.debug("Execute slice query for entity class {}", entityClass);
        return super.sliceQuery(entityClass);
    }

    public NativeQuery nativeQuery(RegularStatement regularStatement, Object ... boundValues) {
        return super.nativeQuery(regularStatement, OptionsBuilder.noOptions(), boundValues);
    }

    @Override
    public NativeQuery nativeQuery(RegularStatement regularStatement, Options options, Object ... boundValues) {
        log.debug("Execute native query {}", (Object)regularStatement);
        return super.nativeQuery(regularStatement, options, boundValues);
    }

    public <T> TypedQuery<T> typedQuery(Class<T> entityClass, RegularStatement regularStatement, Object ... boundValues) {
        return super.typedQueryInternal(entityClass, regularStatement, boundValues);
    }

    @Override
    public <T> TypedQuery<T> indexedQuery(Class<T> entityClass, IndexCondition indexCondition) {
        log.debug("Execute indexed query for entity class {}", entityClass);
        return super.indexedQuery(entityClass, indexCondition);
    }

    @Override
    public <T> TypedQuery<T> rawTypedQuery(Class<T> entityClass, RegularStatement regularStatement, Object ... boundValues) {
        log.debug("Execute raw typed query for entity class {}", entityClass);
        return super.rawTypedQuery(entityClass, regularStatement, boundValues);
    }

    @Override
    public String serializeToJSON(Object entity) throws IOException {
        return super.serializeToJSON(entity);
    }

    @Override
    public <T> T deserializeFromJSON(Class<T> type, String serialized) throws IOException {
        return super.deserializeFromJSON(type, serialized);
    }

    @Override
    public Session getNativeSession() {
        return super.getNativeSession();
    }

    public AsyncBatch createBatch() {
        log.debug("Spawn new AsyncBatch");
        return new AsyncBatch(this.entityMetaMap, this.contextFactory, this.daoContext, this.configContext, false);
    }

    public AsyncBatch createOrderedBatch() {
        log.debug("Spawn new AsyncBatch");
        return new AsyncBatch(this.entityMetaMap, this.contextFactory, this.daoContext, this.configContext, true);
    }
}

