/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.persistence;

import com.datastax.driver.core.RegularStatement;
import com.google.common.base.Optional;
import info.archinnov.achilles.exception.AchillesException;
import info.archinnov.achilles.internal.consistency.ConsistencyConverter;
import info.archinnov.achilles.internal.context.BatchingFlushContext;
import info.archinnov.achilles.internal.context.ConfigurationContext;
import info.archinnov.achilles.internal.context.DaoContext;
import info.archinnov.achilles.internal.context.PersistenceContextFactory;
import info.archinnov.achilles.internal.context.facade.PersistenceManagerOperations;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.persistence.operations.NativeQueryValidator;
import info.archinnov.achilles.internal.statement.wrapper.NativeQueryLog;
import info.archinnov.achilles.internal.statement.wrapper.NativeStatementWrapper;
import info.archinnov.achilles.internal.utils.UUIDGen;
import info.archinnov.achilles.listener.CASResultListener;
import info.archinnov.achilles.persistence.CommonPersistenceManager;
import info.archinnov.achilles.type.ConsistencyLevel;
import info.archinnov.achilles.type.Options;
import info.archinnov.achilles.type.OptionsBuilder;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class CommonBatch
extends CommonPersistenceManager {
    private static final Logger log = LoggerFactory.getLogger(CommonBatch.class);
    protected NativeQueryValidator validator = NativeQueryValidator.Singleton.INSTANCE.get();
    protected BatchingFlushContext flushContext;
    protected final ConsistencyLevel defaultConsistencyLevel;
    private final boolean orderedBatch;

    CommonBatch(Map<Class<?>, EntityMeta> entityMetaMap, PersistenceContextFactory contextFactory, DaoContext daoContext, ConfigurationContext configContext, boolean orderedBatch) {
        super(entityMetaMap, contextFactory, daoContext, configContext);
        this.defaultConsistencyLevel = configContext.getDefaultWriteConsistencyLevel();
        this.orderedBatch = orderedBatch;
        this.flushContext = new BatchingFlushContext(daoContext, this.defaultConsistencyLevel, (Optional<com.datastax.driver.core.ConsistencyLevel>)Optional.absent());
    }

    public void startBatch() {
        log.debug("Starting batch mode");
        this.flushContext = this.flushContext.duplicateWithNoData(this.defaultConsistencyLevel);
    }

    public void startBatch(ConsistencyLevel consistencyLevel) {
        log.debug("Starting batch mode with consistency level {}", (Object)consistencyLevel.name());
        this.flushContext = this.flushContext.duplicateWithNoData(consistencyLevel);
    }

    public void startBatch(ConsistencyLevel consistencyLevel, ConsistencyLevel serialConsistency) {
        log.debug("Starting batch mode with consistency level {}", (Object)consistencyLevel.name());
        Optional serialConsistencyLevel = Optional.absent();
        if (serialConsistency != null) {
            serialConsistencyLevel = Optional.fromNullable((Object)ConsistencyConverter.getCQLLevel(serialConsistency));
        }
        this.flushContext = this.flushContext.duplicateWithNoData(consistencyLevel, (Optional<com.datastax.driver.core.ConsistencyLevel>)serialConsistencyLevel);
    }

    public void cleanBatch() {
        log.debug("Cleaning all pending statements");
        this.flushContext = this.flushContext.duplicateWithNoData(this.defaultConsistencyLevel);
    }

    @Override
    public <T> T insert(T entity) {
        log.debug("Inserting entity '{}'", entity);
        return super.insert(entity, this.maybeAddTimestampToStatement(OptionsBuilder.noOptions()));
    }

    @Override
    public <T> T insert(T entity, Options options) {
        log.debug("Inserting entity '{}' and options '{}'", entity, (Object)options);
        Options modifiedOptions = this.adaptOptionsForBatch(options);
        return super.asyncInsert(entity, modifiedOptions).getImmediately();
    }

    @Override
    public void update(Object entity) {
        log.debug("Updating entity '{}'", this.proxifier.getRealObject(entity));
        super.update(entity, this.maybeAddTimestampToStatement(OptionsBuilder.noOptions()));
    }

    @Override
    public void update(Object entity, Options options) {
        log.debug("Updating entity '{}' with options {} ", this.proxifier.getRealObject(entity), (Object)options);
        Options modifiedOptions = this.adaptOptionsForBatch(options);
        super.asyncUpdate(entity, modifiedOptions).getImmediately();
    }

    @Override
    public <T> T insertOrUpdate(T entity) {
        log.debug("Inserting or updating entity '{}'", this.proxifier.getRealObject(entity));
        return super.insertOrUpdate(entity, this.maybeAddTimestampToStatement(OptionsBuilder.noOptions()));
    }

    @Override
    public <T> T insertOrUpdate(T entity, Options options) {
        log.debug("Inserting or updating entity '{}' with options {}", this.proxifier.getRealObject(entity), (Object)options);
        Options modifiedOptions = this.adaptOptionsForBatch(options);
        return super.insertOrUpdate(entity, modifiedOptions);
    }

    @Override
    public void delete(Object entity) {
        log.debug("Removing entity '{}'", this.proxifier.getRealObject(entity));
        super.delete(entity, this.maybeAddTimestampToStatement(OptionsBuilder.noOptions()));
    }

    @Override
    public void delete(Object entity, Options options) {
        log.debug("Removing entity '{}' with options {}", this.proxifier.getRealObject(entity), (Object)options);
        Options modifiedOptions = this.adaptOptionsForBatch(options);
        super.asyncDelete(entity, modifiedOptions).getImmediately();
    }

    @Override
    public void deleteById(Class<?> entityClass, Object primaryKey) {
        log.debug("Deleting entity of type '{}' by its id '{}'", entityClass, primaryKey);
        super.deleteById(entityClass, primaryKey, this.maybeAddTimestampToStatement(OptionsBuilder.noOptions()));
    }

    @Override
    public void deleteById(Class<?> entityClass, Object primaryKey, Options options) {
        log.debug("Deleting entity of type '{}' by its id '{}'", entityClass, primaryKey);
        Options modifiedOptions = this.maybeAddTimestampToStatement(options);
        super.asyncDeleteById(entityClass, primaryKey, modifiedOptions).getImmediately();
    }

    public void batchNativeStatement(RegularStatement regularStatement, Object ... boundValues) {
        this.batchNativeStatementWithCASListener(regularStatement, null, boundValues);
    }

    public void batchNativeStatementWithCASListener(RegularStatement regularStatement, CASResultListener casResultListener, Object ... boundValues) {
        log.debug("Batch native statement '{}' with bound values '{}'", (Object)regularStatement, (Object)boundValues);
        this.validator.validateUpsertOrDelete(regularStatement);
        NativeStatementWrapper nativeStatementWrapper = new NativeStatementWrapper(NativeQueryLog.class, regularStatement, boundValues, (Optional<CASResultListener>)Optional.fromNullable((Object)casResultListener));
        this.flushContext.pushStatement(nativeStatementWrapper);
    }

    @Override
    protected PersistenceManagerOperations initPersistenceContext(Class<?> entityClass, Object primaryKey, Options options) {
        log.trace("Initializing new persistence context for entity class {} and primary key {}", (Object)entityClass.getCanonicalName(), primaryKey);
        return this.contextFactory.newContextWithFlushContext(entityClass, primaryKey, options, this.flushContext).getPersistenceManagerFacade();
    }

    @Override
    protected PersistenceManagerOperations initPersistenceContext(Object entity, Options options) {
        log.trace("Initializing new persistence context for entity {}", entity);
        return this.contextFactory.newContextWithFlushContext(entity, options, this.flushContext).getPersistenceManagerFacade();
    }

    protected Options adaptOptionsForBatch(Options options) {
        Options modifiedOptions = this.maybeAddTimestampToStatement(options);
        if (!this.optionsValidator.isOptionsValidForBatch(modifiedOptions)) {
            this.flushContext = this.flushContext.duplicateWithNoData(this.defaultConsistencyLevel);
            throw new AchillesException("Runtime custom Consistency Level and/or async listeners cannot be set for batch mode. Please set the Consistency Levels at batch start with 'startBatch(consistencyLevel)' and async listener using endBatch(...)");
        }
        return modifiedOptions;
    }

    protected Options maybeAddTimestampToStatement(Options options) {
        if (this.orderedBatch) {
            return options.duplicateWithNewTimestamp(UUIDGen.increasingMicroTimestamp());
        }
        return options;
    }
}

