/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.persistence;

import info.archinnov.achilles.internal.context.ConfigurationContext;
import info.archinnov.achilles.internal.context.DaoContext;
import info.archinnov.achilles.internal.context.PersistenceContextFactory;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.persistence.AbstractPersistenceManager;
import info.archinnov.achilles.type.Options;
import info.archinnov.achilles.type.OptionsBuilder;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonPersistenceManager
extends AbstractPersistenceManager {
    private static final Logger log = LoggerFactory.getLogger(CommonPersistenceManager.class);

    protected CommonPersistenceManager(Map<Class<?>, EntityMeta> entityMetaMap, PersistenceContextFactory contextFactory, DaoContext daoContext, ConfigurationContext configContext) {
        super(entityMetaMap, contextFactory, daoContext, configContext);
    }

    public <T> T insert(T entity) {
        log.debug("Inserting entity '{}'", entity);
        return super.asyncInsert(entity, OptionsBuilder.noOptions()).getImmediately();
    }

    public <T> T insert(T entity, Options options) {
        log.debug("Inserting entity '{}' with options {} ", entity, (Object)options);
        return super.asyncInsert(entity, options).getImmediately();
    }

    public void update(Object entity) {
        log.debug("Updating entity '{}'", this.proxifier.getRealObject(entity));
        super.asyncUpdate(entity, OptionsBuilder.noOptions()).getImmediately();
    }

    public void update(Object entity, Options options) {
        log.debug("Updating entity '{}' with options {} ", this.proxifier.getRealObject(entity), (Object)options);
        super.asyncUpdate(entity, options).getImmediately();
    }

    public <T> T insertOrUpdate(T entity) {
        log.debug("Inserting or updating entity '{}'", this.proxifier.getRealObject(entity));
        return this.asyncInsertOrUpdate(entity, OptionsBuilder.noOptions()).getImmediately();
    }

    public <T> T insertOrUpdate(T entity, Options options) {
        log.debug("Inserting or updating entity '{}' with options {}", this.proxifier.getRealObject(entity), (Object)options);
        return this.asyncInsertOrUpdate(entity, options).getImmediately();
    }

    public void delete(Object entity) {
        log.debug("Deleting entity '{}'", this.proxifier.getRealObject(entity));
        super.asyncDelete(entity, OptionsBuilder.noOptions()).getImmediately();
    }

    public void delete(Object entity, Options options) {
        log.debug("Deleting entity '{}' with options {}", this.proxifier.getRealObject(entity), (Object)options);
        super.asyncDelete(entity, options).getImmediately();
    }

    public void deleteById(Class<?> entityClass, Object primaryKey) {
        log.debug("Deleting  entity of type '{}' by its id '{}'", entityClass, primaryKey);
        super.asyncDeleteById(entityClass, primaryKey, OptionsBuilder.noOptions()).getImmediately();
    }

    public void deleteById(Class<?> entityClass, Object primaryKey, Options options) {
        log.debug("Deleting  entity of type '{}' by its id '{}'", entityClass, primaryKey);
        super.asyncDeleteById(entityClass, primaryKey, options).getImmediately();
    }
}

