/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.persistence;

import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Session;
import info.archinnov.achilles.exception.AchillesStaleObjectStateException;
import info.archinnov.achilles.internal.context.ConfigurationContext;
import info.archinnov.achilles.internal.context.DaoContext;
import info.archinnov.achilles.internal.context.PersistenceContextFactory;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.persistence.Batch;
import info.archinnov.achilles.persistence.CommonPersistenceManager;
import info.archinnov.achilles.query.cql.NativeQuery;
import info.archinnov.achilles.query.slice.SliceQueryBuilder;
import info.archinnov.achilles.query.typed.TypedQuery;
import info.archinnov.achilles.type.ConsistencyLevel;
import info.archinnov.achilles.type.IndexCondition;
import info.archinnov.achilles.type.Options;
import info.archinnov.achilles.type.OptionsBuilder;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceManager
extends CommonPersistenceManager {
    private static final Logger log = LoggerFactory.getLogger(PersistenceManager.class);

    protected PersistenceManager(Map<Class<?>, EntityMeta> entityMetaMap, PersistenceContextFactory contextFactory, DaoContext daoContext, ConfigurationContext configContext) {
        super(entityMetaMap, contextFactory, daoContext, configContext);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey) {
        log.debug("Find entity class '{}' with primary key '{}'", entityClass, primaryKey);
        return super.asyncFind(entityClass, primaryKey, OptionsBuilder.noOptions()).getImmediately();
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, ConsistencyLevel readLevel) {
        if (log.isDebugEnabled()) {
            log.debug("Find entity class '{}' with primary key {} and read consistency level {}", new Object[]{entityClass, primaryKey, readLevel});
        }
        return super.asyncFind(entityClass, primaryKey, OptionsBuilder.withConsistency(readLevel)).getImmediately();
    }

    public <T> T getProxy(Class<T> entityClass, Object primaryKey) {
        log.debug("Get reference for entity class '{}' with primary key {}", entityClass, primaryKey);
        return super.asyncGetProxy(entityClass, primaryKey, OptionsBuilder.noOptions()).getImmediately();
    }

    public <T> T getProxy(Class<T> entityClass, Object primaryKey, Options options) {
        if (log.isDebugEnabled()) {
            log.debug("Get reference for entity class '{}' with primary key {} and options {}", new Object[]{entityClass, primaryKey, options});
        }
        return super.asyncGetProxy(entityClass, primaryKey, options).getImmediately();
    }

    public void refresh(Object entity) throws AchillesStaleObjectStateException {
        log.debug("Refreshing entity '{}'", this.proxifier.removeProxy(entity));
        super.asyncRefresh(entity, OptionsBuilder.noOptions()).getImmediately();
    }

    public void refresh(Object entity, ConsistencyLevel readLevel) throws AchillesStaleObjectStateException {
        log.debug("Refreshing entity '{}' with consistency level '{}'", this.proxifier.removeProxy(entity));
        super.asyncRefresh(entity, OptionsBuilder.withConsistency(readLevel)).getImmediately();
    }

    @Override
    public <T> T initialize(T entity) {
        if (log.isDebugEnabled()) {
            log.debug("Force lazy fields initialization for entity {}", this.proxifier.removeProxy(entity));
        }
        return super.initialize(entity);
    }

    public <T> Set<T> initialize(Set<T> entities) {
        log.debug("Force lazy fields initialization for entity set {}", entities);
        return super.initialize(entities);
    }

    public <T> List<T> initialize(List<T> entities) {
        log.debug("Force lazy fields initialization for entity set {}", entities);
        return super.initialize(entities);
    }

    public <T> T initAndRemoveProxy(T entity) {
        return super.removeProxy(super.initialize(entity));
    }

    public <T> Set<T> initAndRemoveProxy(Set<T> entities) {
        return super.removeProxy(super.initialize(entities));
    }

    public <T> List<T> initAndRemoveProxy(List<T> entities) {
        return super.removeProxy(super.initialize(entities));
    }

    @Override
    public <T> T removeProxy(T proxy) {
        log.debug("Removing proxy for entity {}", proxy);
        return super.removeProxy(proxy);
    }

    @Override
    public <T> List<T> removeProxy(List<T> proxies) {
        log.debug("Removing proxy for a list of entities {}", proxies);
        return super.removeProxy(proxies);
    }

    @Override
    public <T> Set<T> removeProxy(Set<T> proxies) {
        log.debug("Removing proxy for a set of entities {}", proxies);
        return super.removeProxy(proxies);
    }

    @Override
    public <T> SliceQueryBuilder<T> sliceQuery(Class<T> entityClass) {
        log.debug("Execute slice query for entity class {}", entityClass);
        return super.sliceQuery(entityClass);
    }

    public NativeQuery nativeQuery(RegularStatement regularStatement, Object ... boundValues) {
        return super.nativeQuery(regularStatement, OptionsBuilder.noOptions(), boundValues);
    }

    @Override
    public NativeQuery nativeQuery(RegularStatement regularStatement, Options options, Object ... boundValues) {
        log.debug("Execute native query {}", (Object)regularStatement);
        return super.nativeQuery(regularStatement, options, boundValues);
    }

    public <T> TypedQuery<T> typedQuery(Class<T> entityClass, RegularStatement regularStatement, Object ... boundValues) {
        return super.typedQueryInternal(entityClass, regularStatement, boundValues);
    }

    @Override
    public <T> TypedQuery<T> indexedQuery(Class<T> entityClass, IndexCondition indexCondition) {
        log.debug("Execute indexed query for entity class {}", entityClass);
        return super.indexedQuery(entityClass, indexCondition);
    }

    @Override
    public <T> TypedQuery<T> rawTypedQuery(Class<T> entityClass, RegularStatement regularStatement, Object ... boundValues) {
        log.debug("Execute raw typed query for entity class {}", entityClass);
        return super.rawTypedQuery(entityClass, regularStatement, boundValues);
    }

    @Override
    public String serializeToJSON(Object entity) throws IOException {
        return super.serializeToJSON(entity);
    }

    @Override
    public <T> T deserializeFromJSON(Class<T> type, String serialized) throws IOException {
        return super.deserializeFromJSON(type, serialized);
    }

    @Override
    public Session getNativeSession() {
        return super.getNativeSession();
    }

    public Batch createBatch() {
        log.debug("Create new Batch instance");
        return new Batch(this.entityMetaMap, this.contextFactory, this.daoContext, this.configContext, false);
    }

    public Batch createOrderedBatch() {
        log.debug("Create new ordered Batch");
        return new Batch(this.entityMetaMap, this.contextFactory, this.daoContext, this.configContext, true);
    }
}

