/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.query.cql;

import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.google.common.base.Function;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import info.archinnov.achilles.async.AchillesFuture;
import info.archinnov.achilles.internal.async.AsyncUtils;
import info.archinnov.achilles.internal.context.ConfigurationContext;
import info.archinnov.achilles.internal.context.DaoContext;
import info.archinnov.achilles.internal.persistence.operations.NativeQueryMapper;
import info.archinnov.achilles.internal.persistence.operations.TypedMapIterator;
import info.archinnov.achilles.internal.statement.wrapper.NativeQueryLog;
import info.archinnov.achilles.internal.statement.wrapper.NativeStatementWrapper;
import info.archinnov.achilles.type.Empty;
import info.archinnov.achilles.type.Options;
import info.archinnov.achilles.type.TypedMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeQuery {
    private static final Logger log = LoggerFactory.getLogger(NativeQuery.class);
    protected NativeStatementWrapper nativeStatementWrapper;
    private DaoContext daoContext;
    protected AsyncUtils asyncUtils = AsyncUtils.Singleton.INSTANCE.get();
    protected NativeQueryMapper mapper = NativeQueryMapper.Singleton.INSTANCE.get();
    private ExecutorService executorService;

    public NativeQuery(DaoContext daoContext, ConfigurationContext configContext, RegularStatement regularStatement, Options options, Object ... boundValues) {
        this.daoContext = daoContext;
        this.nativeStatementWrapper = new NativeStatementWrapper(NativeQueryLog.class, regularStatement, boundValues, options.getCasResultListener());
        this.executorService = configContext.getExecutorService();
    }

    public List<TypedMap> get() {
        log.debug("Get results for native query '{}'", (Object)this.nativeStatementWrapper.getStatement());
        return this.asyncGet(new FutureCallback[0]).getImmediately();
    }

    public AchillesFuture<List<TypedMap>> asyncGet(FutureCallback<Object> ... asyncListeners) {
        log.debug("Get results for native query '{}' asynchronously", (Object)this.nativeStatementWrapper.getStatement());
        ListenableFuture<ResultSet> resultSetFuture = this.daoContext.execute(this.nativeStatementWrapper);
        ListenableFuture<List<Row>> futureRows = this.asyncUtils.transformFuture(resultSetFuture, AsyncUtils.RESULTSET_TO_ROWS, this.executorService);
        Function<List<Row>, List<TypedMap>> rowsToTypedMaps = new Function<List<Row>, List<TypedMap>>(){

            public List<TypedMap> apply(List<Row> rows) {
                return NativeQuery.this.mapper.mapRows(rows);
            }
        };
        ListenableFuture<List<TypedMap>> futureTypedMap = this.asyncUtils.transformFuture(futureRows, rowsToTypedMaps, this.executorService);
        this.asyncUtils.maybeAddAsyncListeners(futureTypedMap, asyncListeners, this.executorService);
        return this.asyncUtils.buildInterruptible(futureTypedMap);
    }

    public TypedMap first() {
        log.debug("Get first result for native query {}", (Object)this.nativeStatementWrapper.getStatement());
        return this.asyncFirst(new FutureCallback[0]).getImmediately();
    }

    public AchillesFuture<TypedMap> asyncFirst(FutureCallback<Object> ... asyncListeners) {
        log.debug("Get first result for native query '{}' asynchronously", (Object)this.nativeStatementWrapper.getStatement());
        ListenableFuture<ResultSet> resultSetFuture = this.daoContext.execute(this.nativeStatementWrapper);
        ListenableFuture<List<Row>> futureRows = this.asyncUtils.transformFuture(resultSetFuture, AsyncUtils.RESULTSET_TO_ROWS, this.executorService);
        Function<List<Row>, TypedMap> rowsToTypedMap = new Function<List<Row>, TypedMap>(){

            public TypedMap apply(List<Row> rows) {
                List<TypedMap> result = NativeQuery.this.mapper.mapRows(rows);
                if (result.isEmpty()) {
                    return null;
                }
                return result.get(0);
            }
        };
        ListenableFuture<TypedMap> futureTypedMap = this.asyncUtils.transformFuture(futureRows, rowsToTypedMap, this.executorService);
        this.asyncUtils.maybeAddAsyncListeners(futureTypedMap, asyncListeners, this.executorService);
        return this.asyncUtils.buildInterruptible(futureTypedMap);
    }

    public void execute() {
        log.debug("Execute native query '{}'", (Object)this.nativeStatementWrapper.getStatement());
        this.asyncExecute(new FutureCallback[0]).getImmediately();
    }

    public AchillesFuture<Empty> asyncExecute(FutureCallback<Object> ... asyncListeners) {
        log.debug("Execute native query '{}' asynchronously", (Object)this.nativeStatementWrapper.getStatement());
        ListenableFuture<ResultSet> resultSetFuture = this.daoContext.execute(this.nativeStatementWrapper);
        ListenableFuture<Empty> futureEmpty = this.asyncUtils.transformFutureToEmpty(resultSetFuture, this.executorService);
        this.asyncUtils.maybeAddAsyncListeners(futureEmpty, asyncListeners, this.executorService);
        return this.asyncUtils.buildInterruptible(futureEmpty);
    }

    public Iterator<TypedMap> iterator() {
        log.debug("Execute native query {} and return iterator", (Object)this.nativeStatementWrapper.getStatement());
        ListenableFuture<ResultSet> future = this.daoContext.execute(this.nativeStatementWrapper);
        return new TypedMapIterator(this.asyncUtils.buildInterruptible(future).getImmediately().iterator());
    }

    public AchillesFuture<Iterator<TypedMap>> asyncIterator() {
        log.debug("Execute native query {} and return iterator", (Object)this.nativeStatementWrapper.getStatement());
        ListenableFuture<ResultSet> futureResultSet = this.daoContext.execute(this.nativeStatementWrapper);
        Function<ResultSet, Iterator<TypedMap>> toTypedMap = new Function<ResultSet, Iterator<TypedMap>>(){

            public Iterator<TypedMap> apply(ResultSet resultSet) {
                return new TypedMapIterator(resultSet.iterator());
            }
        };
        ListenableFuture<Iterator<TypedMap>> futureTypedMapIterator = this.asyncUtils.transformFuture(futureResultSet, toTypedMap, this.executorService);
        return this.asyncUtils.buildInterruptible(futureTypedMapIterator);
    }
}

