/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.query.slice;

import com.google.common.collect.FluentIterable;
import com.google.common.util.concurrent.FutureCallback;
import info.archinnov.achilles.async.AchillesFuture;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.persistence.operations.SliceQueryExecutor;
import info.archinnov.achilles.query.slice.BoundingMode;
import info.archinnov.achilles.query.slice.OrderingMode;
import info.archinnov.achilles.query.slice.SliceQueryProperties;
import info.archinnov.achilles.query.slice.SliceQueryRootExtended;
import info.archinnov.achilles.type.ConsistencyLevel;
import java.util.List;

public abstract class SelectPartitionRoot<TYPE, T extends SelectPartitionRoot<TYPE, T>>
extends SliceQueryRootExtended<TYPE, T> {
    protected SelectPartitionRoot(SliceQueryExecutor sliceQueryExecutor, Class<TYPE> entityClass, EntityMeta meta, SliceQueryProperties.SliceType sliceType) {
        super(sliceQueryExecutor, entityClass, meta, sliceType);
    }

    public List<TYPE> get() {
        return super.getInternal();
    }

    public List<TYPE> get(int limit) {
        this.properties.limit(limit);
        return super.getInternal();
    }

    public TYPE getOne() {
        this.properties.limit(1);
        return (TYPE)FluentIterable.from(super.getInternal()).first().orNull();
    }

    public List<TYPE> getMatching(Object ... matchedClusteringKeys) {
        super.withClusteringsInternal(matchedClusteringKeys);
        return super.getInternal();
    }

    public TYPE getOneMatching(Object ... matchedClusteringKeys) {
        return (TYPE)FluentIterable.from(this.getMatching(matchedClusteringKeys)).first().orNull();
    }

    public List<TYPE> getFirstMatching(int limit, Object ... matchingClusteringKeys) {
        this.properties.ordering(OrderingMode.ASCENDING);
        this.properties.limit(limit);
        super.withClusteringsInternal(matchingClusteringKeys);
        return super.getInternal();
    }

    public List<TYPE> getLastMatching(int limit, Object ... matchingClusteringKeys) {
        this.properties.ordering(OrderingMode.DESCENDING);
        super.withClusteringsInternal(matchingClusteringKeys);
        this.properties.limit(limit);
        return super.getInternal();
    }

    public SelectPartitionAsyncRoot async() {
        return new SelectPartitionAsyncRoot();
    }

    public SelectFromClusterings<TYPE> fromClusterings(Object ... fromClusteringKeys) {
        super.fromClusteringsInternal(fromClusteringKeys);
        return new SelectFromClusterings();
    }

    public SelectEnd<TYPE> toClusterings(Object ... toClusteringKeys) {
        super.toClusteringsInternal(toClusteringKeys);
        return new SelectEnd();
    }

    public SelectWithClusterings<TYPE> withClusterings(Object ... clusteringKeys) {
        super.withClusteringsInternal(clusteringKeys);
        return new SelectWithClusterings();
    }

    public class SelectClusteringRootAsync {
        public AchillesFuture<TYPE> getOne() {
            SelectPartitionRoot.this.properties.limit(1);
            return SelectPartitionRoot.super.asyncGetOneInternal();
        }

        public AchillesFuture<List<TYPE>> get() {
            return SelectPartitionRoot.super.asyncGetInternal();
        }

        public AchillesFuture<List<TYPE>> get(int limit) {
            SelectPartitionRoot.this.properties.limit(limit);
            return SelectPartitionRoot.super.asyncGetInternal();
        }
    }

    public class SelectPartitionAsyncRoot {
        public AchillesFuture<List<TYPE>> get() {
            return SelectPartitionRoot.super.asyncGetInternal();
        }

        public AchillesFuture<List<TYPE>> get(int limit) {
            SelectPartitionRoot.this.properties.limit(limit);
            return SelectPartitionRoot.super.asyncGetInternal();
        }

        public AchillesFuture<TYPE> getOne() {
            SelectPartitionRoot.this.properties.limit(1);
            return SelectPartitionRoot.super.asyncGetOneInternal();
        }

        public AchillesFuture<List<TYPE>> getMatching(Object ... matchedClusteringKeys) {
            SelectPartitionRoot.super.withClusteringsInternal(matchedClusteringKeys);
            return SelectPartitionRoot.super.asyncGetInternal();
        }

        public AchillesFuture<TYPE> getOneMatching(Object ... matchedClusteringKeys) {
            SelectPartitionRoot.super.withClusteringsInternal(matchedClusteringKeys);
            return SelectPartitionRoot.super.asyncGetOneInternal();
        }

        public AchillesFuture<List<TYPE>> getFirstMatching(int limit, Object ... matchingClusteringKeys) {
            SelectPartitionRoot.this.properties.ordering(OrderingMode.ASCENDING);
            SelectPartitionRoot.this.properties.limit(limit);
            SelectPartitionRoot.super.withClusteringsInternal(matchingClusteringKeys);
            return SelectPartitionRoot.super.asyncGetInternal();
        }

        public AchillesFuture<List<TYPE>> getLastMatching(int limit, Object ... matchingClusteringKeys) {
            SelectPartitionRoot.this.properties.ordering(OrderingMode.DESCENDING);
            SelectPartitionRoot.super.withClusteringsInternal(matchingClusteringKeys);
            SelectPartitionRoot.this.properties.limit(limit);
            return SelectPartitionRoot.super.asyncGetInternal();
        }
    }

    public class SelectEndWithLimitation<ENTITY_TYPE>
    extends SelectClusteringsRootWithLimitation<ENTITY_TYPE, SelectEndWithLimitation<ENTITY_TYPE>> {
        @Override
        protected SelectEndWithLimitation<ENTITY_TYPE> getThis() {
            return this;
        }
    }

    public class SelectEnd<ENTITY_TYPE>
    extends SelectClusteringsRoot<ENTITY_TYPE, SelectEnd<ENTITY_TYPE>> {
        @Override
        protected SelectEnd<ENTITY_TYPE> getThis() {
            return this;
        }
    }

    public class SelectWithClusterings<ENTITY_TYPE>
    extends SelectClusteringsRootWithLimitation<ENTITY_TYPE, SelectWithClusterings<ENTITY_TYPE>> {
        public SelectEndWithLimitation<ENTITY_TYPE> andClusteringsIN(Object ... clusteringKeys) {
            SelectPartitionRoot.super.andClusteringsInInternal(clusteringKeys);
            return new SelectEndWithLimitation();
        }

        @Override
        protected SelectWithClusterings<ENTITY_TYPE> getThis() {
            return this;
        }
    }

    public class SelectFromClusterings<ENTITY_TYPE>
    extends SelectClusteringsRoot<ENTITY_TYPE, SelectFromClusterings<ENTITY_TYPE>> {
        public SelectEnd<ENTITY_TYPE> toClusterings(Object ... clusteringKeys) {
            SelectPartitionRoot.super.toClusteringsInternal(clusteringKeys);
            return new SelectEnd();
        }

        @Override
        protected SelectFromClusterings<ENTITY_TYPE> getThis() {
            return this;
        }
    }

    public abstract class SelectClusteringsRoot<ENTITY_TYPE, T extends SelectClusteringsRoot<ENTITY_TYPE, T>>
    extends SelectClusteringsRootWithLimitation<ENTITY_TYPE, T> {
        public T withInclusiveBounds() {
            SelectPartitionRoot.this.properties.bounding(BoundingMode.INCLUSIVE_BOUNDS);
            return (T)((SelectClusteringsRoot)this.getThis());
        }

        public T withExclusiveBounds() {
            SelectPartitionRoot.this.properties.bounding(BoundingMode.EXCLUSIVE_BOUNDS);
            return (T)((SelectClusteringsRoot)this.getThis());
        }

        public T fromInclusiveToExclusiveBounds() {
            SelectPartitionRoot.this.properties.bounding(BoundingMode.INCLUSIVE_START_BOUND_ONLY);
            return (T)((SelectClusteringsRoot)this.getThis());
        }

        public T fromExclusiveToInclusiveBounds() {
            SelectPartitionRoot.this.properties.bounding(BoundingMode.INCLUSIVE_END_BOUND_ONLY);
            return (T)((SelectClusteringsRoot)this.getThis());
        }
    }

    public abstract class SelectClusteringsRootWithLimitation<ENTITY_TYPE, T extends SelectClusteringsRootWithLimitation<ENTITY_TYPE, T>> {
        public T orderByAscending() {
            SelectPartitionRoot.this.properties.ordering(OrderingMode.ASCENDING);
            return this.getThis();
        }

        public T orderByDescending() {
            SelectPartitionRoot.this.properties.ordering(OrderingMode.DESCENDING);
            return this.getThis();
        }

        public T limit(int limit) {
            SelectPartitionRoot.this.properties.limit(limit);
            return this.getThis();
        }

        public T noLimit() {
            SelectPartitionRoot.this.properties.disableLimit();
            return this.getThis();
        }

        public T withConsistency(ConsistencyLevel consistencyLevel) {
            SelectPartitionRoot.this.properties.consistency(consistencyLevel);
            return this.getThis();
        }

        public T withAsyncListeners(FutureCallback<Object> ... asyncListeners) {
            SelectPartitionRoot.this.properties.asyncListeners(asyncListeners);
            return this.getThis();
        }

        protected abstract T getThis();

        public SelectClusteringRootAsync async() {
            return new SelectClusteringRootAsync();
        }

        public TYPE getOne() {
            SelectPartitionRoot.this.properties.limit(1);
            return FluentIterable.from((Iterable)SelectPartitionRoot.super.getInternal()).first().orNull();
        }

        public List<TYPE> get() {
            return SelectPartitionRoot.super.getInternal();
        }

        public List<TYPE> get(int limit) {
            SelectPartitionRoot.this.properties.limit(limit);
            return SelectPartitionRoot.super.getInternal();
        }
    }
}

