/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.query.slice;

import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.BindMarker;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.Ordering;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.FutureCallback;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.validation.Validator;
import info.archinnov.achilles.query.slice.BoundingMode;
import info.archinnov.achilles.query.slice.OrderingMode;
import info.archinnov.achilles.schemabuilder.Create;
import info.archinnov.achilles.type.ConsistencyLevel;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SliceQueryProperties<T> {
    private static final Logger log = LoggerFactory.getLogger(SliceQueryProperties.class);
    public static final int DEFAULT_LIMIT = 100;
    private static final Function<String, Object> FROM_NAME_TO_BIND_MARKER = new Function<String, Object>(){

        public BindMarker apply(String name) {
            return QueryBuilder.bindMarker((String)name);
        }
    };
    private final EntityMeta entityMeta;
    private final Class<T> entityClass;
    private final SliceType sliceType;
    private Optional<Integer> limitO = Optional.fromNullable((Object)100);
    protected Optional<Integer> fetchSizeO = Optional.absent();
    private BoundingMode boundingMode = BoundingMode.INCLUSIVE_BOUNDS;
    private Optional<OrderingMode> orderingModeO = Optional.absent();
    private Optional<ConsistencyLevel> consistencyLevelO = Optional.absent();
    private List<Object> partitionKeys = new LinkedList<Object>();
    private List<String> partitionKeysName = new LinkedList<String>();
    private List<Object> partitionKeysIn = new LinkedList<Object>();
    private String lastPartitionKeyName;
    private List<Object> fromClusteringKeys = new LinkedList<Object>();
    private List<String> fromClusteringKeysName = new LinkedList<String>();
    private List<Object> toClusteringKeys = new LinkedList<Object>();
    private List<String> toClusteringKeysName = new LinkedList<String>();
    private List<Object> withClusteringKeys = new LinkedList<Object>();
    private List<String> withClusteringKeysName = new LinkedList<String>();
    private List<Object> clusteringsKeysIn = new LinkedList<Object>();
    private String lastClusteringKeyName;
    private Create.Options.ClusteringOrder clusteringOrder;
    private FutureCallback<Object>[] asyncListeners;

    private SliceQueryProperties(EntityMeta entityMeta, Class<T> entityClass, SliceType sliceType) {
        this.entityMeta = entityMeta;
        this.entityClass = entityClass;
        this.sliceType = sliceType;
        this.clusteringOrder = entityMeta.forSliceQuery().getClusteringOrderForSliceQuery();
    }

    public static <T> SliceQueryProperties<T> builder(EntityMeta entityMeta, Class<T> entityClass, SliceType sliceType) {
        return new SliceQueryProperties<T>(entityMeta, entityClass, sliceType);
    }

    protected SliceQueryProperties<T> limit(int limit) {
        Validator.validateTrue(limit > 0, "The limit '%s' should be strictly positive", limit);
        this.limitO = Optional.fromNullable((Object)limit);
        return this;
    }

    protected SliceQueryProperties<T> disableLimit() {
        this.limitO = Optional.absent();
        return this;
    }

    protected SliceQueryProperties<T> fetchSize(int fetchSize) {
        Validator.validateTrue(fetchSize > 0, "The fetchSize '%s' should be strictly positive", fetchSize);
        this.fetchSizeO = Optional.fromNullable((Object)fetchSize);
        if (CollectionUtils.isNotEmpty(this.partitionKeysIn)) {
            this.orderingModeO = Optional.absent();
            log.warn("Cannot page queries with both ORDER BY and a IN restriction on the partition key; you must either remove the ORDER BY or the IN and sort client side, or disable paging for this query");
        }
        return this;
    }

    protected SliceQueryProperties<T> bounding(BoundingMode boundingMode) {
        this.boundingMode = boundingMode;
        return this;
    }

    protected SliceQueryProperties<T> ordering(OrderingMode orderingMode) {
        this.orderingModeO = Optional.fromNullable((Object)((Object)orderingMode));
        return this;
    }

    protected SliceQueryProperties<T> consistency(ConsistencyLevel consistencyLevel) {
        Validator.validateNotNull(consistencyLevel, "The consistency level should not be null", new Object[0]);
        this.consistencyLevelO = Optional.fromNullable((Object)consistencyLevel);
        return this;
    }

    protected SliceQueryProperties<T> partitionKeys(List<Object> partitionKeys) {
        this.partitionKeys = partitionKeys;
        return this;
    }

    protected SliceQueryProperties<T> partitionKeysName(List<String> partitionKeysName) {
        this.partitionKeysName = partitionKeysName;
        return this;
    }

    protected SliceQueryProperties<T> andPartitionKeysIn(List<Object> partitionKeysIn) {
        this.partitionKeysIn = partitionKeysIn;
        return this;
    }

    protected SliceQueryProperties<T> lastPartitionKeyName(String lastPartitionKeyName) {
        this.lastPartitionKeyName = lastPartitionKeyName;
        return this;
    }

    protected SliceQueryProperties<T> fromClusteringKeys(List<Object> fromClusteringKeys) {
        this.fromClusteringKeys = fromClusteringKeys;
        return this;
    }

    protected SliceQueryProperties<T> fromClusteringKeysName(List<String> fromClusteringKeysName) {
        this.fromClusteringKeysName = fromClusteringKeysName;
        return this;
    }

    protected SliceQueryProperties<T> toClusteringKeys(List<Object> toClusteringKeys) {
        this.toClusteringKeys = toClusteringKeys;
        return this;
    }

    protected SliceQueryProperties<T> toClusteringKeysName(List<String> toClusteringKeysName) {
        this.toClusteringKeysName = toClusteringKeysName;
        return this;
    }

    protected SliceQueryProperties<T> withClusteringKeys(List<Object> withClusteringKeys) {
        this.withClusteringKeys = withClusteringKeys;
        return this;
    }

    protected SliceQueryProperties<T> withClusteringKeysName(List<String> withClusteringKeysName) {
        this.withClusteringKeysName = withClusteringKeysName;
        return this;
    }

    protected SliceQueryProperties<T> andClusteringKeysIn(List<Object> clusteringsKeysIn) {
        this.clusteringsKeysIn = clusteringsKeysIn;
        return this;
    }

    protected SliceQueryProperties<T> lastClusteringKeyName(String lastClusteringKeyName) {
        this.lastClusteringKeyName = lastClusteringKeyName;
        return this;
    }

    protected SliceQueryProperties<T> asyncListeners(FutureCallback<Object>[] asyncListeners) {
        Validator.validateNotEmpty(asyncListeners, "The provided async listeners should not be null", new Object[0]);
        this.asyncListeners = asyncListeners;
        return this;
    }

    public RegularStatement generateWhereClauseForSelect(Select from) {
        Select.Where where = from.where();
        for (String partitionKeyName : this.partitionKeysName) {
            where.and(QueryBuilder.eq((String)partitionKeyName, (Object)QueryBuilder.bindMarker((String)partitionKeyName)));
        }
        if (StringUtils.isNotBlank((CharSequence)this.lastPartitionKeyName)) {
            where.and(QueryBuilder.in((String)this.lastPartitionKeyName, (Object[])new Object[]{QueryBuilder.bindMarker((String)"partitionComponentsIn")}));
        }
        if (CollectionUtils.isNotEmpty(this.withClusteringKeys)) {
            for (String withClusteringName : this.withClusteringKeysName) {
                where.and(QueryBuilder.eq((String)withClusteringName, (Object)QueryBuilder.bindMarker((String)withClusteringName)));
            }
            if (StringUtils.isNotBlank((CharSequence)this.lastClusteringKeyName)) {
                where.and(QueryBuilder.in((String)this.lastClusteringKeyName, (Object[])new Object[]{QueryBuilder.bindMarker((String)"clusteringKeysIn")}));
            }
        } else {
            if (CollectionUtils.isNotEmpty(this.fromClusteringKeys)) {
                this.boundingMode.buildFromClusteringKeys(where, this.clusteringOrder, this.fromClusteringKeysName);
            }
            if (CollectionUtils.isNotEmpty(this.toClusteringKeys)) {
                this.boundingMode.buildToClusteringKeys(where, this.clusteringOrder, this.toClusteringKeysName);
            }
        }
        if (this.orderingModeO.isPresent()) {
            OrderingMode orderingMode = (OrderingMode)((Object)this.orderingModeO.get());
            Select statement = orderingMode.isReverse() ? where.orderBy(new Ordering[]{QueryBuilder.desc((String)this.clusteringOrder.getClusteringColumnName())}) : where.orderBy(new Ordering[]{QueryBuilder.asc((String)this.clusteringOrder.getClusteringColumnName())});
            if (this.limitO.isPresent()) {
                statement.limit(QueryBuilder.bindMarker((String)"limitSize"));
            }
            return statement;
        }
        if (this.limitO.isPresent()) {
            where.limit(QueryBuilder.bindMarker((String)"limitSize"));
        }
        return where;
    }

    public Delete.Where generateWhereClauseForDelete(Delete delete) {
        Delete.Where where = delete.where();
        for (String partitionKeyName : this.partitionKeysName) {
            where.and(QueryBuilder.eq((String)partitionKeyName, (Object)QueryBuilder.bindMarker((String)partitionKeyName)));
        }
        if (StringUtils.isNotBlank((CharSequence)this.lastPartitionKeyName)) {
            where.and(QueryBuilder.in((String)this.lastPartitionKeyName, (Object[])new Object[]{QueryBuilder.bindMarker((String)"partitionComponentsIn")}));
        }
        if (CollectionUtils.isNotEmpty(this.withClusteringKeys)) {
            for (String withClusteringName : this.withClusteringKeysName) {
                where.and(QueryBuilder.eq((String)withClusteringName, (Object)QueryBuilder.bindMarker((String)withClusteringName)));
            }
        }
        return where;
    }

    public Object[] getBoundValues() {
        LinkedList<Object> boundValues = new LinkedList<Object>();
        boundValues.addAll(this.entityMeta.forTranscoding().encodePartitionComponents(this.partitionKeys));
        if (CollectionUtils.isNotEmpty(this.partitionKeysIn)) {
            boundValues.add(this.entityMeta.forTranscoding().encodePartitionComponentsIN(this.partitionKeysIn));
        }
        if (CollectionUtils.isNotEmpty(this.withClusteringKeys)) {
            boundValues.addAll(this.entityMeta.forTranscoding().encodeClusteringKeys(this.withClusteringKeys));
            if (CollectionUtils.isNotEmpty(this.clusteringsKeysIn)) {
                boundValues.add(this.entityMeta.forTranscoding().encodeClusteringKeysIN(this.clusteringsKeysIn));
            }
        } else {
            if (CollectionUtils.isNotEmpty(this.fromClusteringKeys)) {
                boundValues.addAll(this.entityMeta.forTranscoding().encodeClusteringKeys(this.fromClusteringKeys));
            }
            if (CollectionUtils.isNotEmpty(this.toClusteringKeys)) {
                boundValues.addAll(this.entityMeta.forTranscoding().encodeClusteringKeys(this.toClusteringKeys));
            }
        }
        if (this.limitO.isPresent()) {
            boundValues.add(this.limitO.get());
        }
        return boundValues.toArray();
    }

    public void setFetchSizeToStatement(Statement statement) {
        if (this.fetchSizeO.isPresent()) {
            statement.setFetchSize(((Integer)this.fetchSizeO.get()).intValue());
        }
    }

    public ConsistencyLevel getConsistencyLevelOr(ConsistencyLevel defaultConsistencyLevel) {
        return (ConsistencyLevel)this.consistencyLevelO.or((Object)defaultConsistencyLevel);
    }

    public Class<T> getEntityClass() {
        return this.entityClass;
    }

    public EntityMeta getEntityMeta() {
        return this.entityMeta;
    }

    public List<Object> getPartitionKeys() {
        return this.partitionKeys;
    }

    public List<Object> getWithClusteringKeys() {
        return this.withClusteringKeys;
    }

    public FutureCallback<Object>[] getAsyncListeners() {
        return this.asyncListeners;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SliceQueryProperties that = (SliceQueryProperties)o;
        return Objects.equals((Object)this.sliceType, (Object)that.sliceType) && Objects.equals(this.entityClass, that.entityClass) && Objects.equals(this.partitionKeysName, that.partitionKeysName) && Objects.equals(this.lastPartitionKeyName, that.lastPartitionKeyName) && Objects.equals(this.fromClusteringKeysName, that.fromClusteringKeysName) && Objects.equals(this.toClusteringKeysName, that.toClusteringKeysName) && Objects.equals(this.withClusteringKeysName, that.withClusteringKeysName) && Objects.equals(this.lastClusteringKeyName, that.lastClusteringKeyName) && Objects.equals((Object)this.boundingMode, (Object)that.boundingMode) && Objects.equals(this.orderingModeO, that.orderingModeO) && Objects.equals(this.limitO, that.limitO);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sliceType, this.entityClass, this.partitionKeysName, this.lastPartitionKeyName, this.fromClusteringKeysName, this.toClusteringKeysName, this.withClusteringKeysName, this.lastClusteringKeyName, this.boundingMode, this.orderingModeO, this.limitO});
    }

    public static enum SliceType {
        SELECT,
        ITERATE,
        DELETE;

    }
}

