/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.query.typed;

import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import info.archinnov.achilles.async.AchillesFuture;
import info.archinnov.achilles.interceptor.Event;
import info.archinnov.achilles.internal.async.AsyncUtils;
import info.archinnov.achilles.internal.context.ConfigurationContext;
import info.archinnov.achilles.internal.context.DaoContext;
import info.archinnov.achilles.internal.context.PersistenceContext;
import info.archinnov.achilles.internal.context.PersistenceContextFactory;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import info.archinnov.achilles.internal.persistence.operations.EntityMapper;
import info.archinnov.achilles.internal.persistence.operations.EntityProxifier;
import info.archinnov.achilles.internal.statement.wrapper.NativeStatementWrapper;
import info.archinnov.achilles.listener.CASResultListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypedQuery<T> {
    private static final Logger log = LoggerFactory.getLogger(TypedQuery.class);
    private static final Optional<CASResultListener> NO_LISTENER = Optional.absent();
    private final NativeStatementWrapper nativeStatementWrapper;
    private DaoContext daoContext;
    private ExecutorService executorService;
    private Map<String, PropertyMeta> propertiesMap;
    private EntityMeta meta;
    private PersistenceContextFactory contextFactory;
    private EntityMeta.EntityState entityState;
    private Object[] boundValues;
    private EntityMapper mapper = EntityMapper.Singleton.INSTANCE.get();
    private EntityProxifier proxifier = EntityProxifier.Singleton.INSTANCE.get();
    private AsyncUtils asyncUtils = AsyncUtils.Singleton.INSTANCE.get();

    public TypedQuery(Class<T> entityClass, DaoContext daoContext, ConfigurationContext configContext, RegularStatement regularStatement, EntityMeta meta, PersistenceContextFactory contextFactory, EntityMeta.EntityState entityState, Object[] boundValues) {
        this.daoContext = daoContext;
        this.executorService = configContext.getExecutorService();
        this.boundValues = boundValues;
        this.nativeStatementWrapper = new NativeStatementWrapper(entityClass, regularStatement, this.boundValues, (Optional<CASResultListener>)Optional.absent());
        this.meta = meta;
        this.contextFactory = contextFactory;
        this.entityState = entityState;
        this.propertiesMap = this.transformPropertiesMap(meta);
    }

    public List<T> get() {
        log.debug("Get results for typed query '{}'", (Object)this.nativeStatementWrapper.getStatement());
        return this.asyncGet(new FutureCallback[0]).getImmediately();
    }

    public AchillesFuture<List<T>> asyncGet(FutureCallback<Object> ... asyncListeners) {
        log.debug("Get results asynchronously for typed query '{}'", (Object)this.nativeStatementWrapper.getStatement());
        ListenableFuture<ResultSet> resultSetFuture = this.daoContext.execute(this.nativeStatementWrapper);
        ListenableFuture<List<Row>> futureRows = this.asyncUtils.transformFuture(resultSetFuture, AsyncUtils.RESULTSET_TO_ROWS, this.executorService);
        Function<List<Row>, List<T>> rowsToEntities = this.rowsToEntities();
        Function<List<T>, List<T>> applyTriggers = this.applyTriggersToEntities();
        Function<List<T>, List<T>> maybeCreateProxy = this.proxifyEntities();
        ListenableFuture<List<T>> rawEntities = this.asyncUtils.transformFuture(futureRows, rowsToEntities, this.executorService);
        ListenableFuture<List<T>> entitiesWithTriggers = this.asyncUtils.transformFuture(rawEntities, applyTriggers, this.executorService);
        this.asyncUtils.maybeAddAsyncListeners(entitiesWithTriggers, asyncListeners, this.executorService);
        ListenableFuture<List<T>> maybeProxyCreated = this.asyncUtils.transformFuture(entitiesWithTriggers, maybeCreateProxy, this.executorService);
        return this.asyncUtils.buildInterruptible(maybeProxyCreated);
    }

    public T getFirst() {
        log.debug("Get first result for typed query '{}'", (Object)this.nativeStatementWrapper.getStatement());
        return this.asyncGetFirst(new FutureCallback[0]).getImmediately();
    }

    public AchillesFuture<T> asyncGetFirst(FutureCallback<Object> ... asyncListeners) {
        log.debug("Get first result asynchronously for typed query '{}'", (Object)this.nativeStatementWrapper.getStatement());
        ListenableFuture<ResultSet> resultSetFuture = this.daoContext.execute(this.nativeStatementWrapper);
        ListenableFuture<Row> futureRow = this.asyncUtils.transformFuture(resultSetFuture, AsyncUtils.RESULTSET_TO_ROW, this.executorService);
        Function<Row, T> rowToEntity = this.rowToEntity();
        Function<T, T> applyTriggers = this.applyTriggersToEntity();
        Function<T, T> maybeCreateProxy = this.proxifyEntity();
        ListenableFuture<T> rawEntity = this.asyncUtils.transformFuture(futureRow, rowToEntity, this.executorService);
        ListenableFuture<T> entityWithTriggers = this.asyncUtils.transformFuture(rawEntity, applyTriggers, this.executorService);
        this.asyncUtils.maybeAddAsyncListeners(entityWithTriggers, asyncListeners, this.executorService);
        ListenableFuture<T> maybeProxyCreated = this.asyncUtils.transformFuture(entityWithTriggers, maybeCreateProxy, this.executorService);
        return this.asyncUtils.buildInterruptible(maybeProxyCreated);
    }

    protected Function<Row, T> rowToEntity() {
        return new Function<Row, T>(){

            public T apply(Row row) {
                Object entity = null;
                if (row != null) {
                    entity = TypedQuery.this.mapper.mapRowToEntityWithPrimaryKey(TypedQuery.this.meta, row, TypedQuery.this.propertiesMap, TypedQuery.this.entityState);
                }
                return entity;
            }
        };
    }

    protected Function<T, T> applyTriggersToEntity() {
        return new Function<T, T>(){

            public T apply(T entity) {
                if (entity != null) {
                    TypedQuery.this.meta.forInterception().intercept(entity, Event.POST_LOAD);
                }
                return entity;
            }
        };
    }

    protected Function<T, T> proxifyEntity() {
        return new Function<T, T>(){

            public T apply(T entity) {
                Object newEntity = entity;
                if (entity != null && TypedQuery.this.entityState.isManaged()) {
                    newEntity = TypedQuery.this.buildProxy(entity);
                }
                return newEntity;
            }
        };
    }

    protected Function<List<Row>, List<T>> rowsToEntities() {
        return new Function<List<Row>, List<T>>(){

            public List<T> apply(List<Row> rows) {
                ArrayList<Object> entities = new ArrayList<Object>();
                for (Row row : rows) {
                    entities.add(TypedQuery.this.rowToEntity().apply((Object)row));
                }
                return FluentIterable.from(entities).filter(Predicates.notNull()).toList();
            }
        };
    }

    protected Function<List<T>, List<T>> applyTriggersToEntities() {
        return new Function<List<T>, List<T>>(){

            public List<T> apply(List<T> entities) {
                for (Object entity : entities) {
                    TypedQuery.this.applyTriggersToEntity().apply(entity);
                }
                return entities;
            }
        };
    }

    protected Function<List<T>, List<T>> proxifyEntities() {
        return new Function<List<T>, List<T>>(){

            public List<T> apply(List<T> entities) {
                ArrayList<Object> proxies = new ArrayList<Object>();
                for (Object entity : entities) {
                    proxies.add(TypedQuery.this.proxifyEntity().apply(entity));
                }
                return FluentIterable.from(proxies).filter(Predicates.notNull()).toList();
            }
        };
    }

    private Map<String, PropertyMeta> transformPropertiesMap(EntityMeta meta) {
        HashMap<String, PropertyMeta> propertiesMap = new HashMap<String, PropertyMeta>();
        for (PropertyMeta pm : meta.getPropertyMetas().values()) {
            String cql3ColumnName = pm.getCQL3ColumnName();
            propertiesMap.put(cql3ColumnName, pm);
        }
        return propertiesMap;
    }

    private T buildProxy(T entity) {
        PersistenceContext context = this.contextFactory.newContext(entity);
        entity = this.proxifier.buildProxyWithAllFieldsLoadedExceptCounters(entity, context.getEntityFacade());
        return entity;
    }
}

