/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.type;

import com.google.common.base.Objects;
import info.archinnov.achilles.internal.validation.Validator;
import info.archinnov.achilles.type.IndexRelation;

public class IndexCondition {
    private final String columnName;
    private final IndexRelation indexRelation;
    private Object columnValue;

    public IndexCondition(String columnName, Object columnValue) {
        Validator.validateNotBlank(columnName, "Column name for index condition '%s' should be provided", this);
        Validator.validateNotNull(columnValue, "Column value for index condition '%s' should be provided", this);
        this.columnName = columnName;
        this.indexRelation = IndexRelation.EQUAL;
        this.columnValue = columnValue;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public Object getColumnValue() {
        return this.columnValue;
    }

    public void encodedValue(Object encodedValue) {
        this.columnValue = encodedValue;
    }

    public String toString() {
        return Objects.toStringHelper(IndexCondition.class).add("columnName", this.columnValue).add("columnValue", this.columnValue).add("index relation", (Object)this.indexRelation).toString();
    }
}

