/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.type;

import com.datastax.driver.core.querybuilder.Clause;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.FutureCallback;
import info.archinnov.achilles.internal.validation.Validator;
import info.archinnov.achilles.listener.CASResultListener;
import info.archinnov.achilles.type.ConsistencyLevel;
import info.archinnov.achilles.type.OptionsBuilder;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class Options {
    ConsistencyLevel consistency;
    Integer ttl;
    Long timestamp;
    boolean ifNotExists;
    List<CASCondition> CASConditions;
    Optional<CASResultListener> CASResultListenerO = Optional.absent();
    List<FutureCallback<Object>> asyncListeners;
    Optional<com.datastax.driver.core.ConsistencyLevel> serialConsistencyO = Optional.absent();

    Options() {
    }

    public Optional<ConsistencyLevel> getConsistencyLevel() {
        return Optional.fromNullable((Object)this.consistency);
    }

    public Optional<Integer> getTtl() {
        return Optional.fromNullable((Object)this.ttl);
    }

    public Optional<Long> getTimestamp() {
        return Optional.fromNullable((Object)this.timestamp);
    }

    public boolean isIfNotExists() {
        return this.ifNotExists;
    }

    public List<CASCondition> getCASConditions() {
        return this.CASConditions;
    }

    public boolean hasCASConditions() {
        return CollectionUtils.isNotEmpty(this.CASConditions);
    }

    public Optional<CASResultListener> getCasResultListener() {
        return this.CASResultListenerO;
    }

    public List<FutureCallback<Object>> getAsyncListeners() {
        return this.asyncListeners;
    }

    public boolean hasAsyncListeners() {
        return CollectionUtils.isNotEmpty(this.asyncListeners);
    }

    public Optional<com.datastax.driver.core.ConsistencyLevel> getSerialConsistency() {
        return this.serialConsistencyO;
    }

    public String toString() {
        return Objects.toStringHelper(Options.class).add("Consistency Level", (Object)this.consistency).add("Time to live", (Object)this.ttl).add("Timestamp", (Object)this.timestamp).add("IF NOT EXISTS ? ", this.ifNotExists).add("CAS conditions", this.CASConditions).add("CAS result listener optional", this.CASResultListenerO).add("Async listeners", this.asyncListeners).add("Serial consistency", this.serialConsistencyO).toString();
    }

    public Options duplicateWithoutTtlAndTimestamp() {
        return OptionsBuilder.withConsistency(this.consistency).ifNotExists(this.ifNotExists).ifConditions(this.CASConditions).casResultListener((CASResultListener)this.CASResultListenerO.orNull()).casLocalSerial(this.serialConsistencyO.isPresent());
    }

    public Options duplicateWithNewConsistencyLevel(ConsistencyLevel consistencyLevel) {
        return OptionsBuilder.withConsistency(consistencyLevel).withTtl(this.ttl).withTimestamp(this.timestamp).ifNotExists(this.ifNotExists).ifConditions(this.CASConditions).casResultListener((CASResultListener)this.CASResultListenerO.orNull()).casLocalSerial(this.serialConsistencyO.isPresent());
    }

    public Options duplicateWithNewTimestamp(Long timestamp) {
        return OptionsBuilder.withConsistency(this.consistency).withTtl(this.ttl).withTimestamp(timestamp).ifNotExists(this.ifNotExists).ifConditions(this.CASConditions).casResultListener((CASResultListener)this.CASResultListenerO.orNull()).casLocalSerial(this.serialConsistencyO.isPresent());
    }

    public static class CASCondition {
        private String columnName;
        private Object value;

        public CASCondition(String columnName, Object value) {
            Validator.validateNotBlank(columnName, "CAS condition column cannot be blank", new Object[0]);
            this.columnName = columnName;
            this.value = value;
        }

        public void encodedValue(Object encodedValue) {
            this.value = encodedValue;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public Object getValue() {
            return this.value;
        }

        public Clause toClause() {
            return QueryBuilder.eq((String)this.columnName, (Object)this.value);
        }

        public Clause toClauseForPreparedStatement() {
            return QueryBuilder.eq((String)this.columnName, (Object)QueryBuilder.bindMarker((String)this.columnName));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CASCondition that = (CASCondition)o;
            return this.columnName.equals(that.columnName) && this.value.equals(that.value);
        }

        public int hashCode() {
            int result = this.columnName.hashCode();
            result = 31 * result + this.value.hashCode();
            return result;
        }

        public String toString() {
            return Objects.toStringHelper(Options.class).add("columnName", (Object)this.columnName).add("value", this.value).toString();
        }
    }
}

