/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.type;

import com.google.common.base.Optional;
import com.google.common.util.concurrent.FutureCallback;
import info.archinnov.achilles.listener.CASResultListener;
import info.archinnov.achilles.type.ConsistencyLevel;
import info.archinnov.achilles.type.Options;
import java.util.Arrays;
import java.util.List;

public class OptionsBuilder {
    private static final NoOptions noOptions = new NoOptions();

    public static NoOptions noOptions() {
        return noOptions;
    }

    public static BuiltOptions withConsistency(ConsistencyLevel consistencyLevel) {
        return new BuiltOptions(consistencyLevel);
    }

    public static BuiltOptions withTtl(Integer ttl) {
        return new BuiltOptions(ttl);
    }

    public static BuiltOptions withTimestamp(Long timestamp) {
        return new BuiltOptions(timestamp);
    }

    public static BuiltOptions ifNotExists() {
        return new BuiltOptions(true);
    }

    public static BuiltOptions ifConditions(Options.CASCondition ... CASConditions) {
        return new BuiltOptions(CASConditions);
    }

    public static BuiltOptions casResultListener(CASResultListener listener) {
        return new BuiltOptions(listener);
    }

    public static BuiltOptions withAsyncListeners(FutureCallback<Object> ... listeners) {
        return new BuiltOptions(listeners);
    }

    public static BuiltOptions casLocalSerial() {
        return new BuiltOptions((Optional<com.datastax.driver.core.ConsistencyLevel>)Optional.fromNullable((Object)com.datastax.driver.core.ConsistencyLevel.LOCAL_SERIAL));
    }

    public static class BuiltOptions
    extends Options {
        protected BuiltOptions(ConsistencyLevel consistencyLevel) {
            this.consistency = consistencyLevel;
        }

        protected BuiltOptions(Integer ttl) {
            this.ttl = ttl;
        }

        protected BuiltOptions(Long timestamp) {
            this.timestamp = timestamp;
        }

        protected BuiltOptions(boolean ifNotExists) {
            this.ifNotExists = ifNotExists;
        }

        protected BuiltOptions(Options.CASCondition ... CASConditions) {
            this.CASConditions = Arrays.asList(CASConditions);
        }

        protected BuiltOptions(CASResultListener listener) {
            this.CASResultListenerO = Optional.fromNullable((Object)listener);
        }

        protected BuiltOptions(Optional<com.datastax.driver.core.ConsistencyLevel> serialConsistencyO) {
            this.serialConsistencyO = serialConsistencyO;
        }

        protected BuiltOptions(FutureCallback<Object> ... listeners) {
            this.asyncListeners = Arrays.asList(listeners);
        }

        public BuiltOptions withConsistency(ConsistencyLevel consistencyLevel) {
            this.consistency = consistencyLevel;
            return this;
        }

        public BuiltOptions withTtl(Integer ttl) {
            this.ttl = ttl;
            return this;
        }

        public BuiltOptions withTimestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public BuiltOptions ifNotExists() {
            this.ifNotExists = true;
            return this;
        }

        public BuiltOptions ifNotExists(boolean ifNotExists) {
            this.ifNotExists = ifNotExists;
            return this;
        }

        public BuiltOptions casResultListener(CASResultListener listener) {
            this.CASResultListenerO = Optional.fromNullable((Object)listener);
            return this;
        }

        public BuiltOptions ifConditions(Options.CASCondition ... CASConditions) {
            this.CASConditions = Arrays.asList(CASConditions);
            return this;
        }

        public BuiltOptions ifConditions(List<Options.CASCondition> CASConditions) {
            this.CASConditions = CASConditions;
            return this;
        }

        public BuiltOptions casLocalSerial() {
            this.serialConsistencyO = Optional.fromNullable((Object)com.datastax.driver.core.ConsistencyLevel.LOCAL_SERIAL);
            return this;
        }

        BuiltOptions casLocalSerial(boolean localSerial) {
            if (localSerial) {
                this.serialConsistencyO = Optional.fromNullable((Object)com.datastax.driver.core.ConsistencyLevel.LOCAL_SERIAL);
            }
            return this;
        }
    }

    public static class NoOptions
    extends Options {
        protected NoOptions() {
        }

        @Override
        public NoOptions duplicateWithoutTtlAndTimestamp() {
            return this;
        }
    }
}

