/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.type;

import info.archinnov.achilles.type.IndexRelation;
import java.util.Objects;

public class IndexCondition {
    private final String columnName;
    private final IndexRelation indexRelation;
    private Object columnValue;

    public IndexCondition(String columnName, Object columnValue) {
        if (columnName == null || columnName.trim().equals("")) {
            throw new IllegalArgumentException("Column name for index condition '%s' should be provided");
        }
        if (columnValue == null) {
            throw new IllegalArgumentException("Column value for index condition '%s' should be provided");
        }
        this.columnName = columnName;
        this.indexRelation = IndexRelation.EQUAL;
        this.columnValue = columnValue;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public Object getColumnValue() {
        return this.columnValue;
    }

    public void encodedValue(Object encodedValue) {
        this.columnValue = encodedValue;
    }

    public String toString() {
        return "IndexCondition{columnName='" + Objects.toString(this.columnName) + '\'' + ", indexRelation=" + Objects.toString((Object)this.indexRelation) + ", columnValue=" + Objects.toString(this.columnValue) + '}';
    }
}

