/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.type;

import com.fasterxml.jackson.annotation.JsonProperty;
import info.archinnov.achilles.type.Counter;

public class CounterBuilder {
    public static Counter incr() {
        return new CounterImpl(1L);
    }

    public static Counter incr(long incr) {
        return new CounterImpl(incr);
    }

    public static Counter decr() {
        return new CounterImpl(-1L);
    }

    public static Counter decr(long decr) {
        return new CounterImpl(-1L * decr);
    }

    public static class CounterImpl
    implements Counter {
        @JsonProperty
        private long counterValue;

        private CounterImpl(long counterValue) {
            this.counterValue = counterValue;
        }

        @Override
        public Long get() {
            return this.counterValue;
        }

        @Override
        public void incr() {
            ++this.counterValue;
        }

        @Override
        public void incr(long increment) {
            this.counterValue += increment;
        }

        @Override
        public void decr() {
            --this.counterValue;
        }

        @Override
        public void decr(long decrement) {
            this.counterValue -= decrement;
        }
    }
}

