/*
 * Copyright (C) 2012-2014 DuyHai DOAN
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package info.archinnov.achilles.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * <p>
 * Annotation for secondary index. Example
 *
 * <pre class="code"><code class="java">
 *
 *   <strong>{@literal @}Index</strong>
 *   {@literal @}Column
 *   private String countryCode;
 *
 * </code></pre>
 * @see <a href="https://github.com/doanduyhai/Achilles/wiki/Achilles-Annotations#index" target="_blank">@Index</a>
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.FIELD)
@Documented
public @interface Index {
	/**
	 * <p>
	 * Define the name of the secondary index. If not set, defaults to <strong>table name_field name</strong>
     *
     * <pre class="code"><code class="java">
     *
     *   {@literal @}Index(<strong>name = "user_country_code_index"</strong>)
     *   {@literal @}Column
     *   private String countryCode;
     *
     * </code></pre>
	 * </p>
	 */
	String name() default "";
}
