/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.perf;

import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

@State(value=Scope.Benchmark)
public class DefaultExecutorBench {
    public static final int TASKS = 10000;
    public static final int BOUNDED_QUEUE_CAPACITY = 1000;
    public static final int TASK_WEIGHT = 1000000;

    @Benchmark
    public void unlimitedThreadsAndSynchronousQueue(Blackhole blackhole) throws NoSuchFieldException, InterruptedException {
        ThreadPoolExecutor executor = (ThreadPoolExecutor)Executors.newCachedThreadPool();
        this.submitTasks(blackhole, executor);
        this.awaitTermination(executor);
    }

    @Benchmark
    public void cappedThreadsAndSynchronousQueue(Blackhole blackhole) throws NoSuchFieldException, InterruptedException {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 10, 60L, TimeUnit.DAYS, new SynchronousQueue<Runnable>(), new ThreadPoolExecutor.CallerRunsPolicy());
        this.submitTasks(blackhole, executor);
        this.awaitTermination(executor);
    }

    @Benchmark
    public void unlimitedThreadsAndUnboundedLBQ(Blackhole blackhole) throws NoSuchFieldException, InterruptedException {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.DAYS, new LinkedBlockingQueue<Runnable>());
        this.submitTasks(blackhole, executor);
        this.awaitTermination(executor);
    }

    @Benchmark
    public void unlimitedAndBoundedLBQ(Blackhole blackhole) throws NoSuchFieldException, InterruptedException {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.DAYS, new LinkedBlockingQueue<Runnable>(1000), new ThreadPoolExecutor.CallerRunsPolicy());
        this.submitTasks(blackhole, executor);
        this.awaitTermination(executor);
    }

    @Benchmark
    public void cappedThreadsAndBoundedLBQ(Blackhole blackhole) throws NoSuchFieldException, InterruptedException {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 10, 60L, TimeUnit.DAYS, new LinkedBlockingQueue<Runnable>(1000), new ThreadPoolExecutor.CallerRunsPolicy());
        this.submitTasks(blackhole, executor);
        this.awaitTermination(executor);
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(".*" + DefaultExecutorBench.class.getSimpleName() + ".*").warmupIterations(5).measurementIterations(5).shouldDoGC(true).forks(1).build();
        new Runner(opt).run();
    }

    private void awaitTermination(ThreadPoolExecutor executor) throws InterruptedException {
        executor.shutdown();
        executor.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
    }

    private void printThreadCount(ThreadPoolExecutor executor) {
        System.err.println(executor.getPoolSize());
    }

    private void submitTasks(final Blackhole blackhole, ThreadPoolExecutor executor) {
        for (int i = 0; i < 10000; ++i) {
            executor.submit(new Runnable(){

                @Override
                public void run() {
                    blackhole.consume(1000000);
                }
            });
        }
    }
}

