/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.perf;

import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import java.lang.reflect.Field;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@State(value=Scope.Benchmark)
public class LoggerBench {
    private static final Logger logger = LoggerFactory.getLogger(LoggerBench.class);
    String entity = "";
    PropertyMeta idMeta = new PropertyMeta();
    Field field;

    public LoggerBench() {
        try {
            this.field = String.class.getDeclaredField("hash");
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    @Benchmark
    public void log_with_no_guard() throws NoSuchFieldException {
        logger.trace("Get primary key {} from instance {} of class {}", new Object[]{this.idMeta.getPropertyName(), this.entity, this.field.getDeclaringClass().getCanonicalName()});
    }

    @Benchmark
    public void log_with_guard() throws NoSuchFieldException {
        if (logger.isTraceEnabled()) {
            logger.trace("Get primary key {} from instance {} of class {}", new Object[]{this.idMeta.getPropertyName(), this.entity, this.field.getDeclaringClass().getCanonicalName()});
        }
    }

    @Benchmark
    public void log_with_unguarded_method_calls() throws NoSuchFieldException {
        String propertyName = this.idMeta.getPropertyName();
        String canonicalName = this.field.getDeclaringClass().getCanonicalName();
        if (logger.isTraceEnabled()) {
            logger.trace("Get primary key {} from instance {} of class {}", new Object[]{propertyName, this.entity, canonicalName});
        }
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(".*" + LoggerBench.class.getSimpleName() + ".*").warmupIterations(5).measurementIterations(10).forks(1).build();
        new Runner(opt).run();
    }
}

