/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.schema;

import com.google.common.collect.Lists;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.reflections.vfs.Vfs;

public class ReflectionsHelper {
    public static void registerUrlTypes(String ... typesToSkip) {
        ArrayList urlTypes = Lists.newArrayList();
        urlTypes.add(new EmptyIfFileEndingsUrlType(typesToSkip));
        urlTypes.addAll(Arrays.asList(Vfs.DefaultUrlTypes.values()));
        Vfs.setDefaultURLTypes((List)urlTypes);
    }

    private static class EmptyIfFileEndingsUrlType
    implements Vfs.UrlType {
        private final List<String> fileEndings;

        private EmptyIfFileEndingsUrlType(String ... fileEndings) {
            this.fileEndings = Lists.newArrayList((Object[])fileEndings);
        }

        public boolean matches(URL url) {
            String protocol = url.getProtocol();
            String externalForm = url.toExternalForm();
            if (!protocol.equals("file")) {
                return false;
            }
            for (String fileEnding : this.fileEndings) {
                if (!externalForm.endsWith(fileEnding)) continue;
                return true;
            }
            return false;
        }

        public Vfs.Dir createDir(URL url) throws Exception {
            return EmptyIfFileEndingsUrlType.emptyVfsDir(url);
        }

        private static Vfs.Dir emptyVfsDir(final URL url) {
            return new Vfs.Dir(){

                public String getPath() {
                    return url.toExternalForm();
                }

                public Iterable<Vfs.File> getFiles() {
                    return Collections.emptyList();
                }

                public void close() {
                }
            };
        }
    }
}

