/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.schema;

import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.ProtocolVersion;
import com.google.common.collect.Sets;
import info.archinnov.achilles.internals.factory.TupleTypeFactory;
import info.archinnov.achilles.internals.factory.UserTypeFactory;
import info.archinnov.achilles.internals.metamodel.AbstractEntityProperty;
import info.archinnov.achilles.internals.metamodel.AbstractUDTClassProperty;
import info.archinnov.achilles.internals.metamodel.AbstractViewProperty;
import info.archinnov.achilles.internals.schema.SchemaContext;
import info.archinnov.achilles.schema.ReflectionsHelper;
import info.archinnov.achilles.type.tuples.Tuple2;
import info.archinnov.achilles.validation.Validator;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.reflections.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaGenerator.class);
    private static final CodecRegistry CODEC_REGISTRY = new CodecRegistry();
    private static final TupleTypeFactory TUPLE_TYPE_FACTORY = new TupleTypeFactory(ProtocolVersion.NEWEST_SUPPORTED, CODEC_REGISTRY);
    private static final UserTypeFactory USER_TYPE_FACTORY = new UserTypeFactory(ProtocolVersion.NEWEST_SUPPORTED, CODEC_REGISTRY);
    private static final Comparator<Tuple2<String, Class<AbstractEntityProperty<?>>>> BY_NAME_ENTITY_CLASS_SORTER = (o1, o2) -> ((String)o1._1()).compareTo((String)o2._1());
    private static final Comparator<Tuple2<String, Class<AbstractUDTClassProperty<?>>>> BY_NAME_UDT_CLASS_SORTER = (o1, o2) -> ((String)o1._1()).compareTo((String)o2._1());
    private Optional<String> keyspace = Optional.empty();
    private boolean createIndex = true;
    private boolean createUdt = true;

    private SchemaGenerator(String keyspaceName) {
        this.keyspace = Optional.ofNullable(keyspaceName);
    }

    public static void main(String ... args) throws IOException {
        if (args == null || args.length != 4) {
            System.out.println(SchemaGenerator.displayUsage());
        } else {
            String targetFile = args[1];
            String keyspaceName = args[3];
            Path path = new File(targetFile).toPath();
            Files.deleteIfExists(path);
            Files.createFile(path, new FileAttribute[0]);
            SchemaGenerator generator = new SchemaGenerator(keyspaceName);
            generator.createIndex = true;
            generator.createUdt = true;
            generator.generateTo(path);
        }
    }

    private static String displayUsage() {
        StringBuilder builder = new StringBuilder();
        builder.append("*********************************************************************************************************************************************************************\n");
        builder.append("\n");
        builder.append("Usage for Schema Generator : \n");
        builder.append("\n");
        builder.append("java -cp ./your_compiled_entities.jar:./achilles-schema-generator-<version>-shaded.jar info.archinnov.achilles.schema.SchemaGenerator -target <schema_file> -keyspace <keyspace_name> \n");
        builder.append("\n");
        builder.append("*********************************************************************************************************************************************************************\n");
        return builder.toString();
    }

    public static SchemaGenerator builder() {
        return new SchemaGenerator(null);
    }

    public SchemaGenerator withKeyspace(String keyspace) {
        Validator.validateNotBlank((String)keyspace, (String)"Provided keyspace for SchemaGenerator should not be blank", (Object[])new Object[0]);
        this.keyspace = Optional.of(keyspace);
        return this;
    }

    public SchemaGenerator generateCustomTypes(boolean generateCustomTypes) {
        this.createUdt = generateCustomTypes;
        return this;
    }

    public SchemaGenerator withCustomTypes() {
        this.createUdt = true;
        return this;
    }

    public SchemaGenerator withoutCustomTypes() {
        this.createUdt = false;
        return this;
    }

    public SchemaGenerator generateIndices(boolean generateIndices) {
        this.createIndex = generateIndices;
        return this;
    }

    public SchemaGenerator withIndices() {
        this.createIndex = true;
        return this;
    }

    public SchemaGenerator withoutIndices() {
        this.createIndex = false;
        return this;
    }

    public String generate() {
        long viewCount;
        LOGGER.info("Start generating schema file ");
        Validator.validateNotBlank((String)this.keyspace.orElse(""), (String)"Keyspace should be provided to generate schema", (Object[])new Object[0]);
        SchemaContext context = new SchemaContext(this.keyspace.get(), this.createUdt, this.createIndex);
        ReflectionsHelper.registerUrlTypes(".mar", ".jnilib", ".zip");
        Reflections reflections = new Reflections(new Object[]{Sets.newHashSet((Object[])new String[]{"info.archinnov.achilles.generated.meta.entity", "info.archinnov.achilles.generated.meta.udt"}), this.getClass().getClassLoader()});
        StringBuilder builder = new StringBuilder();
        List entityMetas = reflections.getSubTypesOf(AbstractEntityProperty.class).stream().map(x -> Tuple2.of((Object)x.getCanonicalName(), (Object)x)).sorted(BY_NAME_ENTITY_CLASS_SORTER).map(x -> (Class)x._2()).map(SchemaGenerator::newInstanceForEntityProperty).filter(x -> x != null).collect(Collectors.toList());
        LOGGER.info(String.format("Found %s entity meta classes", entityMetas.size()));
        if (context.createUdt) {
            LOGGER.info(String.format("Generating schema for UDT", new Object[0]));
            List udtMetas = reflections.getSubTypesOf(AbstractUDTClassProperty.class).stream().map(x -> Tuple2.of((Object)x.getCanonicalName(), (Object)x)).sorted(BY_NAME_UDT_CLASS_SORTER).map(x -> (Class)x._2()).map(SchemaGenerator::newInstanceForUDTProperty).filter(x -> x != null).collect(Collectors.toList());
            LOGGER.info(String.format("Found %s udt classes", udtMetas.size()));
            for (AbstractUDTClassProperty instance : udtMetas) {
                instance.inject(USER_TYPE_FACTORY);
                instance.inject(TUPLE_TYPE_FACTORY);
                builder.append(instance.generateSchema(context));
            }
        }
        if ((viewCount = entityMetas.stream().filter(AbstractEntityProperty::isView).count()) > 0L) {
            Map<Class, AbstractEntityProperty> entityPropertiesMap = entityMetas.stream().filter(AbstractEntityProperty::isTable).collect(Collectors.toMap(x -> x.entityClass, x -> x));
            entityMetas.stream().filter(AbstractEntityProperty::isView).map(x -> (AbstractViewProperty)x).forEach(x -> x.setBaseClassProperty((AbstractEntityProperty)entityPropertiesMap.get(x.getBaseEntityClass())));
        }
        for (AbstractEntityProperty instance : entityMetas) {
            instance.inject(USER_TYPE_FACTORY);
            instance.inject(TUPLE_TYPE_FACTORY);
            builder.append(instance.generateSchema(context));
        }
        return builder.toString();
    }

    public void generateTo(Appendable appendable) throws IOException {
        String schemaString = this.generate();
        appendable.append(schemaString);
    }

    public void generateTo(Path file) throws IOException {
        Validator.validateTrue((boolean)Files.exists(file, new LinkOption[0]), (String)"'%s' should exist", (Object[])new Object[]{file.toString()});
        Validator.validateTrue((boolean)Files.isWritable(file), (String)"'%s' should have write permission", (Object[])new Object[]{file.toString()});
        OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(file, new OpenOption[0]));
        this.generateTo(writer);
        ((Writer)writer).flush();
        ((Writer)writer).close();
    }

    public void generateTo(File file) throws IOException {
        this.generateTo(file.toPath());
    }

    public static AbstractEntityProperty<?> newInstanceForEntityProperty(Class<? extends AbstractEntityProperty<?>> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static AbstractUDTClassProperty<?> newInstanceForUDTProperty(Class<? extends AbstractUDTClassProperty<?>> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            return null;
        }
    }
}

