package info.archinnov.achilles.generated.dsl;

import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.NotEq;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import info.archinnov.achilles.generated.meta.entity.EntityForJSONCall_AchillesMeta;
import info.archinnov.achilles.internals.dsl.query.delete.AbstractDelete;
import info.archinnov.achilles.internals.dsl.query.delete.AbstractDeleteColumns;
import info.archinnov.achilles.internals.dsl.query.delete.AbstractDeleteEnd;
import info.archinnov.achilles.internals.dsl.query.delete.AbstractDeleteFrom;
import info.archinnov.achilles.internals.dsl.query.delete.AbstractDeleteWhere;
import info.archinnov.achilles.internals.dsl.query.delete.AbstractDeleteWherePartition;
import info.archinnov.achilles.internals.entities.EntityForJSONCall;
import info.archinnov.achilles.internals.metamodel.AbstractEntityProperty;
import info.archinnov.achilles.internals.options.CassandraOptions;
import info.archinnov.achilles.internals.runtime.RuntimeEngine;
import info.archinnov.achilles.type.SchemaNameProvider;
import info.archinnov.achilles.validation.Validator;
import java.lang.Class;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;

public final class EntityForJSONCall_Delete extends AbstractDelete {
  protected final EntityForJSONCall_AchillesMeta meta;

  protected final Class<EntityForJSONCall> entityClass = EntityForJSONCall.class;

  public EntityForJSONCall_Delete(RuntimeEngine rte, EntityForJSONCall_AchillesMeta meta) {
    super(rte);
    this.meta = meta;
  }

  /**
   * Generate DELETE <strong>value</strong> ... */
  public final EntityForJSONCall_Delete.Cols value() {
    delete.column("value");
    return new EntityForJSONCall_Delete.Cols(delete);
  }

  /**
   * Generate DELETE <strong>liststring</strong> ... */
  public final EntityForJSONCall_Delete.Cols listString() {
    delete.column("liststring");
    return new EntityForJSONCall_Delete.Cols(delete);
  }

  /**
   * Generate DELETE <strong>setstring</strong> ... */
  public final EntityForJSONCall_Delete.Cols setString() {
    delete.column("setstring");
    return new EntityForJSONCall_Delete.Cols(delete);
  }

  /**
   * Generate DELETE <strong>mapstring</strong> ... */
  public final EntityForJSONCall_Delete.Cols mapString() {
    delete.column("mapstring");
    return new EntityForJSONCall_Delete.Cols(delete);
  }

  /**
   * Generate ... * FROM ... */
  public final EntityForJSONCall_Delete.F allColumns_FromBaseTable() {
    final Delete.Where where = delete.all().from(meta.getKeyspace().orElse("unknown_keyspace_for_" + meta.entityClass.getCanonicalName()), meta.getTableOrViewName()).where();
    return new EntityForJSONCall_Delete.F(where, new CassandraOptions());
  }

  /**
   * Generate ... * FROM ... using the given SchemaNameProvider */
  public final EntityForJSONCall_Delete.F allColumns_From(final SchemaNameProvider schemaNameProvider) {
    final String currentKeyspace = lookupKeyspace(schemaNameProvider, meta.entityClass);
    final String currentTable = lookupTable(schemaNameProvider, meta.entityClass);
    final Delete.Where where = delete.all().from(currentKeyspace, currentTable).where();
    return new EntityForJSONCall_Delete.F(where, CassandraOptions.withSchemaNameProvider(schemaNameProvider));
  }

  public class Cols extends AbstractDeleteColumns {
    Cols(Delete.Selection deleteColumns) {
      super(deleteColumns);
    }

    /**
     * Generate DELETE <strong>value</strong> ... */
    public final EntityForJSONCall_Delete.Cols value() {
      delete.column("value");
      return this;
    }

    /**
     * Generate DELETE <strong>liststring</strong> ... */
    public final EntityForJSONCall_Delete.Cols listString() {
      delete.column("liststring");
      return this;
    }

    /**
     * Generate DELETE <strong>setstring</strong> ... */
    public final EntityForJSONCall_Delete.Cols setString() {
      delete.column("setstring");
      return this;
    }

    /**
     * Generate DELETE <strong>mapstring</strong> ... */
    public final EntityForJSONCall_Delete.Cols mapString() {
      delete.column("mapstring");
      return this;
    }

    /**
     * Generate a ... <strong>FROM xxx</strong> ...  */
    public final EntityForJSONCall_Delete.F fromBaseTable() {
      final Delete.Where where = deleteColumns.from(meta.getKeyspace().orElse("unknown_keyspace_for_" + meta.entityClass.getCanonicalName()), meta.getTableOrViewName()).where();
      return new EntityForJSONCall_Delete.F(where, new CassandraOptions());
    }

    /**
     * Generate a ... <strong>FROM xxx</strong> ... using the given SchemaNameProvider */
    public final EntityForJSONCall_Delete.F from(final SchemaNameProvider schemaNameProvider) {
      final String currentKeyspace = lookupKeyspace(schemaNameProvider, meta.entityClass);
      final String currentTable = lookupTable(schemaNameProvider, meta.entityClass);
      final Delete.Where where = deleteColumns.from(currentKeyspace, currentTable).where();
      return new EntityForJSONCall_Delete.F(where, CassandraOptions.withSchemaNameProvider(schemaNameProvider));
    }
  }

  public class F extends AbstractDeleteFrom {
    F(Delete.Where where, CassandraOptions cassandraOptions) {
      super(where, cassandraOptions);
    }

    public final EntityForJSONCall_Delete.W_Id where() {
      return new EntityForJSONCall_Delete.W_Id(where, cassandraOptions);
    }
  }

  public final class W_Id extends AbstractDeleteWherePartition {
    public W_Id(Delete.Where where, CassandraOptions cassandraOptions) {
      super(where, cassandraOptions);
    }

    public final EntityForJSONCall_Delete.W_Id.Relation id() {
      return new EntityForJSONCall_Delete.W_Id.Relation();
    }

    public final class Relation {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>id = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Delete.W_Clust Eq(Long id) {
        where.and(QueryBuilder.eq("id", QueryBuilder.bindMarker("id")));
        boundValues.add(id);
        encodedValues.add(meta.id.encodeFromJava(id, Optional.of(cassandraOptions)));
        return new EntityForJSONCall_Delete.W_Clust(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>id IN ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Delete.W_Clust IN(Long... id) {
        Validator.validateTrue(ArrayUtils.isNotEmpty(id), "Varargs for field '%s' should not be null/empty", "id");
        where.and(QueryBuilder.in("id",QueryBuilder.bindMarker("id")));
        final List<Object> varargs = Arrays.<Object>asList((Object[])id);
        final List<Object> encodedVarargs = Arrays.<Long>stream((Long[])id).map(x -> meta.id.encodeFromJava(x, Optional.of(cassandraOptions))).collect(Collectors.toList());
        boundValues.add(varargs);
        encodedValues.add(encodedVarargs);
        return new EntityForJSONCall_Delete.W_Clust(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>id  = fromJson(?) </strong> */
      public final EntityForJSONCall_Delete.W_Clust Eq_FromJson(String id) {
        where.and(QueryBuilder.eq("id", QueryBuilder.fromJson(QueryBuilder.bindMarker("id"))));
        boundValues.add(id);
        encodedValues.add(id);
        return new EntityForJSONCall_Delete.W_Clust(where, cassandraOptions);
      }
    }
  }

  public final class W_Clust extends AbstractDeleteWhere {
    public W_Clust(Delete.Where where, CassandraOptions cassandraOptions) {
      super(where, cassandraOptions);
    }

    public final EntityForJSONCall_Delete.W_Clust.Relation clust() {
      return new EntityForJSONCall_Delete.W_Clust.Relation();
    }

    public final class Relation {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Delete.E Eq(Long clust) {
        where.and(QueryBuilder.eq("clust", QueryBuilder.bindMarker("clust")));
        boundValues.add(clust);
        encodedValues.add(meta.clust.encodeFromJava(clust, Optional.of(cassandraOptions)));
        return new EntityForJSONCall_Delete.E(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust  = fromJson(?) </strong> */
      public final EntityForJSONCall_Delete.E Eq_FromJson(String clust) {
        where.and(QueryBuilder.eq("clust", QueryBuilder.fromJson(QueryBuilder.bindMarker("clust"))));
        boundValues.add(clust);
        encodedValues.add(clust);
        return new EntityForJSONCall_Delete.E(where, cassandraOptions);
      }
    }
  }

  public final class E extends AbstractDeleteEnd<EntityForJSONCall_Delete.E, EntityForJSONCall> {
    public E(Delete.Where where, CassandraOptions cassandraOptions) {
      super(where, cassandraOptions);
    }

    @Override
    protected final Class<EntityForJSONCall> getEntityClass() {
      return entityClass;
    }

    @Override
    protected final AbstractEntityProperty<EntityForJSONCall> getMetaInternal() {
      return meta;
    }

    @Override
    protected final RuntimeEngine getRte() {
      return rte;
    }

    @Override
    protected final CassandraOptions getOptions() {
      return cassandraOptions;
    }

    @Override
    protected final List<Object> getBoundValuesInternal() {
      return boundValues;
    }

    @Override
    protected final List<Object> getEncodedValuesInternal() {
      return encodedValues;
    }

    @Override
    protected final EntityForJSONCall_Delete.E getThis() {
      return this;
    }

    public final E.If_Value if_Value() {
      return new E.If_Value();
    }

    public final E.If_ListString if_ListString() {
      return new E.If_ListString();
    }

    public final E.If_SetString if_SetString() {
      return new E.If_SetString();
    }

    public final E.If_MapString if_MapString() {
      return new E.If_MapString();
    }

    public final class If_Value {
      /**
       * Generate an ... <strong>IF value = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Delete.E Eq(final String value) {
        boundValues.add(value);
        encodedValues.add(meta.value.encodeFromJava(value, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.eq("value", QueryBuilder.bindMarker("value")));
        return EntityForJSONCall_Delete.E.this;
      }

      /**
       * Generate an ... <strong>IF value > ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Delete.E Gt(final String value) {
        boundValues.add(value);
        encodedValues.add(meta.value.encodeFromJava(value, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.gt("value", QueryBuilder.bindMarker("value")));
        return EntityForJSONCall_Delete.E.this;
      }

      /**
       * Generate an ... <strong>IF value >= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Delete.E Gte(final String value) {
        boundValues.add(value);
        encodedValues.add(meta.value.encodeFromJava(value, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.gte("value", QueryBuilder.bindMarker("value")));
        return EntityForJSONCall_Delete.E.this;
      }

      /**
       * Generate an ... <strong>IF value < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Delete.E Lt(final String value) {
        boundValues.add(value);
        encodedValues.add(meta.value.encodeFromJava(value, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.lt("value", QueryBuilder.bindMarker("value")));
        return EntityForJSONCall_Delete.E.this;
      }

      /**
       * Generate an ... <strong>IF value <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Delete.E Lte(final String value) {
        boundValues.add(value);
        encodedValues.add(meta.value.encodeFromJava(value, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.lte("value", QueryBuilder.bindMarker("value")));
        return EntityForJSONCall_Delete.E.this;
      }

      /**
       * Generate an  ... <strong>IF value != ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Delete.E NotEq(final String value) {
        boundValues.add(value);
        encodedValues.add(meta.value.encodeFromJava(value, Optional.of(cassandraOptions)));
        where.onlyIf(NotEq.of("value", QueryBuilder.bindMarker("value")));
        return EntityForJSONCall_Delete.E.this;
      }

      /**
       * Generate an ... <strong>IF value = fromJson(?)</strong> */
      public final EntityForJSONCall_Delete.E Eq_FromJSON(final String value) {
        boundValues.add(value);
        encodedValues.add(value);
        where.onlyIf(QueryBuilder.eq("value", QueryBuilder.fromJson(QueryBuilder.bindMarker("value"))));
        return EntityForJSONCall_Delete.E.this;
      }
    }

    public final class If_ListString {
      /**
       * Generate an ... <strong>IF listString = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Delete.E Eq(final List<String> listString) {
        boundValues.add(listString);
        encodedValues.add(meta.listString.encodeFromJava(listString, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.eq("liststring", QueryBuilder.bindMarker("liststring")));
        return EntityForJSONCall_Delete.E.this;
      }

      /**
       * Generate an ... <strong>IF listString > ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Delete.E Gt(final List<String> listString) {
        boundValues.add(listString);
        encodedValues.add(meta.listString.encodeFromJava(listString, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.gt("liststring", QueryBuilder.bindMarker("liststring")));
        return EntityForJSONCall_Delete.E.this;
      }

      /**
       * Generate an ... <strong>IF listString >= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Delete.E Gte(final List<String> listString) {
        boundValues.add(listString);
        encodedValues.add(meta.listString.encodeFromJava(listString, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.gte("liststring", QueryBuilder.bindMarker("liststring")));
        return EntityForJSONCall_Delete.E.this;
      }

      /**
       * Generate an ... <strong>IF listString < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Delete.E Lt(final List<String> listString) {
        boundValues.add(listString);
        encodedValues.add(meta.listString.encodeFromJava(listString, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.lt("liststring", QueryBuilder.bindMarker("liststring")));
        return EntityForJSONCall_Delete.E.this;
      }

      /**
       * Generate an ... <strong>IF listString <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Delete.E Lte(final List<String> listString) {
        boundValues.add(listString);
        encodedValues.add(meta.listString.encodeFromJava(listString, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.lte("liststring", QueryBuilder.bindMarker("liststring")));
        return EntityForJSONCall_Delete.E.this;
      }

      /**
       * Generate an  ... <strong>IF listString != ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Delete.E NotEq(final List<String> listString) {
        boundValues.add(listString);
        encodedValues.add(meta.listString.encodeFromJava(listString, Optional.of(cassandraOptions)));
        where.onlyIf(NotEq.of("liststring", QueryBuilder.bindMarker("liststring")));
        return EntityForJSONCall_Delete.E.this;
      }

      /**
       * Generate an ... <strong>IF listString = fromJson(?)</strong> */
      public final EntityForJSONCall_Delete.E Eq_FromJSON(final String listString) {
        boundValues.add(listString);
        encodedValues.add(listString);
        where.onlyIf(QueryBuilder.eq("liststring", QueryBuilder.fromJson(QueryBuilder.bindMarker("liststring"))));
        return EntityForJSONCall_Delete.E.this;
      }
    }

    public final class If_SetString {
      /**
       * Generate an ... <strong>IF setString = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Delete.E Eq(final Set<String> setString) {
        boundValues.add(setString);
        encodedValues.add(meta.setString.encodeFromJava(setString, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.eq("setstring", QueryBuilder.bindMarker("setstring")));
        return EntityForJSONCall_Delete.E.this;
      }

      /**
       * Generate an ... <strong>IF setString > ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Delete.E Gt(final Set<String> setString) {
        boundValues.add(setString);
        encodedValues.add(meta.setString.encodeFromJava(setString, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.gt("setstring", QueryBuilder.bindMarker("setstring")));
        return EntityForJSONCall_Delete.E.this;
      }

      /**
       * Generate an ... <strong>IF setString >= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Delete.E Gte(final Set<String> setString) {
        boundValues.add(setString);
        encodedValues.add(meta.setString.encodeFromJava(setString, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.gte("setstring", QueryBuilder.bindMarker("setstring")));
        return EntityForJSONCall_Delete.E.this;
      }

      /**
       * Generate an ... <strong>IF setString < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Delete.E Lt(final Set<String> setString) {
        boundValues.add(setString);
        encodedValues.add(meta.setString.encodeFromJava(setString, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.lt("setstring", QueryBuilder.bindMarker("setstring")));
        return EntityForJSONCall_Delete.E.this;
      }

      /**
       * Generate an ... <strong>IF setString <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Delete.E Lte(final Set<String> setString) {
        boundValues.add(setString);
        encodedValues.add(meta.setString.encodeFromJava(setString, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.lte("setstring", QueryBuilder.bindMarker("setstring")));
        return EntityForJSONCall_Delete.E.this;
      }

      /**
       * Generate an  ... <strong>IF setString != ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Delete.E NotEq(final Set<String> setString) {
        boundValues.add(setString);
        encodedValues.add(meta.setString.encodeFromJava(setString, Optional.of(cassandraOptions)));
        where.onlyIf(NotEq.of("setstring", QueryBuilder.bindMarker("setstring")));
        return EntityForJSONCall_Delete.E.this;
      }

      /**
       * Generate an ... <strong>IF setString = fromJson(?)</strong> */
      public final EntityForJSONCall_Delete.E Eq_FromJSON(final String setString) {
        boundValues.add(setString);
        encodedValues.add(setString);
        where.onlyIf(QueryBuilder.eq("setstring", QueryBuilder.fromJson(QueryBuilder.bindMarker("setstring"))));
        return EntityForJSONCall_Delete.E.this;
      }
    }

    public final class If_MapString {
      /**
       * Generate an ... <strong>IF mapString = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Delete.E Eq(final Map<Integer, String> mapString) {
        boundValues.add(mapString);
        encodedValues.add(meta.mapString.encodeFromJava(mapString, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.eq("mapstring", QueryBuilder.bindMarker("mapstring")));
        return EntityForJSONCall_Delete.E.this;
      }

      /**
       * Generate an ... <strong>IF mapString > ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Delete.E Gt(final Map<Integer, String> mapString) {
        boundValues.add(mapString);
        encodedValues.add(meta.mapString.encodeFromJava(mapString, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.gt("mapstring", QueryBuilder.bindMarker("mapstring")));
        return EntityForJSONCall_Delete.E.this;
      }

      /**
       * Generate an ... <strong>IF mapString >= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Delete.E Gte(final Map<Integer, String> mapString) {
        boundValues.add(mapString);
        encodedValues.add(meta.mapString.encodeFromJava(mapString, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.gte("mapstring", QueryBuilder.bindMarker("mapstring")));
        return EntityForJSONCall_Delete.E.this;
      }

      /**
       * Generate an ... <strong>IF mapString < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Delete.E Lt(final Map<Integer, String> mapString) {
        boundValues.add(mapString);
        encodedValues.add(meta.mapString.encodeFromJava(mapString, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.lt("mapstring", QueryBuilder.bindMarker("mapstring")));
        return EntityForJSONCall_Delete.E.this;
      }

      /**
       * Generate an ... <strong>IF mapString <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Delete.E Lte(final Map<Integer, String> mapString) {
        boundValues.add(mapString);
        encodedValues.add(meta.mapString.encodeFromJava(mapString, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.lte("mapstring", QueryBuilder.bindMarker("mapstring")));
        return EntityForJSONCall_Delete.E.this;
      }

      /**
       * Generate an  ... <strong>IF mapString != ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Delete.E NotEq(final Map<Integer, String> mapString) {
        boundValues.add(mapString);
        encodedValues.add(meta.mapString.encodeFromJava(mapString, Optional.of(cassandraOptions)));
        where.onlyIf(NotEq.of("mapstring", QueryBuilder.bindMarker("mapstring")));
        return EntityForJSONCall_Delete.E.this;
      }

      /**
       * Generate an ... <strong>IF mapString = fromJson(?)</strong> */
      public final EntityForJSONCall_Delete.E Eq_FromJSON(final String mapString) {
        boundValues.add(mapString);
        encodedValues.add(mapString);
        where.onlyIf(QueryBuilder.eq("mapstring", QueryBuilder.fromJson(QueryBuilder.bindMarker("mapstring"))));
        return EntityForJSONCall_Delete.E.this;
      }
    }
  }
}
