package info.archinnov.achilles.generated.dsl;

import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import info.archinnov.achilles.generated.meta.entity.EntityForJSONCall_AchillesMeta;
import info.archinnov.achilles.internals.dsl.query.select.AbstractSelect;
import info.archinnov.achilles.internals.dsl.query.select.AbstractSelectColumns;
import info.archinnov.achilles.internals.dsl.query.select.AbstractSelectColumnsTypeMap;
import info.archinnov.achilles.internals.dsl.query.select.AbstractSelectFrom;
import info.archinnov.achilles.internals.dsl.query.select.AbstractSelectFromJSON;
import info.archinnov.achilles.internals.dsl.query.select.AbstractSelectFromTypeMap;
import info.archinnov.achilles.internals.dsl.query.select.AbstractSelectWhere;
import info.archinnov.achilles.internals.dsl.query.select.AbstractSelectWhereJSON;
import info.archinnov.achilles.internals.dsl.query.select.AbstractSelectWherePartition;
import info.archinnov.achilles.internals.dsl.query.select.AbstractSelectWherePartitionJSON;
import info.archinnov.achilles.internals.dsl.query.select.AbstractSelectWherePartitionTypeMap;
import info.archinnov.achilles.internals.dsl.query.select.AbstractSelectWhereTypeMap;
import info.archinnov.achilles.internals.entities.EntityForJSONCall;
import info.archinnov.achilles.internals.metamodel.AbstractEntityProperty;
import info.archinnov.achilles.internals.metamodel.functions.FunctionCall;
import info.archinnov.achilles.internals.options.CassandraOptions;
import info.archinnov.achilles.internals.runtime.RuntimeEngine;
import info.archinnov.achilles.type.SchemaNameProvider;
import info.archinnov.achilles.validation.Validator;
import java.lang.Class;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;

public final class EntityForJSONCall_Select extends AbstractSelect {
  protected final EntityForJSONCall_AchillesMeta meta;

  protected final Class<EntityForJSONCall> entityClass = EntityForJSONCall.class;

  public EntityForJSONCall_Select(RuntimeEngine rte, EntityForJSONCall_AchillesMeta meta) {
    super(rte);
    this.meta = meta;
  }

  /**
   * Generate a SELECT ... <strong>id</strong> ... */
  public final EntityForJSONCall_Select.Cols id() {
    select.column("id");
    return new EntityForJSONCall_Select.Cols(select);
  }

  /**
   * Generate a SELECT ... <strong>clust</strong> ... */
  public final EntityForJSONCall_Select.Cols clust() {
    select.column("clust");
    return new EntityForJSONCall_Select.Cols(select);
  }

  /**
   * Generate a SELECT ... <strong>value</strong> ... */
  public final EntityForJSONCall_Select.Cols value() {
    select.column("value");
    return new EntityForJSONCall_Select.Cols(select);
  }

  /**
   * Generate a SELECT ... <strong>liststring</strong> ... */
  public final EntityForJSONCall_Select.Cols listString() {
    select.column("liststring");
    return new EntityForJSONCall_Select.Cols(select);
  }

  /**
   * Generate a SELECT ... <strong>setstring</strong> ... */
  public final EntityForJSONCall_Select.Cols setString() {
    select.column("setstring");
    return new EntityForJSONCall_Select.Cols(select);
  }

  /**
   * Generate a SELECT ... <strong>mapstring</strong> ... */
  public final EntityForJSONCall_Select.Cols mapString() {
    select.column("mapstring");
    return new EntityForJSONCall_Select.Cols(select);
  }

  /**
   * Use this method to call a system or user-defined function.<br/>All the system functions are accessible from the <strong>{@link info.archinnov.achilles.generated.function.SystemFunctions}</strong> class<br/>All the user-defined functions and aggregates are accessible from the <strong>{@link info.archinnov.achilles.generated.function.FunctionsRegistry}</strong> class<br/>System and user-defined functions accept only appropriate type. To pass in an entity field as function argument, use the generated <strong>manager.COLUMNS</strong> class which exposes all columns with their appropriate type<br/>Example: <pre class="code"><code class="java">
   *   {@literal @}Table
   *   public class MyEntity {
   *
   *       ...
   *
   *       {@literal @}Column("value_column")
   *       private String value;
   *
   *       {@literal @}Column("list_of_string")
   *       private List<String> strings;
   *
   *       ...
   *
   *   }
   *
   *   {@literal @}FunctionsRegistry
   *   public interface MyFunctions {
   *
   *        String convertListToJson(List<String> strings);
   *
   *   }
   *
   *
   *   ...
   *
   *
   *   manager
   *      .dsl()
   *      .select()
   *      // This call will generate SELECT cast(writetime(value_column) as text) AS writetimeOfValueAsString, ...
   *      .function(SystemFunctions.castAsText(SystemFunctions.writetime(manager.COLUMNS.VALUE)), "writetimeOfValueAsString")
   *      ...
   *
   *   manager
   *      .dsl()
   *      .select()
   *      // This call will generate SELECT convertlisttojson(list_of_string) AS strings_as_json, ...
   *      .function(FunctionsRegistry.convertListToJson(manager.COLUMNS.STRINGS), "strings_as_json")
   *      ...
   *
   * </code></pre>
   * <br/>
   * @param functionCall the function call object
   * @param alias mandatory alias for this function call for easier retrieval from the ResultSet
   * @return a built-in function call passed to the QueryBuilder object
   */
  public final EntityForJSONCall_Select.ColsTM function(final FunctionCall functionCall, final String alias) {
    functionCall.addToSelect(select, alias);
    return new EntityForJSONCall_Select.ColsTM(select);
  }

  /**
   * Generate ... * FROM ... */
  public final EntityForJSONCall_Select.F allColumns_FromBaseTable() {
    final Select.Where where = select.all().from(meta.getKeyspace().orElse("unknown_keyspace_for_" + meta.entityClass.getCanonicalName()), meta.getTableOrViewName()).where();
    return new EntityForJSONCall_Select.F(where, new CassandraOptions());
  }

  /**
   * Generate ... * FROM ... using the given SchemaNameProvider */
  public final EntityForJSONCall_Select.F allColumns_From(final SchemaNameProvider schemaNameProvider) {
    final String currentKeyspace = lookupKeyspace(schemaNameProvider, meta.entityClass);
    final String currentTable = lookupTable(schemaNameProvider, meta.entityClass);
    final Select.Where where = select.all().from(currentKeyspace, currentTable).where();
    return new EntityForJSONCall_Select.F(where, CassandraOptions.withSchemaNameProvider(schemaNameProvider));
  }

  /**
   * Generate ... * FROM ... */
  public final EntityForJSONCall_Select.F_J allColumnsAsJSON_FromBaseTable() {
    final Select.Where where = select.json().all().from(meta.getKeyspace().orElse("unknown_keyspace_for_" + meta.entityClass.getCanonicalName()), meta.getTableOrViewName()).where();
    return new EntityForJSONCall_Select.F_J(where, new CassandraOptions());
  }

  /**
   * Generate ... * FROM ... using the given SchemaNameProvider */
  public final EntityForJSONCall_Select.F_J allColumnsAsJSON_From(final SchemaNameProvider schemaNameProvider) {
    final String currentKeyspace = lookupKeyspace(schemaNameProvider, meta.entityClass);
    final String currentTable = lookupTable(schemaNameProvider, meta.entityClass);
    final Select.Where where = select.json().all().from(currentKeyspace, currentTable).where();
    return new EntityForJSONCall_Select.F_J(where, CassandraOptions.withSchemaNameProvider(schemaNameProvider));
  }

  public class Cols extends AbstractSelectColumns {
    public Cols(Select.Selection selection) {
      super(selection);
    }

    /**
     * Generate a SELECT ... <strong>id</strong> ... */
    public final EntityForJSONCall_Select.Cols id() {
      selection.column("id");
      return this;
    }

    /**
     * Generate a SELECT ... <strong>clust</strong> ... */
    public final EntityForJSONCall_Select.Cols clust() {
      selection.column("clust");
      return this;
    }

    /**
     * Generate a SELECT ... <strong>value</strong> ... */
    public final EntityForJSONCall_Select.Cols value() {
      selection.column("value");
      return this;
    }

    /**
     * Generate a SELECT ... <strong>liststring</strong> ... */
    public final EntityForJSONCall_Select.Cols listString() {
      selection.column("liststring");
      return this;
    }

    /**
     * Generate a SELECT ... <strong>setstring</strong> ... */
    public final EntityForJSONCall_Select.Cols setString() {
      selection.column("setstring");
      return this;
    }

    /**
     * Generate a SELECT ... <strong>mapstring</strong> ... */
    public final EntityForJSONCall_Select.Cols mapString() {
      selection.column("mapstring");
      return this;
    }

    /**
     * Use this method to call a system or user-defined function.<br/>All the system functions are accessible from the <strong>{@link info.archinnov.achilles.generated.function.SystemFunctions}</strong> class<br/>All the user-defined functions and aggregates are accessible from the <strong>{@link info.archinnov.achilles.generated.function.FunctionsRegistry}</strong> class<br/>System and user-defined functions accept only appropriate type. To pass in an entity field as function argument, use the generated <strong>manager.COLUMNS</strong> class which exposes all columns with their appropriate type<br/>Example: <pre class="code"><code class="java">
     *   {@literal @}Table
     *   public class MyEntity {
     *
     *       ...
     *
     *       {@literal @}Column("value_column")
     *       private String value;
     *
     *       {@literal @}Column("list_of_string")
     *       private List<String> strings;
     *
     *       ...
     *
     *   }
     *
     *   {@literal @}FunctionsRegistry
     *   public interface MyFunctions {
     *
     *        String convertListToJson(List<String> strings);
     *
     *   }
     *
     *
     *   ...
     *
     *
     *   manager
     *      .dsl()
     *      .select()
     *      // This call will generate SELECT cast(writetime(value_column) as text) AS writetimeOfValueAsString, ...
     *      .function(SystemFunctions.castAsText(SystemFunctions.writetime(manager.COLUMNS.VALUE)), "writetimeOfValueAsString")
     *      ...
     *
     *   manager
     *      .dsl()
     *      .select()
     *      // This call will generate SELECT convertlisttojson(list_of_string) AS strings_as_json, ...
     *      .function(FunctionsRegistry.convertListToJson(manager.COLUMNS.STRINGS), "strings_as_json")
     *      ...
     *
     * </code></pre>
     * <br/>
     * @param functionCall the function call object
     * @param alias mandatory alias for this function call for easier retrieval from the ResultSet
     * @return a built-in function call passed to the QueryBuilder object
     */
    public final EntityForJSONCall_Select.ColsTM function(final FunctionCall functionCall, final String alias) {
      functionCall.addToSelect(selection, alias);
      return new EntityForJSONCall_Select.ColsTM(select);
    }

    /**
     * Generate a ... <strong>FROM xxx</strong> ...  */
    public final EntityForJSONCall_Select.F fromBaseTable() {
      final Select.Where where = selection.from(meta.getKeyspace().orElse("unknown_keyspace_for_" + meta.entityClass.getCanonicalName()), meta.getTableOrViewName()).where();
      return new EntityForJSONCall_Select.F(where, new CassandraOptions());
    }

    /**
     * Generate a ... <strong>FROM xxx</strong> ... using the given SchemaNameProvider */
    public final EntityForJSONCall_Select.F from(final SchemaNameProvider schemaNameProvider) {
      final String currentKeyspace = lookupKeyspace(schemaNameProvider, meta.entityClass);
      final String currentTable = lookupTable(schemaNameProvider, meta.entityClass);
      final Select.Where where = selection.from(currentKeyspace, currentTable).where();
      return new EntityForJSONCall_Select.F(where, CassandraOptions.withSchemaNameProvider(schemaNameProvider));
    }
  }

  public class ColsTM extends AbstractSelectColumnsTypeMap {
    public ColsTM(Select.Selection selection) {
      super(selection);
    }

    /**
     * Generate a SELECT ... <strong>id</strong> ... */
    public final EntityForJSONCall_Select.ColsTM id() {
      selection.column("id");
      return this;
    }

    /**
     * Generate a SELECT ... <strong>clust</strong> ... */
    public final EntityForJSONCall_Select.ColsTM clust() {
      selection.column("clust");
      return this;
    }

    /**
     * Generate a SELECT ... <strong>value</strong> ... */
    public final EntityForJSONCall_Select.ColsTM value() {
      selection.column("value");
      return this;
    }

    /**
     * Generate a SELECT ... <strong>liststring</strong> ... */
    public final EntityForJSONCall_Select.ColsTM listString() {
      selection.column("liststring");
      return this;
    }

    /**
     * Generate a SELECT ... <strong>setstring</strong> ... */
    public final EntityForJSONCall_Select.ColsTM setString() {
      selection.column("setstring");
      return this;
    }

    /**
     * Generate a SELECT ... <strong>mapstring</strong> ... */
    public final EntityForJSONCall_Select.ColsTM mapString() {
      selection.column("mapstring");
      return this;
    }

    /**
     * Use this method to call a system or user-defined function.<br/>All the system functions are accessible from the <strong>{@link info.archinnov.achilles.generated.function.SystemFunctions}</strong> class<br/>All the user-defined functions and aggregates are accessible from the <strong>{@link info.archinnov.achilles.generated.function.FunctionsRegistry}</strong> class<br/>System and user-defined functions accept only appropriate type. To pass in an entity field as function argument, use the generated <strong>manager.COLUMNS</strong> class which exposes all columns with their appropriate type<br/>Example: <pre class="code"><code class="java">
     *   {@literal @}Table
     *   public class MyEntity {
     *
     *       ...
     *
     *       {@literal @}Column("value_column")
     *       private String value;
     *
     *       {@literal @}Column("list_of_string")
     *       private List<String> strings;
     *
     *       ...
     *
     *   }
     *
     *   {@literal @}FunctionsRegistry
     *   public interface MyFunctions {
     *
     *        String convertListToJson(List<String> strings);
     *
     *   }
     *
     *
     *   ...
     *
     *
     *   manager
     *      .dsl()
     *      .select()
     *      // This call will generate SELECT cast(writetime(value_column) as text) AS writetimeOfValueAsString, ...
     *      .function(SystemFunctions.castAsText(SystemFunctions.writetime(manager.COLUMNS.VALUE)), "writetimeOfValueAsString")
     *      ...
     *
     *   manager
     *      .dsl()
     *      .select()
     *      // This call will generate SELECT convertlisttojson(list_of_string) AS strings_as_json, ...
     *      .function(FunctionsRegistry.convertListToJson(manager.COLUMNS.STRINGS), "strings_as_json")
     *      ...
     *
     * </code></pre>
     * <br/>
     * @param functionCall the function call object
     * @param alias mandatory alias for this function call for easier retrieval from the ResultSet
     * @return a built-in function call passed to the QueryBuilder object
     */
    public final EntityForJSONCall_Select.ColsTM function(final FunctionCall functionCall, final String alias) {
      functionCall.addToSelect(selection, alias);
      return this;
    }

    /**
     * Generate a ... <strong>FROM xxx</strong> ...  */
    public final EntityForJSONCall_Select.F_TM fromBaseTable() {
      final Select.Where where = selection.from(meta.getKeyspace().orElse("unknown_keyspace_for_" + meta.entityClass.getCanonicalName()), meta.getTableOrViewName()).where();
      return new EntityForJSONCall_Select.F_TM(where, new CassandraOptions());
    }

    /**
     * Generate a ... <strong>FROM xxx</strong> ... using the given SchemaNameProvider */
    public final EntityForJSONCall_Select.F_TM from(final SchemaNameProvider schemaNameProvider) {
      final String currentKeyspace = lookupKeyspace(schemaNameProvider, meta.entityClass);
      final String currentTable = lookupTable(schemaNameProvider, meta.entityClass);
      final Select.Where where = selection.from(currentKeyspace, currentTable).where();
      return new EntityForJSONCall_Select.F_TM(where, CassandraOptions.withSchemaNameProvider(schemaNameProvider));
    }
  }

  public class F extends AbstractSelectFrom {
    F(Select.Where where, CassandraOptions cassandraOptions) {
      super(where, cassandraOptions);
    }

    /**
     * Generate a SELECT ... FROM ... <strong>WHERE</strong> ... */
    public final EntityForJSONCall_Select.W_Id where() {
      return new EntityForJSONCall_Select.W_Id(where, cassandraOptions);
    }

    /**
     * Generate a SELECT statement <strong>without</strong> the <strong>WHERE</strong> clause */
    public final EntityForJSONCall_Select.E without_WHERE_Clause() {
      return new EntityForJSONCall_Select.E(where, cassandraOptions);
    }
  }

  public class F_TM extends AbstractSelectFromTypeMap {
    F_TM(Select.Where where, CassandraOptions cassandraOptions) {
      super(where, cassandraOptions);
    }

    /**
     * Generate a SELECT ... FROM ... <strong>WHERE</strong> ... */
    public final EntityForJSONCall_Select.W_TM_Id where() {
      return new EntityForJSONCall_Select.W_TM_Id(where, cassandraOptions);
    }

    /**
     * Generate a SELECT statement <strong>without</strong> the <strong>WHERE</strong> clause */
    public final EntityForJSONCall_Select.E_TM without_WHERE_Clause() {
      return new EntityForJSONCall_Select.E_TM(where, cassandraOptions);
    }
  }

  public class F_J extends AbstractSelectFromJSON {
    F_J(Select.Where where, CassandraOptions cassandraOptions) {
      super(where, cassandraOptions);
    }

    /**
     * Generate a SELECT ... FROM ... <strong>WHERE</strong> ... */
    public final EntityForJSONCall_Select.W_J_Id where() {
      return new EntityForJSONCall_Select.W_J_Id(where, cassandraOptions);
    }

    /**
     * Generate a SELECT statement <strong>without</strong> the <strong>WHERE</strong> clause */
    public final EntityForJSONCall_Select.E_J without_WHERE_Clause() {
      return new EntityForJSONCall_Select.E_J(where, cassandraOptions);
    }
  }

  public final class W_Id extends AbstractSelectWherePartition {
    public W_Id(Select.Where where, CassandraOptions cassandraOptions) {
      super(where, cassandraOptions);
    }

    public final EntityForJSONCall_Select.W_Id.Relation id() {
      return new EntityForJSONCall_Select.W_Id.Relation();
    }

    public final EntityForJSONCall_Select.W_Id.Token tokenValueOf_id() {
      return new EntityForJSONCall_Select.W_Id.Token();
    }

    public final class Relation {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>id = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Select.W_Clust Eq(Long id) {
        where.and(QueryBuilder.eq("id", QueryBuilder.bindMarker("id")));
        boundValues.add(id);
        encodedValues.add(meta.id.encodeFromJava(id, Optional.of(cassandraOptions)));
        return new EntityForJSONCall_Select.W_Clust(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>id IN ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Select.W_Clust IN(Long... id) {
        Validator.validateTrue(ArrayUtils.isNotEmpty(id), "Varargs for field '%s' should not be null/empty", "id");
        where.and(QueryBuilder.in("id",QueryBuilder.bindMarker("id")));
        final List<Object> varargs = Arrays.<Object>asList((Object[])id);
        final List<Object> encodedVarargs = Arrays.<Long>stream((Long[])id).map(x -> meta.id.encodeFromJava(x, Optional.of(cassandraOptions))).collect(Collectors.toList());
        boundValues.add(varargs);
        encodedValues.add(encodedVarargs);
        return new EntityForJSONCall_Select.W_Clust(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>id  = fromJson(?) </strong> */
      public final EntityForJSONCall_Select.W_Clust Eq_FromJson(String id) {
        where.and(QueryBuilder.eq("id", QueryBuilder.fromJson(QueryBuilder.bindMarker("id"))));
        boundValues.add(id);
        encodedValues.add(id);
        return new EntityForJSONCall_Select.W_Clust(where, cassandraOptions);
      }
    }

    public final class Token {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>token(id) = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Select.E Eq(Long tokenValue) {
        where.and(QueryBuilder.eq("token(id)", QueryBuilder.bindMarker("tokenValue")));
        boundValues.add(tokenValue);
        encodedValues.add(tokenValue);
        return new EntityForJSONCall_Select.E(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>token(id) > ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Select.E Gt(Long tokenValue) {
        where.and(QueryBuilder.gt("token(id)", QueryBuilder.bindMarker("tokenValue")));
        boundValues.add(tokenValue);
        encodedValues.add(tokenValue);
        return new EntityForJSONCall_Select.E(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>token(id) >= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Select.E Gte(Long tokenValue) {
        where.and(QueryBuilder.gte("token(id)", QueryBuilder.bindMarker("tokenValue")));
        boundValues.add(tokenValue);
        encodedValues.add(tokenValue);
        return new EntityForJSONCall_Select.E(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>token(id) < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Select.E Lt(Long tokenValue) {
        where.and(QueryBuilder.lt("token(id)", QueryBuilder.bindMarker("tokenValue")));
        boundValues.add(tokenValue);
        encodedValues.add(tokenValue);
        return new EntityForJSONCall_Select.E(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>token(id) <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Select.E Lte(Long tokenValue) {
        where.and(QueryBuilder.lte("token(id)", QueryBuilder.bindMarker("tokenValue")));
        boundValues.add(tokenValue);
        encodedValues.add(tokenValue);
        return new EntityForJSONCall_Select.E(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>token(id) > ? AND token(id) < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Select.E Gt_And_Lt(Long tokenValue1, Long tokenValue2) {
        where.and(QueryBuilder.gt("token(id)",QueryBuilder.bindMarker("tokenValue1")));
        where.and(QueryBuilder.lt("token(id)",QueryBuilder.bindMarker("tokenValue2")));
        boundValues.add(tokenValue1);
        encodedValues.add(tokenValue1);
        boundValues.add(tokenValue2);
        encodedValues.add(tokenValue2);
        return new EntityForJSONCall_Select.E(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>token(id) > ? AND token(id) <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Select.E Gt_And_Lte(Long tokenValue1, Long tokenValue2) {
        where.and(QueryBuilder.gt("token(id)",QueryBuilder.bindMarker("tokenValue1")));
        where.and(QueryBuilder.lte("token(id)",QueryBuilder.bindMarker("tokenValue2")));
        boundValues.add(tokenValue1);
        encodedValues.add(tokenValue1);
        boundValues.add(tokenValue2);
        encodedValues.add(tokenValue2);
        return new EntityForJSONCall_Select.E(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>token(id) >= ? AND token(id) < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Select.E Gte_And_Lt(Long tokenValue1, Long tokenValue2) {
        where.and(QueryBuilder.gte("token(id)",QueryBuilder.bindMarker("tokenValue1")));
        where.and(QueryBuilder.lt("token(id)",QueryBuilder.bindMarker("tokenValue2")));
        boundValues.add(tokenValue1);
        encodedValues.add(tokenValue1);
        boundValues.add(tokenValue2);
        encodedValues.add(tokenValue2);
        return new EntityForJSONCall_Select.E(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>token(id) >= ? AND token(id) <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Select.E Gte_And_Lte(Long tokenValue1, Long tokenValue2) {
        where.and(QueryBuilder.gte("token(id)",QueryBuilder.bindMarker("tokenValue1")));
        where.and(QueryBuilder.lte("token(id)",QueryBuilder.bindMarker("tokenValue2")));
        boundValues.add(tokenValue1);
        encodedValues.add(tokenValue1);
        boundValues.add(tokenValue2);
        encodedValues.add(tokenValue2);
        return new EntityForJSONCall_Select.E(where, cassandraOptions);
      }
    }
  }

  public final class W_Clust extends AbstractSelectWhere<EntityForJSONCall_Select.W_Clust, EntityForJSONCall> {
    public W_Clust(Select.Where where, CassandraOptions cassandraOptions) {
      super(where, cassandraOptions);
    }

    @Override
    protected final EntityForJSONCall_Select.W_Clust getThis() {
      return this;
    }

    @Override
    protected final AbstractEntityProperty<EntityForJSONCall> getMetaInternal() {
      return meta;
    }

    @Override
    protected final Class<EntityForJSONCall> getEntityClass() {
      return entityClass;
    }

    @Override
    protected final RuntimeEngine getRte() {
      return rte;
    }

    @Override
    protected final CassandraOptions getOptions() {
      return cassandraOptions;
    }

    @Override
    protected final List<Object> getBoundValuesInternal() {
      return boundValues;
    }

    @Override
    protected final List<Object> getEncodedValuesInternal() {
      return encodedValues;
    }

    /**
     * Generate a SELECT ... FROM ... WHERE ... <strong>LIMIT :limit</strong> */
    public final EntityForJSONCall_Select.W_Clust limit(final Integer limit) {
      where.limit(QueryBuilder.bindMarker("lim"));
      boundValues.add(limit);
      encodedValues.add(limit);
      return this;
    }

    public final EntityForJSONCall_Select.W_Clust.Relation clust() {
      return new EntityForJSONCall_Select.W_Clust.Relation();
    }

    /**
     * Generate a SELECT ... FROM ... WHERE ... <strong>ORDER BY clust ASC</strong> */
    public final EntityForJSONCall_Select.W_Clust orderByClustAscending() {
      where.orderBy(QueryBuilder.asc("clust"));
      return this;
    }

    /**
     * Generate a SELECT ... FROM ... WHERE ... <strong>ORDER BY clust DESC</strong> */
    public final EntityForJSONCall_Select.W_Clust orderByClustDescending() {
      where.orderBy(QueryBuilder.desc("clust"));
      return this;
    }

    public final class Relation {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Select.E Eq(Long clust) {
        where.and(QueryBuilder.eq("clust", QueryBuilder.bindMarker("clust")));
        boundValues.add(clust);
        encodedValues.add(meta.clust.encodeFromJava(clust, Optional.of(cassandraOptions)));
        return new EntityForJSONCall_Select.E(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust IN ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Select.E IN(Long... clust) {
        Validator.validateTrue(ArrayUtils.isNotEmpty(clust), "Varargs for field '%s' should not be null/empty", "clust");
        where.and(QueryBuilder.in("clust",QueryBuilder.bindMarker("clust")));
        final List<Object> varargs = Arrays.<Object>asList((Object[])clust);
        final List<Object> encodedVarargs = Arrays.<Long>stream((Long[])clust).map(x -> meta.clust.encodeFromJava(x, Optional.of(cassandraOptions))).collect(Collectors.toList());
        boundValues.add(varargs);
        encodedValues.add(encodedVarargs);
        return new EntityForJSONCall_Select.E(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust > ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Select.E Gt(Long clust) {
        where.and(QueryBuilder.gt("clust", QueryBuilder.bindMarker("clust")));
        boundValues.add(clust);
        encodedValues.add(meta.clust.encodeFromJava(clust, Optional.of(cassandraOptions)));
        return new EntityForJSONCall_Select.E(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust >= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Select.E Gte(Long clust) {
        where.and(QueryBuilder.gte("clust", QueryBuilder.bindMarker("clust")));
        boundValues.add(clust);
        encodedValues.add(meta.clust.encodeFromJava(clust, Optional.of(cassandraOptions)));
        return new EntityForJSONCall_Select.E(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Select.E Lt(Long clust) {
        where.and(QueryBuilder.lt("clust", QueryBuilder.bindMarker("clust")));
        boundValues.add(clust);
        encodedValues.add(meta.clust.encodeFromJava(clust, Optional.of(cassandraOptions)));
        return new EntityForJSONCall_Select.E(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Select.E Lte(Long clust) {
        where.and(QueryBuilder.lte("clust", QueryBuilder.bindMarker("clust")));
        boundValues.add(clust);
        encodedValues.add(meta.clust.encodeFromJava(clust, Optional.of(cassandraOptions)));
        return new EntityForJSONCall_Select.E(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust > ? AND clust < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Select.E Gt_And_Lt(Long clust_Gt, Long clust_Lt) {
        where.and(QueryBuilder.gt("clust",QueryBuilder.bindMarker("clust_Lt")));
        where.and(QueryBuilder.lt("clust",QueryBuilder.bindMarker("clust_Lt")));
        boundValues.add(clust_Gt);
        encodedValues.add(meta.clust.encodeFromJava(clust_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust_Lt);
        encodedValues.add(meta.clust.encodeFromJava(clust_Lt, Optional.of(cassandraOptions)));
        return new EntityForJSONCall_Select.E(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust > ? AND clust <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Select.E Gt_And_Lte(Long clust_Gt, Long clust_Lte) {
        where.and(QueryBuilder.gt("clust",QueryBuilder.bindMarker("clust_Lte")));
        where.and(QueryBuilder.lte("clust",QueryBuilder.bindMarker("clust_Lte")));
        boundValues.add(clust_Gt);
        encodedValues.add(meta.clust.encodeFromJava(clust_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust_Lte);
        encodedValues.add(meta.clust.encodeFromJava(clust_Lte, Optional.of(cassandraOptions)));
        return new EntityForJSONCall_Select.E(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust >= ? AND clust < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Select.E Gte_And_Lt(Long clust_Gte, Long clust_Lt) {
        where.and(QueryBuilder.gte("clust",QueryBuilder.bindMarker("clust_Lt")));
        where.and(QueryBuilder.lt("clust",QueryBuilder.bindMarker("clust_Lt")));
        boundValues.add(clust_Gte);
        encodedValues.add(meta.clust.encodeFromJava(clust_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust_Lt);
        encodedValues.add(meta.clust.encodeFromJava(clust_Lt, Optional.of(cassandraOptions)));
        return new EntityForJSONCall_Select.E(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust >= ? AND clust <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Select.E Gte_And_Lte(Long clust_Gte, Long clust_Lte) {
        where.and(QueryBuilder.gte("clust",QueryBuilder.bindMarker("clust_Lte")));
        where.and(QueryBuilder.lte("clust",QueryBuilder.bindMarker("clust_Lte")));
        boundValues.add(clust_Gte);
        encodedValues.add(meta.clust.encodeFromJava(clust_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust_Lte);
        encodedValues.add(meta.clust.encodeFromJava(clust_Lte, Optional.of(cassandraOptions)));
        return new EntityForJSONCall_Select.E(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust  = fromJson(?) </strong> */
      public final EntityForJSONCall_Select.E Eq_FromJson(String clust) {
        where.and(QueryBuilder.eq("clust", QueryBuilder.fromJson(QueryBuilder.bindMarker("clust"))));
        boundValues.add(clust);
        encodedValues.add(clust);
        return new EntityForJSONCall_Select.E(where, cassandraOptions);
      }
    }
  }

  public final class E extends AbstractSelectWhere<EntityForJSONCall_Select.E, EntityForJSONCall> {
    public E(Select.Where where, CassandraOptions cassandraOptions) {
      super(where, cassandraOptions);
    }

    @Override
    protected final Class<EntityForJSONCall> getEntityClass() {
      return entityClass;
    }

    @Override
    protected final AbstractEntityProperty<EntityForJSONCall> getMetaInternal() {
      return meta;
    }

    @Override
    protected final RuntimeEngine getRte() {
      return rte;
    }

    @Override
    protected final CassandraOptions getOptions() {
      return cassandraOptions;
    }

    @Override
    protected final List<Object> getBoundValuesInternal() {
      return boundValues;
    }

    @Override
    protected final List<Object> getEncodedValuesInternal() {
      return encodedValues;
    }

    /**
     * Generate a SELECT ... FROM ... WHERE ... <strong>LIMIT :limit</strong> */
    public final EntityForJSONCall_Select.E limit(final Integer limit) {
      where.limit(QueryBuilder.bindMarker("lim"));
      boundValues.add(limit);
      encodedValues.add(limit);
      return this;
    }

    @Override
    protected final EntityForJSONCall_Select.E getThis() {
      return this;
    }

    /**
     * Generate a SELECT ... FROM ... WHERE ... <strong>ORDER BY clust ASC</strong> */
    public final EntityForJSONCall_Select.E orderByClustAscending() {
      where.orderBy(QueryBuilder.asc("clust"));
      return this;
    }

    /**
     * Generate a SELECT ... FROM ... WHERE ... <strong>ORDER BY clust DESC</strong> */
    public final EntityForJSONCall_Select.E orderByClustDescending() {
      where.orderBy(QueryBuilder.desc("clust"));
      return this;
    }
  }

  public final class W_TM_Id extends AbstractSelectWherePartitionTypeMap {
    public W_TM_Id(Select.Where where, CassandraOptions cassandraOptions) {
      super(where, cassandraOptions);
    }

    public final EntityForJSONCall_Select.W_TM_Id.Relation id() {
      return new EntityForJSONCall_Select.W_TM_Id.Relation();
    }

    public final EntityForJSONCall_Select.W_TM_Id.Token tokenValueOf_id() {
      return new EntityForJSONCall_Select.W_TM_Id.Token();
    }

    public final class Relation {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>id = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Select.W_TM_Clust Eq(Long id) {
        where.and(QueryBuilder.eq("id", QueryBuilder.bindMarker("id")));
        boundValues.add(id);
        encodedValues.add(meta.id.encodeFromJava(id, Optional.of(cassandraOptions)));
        return new EntityForJSONCall_Select.W_TM_Clust(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>id IN ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Select.W_TM_Clust IN(Long... id) {
        Validator.validateTrue(ArrayUtils.isNotEmpty(id), "Varargs for field '%s' should not be null/empty", "id");
        where.and(QueryBuilder.in("id",QueryBuilder.bindMarker("id")));
        final List<Object> varargs = Arrays.<Object>asList((Object[])id);
        final List<Object> encodedVarargs = Arrays.<Long>stream((Long[])id).map(x -> meta.id.encodeFromJava(x, Optional.of(cassandraOptions))).collect(Collectors.toList());
        boundValues.add(varargs);
        encodedValues.add(encodedVarargs);
        return new EntityForJSONCall_Select.W_TM_Clust(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>id  = fromJson(?) </strong> */
      public final EntityForJSONCall_Select.W_TM_Clust Eq_FromJson(String id) {
        where.and(QueryBuilder.eq("id", QueryBuilder.fromJson(QueryBuilder.bindMarker("id"))));
        boundValues.add(id);
        encodedValues.add(id);
        return new EntityForJSONCall_Select.W_TM_Clust(where, cassandraOptions);
      }
    }

    public final class Token {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>token(id) = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Select.E_TM Eq(Long tokenValue) {
        where.and(QueryBuilder.eq("token(id)", QueryBuilder.bindMarker("tokenValue")));
        boundValues.add(tokenValue);
        encodedValues.add(tokenValue);
        return new EntityForJSONCall_Select.E_TM(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>token(id) > ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Select.E_TM Gt(Long tokenValue) {
        where.and(QueryBuilder.gt("token(id)", QueryBuilder.bindMarker("tokenValue")));
        boundValues.add(tokenValue);
        encodedValues.add(tokenValue);
        return new EntityForJSONCall_Select.E_TM(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>token(id) >= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Select.E_TM Gte(Long tokenValue) {
        where.and(QueryBuilder.gte("token(id)", QueryBuilder.bindMarker("tokenValue")));
        boundValues.add(tokenValue);
        encodedValues.add(tokenValue);
        return new EntityForJSONCall_Select.E_TM(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>token(id) < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Select.E_TM Lt(Long tokenValue) {
        where.and(QueryBuilder.lt("token(id)", QueryBuilder.bindMarker("tokenValue")));
        boundValues.add(tokenValue);
        encodedValues.add(tokenValue);
        return new EntityForJSONCall_Select.E_TM(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>token(id) <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Select.E_TM Lte(Long tokenValue) {
        where.and(QueryBuilder.lte("token(id)", QueryBuilder.bindMarker("tokenValue")));
        boundValues.add(tokenValue);
        encodedValues.add(tokenValue);
        return new EntityForJSONCall_Select.E_TM(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>token(id) > ? AND token(id) < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Select.E_TM Gt_And_Lt(Long tokenValue1, Long tokenValue2) {
        where.and(QueryBuilder.gt("token(id)",QueryBuilder.bindMarker("tokenValue1")));
        where.and(QueryBuilder.lt("token(id)",QueryBuilder.bindMarker("tokenValue2")));
        boundValues.add(tokenValue1);
        encodedValues.add(tokenValue1);
        boundValues.add(tokenValue2);
        encodedValues.add(tokenValue2);
        return new EntityForJSONCall_Select.E_TM(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>token(id) > ? AND token(id) <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Select.E_TM Gt_And_Lte(Long tokenValue1, Long tokenValue2) {
        where.and(QueryBuilder.gt("token(id)",QueryBuilder.bindMarker("tokenValue1")));
        where.and(QueryBuilder.lte("token(id)",QueryBuilder.bindMarker("tokenValue2")));
        boundValues.add(tokenValue1);
        encodedValues.add(tokenValue1);
        boundValues.add(tokenValue2);
        encodedValues.add(tokenValue2);
        return new EntityForJSONCall_Select.E_TM(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>token(id) >= ? AND token(id) < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Select.E_TM Gte_And_Lt(Long tokenValue1, Long tokenValue2) {
        where.and(QueryBuilder.gte("token(id)",QueryBuilder.bindMarker("tokenValue1")));
        where.and(QueryBuilder.lt("token(id)",QueryBuilder.bindMarker("tokenValue2")));
        boundValues.add(tokenValue1);
        encodedValues.add(tokenValue1);
        boundValues.add(tokenValue2);
        encodedValues.add(tokenValue2);
        return new EntityForJSONCall_Select.E_TM(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>token(id) >= ? AND token(id) <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Select.E_TM Gte_And_Lte(Long tokenValue1, Long tokenValue2) {
        where.and(QueryBuilder.gte("token(id)",QueryBuilder.bindMarker("tokenValue1")));
        where.and(QueryBuilder.lte("token(id)",QueryBuilder.bindMarker("tokenValue2")));
        boundValues.add(tokenValue1);
        encodedValues.add(tokenValue1);
        boundValues.add(tokenValue2);
        encodedValues.add(tokenValue2);
        return new EntityForJSONCall_Select.E_TM(where, cassandraOptions);
      }
    }
  }

  public final class W_TM_Clust extends AbstractSelectWhereTypeMap<EntityForJSONCall_Select.W_TM_Clust, EntityForJSONCall> {
    public W_TM_Clust(Select.Where where, CassandraOptions cassandraOptions) {
      super(where, cassandraOptions);
    }

    @Override
    protected final EntityForJSONCall_Select.W_TM_Clust getThis() {
      return this;
    }

    @Override
    protected final AbstractEntityProperty<EntityForJSONCall> getMetaInternal() {
      return meta;
    }

    @Override
    protected final Class<EntityForJSONCall> getEntityClass() {
      return entityClass;
    }

    @Override
    protected final RuntimeEngine getRte() {
      return rte;
    }

    @Override
    protected final CassandraOptions getOptions() {
      return cassandraOptions;
    }

    @Override
    protected final List<Object> getBoundValuesInternal() {
      return boundValues;
    }

    @Override
    protected final List<Object> getEncodedValuesInternal() {
      return encodedValues;
    }

    /**
     * Generate a SELECT ... FROM ... WHERE ... <strong>LIMIT :limit</strong> */
    public final EntityForJSONCall_Select.W_TM_Clust limit(final Integer limit) {
      where.limit(QueryBuilder.bindMarker("lim"));
      boundValues.add(limit);
      encodedValues.add(limit);
      return this;
    }

    public final EntityForJSONCall_Select.W_TM_Clust.Relation clust() {
      return new EntityForJSONCall_Select.W_TM_Clust.Relation();
    }

    /**
     * Generate a SELECT ... FROM ... WHERE ... <strong>ORDER BY clust ASC</strong> */
    public final EntityForJSONCall_Select.W_TM_Clust orderByClustAscending() {
      where.orderBy(QueryBuilder.asc("clust"));
      return this;
    }

    /**
     * Generate a SELECT ... FROM ... WHERE ... <strong>ORDER BY clust DESC</strong> */
    public final EntityForJSONCall_Select.W_TM_Clust orderByClustDescending() {
      where.orderBy(QueryBuilder.desc("clust"));
      return this;
    }

    public final class Relation {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Select.E_TM Eq(Long clust) {
        where.and(QueryBuilder.eq("clust", QueryBuilder.bindMarker("clust")));
        boundValues.add(clust);
        encodedValues.add(meta.clust.encodeFromJava(clust, Optional.of(cassandraOptions)));
        return new EntityForJSONCall_Select.E_TM(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust IN ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Select.E_TM IN(Long... clust) {
        Validator.validateTrue(ArrayUtils.isNotEmpty(clust), "Varargs for field '%s' should not be null/empty", "clust");
        where.and(QueryBuilder.in("clust",QueryBuilder.bindMarker("clust")));
        final List<Object> varargs = Arrays.<Object>asList((Object[])clust);
        final List<Object> encodedVarargs = Arrays.<Long>stream((Long[])clust).map(x -> meta.clust.encodeFromJava(x, Optional.of(cassandraOptions))).collect(Collectors.toList());
        boundValues.add(varargs);
        encodedValues.add(encodedVarargs);
        return new EntityForJSONCall_Select.E_TM(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust > ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Select.E_TM Gt(Long clust) {
        where.and(QueryBuilder.gt("clust", QueryBuilder.bindMarker("clust")));
        boundValues.add(clust);
        encodedValues.add(meta.clust.encodeFromJava(clust, Optional.of(cassandraOptions)));
        return new EntityForJSONCall_Select.E_TM(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust >= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Select.E_TM Gte(Long clust) {
        where.and(QueryBuilder.gte("clust", QueryBuilder.bindMarker("clust")));
        boundValues.add(clust);
        encodedValues.add(meta.clust.encodeFromJava(clust, Optional.of(cassandraOptions)));
        return new EntityForJSONCall_Select.E_TM(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Select.E_TM Lt(Long clust) {
        where.and(QueryBuilder.lt("clust", QueryBuilder.bindMarker("clust")));
        boundValues.add(clust);
        encodedValues.add(meta.clust.encodeFromJava(clust, Optional.of(cassandraOptions)));
        return new EntityForJSONCall_Select.E_TM(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Select.E_TM Lte(Long clust) {
        where.and(QueryBuilder.lte("clust", QueryBuilder.bindMarker("clust")));
        boundValues.add(clust);
        encodedValues.add(meta.clust.encodeFromJava(clust, Optional.of(cassandraOptions)));
        return new EntityForJSONCall_Select.E_TM(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust > ? AND clust < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Select.E_TM Gt_And_Lt(Long clust_Gt, Long clust_Lt) {
        where.and(QueryBuilder.gt("clust",QueryBuilder.bindMarker("clust_Lt")));
        where.and(QueryBuilder.lt("clust",QueryBuilder.bindMarker("clust_Lt")));
        boundValues.add(clust_Gt);
        encodedValues.add(meta.clust.encodeFromJava(clust_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust_Lt);
        encodedValues.add(meta.clust.encodeFromJava(clust_Lt, Optional.of(cassandraOptions)));
        return new EntityForJSONCall_Select.E_TM(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust > ? AND clust <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Select.E_TM Gt_And_Lte(Long clust_Gt, Long clust_Lte) {
        where.and(QueryBuilder.gt("clust",QueryBuilder.bindMarker("clust_Lte")));
        where.and(QueryBuilder.lte("clust",QueryBuilder.bindMarker("clust_Lte")));
        boundValues.add(clust_Gt);
        encodedValues.add(meta.clust.encodeFromJava(clust_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust_Lte);
        encodedValues.add(meta.clust.encodeFromJava(clust_Lte, Optional.of(cassandraOptions)));
        return new EntityForJSONCall_Select.E_TM(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust >= ? AND clust < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Select.E_TM Gte_And_Lt(Long clust_Gte, Long clust_Lt) {
        where.and(QueryBuilder.gte("clust",QueryBuilder.bindMarker("clust_Lt")));
        where.and(QueryBuilder.lt("clust",QueryBuilder.bindMarker("clust_Lt")));
        boundValues.add(clust_Gte);
        encodedValues.add(meta.clust.encodeFromJava(clust_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust_Lt);
        encodedValues.add(meta.clust.encodeFromJava(clust_Lt, Optional.of(cassandraOptions)));
        return new EntityForJSONCall_Select.E_TM(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust >= ? AND clust <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Select.E_TM Gte_And_Lte(Long clust_Gte, Long clust_Lte) {
        where.and(QueryBuilder.gte("clust",QueryBuilder.bindMarker("clust_Lte")));
        where.and(QueryBuilder.lte("clust",QueryBuilder.bindMarker("clust_Lte")));
        boundValues.add(clust_Gte);
        encodedValues.add(meta.clust.encodeFromJava(clust_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust_Lte);
        encodedValues.add(meta.clust.encodeFromJava(clust_Lte, Optional.of(cassandraOptions)));
        return new EntityForJSONCall_Select.E_TM(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust  = fromJson(?) </strong> */
      public final EntityForJSONCall_Select.E_TM Eq_FromJson(String clust) {
        where.and(QueryBuilder.eq("clust", QueryBuilder.fromJson(QueryBuilder.bindMarker("clust"))));
        boundValues.add(clust);
        encodedValues.add(clust);
        return new EntityForJSONCall_Select.E_TM(where, cassandraOptions);
      }
    }
  }

  public final class E_TM extends AbstractSelectWhereTypeMap<EntityForJSONCall_Select.E_TM, EntityForJSONCall> {
    public E_TM(Select.Where where, CassandraOptions cassandraOptions) {
      super(where, cassandraOptions);
    }

    @Override
    protected final Class<EntityForJSONCall> getEntityClass() {
      return entityClass;
    }

    @Override
    protected final AbstractEntityProperty<EntityForJSONCall> getMetaInternal() {
      return meta;
    }

    @Override
    protected final RuntimeEngine getRte() {
      return rte;
    }

    @Override
    protected final CassandraOptions getOptions() {
      return cassandraOptions;
    }

    @Override
    protected final List<Object> getBoundValuesInternal() {
      return boundValues;
    }

    @Override
    protected final List<Object> getEncodedValuesInternal() {
      return encodedValues;
    }

    /**
     * Generate a SELECT ... FROM ... WHERE ... <strong>LIMIT :limit</strong> */
    public final EntityForJSONCall_Select.E_TM limit(final Integer limit) {
      where.limit(QueryBuilder.bindMarker("lim"));
      boundValues.add(limit);
      encodedValues.add(limit);
      return this;
    }

    @Override
    protected final EntityForJSONCall_Select.E_TM getThis() {
      return this;
    }

    /**
     * Generate a SELECT ... FROM ... WHERE ... <strong>ORDER BY clust ASC</strong> */
    public final EntityForJSONCall_Select.E_TM orderByClustAscending() {
      where.orderBy(QueryBuilder.asc("clust"));
      return this;
    }

    /**
     * Generate a SELECT ... FROM ... WHERE ... <strong>ORDER BY clust DESC</strong> */
    public final EntityForJSONCall_Select.E_TM orderByClustDescending() {
      where.orderBy(QueryBuilder.desc("clust"));
      return this;
    }
  }

  public final class W_J_Id extends AbstractSelectWherePartitionJSON {
    public W_J_Id(Select.Where where, CassandraOptions cassandraOptions) {
      super(where, cassandraOptions);
    }

    public final EntityForJSONCall_Select.W_J_Id.Relation id() {
      return new EntityForJSONCall_Select.W_J_Id.Relation();
    }

    public final EntityForJSONCall_Select.W_J_Id.Token tokenValueOf_id() {
      return new EntityForJSONCall_Select.W_J_Id.Token();
    }

    public final class Relation {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>id = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Select.W_J_Clust Eq(Long id) {
        where.and(QueryBuilder.eq("id", QueryBuilder.bindMarker("id")));
        boundValues.add(id);
        encodedValues.add(meta.id.encodeFromJava(id, Optional.of(cassandraOptions)));
        return new EntityForJSONCall_Select.W_J_Clust(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>id IN ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Select.W_J_Clust IN(Long... id) {
        Validator.validateTrue(ArrayUtils.isNotEmpty(id), "Varargs for field '%s' should not be null/empty", "id");
        where.and(QueryBuilder.in("id",QueryBuilder.bindMarker("id")));
        final List<Object> varargs = Arrays.<Object>asList((Object[])id);
        final List<Object> encodedVarargs = Arrays.<Long>stream((Long[])id).map(x -> meta.id.encodeFromJava(x, Optional.of(cassandraOptions))).collect(Collectors.toList());
        boundValues.add(varargs);
        encodedValues.add(encodedVarargs);
        return new EntityForJSONCall_Select.W_J_Clust(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>id  = fromJson(?) </strong> */
      public final EntityForJSONCall_Select.W_J_Clust Eq_FromJson(String id) {
        where.and(QueryBuilder.eq("id", QueryBuilder.fromJson(QueryBuilder.bindMarker("id"))));
        boundValues.add(id);
        encodedValues.add(id);
        return new EntityForJSONCall_Select.W_J_Clust(where, cassandraOptions);
      }
    }

    public final class Token {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>token(id) = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Select.E_J Eq(Long tokenValue) {
        where.and(QueryBuilder.eq("token(id)", QueryBuilder.bindMarker("tokenValue")));
        boundValues.add(tokenValue);
        encodedValues.add(tokenValue);
        return new EntityForJSONCall_Select.E_J(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>token(id) > ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Select.E_J Gt(Long tokenValue) {
        where.and(QueryBuilder.gt("token(id)", QueryBuilder.bindMarker("tokenValue")));
        boundValues.add(tokenValue);
        encodedValues.add(tokenValue);
        return new EntityForJSONCall_Select.E_J(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>token(id) >= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Select.E_J Gte(Long tokenValue) {
        where.and(QueryBuilder.gte("token(id)", QueryBuilder.bindMarker("tokenValue")));
        boundValues.add(tokenValue);
        encodedValues.add(tokenValue);
        return new EntityForJSONCall_Select.E_J(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>token(id) < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Select.E_J Lt(Long tokenValue) {
        where.and(QueryBuilder.lt("token(id)", QueryBuilder.bindMarker("tokenValue")));
        boundValues.add(tokenValue);
        encodedValues.add(tokenValue);
        return new EntityForJSONCall_Select.E_J(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>token(id) <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Select.E_J Lte(Long tokenValue) {
        where.and(QueryBuilder.lte("token(id)", QueryBuilder.bindMarker("tokenValue")));
        boundValues.add(tokenValue);
        encodedValues.add(tokenValue);
        return new EntityForJSONCall_Select.E_J(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>token(id) > ? AND token(id) < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Select.E_J Gt_And_Lt(Long tokenValue1, Long tokenValue2) {
        where.and(QueryBuilder.gt("token(id)",QueryBuilder.bindMarker("tokenValue1")));
        where.and(QueryBuilder.lt("token(id)",QueryBuilder.bindMarker("tokenValue2")));
        boundValues.add(tokenValue1);
        encodedValues.add(tokenValue1);
        boundValues.add(tokenValue2);
        encodedValues.add(tokenValue2);
        return new EntityForJSONCall_Select.E_J(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>token(id) > ? AND token(id) <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Select.E_J Gt_And_Lte(Long tokenValue1, Long tokenValue2) {
        where.and(QueryBuilder.gt("token(id)",QueryBuilder.bindMarker("tokenValue1")));
        where.and(QueryBuilder.lte("token(id)",QueryBuilder.bindMarker("tokenValue2")));
        boundValues.add(tokenValue1);
        encodedValues.add(tokenValue1);
        boundValues.add(tokenValue2);
        encodedValues.add(tokenValue2);
        return new EntityForJSONCall_Select.E_J(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>token(id) >= ? AND token(id) < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Select.E_J Gte_And_Lt(Long tokenValue1, Long tokenValue2) {
        where.and(QueryBuilder.gte("token(id)",QueryBuilder.bindMarker("tokenValue1")));
        where.and(QueryBuilder.lt("token(id)",QueryBuilder.bindMarker("tokenValue2")));
        boundValues.add(tokenValue1);
        encodedValues.add(tokenValue1);
        boundValues.add(tokenValue2);
        encodedValues.add(tokenValue2);
        return new EntityForJSONCall_Select.E_J(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>token(id) >= ? AND token(id) <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Select.E_J Gte_And_Lte(Long tokenValue1, Long tokenValue2) {
        where.and(QueryBuilder.gte("token(id)",QueryBuilder.bindMarker("tokenValue1")));
        where.and(QueryBuilder.lte("token(id)",QueryBuilder.bindMarker("tokenValue2")));
        boundValues.add(tokenValue1);
        encodedValues.add(tokenValue1);
        boundValues.add(tokenValue2);
        encodedValues.add(tokenValue2);
        return new EntityForJSONCall_Select.E_J(where, cassandraOptions);
      }
    }
  }

  public final class W_J_Clust extends AbstractSelectWhereJSON<EntityForJSONCall_Select.W_J_Clust, EntityForJSONCall> {
    public W_J_Clust(Select.Where where, CassandraOptions cassandraOptions) {
      super(where, cassandraOptions);
    }

    @Override
    protected final EntityForJSONCall_Select.W_J_Clust getThis() {
      return this;
    }

    @Override
    protected final AbstractEntityProperty<EntityForJSONCall> getMetaInternal() {
      return meta;
    }

    @Override
    protected final Class<EntityForJSONCall> getEntityClass() {
      return entityClass;
    }

    @Override
    protected final RuntimeEngine getRte() {
      return rte;
    }

    @Override
    protected final CassandraOptions getOptions() {
      return cassandraOptions;
    }

    @Override
    protected final List<Object> getBoundValuesInternal() {
      return boundValues;
    }

    @Override
    protected final List<Object> getEncodedValuesInternal() {
      return encodedValues;
    }

    /**
     * Generate a SELECT ... FROM ... WHERE ... <strong>LIMIT :limit</strong> */
    public final EntityForJSONCall_Select.W_J_Clust limit(final Integer limit) {
      where.limit(QueryBuilder.bindMarker("lim"));
      boundValues.add(limit);
      encodedValues.add(limit);
      return this;
    }

    public final EntityForJSONCall_Select.W_J_Clust.Relation clust() {
      return new EntityForJSONCall_Select.W_J_Clust.Relation();
    }

    /**
     * Generate a SELECT ... FROM ... WHERE ... <strong>ORDER BY clust ASC</strong> */
    public final EntityForJSONCall_Select.W_J_Clust orderByClustAscending() {
      where.orderBy(QueryBuilder.asc("clust"));
      return this;
    }

    /**
     * Generate a SELECT ... FROM ... WHERE ... <strong>ORDER BY clust DESC</strong> */
    public final EntityForJSONCall_Select.W_J_Clust orderByClustDescending() {
      where.orderBy(QueryBuilder.desc("clust"));
      return this;
    }

    public final class Relation {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Select.E_J Eq(Long clust) {
        where.and(QueryBuilder.eq("clust", QueryBuilder.bindMarker("clust")));
        boundValues.add(clust);
        encodedValues.add(meta.clust.encodeFromJava(clust, Optional.of(cassandraOptions)));
        return new EntityForJSONCall_Select.E_J(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust IN ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Select.E_J IN(Long... clust) {
        Validator.validateTrue(ArrayUtils.isNotEmpty(clust), "Varargs for field '%s' should not be null/empty", "clust");
        where.and(QueryBuilder.in("clust",QueryBuilder.bindMarker("clust")));
        final List<Object> varargs = Arrays.<Object>asList((Object[])clust);
        final List<Object> encodedVarargs = Arrays.<Long>stream((Long[])clust).map(x -> meta.clust.encodeFromJava(x, Optional.of(cassandraOptions))).collect(Collectors.toList());
        boundValues.add(varargs);
        encodedValues.add(encodedVarargs);
        return new EntityForJSONCall_Select.E_J(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust > ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Select.E_J Gt(Long clust) {
        where.and(QueryBuilder.gt("clust", QueryBuilder.bindMarker("clust")));
        boundValues.add(clust);
        encodedValues.add(meta.clust.encodeFromJava(clust, Optional.of(cassandraOptions)));
        return new EntityForJSONCall_Select.E_J(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust >= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Select.E_J Gte(Long clust) {
        where.and(QueryBuilder.gte("clust", QueryBuilder.bindMarker("clust")));
        boundValues.add(clust);
        encodedValues.add(meta.clust.encodeFromJava(clust, Optional.of(cassandraOptions)));
        return new EntityForJSONCall_Select.E_J(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Select.E_J Lt(Long clust) {
        where.and(QueryBuilder.lt("clust", QueryBuilder.bindMarker("clust")));
        boundValues.add(clust);
        encodedValues.add(meta.clust.encodeFromJava(clust, Optional.of(cassandraOptions)));
        return new EntityForJSONCall_Select.E_J(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Select.E_J Lte(Long clust) {
        where.and(QueryBuilder.lte("clust", QueryBuilder.bindMarker("clust")));
        boundValues.add(clust);
        encodedValues.add(meta.clust.encodeFromJava(clust, Optional.of(cassandraOptions)));
        return new EntityForJSONCall_Select.E_J(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust > ? AND clust < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Select.E_J Gt_And_Lt(Long clust_Gt, Long clust_Lt) {
        where.and(QueryBuilder.gt("clust",QueryBuilder.bindMarker("clust_Lt")));
        where.and(QueryBuilder.lt("clust",QueryBuilder.bindMarker("clust_Lt")));
        boundValues.add(clust_Gt);
        encodedValues.add(meta.clust.encodeFromJava(clust_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust_Lt);
        encodedValues.add(meta.clust.encodeFromJava(clust_Lt, Optional.of(cassandraOptions)));
        return new EntityForJSONCall_Select.E_J(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust > ? AND clust <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Select.E_J Gt_And_Lte(Long clust_Gt, Long clust_Lte) {
        where.and(QueryBuilder.gt("clust",QueryBuilder.bindMarker("clust_Lte")));
        where.and(QueryBuilder.lte("clust",QueryBuilder.bindMarker("clust_Lte")));
        boundValues.add(clust_Gt);
        encodedValues.add(meta.clust.encodeFromJava(clust_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust_Lte);
        encodedValues.add(meta.clust.encodeFromJava(clust_Lte, Optional.of(cassandraOptions)));
        return new EntityForJSONCall_Select.E_J(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust >= ? AND clust < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Select.E_J Gte_And_Lt(Long clust_Gte, Long clust_Lt) {
        where.and(QueryBuilder.gte("clust",QueryBuilder.bindMarker("clust_Lt")));
        where.and(QueryBuilder.lt("clust",QueryBuilder.bindMarker("clust_Lt")));
        boundValues.add(clust_Gte);
        encodedValues.add(meta.clust.encodeFromJava(clust_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust_Lt);
        encodedValues.add(meta.clust.encodeFromJava(clust_Lt, Optional.of(cassandraOptions)));
        return new EntityForJSONCall_Select.E_J(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust >= ? AND clust <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Select.E_J Gte_And_Lte(Long clust_Gte, Long clust_Lte) {
        where.and(QueryBuilder.gte("clust",QueryBuilder.bindMarker("clust_Lte")));
        where.and(QueryBuilder.lte("clust",QueryBuilder.bindMarker("clust_Lte")));
        boundValues.add(clust_Gte);
        encodedValues.add(meta.clust.encodeFromJava(clust_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust_Lte);
        encodedValues.add(meta.clust.encodeFromJava(clust_Lte, Optional.of(cassandraOptions)));
        return new EntityForJSONCall_Select.E_J(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust  = fromJson(?) </strong> */
      public final EntityForJSONCall_Select.E_J Eq_FromJson(String clust) {
        where.and(QueryBuilder.eq("clust", QueryBuilder.fromJson(QueryBuilder.bindMarker("clust"))));
        boundValues.add(clust);
        encodedValues.add(clust);
        return new EntityForJSONCall_Select.E_J(where, cassandraOptions);
      }
    }
  }

  public final class E_J extends AbstractSelectWhereJSON<EntityForJSONCall_Select.E_J, EntityForJSONCall> {
    public E_J(Select.Where where, CassandraOptions cassandraOptions) {
      super(where, cassandraOptions);
    }

    @Override
    protected final Class<EntityForJSONCall> getEntityClass() {
      return entityClass;
    }

    @Override
    protected final AbstractEntityProperty<EntityForJSONCall> getMetaInternal() {
      return meta;
    }

    @Override
    protected final RuntimeEngine getRte() {
      return rte;
    }

    @Override
    protected final CassandraOptions getOptions() {
      return cassandraOptions;
    }

    @Override
    protected final List<Object> getBoundValuesInternal() {
      return boundValues;
    }

    @Override
    protected final List<Object> getEncodedValuesInternal() {
      return encodedValues;
    }

    /**
     * Generate a SELECT ... FROM ... WHERE ... <strong>LIMIT :limit</strong> */
    public final EntityForJSONCall_Select.E_J limit(final Integer limit) {
      where.limit(QueryBuilder.bindMarker("lim"));
      boundValues.add(limit);
      encodedValues.add(limit);
      return this;
    }

    @Override
    protected final EntityForJSONCall_Select.E_J getThis() {
      return this;
    }

    /**
     * Generate a SELECT ... FROM ... WHERE ... <strong>ORDER BY clust ASC</strong> */
    public final EntityForJSONCall_Select.E_J orderByClustAscending() {
      where.orderBy(QueryBuilder.asc("clust"));
      return this;
    }

    /**
     * Generate a SELECT ... FROM ... WHERE ... <strong>ORDER BY clust DESC</strong> */
    public final EntityForJSONCall_Select.E_J orderByClustDescending() {
      where.orderBy(QueryBuilder.desc("clust"));
      return this;
    }
  }
}
