package info.archinnov.achilles.generated.dsl;

import com.datastax.driver.core.querybuilder.NonEscapingSetAssignment;
import com.datastax.driver.core.querybuilder.NotEq;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Update;
import com.google.common.collect.Sets;
import info.archinnov.achilles.generated.meta.entity.EntityForJSONCall_AchillesMeta;
import info.archinnov.achilles.internals.dsl.query.update.AbstractUpdate;
import info.archinnov.achilles.internals.dsl.query.update.AbstractUpdateColumns;
import info.archinnov.achilles.internals.dsl.query.update.AbstractUpdateEnd;
import info.archinnov.achilles.internals.dsl.query.update.AbstractUpdateFrom;
import info.archinnov.achilles.internals.dsl.query.update.AbstractUpdateWhere;
import info.archinnov.achilles.internals.entities.EntityForJSONCall;
import info.archinnov.achilles.internals.metamodel.AbstractEntityProperty;
import info.archinnov.achilles.internals.options.CassandraOptions;
import info.archinnov.achilles.internals.runtime.RuntimeEngine;
import info.archinnov.achilles.type.SchemaNameProvider;
import info.archinnov.achilles.validation.Validator;
import java.lang.Class;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;

public final class EntityForJSONCall_Update extends AbstractUpdate {
  protected final EntityForJSONCall_AchillesMeta meta;

  protected final Class<EntityForJSONCall> entityClass = EntityForJSONCall.class;

  public EntityForJSONCall_Update(RuntimeEngine rte, EntityForJSONCall_AchillesMeta meta) {
    super(rte);
    this.meta = meta;
  }

  /**
   * Generate an UPDATE <strong>FROM</strong> ... */
  public final EntityForJSONCall_Update.F fromBaseTable() {
    final String currentKeyspace = meta.getKeyspace().orElse("unknown_keyspace_for_" + meta.entityClass.getCanonicalName());
    final Update.Where where = QueryBuilder.update(currentKeyspace, meta.getTableOrViewName()).where();
    return new EntityForJSONCall_Update.F(where, new CassandraOptions());
  }

  /**
   * Generate an UPDATE <strong>FROM</strong> ... using the given SchemaNameProvider */
  public final EntityForJSONCall_Update.F from(final SchemaNameProvider schemaNameProvider) {
    final String currentKeyspace = lookupKeyspace(schemaNameProvider, meta.entityClass);
    final String currentTable = lookupTable(schemaNameProvider, meta.entityClass);
    final Update.Where where = QueryBuilder.update(currentKeyspace, currentTable).where();
    return new EntityForJSONCall_Update.F(where, CassandraOptions.withSchemaNameProvider(schemaNameProvider));
  }

  public class Cols extends AbstractUpdateColumns {
    Cols(Update.Where where, CassandraOptions cassandraOptions) {
      super(where, cassandraOptions);
    }

    public final Cols.Value value() {
      return new Cols.Value();
    }

    public final Cols.ListString listString() {
      return new Cols.ListString();
    }

    public final Cols.SetString setString() {
      return new Cols.SetString();
    }

    public final Cols.MapString mapString() {
      return new Cols.MapString();
    }

    public final EntityForJSONCall_Update.W_Id where() {
      return new EntityForJSONCall_Update.W_Id(where, cassandraOptions);
    }

    public final class Value {
      /**
       * Generate an UPDATE FROM ... <strong>SET value = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Update.Cols Set(final String value) {
        where.with(NonEscapingSetAssignment.of("value", QueryBuilder.bindMarker("value")));
        boundValues.add(value);
        encodedValues.add(meta.value.encodeFromJava(value, Optional.of(cassandraOptions)));
        return EntityForJSONCall_Update.Cols.this;
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET value = fromJson(?)</strong> */
      public final EntityForJSONCall_Update.Cols Set_FromJSON(final String value_element) {
        where.with(NonEscapingSetAssignment.of("value", QueryBuilder.fromJson(QueryBuilder.bindMarker("value"))));
        boundValues.add(value_element);
        encodedValues.add(value_element);
        return EntityForJSONCall_Update.Cols.this;
      }
    }

    public final class ListString {
      /**
       * Generate an UPDATE FROM ... <strong>SET liststring = liststring + [?]</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Update.Cols AppendTo(final String listString_element) {
        where.with(QueryBuilder.appendAll("liststring", QueryBuilder.bindMarker("liststring")));
        boundValues.add(Arrays.asList(listString_element));
        encodedValues.add(meta.listString.encodeFromJava(Arrays.asList(listString_element), Optional.of(cassandraOptions)));
        return EntityForJSONCall_Update.Cols.this;
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET listString = listString + ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Update.Cols AppendAllTo(final List<String> listString_element) {
        where.with(QueryBuilder.appendAll("liststring", QueryBuilder.bindMarker("liststring")));
        boundValues.add(listString_element);
        encodedValues.add(meta.listString.encodeFromJava(listString_element, Optional.of(cassandraOptions)));
        return EntityForJSONCall_Update.Cols.this;
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET listString = [?] + listString</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Update.Cols PrependTo(final String listString_element) {
        where.with(QueryBuilder.prependAll("liststring", QueryBuilder.bindMarker("liststring")));
        boundValues.add(Arrays.asList(listString_element));
        encodedValues.add(meta.listString.encodeFromJava(Arrays.asList(listString_element), Optional.of(cassandraOptions)));
        return EntityForJSONCall_Update.Cols.this;
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET listString = ? + listString</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Update.Cols PrependAllTo(final List<String> listString_element) {
        where.with(QueryBuilder.prependAll("liststring", QueryBuilder.bindMarker("liststring")));
        boundValues.add(listString_element);
        encodedValues.add(meta.listString.encodeFromJava(listString_element, Optional.of(cassandraOptions)));
        return EntityForJSONCall_Update.Cols.this;
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET listString[index] = ?</strong> */
      public final EntityForJSONCall_Update.Cols SetAtIndex(final int index, final String listString_element) {
        where.with(QueryBuilder.setIdx("liststring", index, QueryBuilder.bindMarker("liststring")));
        boundValues.add(listString_element);
        encodedValues.add(meta.listString.valueProperty.encodeFromJava(listString_element, Optional.of(cassandraOptions)));
        return EntityForJSONCall_Update.Cols.this;
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET listString[index] = null</strong> */
      public final EntityForJSONCall_Update.Cols RemoveAtIndex(final int index) {
        where.with(QueryBuilder.setIdx("liststring", index, QueryBuilder.bindMarker("liststring")));
        boundValues.add(null);
        encodedValues.add(null);
        return EntityForJSONCall_Update.Cols.this;
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET listString = listString - [?]</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Update.Cols RemoveFrom(final String listString_element) {
        where.with(QueryBuilder.discardAll("liststring", QueryBuilder.bindMarker("liststring")));
        boundValues.add(Arrays.asList(listString_element));
        encodedValues.add(meta.listString.encodeFromJava(Arrays.asList(listString_element), Optional.of(cassandraOptions)));
        return EntityForJSONCall_Update.Cols.this;
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET listString = listString - ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Update.Cols RemoveAllFrom(final List<String> listString_element) {
        where.with(QueryBuilder.discardAll("liststring", QueryBuilder.bindMarker("liststring")));
        boundValues.add(listString_element);
        encodedValues.add(meta.listString.encodeFromJava(listString_element, Optional.of(cassandraOptions)));
        return EntityForJSONCall_Update.Cols.this;
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET listString = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Update.Cols Set(final List<String> listString_element) {
        where.with(NonEscapingSetAssignment.of("liststring", QueryBuilder.bindMarker("liststring")));
        boundValues.add(listString_element);
        encodedValues.add(meta.listString.encodeFromJava(listString_element, Optional.of(cassandraOptions)));
        return EntityForJSONCall_Update.Cols.this;
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET liststring = fromJson(?)</strong> */
      public final EntityForJSONCall_Update.Cols Set_FromJSON(final String listString_element) {
        where.with(NonEscapingSetAssignment.of("liststring", QueryBuilder.fromJson(QueryBuilder.bindMarker("liststring"))));
        boundValues.add(listString_element);
        encodedValues.add(listString_element);
        return EntityForJSONCall_Update.Cols.this;
      }
    }

    public final class SetString {
      /**
       * Generate an UPDATE FROM ... <strong>SET setstring = setstring + {?}</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Update.Cols AddTo(final String setString_element) {
        where.with(QueryBuilder.addAll("setstring", QueryBuilder.bindMarker("setstring")));
        boundValues.add(Sets.newHashSet(setString_element));
        encodedValues.add(meta.setString.encodeFromJava(Sets.newHashSet(setString_element), Optional.of(cassandraOptions)));
        return EntityForJSONCall_Update.Cols.this;
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET setString = setString + ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Update.Cols AddAllTo(final Set<String> setString_element) {
        where.with(QueryBuilder.addAll("setstring", QueryBuilder.bindMarker("setstring")));
        boundValues.add(setString_element);
        encodedValues.add(meta.setString.encodeFromJava(setString_element, Optional.of(cassandraOptions)));
        return EntityForJSONCall_Update.Cols.this;
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET setString = setString - {?}</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Update.Cols RemoveFrom(final String setString_element) {
        where.with(QueryBuilder.removeAll("setstring", QueryBuilder.bindMarker("setstring")));
        boundValues.add(Sets.newHashSet(setString_element));
        encodedValues.add(meta.setString.encodeFromJava(Sets.newHashSet(setString_element), Optional.of(cassandraOptions)));
        return EntityForJSONCall_Update.Cols.this;
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET setString = setString - ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Update.Cols RemoveAllFrom(final Set<String> setString_element) {
        where.with(QueryBuilder.removeAll("setstring", QueryBuilder.bindMarker("setstring")));
        boundValues.add(setString_element);
        encodedValues.add(meta.setString.encodeFromJava(setString_element, Optional.of(cassandraOptions)));
        return EntityForJSONCall_Update.Cols.this;
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET setString = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Update.Cols Set(final Set<String> setString_element) {
        where.with(NonEscapingSetAssignment.of("setstring", QueryBuilder.bindMarker("setstring")));
        boundValues.add(setString_element);
        encodedValues.add(meta.setString.encodeFromJava(setString_element, Optional.of(cassandraOptions)));
        return EntityForJSONCall_Update.Cols.this;
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET setstring = fromJson(?)</strong> */
      public final EntityForJSONCall_Update.Cols Set_FromJSON(final String setString_element) {
        where.with(NonEscapingSetAssignment.of("setstring", QueryBuilder.fromJson(QueryBuilder.bindMarker("setstring"))));
        boundValues.add(setString_element);
        encodedValues.add(setString_element);
        return EntityForJSONCall_Update.Cols.this;
      }
    }

    public final class MapString {
      /**
       * Generate an UPDATE FROM ... <strong>SET mapstring[?] = ?</strong> */
      public final EntityForJSONCall_Update.Cols PutTo(final Integer mapString_key, final String mapString_value) {
        where.with(QueryBuilder.put("mapstring", QueryBuilder.bindMarker("mapString_key"), QueryBuilder.bindMarker("mapString_value")));
        boundValues.add(mapString_key);
        boundValues.add(mapString_value);
        encodedValues.add(meta.mapString.keyProperty.encodeFromJava(mapString_key, Optional.of(cassandraOptions)));
        encodedValues.add(meta.mapString.valueProperty.encodeFromJava(mapString_value, Optional.of(cassandraOptions)));
        return EntityForJSONCall_Update.Cols.this;
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET mapString = mapString + ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Update.Cols AddAllTo(final Map<Integer, String> mapString) {
        where.with(QueryBuilder.addAll("mapstring", QueryBuilder.bindMarker("mapstring")));
        boundValues.add(mapString);
        encodedValues.add(meta.mapString.encodeFromJava(mapString, Optional.of(cassandraOptions)));
        return EntityForJSONCall_Update.Cols.this;
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET mapString[?] = null</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Update.Cols RemoveByKey(final Integer mapString_key) {
        where.with(QueryBuilder.put("mapstring", QueryBuilder.bindMarker("mapString_key"), QueryBuilder.bindMarker("mapString_value")));
        boundValues.add(mapString_key);
        boundValues.add(null);
        encodedValues.add(meta.mapString.keyProperty.encodeFromJava(mapString_key, Optional.of(cassandraOptions)));
        encodedValues.add(null);
        return EntityForJSONCall_Update.Cols.this;
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET mapString = ? */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Update.Cols Set(final Map<Integer, String> mapString) {
        where.with(NonEscapingSetAssignment.of("mapstring", QueryBuilder.bindMarker("mapstring")));
        boundValues.add(mapString);
        encodedValues.add(meta.mapString.encodeFromJava(mapString, Optional.of(cassandraOptions)));
        return EntityForJSONCall_Update.Cols.this;
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET mapstring = fromJson(?)</strong> */
      public final EntityForJSONCall_Update.Cols Set_FromJSON(final String mapString_element) {
        where.with(NonEscapingSetAssignment.of("mapstring", QueryBuilder.fromJson(QueryBuilder.bindMarker("mapstring"))));
        boundValues.add(mapString_element);
        encodedValues.add(mapString_element);
        return EntityForJSONCall_Update.Cols.this;
      }
    }
  }

  public class F extends AbstractUpdateFrom {
    F(Update.Where where, CassandraOptions cassandraOptions) {
      super(where, cassandraOptions);
    }

    public final F.Value value() {
      return new F.Value();
    }

    public final F.ListString listString() {
      return new F.ListString();
    }

    public final F.SetString setString() {
      return new F.SetString();
    }

    public final F.MapString mapString() {
      return new F.MapString();
    }

    public final class Value {
      /**
       * Generate an UPDATE FROM ... <strong>SET value = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Update.Cols Set(final String value) {
        where.with(NonEscapingSetAssignment.of("value", QueryBuilder.bindMarker("value")));
        boundValues.add(value);
        encodedValues.add(meta.value.encodeFromJava(value, Optional.of(cassandraOptions)));
        return new EntityForJSONCall_Update.Cols(where, cassandraOptions);
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET value = fromJson(?)</strong> */
      public final EntityForJSONCall_Update.Cols Set_FromJSON(final String value_element) {
        where.with(NonEscapingSetAssignment.of("value", QueryBuilder.fromJson(QueryBuilder.bindMarker("value"))));
        boundValues.add(value_element);
        encodedValues.add(value_element);
        return new EntityForJSONCall_Update.Cols(where, cassandraOptions);
      }
    }

    public final class ListString {
      /**
       * Generate an UPDATE FROM ... <strong>SET liststring = liststring + [?]</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Update.Cols AppendTo(final String listString_element) {
        where.with(QueryBuilder.appendAll("liststring", QueryBuilder.bindMarker("liststring")));
        boundValues.add(Arrays.asList(listString_element));
        encodedValues.add(meta.listString.encodeFromJava(Arrays.asList(listString_element), Optional.of(cassandraOptions)));
        return new EntityForJSONCall_Update.Cols(where, cassandraOptions);
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET listString = listString + ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Update.Cols AppendAllTo(final List<String> listString_element) {
        where.with(QueryBuilder.appendAll("liststring", QueryBuilder.bindMarker("liststring")));
        boundValues.add(listString_element);
        encodedValues.add(meta.listString.encodeFromJava(listString_element, Optional.of(cassandraOptions)));
        return new EntityForJSONCall_Update.Cols(where, cassandraOptions);
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET listString = [?] + listString</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Update.Cols PrependTo(final String listString_element) {
        where.with(QueryBuilder.prependAll("liststring", QueryBuilder.bindMarker("liststring")));
        boundValues.add(Arrays.asList(listString_element));
        encodedValues.add(meta.listString.encodeFromJava(Arrays.asList(listString_element), Optional.of(cassandraOptions)));
        return new EntityForJSONCall_Update.Cols(where, cassandraOptions);
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET listString = ? + listString</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Update.Cols PrependAllTo(final List<String> listString_element) {
        where.with(QueryBuilder.prependAll("liststring", QueryBuilder.bindMarker("liststring")));
        boundValues.add(listString_element);
        encodedValues.add(meta.listString.encodeFromJava(listString_element, Optional.of(cassandraOptions)));
        return new EntityForJSONCall_Update.Cols(where, cassandraOptions);
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET listString[index] = ?</strong> */
      public final EntityForJSONCall_Update.Cols SetAtIndex(final int index, final String listString_element) {
        where.with(QueryBuilder.setIdx("liststring", index, QueryBuilder.bindMarker("liststring")));
        boundValues.add(listString_element);
        encodedValues.add(meta.listString.valueProperty.encodeFromJava(listString_element, Optional.of(cassandraOptions)));
        return new EntityForJSONCall_Update.Cols(where, cassandraOptions);
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET listString[index] = null</strong> */
      public final EntityForJSONCall_Update.Cols RemoveAtIndex(final int index) {
        where.with(QueryBuilder.setIdx("liststring", index, QueryBuilder.bindMarker("liststring")));
        boundValues.add(null);
        encodedValues.add(null);
        return new EntityForJSONCall_Update.Cols(where, cassandraOptions);
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET listString = listString - [?]</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Update.Cols RemoveFrom(final String listString_element) {
        where.with(QueryBuilder.discardAll("liststring", QueryBuilder.bindMarker("liststring")));
        boundValues.add(Arrays.asList(listString_element));
        encodedValues.add(meta.listString.encodeFromJava(Arrays.asList(listString_element), Optional.of(cassandraOptions)));
        return new EntityForJSONCall_Update.Cols(where, cassandraOptions);
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET listString = listString - ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Update.Cols RemoveAllFrom(final List<String> listString_element) {
        where.with(QueryBuilder.discardAll("liststring", QueryBuilder.bindMarker("liststring")));
        boundValues.add(listString_element);
        encodedValues.add(meta.listString.encodeFromJava(listString_element, Optional.of(cassandraOptions)));
        return new EntityForJSONCall_Update.Cols(where, cassandraOptions);
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET listString = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Update.Cols Set(final List<String> listString_element) {
        where.with(NonEscapingSetAssignment.of("liststring", QueryBuilder.bindMarker("liststring")));
        boundValues.add(listString_element);
        encodedValues.add(meta.listString.encodeFromJava(listString_element, Optional.of(cassandraOptions)));
        return new EntityForJSONCall_Update.Cols(where, cassandraOptions);
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET liststring = fromJson(?)</strong> */
      public final EntityForJSONCall_Update.Cols Set_FromJSON(final String listString_element) {
        where.with(NonEscapingSetAssignment.of("liststring", QueryBuilder.fromJson(QueryBuilder.bindMarker("liststring"))));
        boundValues.add(listString_element);
        encodedValues.add(listString_element);
        return new EntityForJSONCall_Update.Cols(where, cassandraOptions);
      }
    }

    public final class SetString {
      /**
       * Generate an UPDATE FROM ... <strong>SET setstring = setstring + {?}</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Update.Cols AddTo(final String setString_element) {
        where.with(QueryBuilder.addAll("setstring", QueryBuilder.bindMarker("setstring")));
        boundValues.add(Sets.newHashSet(setString_element));
        encodedValues.add(meta.setString.encodeFromJava(Sets.newHashSet(setString_element), Optional.of(cassandraOptions)));
        return new EntityForJSONCall_Update.Cols(where, cassandraOptions);
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET setString = setString + ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Update.Cols AddAllTo(final Set<String> setString_element) {
        where.with(QueryBuilder.addAll("setstring", QueryBuilder.bindMarker("setstring")));
        boundValues.add(setString_element);
        encodedValues.add(meta.setString.encodeFromJava(setString_element, Optional.of(cassandraOptions)));
        return new EntityForJSONCall_Update.Cols(where, cassandraOptions);
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET setString = setString - {?}</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Update.Cols RemoveFrom(final String setString_element) {
        where.with(QueryBuilder.removeAll("setstring", QueryBuilder.bindMarker("setstring")));
        boundValues.add(Sets.newHashSet(setString_element));
        encodedValues.add(meta.setString.encodeFromJava(Sets.newHashSet(setString_element), Optional.of(cassandraOptions)));
        return new EntityForJSONCall_Update.Cols(where, cassandraOptions);
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET setString = setString - ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Update.Cols RemoveAllFrom(final Set<String> setString_element) {
        where.with(QueryBuilder.removeAll("setstring", QueryBuilder.bindMarker("setstring")));
        boundValues.add(setString_element);
        encodedValues.add(meta.setString.encodeFromJava(setString_element, Optional.of(cassandraOptions)));
        return new EntityForJSONCall_Update.Cols(where, cassandraOptions);
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET setString = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Update.Cols Set(final Set<String> setString_element) {
        where.with(NonEscapingSetAssignment.of("setstring", QueryBuilder.bindMarker("setstring")));
        boundValues.add(setString_element);
        encodedValues.add(meta.setString.encodeFromJava(setString_element, Optional.of(cassandraOptions)));
        return new EntityForJSONCall_Update.Cols(where, cassandraOptions);
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET setstring = fromJson(?)</strong> */
      public final EntityForJSONCall_Update.Cols Set_FromJSON(final String setString_element) {
        where.with(NonEscapingSetAssignment.of("setstring", QueryBuilder.fromJson(QueryBuilder.bindMarker("setstring"))));
        boundValues.add(setString_element);
        encodedValues.add(setString_element);
        return new EntityForJSONCall_Update.Cols(where, cassandraOptions);
      }
    }

    public final class MapString {
      /**
       * Generate an UPDATE FROM ... <strong>SET mapstring[?] = ?</strong> */
      public final EntityForJSONCall_Update.Cols PutTo(final Integer mapString_key, final String mapString_value) {
        where.with(QueryBuilder.put("mapstring", QueryBuilder.bindMarker("mapString_key"), QueryBuilder.bindMarker("mapString_value")));
        boundValues.add(mapString_key);
        boundValues.add(mapString_value);
        encodedValues.add(meta.mapString.keyProperty.encodeFromJava(mapString_key, Optional.of(cassandraOptions)));
        encodedValues.add(meta.mapString.valueProperty.encodeFromJava(mapString_value, Optional.of(cassandraOptions)));
        return new EntityForJSONCall_Update.Cols(where, cassandraOptions);
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET mapString = mapString + ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Update.Cols AddAllTo(final Map<Integer, String> mapString) {
        where.with(QueryBuilder.addAll("mapstring", QueryBuilder.bindMarker("mapstring")));
        boundValues.add(mapString);
        encodedValues.add(meta.mapString.encodeFromJava(mapString, Optional.of(cassandraOptions)));
        return new EntityForJSONCall_Update.Cols(where, cassandraOptions);
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET mapString[?] = null</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Update.Cols RemoveByKey(final Integer mapString_key) {
        where.with(QueryBuilder.put("mapstring", QueryBuilder.bindMarker("mapString_key"), QueryBuilder.bindMarker("mapString_value")));
        boundValues.add(mapString_key);
        boundValues.add(null);
        encodedValues.add(meta.mapString.keyProperty.encodeFromJava(mapString_key, Optional.of(cassandraOptions)));
        encodedValues.add(null);
        return new EntityForJSONCall_Update.Cols(where, cassandraOptions);
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET mapString = ? */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Update.Cols Set(final Map<Integer, String> mapString) {
        where.with(NonEscapingSetAssignment.of("mapstring", QueryBuilder.bindMarker("mapstring")));
        boundValues.add(mapString);
        encodedValues.add(meta.mapString.encodeFromJava(mapString, Optional.of(cassandraOptions)));
        return new EntityForJSONCall_Update.Cols(where, cassandraOptions);
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET mapstring = fromJson(?)</strong> */
      public final EntityForJSONCall_Update.Cols Set_FromJSON(final String mapString_element) {
        where.with(NonEscapingSetAssignment.of("mapstring", QueryBuilder.fromJson(QueryBuilder.bindMarker("mapstring"))));
        boundValues.add(mapString_element);
        encodedValues.add(mapString_element);
        return new EntityForJSONCall_Update.Cols(where, cassandraOptions);
      }
    }
  }

  public final class W_Id extends AbstractUpdateWhere {
    public W_Id(Update.Where where, CassandraOptions cassandraOptions) {
      super(where, cassandraOptions);
    }

    public final EntityForJSONCall_Update.W_Id.Relation id() {
      return new EntityForJSONCall_Update.W_Id.Relation();
    }

    public final class Relation {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>id = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Update.W_Clust Eq(Long id) {
        where.and(QueryBuilder.eq("id", QueryBuilder.bindMarker("id")));
        boundValues.add(id);
        encodedValues.add(meta.id.encodeFromJava(id, Optional.of(cassandraOptions)));
        return new EntityForJSONCall_Update.W_Clust(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>id IN ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Update.W_Clust IN(Long... id) {
        Validator.validateTrue(ArrayUtils.isNotEmpty(id), "Varargs for field '%s' should not be null/empty", "id");
        where.and(QueryBuilder.in("id",QueryBuilder.bindMarker("id")));
        final List<Object> varargs = Arrays.<Object>asList((Object[])id);
        final List<Object> encodedVarargs = Arrays.<Long>stream((Long[])id).map(x -> meta.id.encodeFromJava(x, Optional.of(cassandraOptions))).collect(Collectors.toList());
        boundValues.add(varargs);
        encodedValues.add(encodedVarargs);
        return new EntityForJSONCall_Update.W_Clust(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>id  = fromJson(?) </strong> */
      public final EntityForJSONCall_Update.W_Clust Eq_FromJson(String id) {
        where.and(QueryBuilder.eq("id", QueryBuilder.fromJson(QueryBuilder.bindMarker("id"))));
        boundValues.add(id);
        encodedValues.add(id);
        return new EntityForJSONCall_Update.W_Clust(where, cassandraOptions);
      }
    }
  }

  public final class W_Clust extends AbstractUpdateWhere {
    public W_Clust(Update.Where where, CassandraOptions cassandraOptions) {
      super(where, cassandraOptions);
    }

    public final EntityForJSONCall_Update.W_Clust.Relation clust() {
      return new EntityForJSONCall_Update.W_Clust.Relation();
    }

    public final class Relation {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Update.E Eq(Long clust) {
        where.and(QueryBuilder.eq("clust", QueryBuilder.bindMarker("clust")));
        boundValues.add(clust);
        encodedValues.add(meta.clust.encodeFromJava(clust, Optional.of(cassandraOptions)));
        return new EntityForJSONCall_Update.E(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust  = fromJson(?) </strong> */
      public final EntityForJSONCall_Update.E Eq_FromJson(String clust) {
        where.and(QueryBuilder.eq("clust", QueryBuilder.fromJson(QueryBuilder.bindMarker("clust"))));
        boundValues.add(clust);
        encodedValues.add(clust);
        return new EntityForJSONCall_Update.E(where, cassandraOptions);
      }
    }
  }

  public final class E extends AbstractUpdateEnd<EntityForJSONCall_Update.E, EntityForJSONCall> {
    public E(Update.Where where, CassandraOptions cassandraOptions) {
      super(where, cassandraOptions);
    }

    @Override
    protected final Class<EntityForJSONCall> getEntityClass() {
      return entityClass;
    }

    @Override
    protected final AbstractEntityProperty<EntityForJSONCall> getMetaInternal() {
      return meta;
    }

    @Override
    protected final RuntimeEngine getRte() {
      return rte;
    }

    @Override
    protected final CassandraOptions getOptions() {
      return cassandraOptions;
    }

    @Override
    protected final List<Object> getBoundValuesInternal() {
      return boundValues;
    }

    @Override
    protected final List<Object> getEncodedValuesInternal() {
      return encodedValues;
    }

    @Override
    protected final EntityForJSONCall_Update.E getThis() {
      return this;
    }

    public final E.If_Value if_Value() {
      return new E.If_Value();
    }

    public final E.If_ListString if_ListString() {
      return new E.If_ListString();
    }

    public final E.If_SetString if_SetString() {
      return new E.If_SetString();
    }

    public final E.If_MapString if_MapString() {
      return new E.If_MapString();
    }

    public final class If_Value {
      /**
       * Generate an ... <strong>IF value = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Update.E Eq(final String value) {
        boundValues.add(value);
        encodedValues.add(meta.value.encodeFromJava(value, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.eq("value", QueryBuilder.bindMarker("value")));
        return EntityForJSONCall_Update.E.this;
      }

      /**
       * Generate an ... <strong>IF value > ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Update.E Gt(final String value) {
        boundValues.add(value);
        encodedValues.add(meta.value.encodeFromJava(value, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.gt("value", QueryBuilder.bindMarker("value")));
        return EntityForJSONCall_Update.E.this;
      }

      /**
       * Generate an ... <strong>IF value >= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Update.E Gte(final String value) {
        boundValues.add(value);
        encodedValues.add(meta.value.encodeFromJava(value, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.gte("value", QueryBuilder.bindMarker("value")));
        return EntityForJSONCall_Update.E.this;
      }

      /**
       * Generate an ... <strong>IF value < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Update.E Lt(final String value) {
        boundValues.add(value);
        encodedValues.add(meta.value.encodeFromJava(value, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.lt("value", QueryBuilder.bindMarker("value")));
        return EntityForJSONCall_Update.E.this;
      }

      /**
       * Generate an ... <strong>IF value <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Update.E Lte(final String value) {
        boundValues.add(value);
        encodedValues.add(meta.value.encodeFromJava(value, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.lte("value", QueryBuilder.bindMarker("value")));
        return EntityForJSONCall_Update.E.this;
      }

      /**
       * Generate an  ... <strong>IF value != ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Update.E NotEq(final String value) {
        boundValues.add(value);
        encodedValues.add(meta.value.encodeFromJava(value, Optional.of(cassandraOptions)));
        where.onlyIf(NotEq.of("value", QueryBuilder.bindMarker("value")));
        return EntityForJSONCall_Update.E.this;
      }

      /**
       * Generate an ... <strong>IF value = fromJson(?)</strong> */
      public final EntityForJSONCall_Update.E Eq_FromJSON(final String value) {
        boundValues.add(value);
        encodedValues.add(value);
        where.onlyIf(QueryBuilder.eq("value", QueryBuilder.fromJson(QueryBuilder.bindMarker("value"))));
        return EntityForJSONCall_Update.E.this;
      }
    }

    public final class If_ListString {
      /**
       * Generate an ... <strong>IF listString = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Update.E Eq(final List<String> listString) {
        boundValues.add(listString);
        encodedValues.add(meta.listString.encodeFromJava(listString, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.eq("liststring", QueryBuilder.bindMarker("liststring")));
        return EntityForJSONCall_Update.E.this;
      }

      /**
       * Generate an ... <strong>IF listString > ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Update.E Gt(final List<String> listString) {
        boundValues.add(listString);
        encodedValues.add(meta.listString.encodeFromJava(listString, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.gt("liststring", QueryBuilder.bindMarker("liststring")));
        return EntityForJSONCall_Update.E.this;
      }

      /**
       * Generate an ... <strong>IF listString >= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Update.E Gte(final List<String> listString) {
        boundValues.add(listString);
        encodedValues.add(meta.listString.encodeFromJava(listString, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.gte("liststring", QueryBuilder.bindMarker("liststring")));
        return EntityForJSONCall_Update.E.this;
      }

      /**
       * Generate an ... <strong>IF listString < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Update.E Lt(final List<String> listString) {
        boundValues.add(listString);
        encodedValues.add(meta.listString.encodeFromJava(listString, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.lt("liststring", QueryBuilder.bindMarker("liststring")));
        return EntityForJSONCall_Update.E.this;
      }

      /**
       * Generate an ... <strong>IF listString <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Update.E Lte(final List<String> listString) {
        boundValues.add(listString);
        encodedValues.add(meta.listString.encodeFromJava(listString, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.lte("liststring", QueryBuilder.bindMarker("liststring")));
        return EntityForJSONCall_Update.E.this;
      }

      /**
       * Generate an  ... <strong>IF listString != ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Update.E NotEq(final List<String> listString) {
        boundValues.add(listString);
        encodedValues.add(meta.listString.encodeFromJava(listString, Optional.of(cassandraOptions)));
        where.onlyIf(NotEq.of("liststring", QueryBuilder.bindMarker("liststring")));
        return EntityForJSONCall_Update.E.this;
      }

      /**
       * Generate an ... <strong>IF listString = fromJson(?)</strong> */
      public final EntityForJSONCall_Update.E Eq_FromJSON(final String listString) {
        boundValues.add(listString);
        encodedValues.add(listString);
        where.onlyIf(QueryBuilder.eq("liststring", QueryBuilder.fromJson(QueryBuilder.bindMarker("liststring"))));
        return EntityForJSONCall_Update.E.this;
      }
    }

    public final class If_SetString {
      /**
       * Generate an ... <strong>IF setString = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Update.E Eq(final Set<String> setString) {
        boundValues.add(setString);
        encodedValues.add(meta.setString.encodeFromJava(setString, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.eq("setstring", QueryBuilder.bindMarker("setstring")));
        return EntityForJSONCall_Update.E.this;
      }

      /**
       * Generate an ... <strong>IF setString > ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Update.E Gt(final Set<String> setString) {
        boundValues.add(setString);
        encodedValues.add(meta.setString.encodeFromJava(setString, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.gt("setstring", QueryBuilder.bindMarker("setstring")));
        return EntityForJSONCall_Update.E.this;
      }

      /**
       * Generate an ... <strong>IF setString >= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Update.E Gte(final Set<String> setString) {
        boundValues.add(setString);
        encodedValues.add(meta.setString.encodeFromJava(setString, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.gte("setstring", QueryBuilder.bindMarker("setstring")));
        return EntityForJSONCall_Update.E.this;
      }

      /**
       * Generate an ... <strong>IF setString < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Update.E Lt(final Set<String> setString) {
        boundValues.add(setString);
        encodedValues.add(meta.setString.encodeFromJava(setString, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.lt("setstring", QueryBuilder.bindMarker("setstring")));
        return EntityForJSONCall_Update.E.this;
      }

      /**
       * Generate an ... <strong>IF setString <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Update.E Lte(final Set<String> setString) {
        boundValues.add(setString);
        encodedValues.add(meta.setString.encodeFromJava(setString, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.lte("setstring", QueryBuilder.bindMarker("setstring")));
        return EntityForJSONCall_Update.E.this;
      }

      /**
       * Generate an  ... <strong>IF setString != ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Update.E NotEq(final Set<String> setString) {
        boundValues.add(setString);
        encodedValues.add(meta.setString.encodeFromJava(setString, Optional.of(cassandraOptions)));
        where.onlyIf(NotEq.of("setstring", QueryBuilder.bindMarker("setstring")));
        return EntityForJSONCall_Update.E.this;
      }

      /**
       * Generate an ... <strong>IF setString = fromJson(?)</strong> */
      public final EntityForJSONCall_Update.E Eq_FromJSON(final String setString) {
        boundValues.add(setString);
        encodedValues.add(setString);
        where.onlyIf(QueryBuilder.eq("setstring", QueryBuilder.fromJson(QueryBuilder.bindMarker("setstring"))));
        return EntityForJSONCall_Update.E.this;
      }
    }

    public final class If_MapString {
      /**
       * Generate an ... <strong>IF mapString = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Update.E Eq(final Map<Integer, String> mapString) {
        boundValues.add(mapString);
        encodedValues.add(meta.mapString.encodeFromJava(mapString, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.eq("mapstring", QueryBuilder.bindMarker("mapstring")));
        return EntityForJSONCall_Update.E.this;
      }

      /**
       * Generate an ... <strong>IF mapString > ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Update.E Gt(final Map<Integer, String> mapString) {
        boundValues.add(mapString);
        encodedValues.add(meta.mapString.encodeFromJava(mapString, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.gt("mapstring", QueryBuilder.bindMarker("mapstring")));
        return EntityForJSONCall_Update.E.this;
      }

      /**
       * Generate an ... <strong>IF mapString >= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Update.E Gte(final Map<Integer, String> mapString) {
        boundValues.add(mapString);
        encodedValues.add(meta.mapString.encodeFromJava(mapString, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.gte("mapstring", QueryBuilder.bindMarker("mapstring")));
        return EntityForJSONCall_Update.E.this;
      }

      /**
       * Generate an ... <strong>IF mapString < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Update.E Lt(final Map<Integer, String> mapString) {
        boundValues.add(mapString);
        encodedValues.add(meta.mapString.encodeFromJava(mapString, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.lt("mapstring", QueryBuilder.bindMarker("mapstring")));
        return EntityForJSONCall_Update.E.this;
      }

      /**
       * Generate an ... <strong>IF mapString <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Update.E Lte(final Map<Integer, String> mapString) {
        boundValues.add(mapString);
        encodedValues.add(meta.mapString.encodeFromJava(mapString, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.lte("mapstring", QueryBuilder.bindMarker("mapstring")));
        return EntityForJSONCall_Update.E.this;
      }

      /**
       * Generate an  ... <strong>IF mapString != ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityForJSONCall_Update.E NotEq(final Map<Integer, String> mapString) {
        boundValues.add(mapString);
        encodedValues.add(meta.mapString.encodeFromJava(mapString, Optional.of(cassandraOptions)));
        where.onlyIf(NotEq.of("mapstring", QueryBuilder.bindMarker("mapstring")));
        return EntityForJSONCall_Update.E.this;
      }

      /**
       * Generate an ... <strong>IF mapString = fromJson(?)</strong> */
      public final EntityForJSONCall_Update.E Eq_FromJSON(final String mapString) {
        boundValues.add(mapString);
        encodedValues.add(mapString);
        where.onlyIf(QueryBuilder.eq("mapstring", QueryBuilder.fromJson(QueryBuilder.bindMarker("mapstring"))));
        return EntityForJSONCall_Update.E.this;
      }
    }
  }
}
