package info.archinnov.achilles.generated.dsl;

import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.NotEq;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import info.archinnov.achilles.generated.meta.entity.EntityWithIndicesForJSON_AchillesMeta;
import info.archinnov.achilles.internals.dsl.query.delete.AbstractDelete;
import info.archinnov.achilles.internals.dsl.query.delete.AbstractDeleteColumns;
import info.archinnov.achilles.internals.dsl.query.delete.AbstractDeleteEnd;
import info.archinnov.achilles.internals.dsl.query.delete.AbstractDeleteFrom;
import info.archinnov.achilles.internals.dsl.query.delete.AbstractDeleteWhere;
import info.archinnov.achilles.internals.dsl.query.delete.AbstractDeleteWherePartition;
import info.archinnov.achilles.internals.entities.EntityWithIndicesForJSON;
import info.archinnov.achilles.internals.metamodel.AbstractEntityProperty;
import info.archinnov.achilles.internals.options.CassandraOptions;
import info.archinnov.achilles.internals.runtime.RuntimeEngine;
import info.archinnov.achilles.type.SchemaNameProvider;
import info.archinnov.achilles.validation.Validator;
import java.lang.Class;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;

public final class EntityWithIndicesForJSON_Delete extends AbstractDelete {
  protected final EntityWithIndicesForJSON_AchillesMeta meta;

  protected final Class<EntityWithIndicesForJSON> entityClass = EntityWithIndicesForJSON.class;

  public EntityWithIndicesForJSON_Delete(RuntimeEngine rte, EntityWithIndicesForJSON_AchillesMeta meta) {
    super(rte);
    this.meta = meta;
  }

  /**
   * Generate DELETE <strong>simpleindex</strong> ... */
  public final EntityWithIndicesForJSON_Delete.Cols simpleIndex() {
    delete.column("simpleindex");
    return new EntityWithIndicesForJSON_Delete.Cols(delete);
  }

  /**
   * Generate DELETE <strong>collectionindex</strong> ... */
  public final EntityWithIndicesForJSON_Delete.Cols collectionIndex() {
    delete.column("collectionindex");
    return new EntityWithIndicesForJSON_Delete.Cols(delete);
  }

  /**
   * Generate DELETE <strong>fullindexoncollection</strong> ... */
  public final EntityWithIndicesForJSON_Delete.Cols fullIndexOnCollection() {
    delete.column("fullindexoncollection");
    return new EntityWithIndicesForJSON_Delete.Cols(delete);
  }

  /**
   * Generate DELETE <strong>indexonmapkey</strong> ... */
  public final EntityWithIndicesForJSON_Delete.Cols indexOnMapKey() {
    delete.column("indexonmapkey");
    return new EntityWithIndicesForJSON_Delete.Cols(delete);
  }

  /**
   * Generate DELETE <strong>indexonmapvalue</strong> ... */
  public final EntityWithIndicesForJSON_Delete.Cols indexOnMapValue() {
    delete.column("indexonmapvalue");
    return new EntityWithIndicesForJSON_Delete.Cols(delete);
  }

  /**
   * Generate DELETE <strong>indexonmapentry</strong> ... */
  public final EntityWithIndicesForJSON_Delete.Cols indexOnMapEntry() {
    delete.column("indexonmapentry");
    return new EntityWithIndicesForJSON_Delete.Cols(delete);
  }

  /**
   * Generate ... * FROM ... */
  public final EntityWithIndicesForJSON_Delete.F allColumns_FromBaseTable() {
    final Delete.Where where = delete.all().from(meta.getKeyspace().orElse("unknown_keyspace_for_" + meta.entityClass.getCanonicalName()), meta.getTableOrViewName()).where();
    return new EntityWithIndicesForJSON_Delete.F(where, new CassandraOptions());
  }

  /**
   * Generate ... * FROM ... using the given SchemaNameProvider */
  public final EntityWithIndicesForJSON_Delete.F allColumns_From(final SchemaNameProvider schemaNameProvider) {
    final String currentKeyspace = lookupKeyspace(schemaNameProvider, meta.entityClass);
    final String currentTable = lookupTable(schemaNameProvider, meta.entityClass);
    final Delete.Where where = delete.all().from(currentKeyspace, currentTable).where();
    return new EntityWithIndicesForJSON_Delete.F(where, CassandraOptions.withSchemaNameProvider(schemaNameProvider));
  }

  public class Cols extends AbstractDeleteColumns {
    Cols(Delete.Selection deleteColumns) {
      super(deleteColumns);
    }

    /**
     * Generate DELETE <strong>simpleindex</strong> ... */
    public final EntityWithIndicesForJSON_Delete.Cols simpleIndex() {
      delete.column("simpleindex");
      return this;
    }

    /**
     * Generate DELETE <strong>collectionindex</strong> ... */
    public final EntityWithIndicesForJSON_Delete.Cols collectionIndex() {
      delete.column("collectionindex");
      return this;
    }

    /**
     * Generate DELETE <strong>fullindexoncollection</strong> ... */
    public final EntityWithIndicesForJSON_Delete.Cols fullIndexOnCollection() {
      delete.column("fullindexoncollection");
      return this;
    }

    /**
     * Generate DELETE <strong>indexonmapkey</strong> ... */
    public final EntityWithIndicesForJSON_Delete.Cols indexOnMapKey() {
      delete.column("indexonmapkey");
      return this;
    }

    /**
     * Generate DELETE <strong>indexonmapvalue</strong> ... */
    public final EntityWithIndicesForJSON_Delete.Cols indexOnMapValue() {
      delete.column("indexonmapvalue");
      return this;
    }

    /**
     * Generate DELETE <strong>indexonmapentry</strong> ... */
    public final EntityWithIndicesForJSON_Delete.Cols indexOnMapEntry() {
      delete.column("indexonmapentry");
      return this;
    }

    /**
     * Generate a ... <strong>FROM xxx</strong> ...  */
    public final EntityWithIndicesForJSON_Delete.F fromBaseTable() {
      final Delete.Where where = deleteColumns.from(meta.getKeyspace().orElse("unknown_keyspace_for_" + meta.entityClass.getCanonicalName()), meta.getTableOrViewName()).where();
      return new EntityWithIndicesForJSON_Delete.F(where, new CassandraOptions());
    }

    /**
     * Generate a ... <strong>FROM xxx</strong> ... using the given SchemaNameProvider */
    public final EntityWithIndicesForJSON_Delete.F from(final SchemaNameProvider schemaNameProvider) {
      final String currentKeyspace = lookupKeyspace(schemaNameProvider, meta.entityClass);
      final String currentTable = lookupTable(schemaNameProvider, meta.entityClass);
      final Delete.Where where = deleteColumns.from(currentKeyspace, currentTable).where();
      return new EntityWithIndicesForJSON_Delete.F(where, CassandraOptions.withSchemaNameProvider(schemaNameProvider));
    }
  }

  public class F extends AbstractDeleteFrom {
    F(Delete.Where where, CassandraOptions cassandraOptions) {
      super(where, cassandraOptions);
    }

    public final EntityWithIndicesForJSON_Delete.W_Id where() {
      return new EntityWithIndicesForJSON_Delete.W_Id(where, cassandraOptions);
    }
  }

  public final class W_Id extends AbstractDeleteWherePartition {
    public W_Id(Delete.Where where, CassandraOptions cassandraOptions) {
      super(where, cassandraOptions);
    }

    public final EntityWithIndicesForJSON_Delete.W_Id.Relation id() {
      return new EntityWithIndicesForJSON_Delete.W_Id.Relation();
    }

    public final class Relation {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>id = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Delete.W_Clust1 Eq(Long id) {
        where.and(QueryBuilder.eq("id", QueryBuilder.bindMarker("id")));
        boundValues.add(id);
        encodedValues.add(meta.id.encodeFromJava(id, Optional.of(cassandraOptions)));
        return new EntityWithIndicesForJSON_Delete.W_Clust1(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>id IN ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Delete.W_Clust1 IN(Long... id) {
        Validator.validateTrue(ArrayUtils.isNotEmpty(id), "Varargs for field '%s' should not be null/empty", "id");
        where.and(QueryBuilder.in("id",QueryBuilder.bindMarker("id")));
        final List<Object> varargs = Arrays.<Object>asList((Object[])id);
        final List<Object> encodedVarargs = Arrays.<Long>stream((Long[])id).map(x -> meta.id.encodeFromJava(x, Optional.of(cassandraOptions))).collect(Collectors.toList());
        boundValues.add(varargs);
        encodedValues.add(encodedVarargs);
        return new EntityWithIndicesForJSON_Delete.W_Clust1(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>id  = fromJson(?) </strong> */
      public final EntityWithIndicesForJSON_Delete.W_Clust1 Eq_FromJson(String id) {
        where.and(QueryBuilder.eq("id", QueryBuilder.fromJson(QueryBuilder.bindMarker("id"))));
        boundValues.add(id);
        encodedValues.add(id);
        return new EntityWithIndicesForJSON_Delete.W_Clust1(where, cassandraOptions);
      }
    }
  }

  public final class W_Clust1 extends AbstractDeleteWhere {
    public W_Clust1(Delete.Where where, CassandraOptions cassandraOptions) {
      super(where, cassandraOptions);
    }

    public final EntityWithIndicesForJSON_Delete.W_Clust1.Relation clust1() {
      return new EntityWithIndicesForJSON_Delete.W_Clust1.Relation();
    }

    public final class Relation {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust1 = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Delete.W_Clust2 Eq(int clust1) {
        where.and(QueryBuilder.eq("clust1", QueryBuilder.bindMarker("clust1")));
        boundValues.add(clust1);
        encodedValues.add(meta.clust1.encodeFromJava(clust1, Optional.of(cassandraOptions)));
        return new EntityWithIndicesForJSON_Delete.W_Clust2(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust1  = fromJson(?) </strong> */
      public final EntityWithIndicesForJSON_Delete.W_Clust2 Eq_FromJson(String clust1) {
        where.and(QueryBuilder.eq("clust1", QueryBuilder.fromJson(QueryBuilder.bindMarker("clust1"))));
        boundValues.add(clust1);
        encodedValues.add(clust1);
        return new EntityWithIndicesForJSON_Delete.W_Clust2(where, cassandraOptions);
      }
    }
  }

  public final class W_Clust2 extends AbstractDeleteWhere {
    public W_Clust2(Delete.Where where, CassandraOptions cassandraOptions) {
      super(where, cassandraOptions);
    }

    public final EntityWithIndicesForJSON_Delete.W_Clust2.Relation clust2() {
      return new EntityWithIndicesForJSON_Delete.W_Clust2.Relation();
    }

    public final class Relation {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust2 = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Delete.W_Clust3 Eq(int clust2) {
        where.and(QueryBuilder.eq("clust2", QueryBuilder.bindMarker("clust2")));
        boundValues.add(clust2);
        encodedValues.add(meta.clust2.encodeFromJava(clust2, Optional.of(cassandraOptions)));
        return new EntityWithIndicesForJSON_Delete.W_Clust3(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust2  = fromJson(?) </strong> */
      public final EntityWithIndicesForJSON_Delete.W_Clust3 Eq_FromJson(String clust2) {
        where.and(QueryBuilder.eq("clust2", QueryBuilder.fromJson(QueryBuilder.bindMarker("clust2"))));
        boundValues.add(clust2);
        encodedValues.add(clust2);
        return new EntityWithIndicesForJSON_Delete.W_Clust3(where, cassandraOptions);
      }
    }
  }

  public final class W_Clust3 extends AbstractDeleteWhere {
    public W_Clust3(Delete.Where where, CassandraOptions cassandraOptions) {
      super(where, cassandraOptions);
    }

    public final EntityWithIndicesForJSON_Delete.W_Clust3.Relation clust3() {
      return new EntityWithIndicesForJSON_Delete.W_Clust3.Relation();
    }

    public final class Relation {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust3 = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Delete.E Eq(String clust3) {
        where.and(QueryBuilder.eq("clust3", QueryBuilder.bindMarker("clust3")));
        boundValues.add(clust3);
        encodedValues.add(meta.clust3.encodeFromJava(clust3, Optional.of(cassandraOptions)));
        return new EntityWithIndicesForJSON_Delete.E(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust3  = fromJson(?) </strong> */
      public final EntityWithIndicesForJSON_Delete.E Eq_FromJson(String clust3) {
        where.and(QueryBuilder.eq("clust3", QueryBuilder.fromJson(QueryBuilder.bindMarker("clust3"))));
        boundValues.add(clust3);
        encodedValues.add(clust3);
        return new EntityWithIndicesForJSON_Delete.E(where, cassandraOptions);
      }
    }
  }

  public final class E extends AbstractDeleteEnd<EntityWithIndicesForJSON_Delete.E, EntityWithIndicesForJSON> {
    public E(Delete.Where where, CassandraOptions cassandraOptions) {
      super(where, cassandraOptions);
    }

    @Override
    protected final Class<EntityWithIndicesForJSON> getEntityClass() {
      return entityClass;
    }

    @Override
    protected final AbstractEntityProperty<EntityWithIndicesForJSON> getMetaInternal() {
      return meta;
    }

    @Override
    protected final RuntimeEngine getRte() {
      return rte;
    }

    @Override
    protected final CassandraOptions getOptions() {
      return cassandraOptions;
    }

    @Override
    protected final List<Object> getBoundValuesInternal() {
      return boundValues;
    }

    @Override
    protected final List<Object> getEncodedValuesInternal() {
      return encodedValues;
    }

    @Override
    protected final EntityWithIndicesForJSON_Delete.E getThis() {
      return this;
    }

    public final E.If_SimpleIndex if_SimpleIndex() {
      return new E.If_SimpleIndex();
    }

    public final E.If_CollectionIndex if_CollectionIndex() {
      return new E.If_CollectionIndex();
    }

    public final E.If_FullIndexOnCollection if_FullIndexOnCollection() {
      return new E.If_FullIndexOnCollection();
    }

    public final E.If_IndexOnMapKey if_IndexOnMapKey() {
      return new E.If_IndexOnMapKey();
    }

    public final E.If_IndexOnMapValue if_IndexOnMapValue() {
      return new E.If_IndexOnMapValue();
    }

    public final E.If_IndexOnMapEntry if_IndexOnMapEntry() {
      return new E.If_IndexOnMapEntry();
    }

    public final class If_SimpleIndex {
      /**
       * Generate an ... <strong>IF simpleIndex = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Delete.E Eq(final String simpleIndex) {
        boundValues.add(simpleIndex);
        encodedValues.add(meta.simpleIndex.encodeFromJava(simpleIndex, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.eq("simpleindex", QueryBuilder.bindMarker("simpleindex")));
        return EntityWithIndicesForJSON_Delete.E.this;
      }

      /**
       * Generate an ... <strong>IF simpleIndex > ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Delete.E Gt(final String simpleIndex) {
        boundValues.add(simpleIndex);
        encodedValues.add(meta.simpleIndex.encodeFromJava(simpleIndex, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.gt("simpleindex", QueryBuilder.bindMarker("simpleindex")));
        return EntityWithIndicesForJSON_Delete.E.this;
      }

      /**
       * Generate an ... <strong>IF simpleIndex >= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Delete.E Gte(final String simpleIndex) {
        boundValues.add(simpleIndex);
        encodedValues.add(meta.simpleIndex.encodeFromJava(simpleIndex, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.gte("simpleindex", QueryBuilder.bindMarker("simpleindex")));
        return EntityWithIndicesForJSON_Delete.E.this;
      }

      /**
       * Generate an ... <strong>IF simpleIndex < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Delete.E Lt(final String simpleIndex) {
        boundValues.add(simpleIndex);
        encodedValues.add(meta.simpleIndex.encodeFromJava(simpleIndex, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.lt("simpleindex", QueryBuilder.bindMarker("simpleindex")));
        return EntityWithIndicesForJSON_Delete.E.this;
      }

      /**
       * Generate an ... <strong>IF simpleIndex <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Delete.E Lte(final String simpleIndex) {
        boundValues.add(simpleIndex);
        encodedValues.add(meta.simpleIndex.encodeFromJava(simpleIndex, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.lte("simpleindex", QueryBuilder.bindMarker("simpleindex")));
        return EntityWithIndicesForJSON_Delete.E.this;
      }

      /**
       * Generate an  ... <strong>IF simpleIndex != ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Delete.E NotEq(final String simpleIndex) {
        boundValues.add(simpleIndex);
        encodedValues.add(meta.simpleIndex.encodeFromJava(simpleIndex, Optional.of(cassandraOptions)));
        where.onlyIf(NotEq.of("simpleindex", QueryBuilder.bindMarker("simpleindex")));
        return EntityWithIndicesForJSON_Delete.E.this;
      }

      /**
       * Generate an ... <strong>IF simpleIndex = fromJson(?)</strong> */
      public final EntityWithIndicesForJSON_Delete.E Eq_FromJSON(final String simpleIndex) {
        boundValues.add(simpleIndex);
        encodedValues.add(simpleIndex);
        where.onlyIf(QueryBuilder.eq("simpleindex", QueryBuilder.fromJson(QueryBuilder.bindMarker("simpleindex"))));
        return EntityWithIndicesForJSON_Delete.E.this;
      }
    }

    public final class If_CollectionIndex {
      /**
       * Generate an ... <strong>IF collectionIndex = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Delete.E Eq(final List<String> collectionIndex) {
        boundValues.add(collectionIndex);
        encodedValues.add(meta.collectionIndex.encodeFromJava(collectionIndex, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.eq("collectionindex", QueryBuilder.bindMarker("collectionindex")));
        return EntityWithIndicesForJSON_Delete.E.this;
      }

      /**
       * Generate an ... <strong>IF collectionIndex > ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Delete.E Gt(final List<String> collectionIndex) {
        boundValues.add(collectionIndex);
        encodedValues.add(meta.collectionIndex.encodeFromJava(collectionIndex, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.gt("collectionindex", QueryBuilder.bindMarker("collectionindex")));
        return EntityWithIndicesForJSON_Delete.E.this;
      }

      /**
       * Generate an ... <strong>IF collectionIndex >= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Delete.E Gte(final List<String> collectionIndex) {
        boundValues.add(collectionIndex);
        encodedValues.add(meta.collectionIndex.encodeFromJava(collectionIndex, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.gte("collectionindex", QueryBuilder.bindMarker("collectionindex")));
        return EntityWithIndicesForJSON_Delete.E.this;
      }

      /**
       * Generate an ... <strong>IF collectionIndex < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Delete.E Lt(final List<String> collectionIndex) {
        boundValues.add(collectionIndex);
        encodedValues.add(meta.collectionIndex.encodeFromJava(collectionIndex, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.lt("collectionindex", QueryBuilder.bindMarker("collectionindex")));
        return EntityWithIndicesForJSON_Delete.E.this;
      }

      /**
       * Generate an ... <strong>IF collectionIndex <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Delete.E Lte(final List<String> collectionIndex) {
        boundValues.add(collectionIndex);
        encodedValues.add(meta.collectionIndex.encodeFromJava(collectionIndex, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.lte("collectionindex", QueryBuilder.bindMarker("collectionindex")));
        return EntityWithIndicesForJSON_Delete.E.this;
      }

      /**
       * Generate an  ... <strong>IF collectionIndex != ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Delete.E NotEq(final List<String> collectionIndex) {
        boundValues.add(collectionIndex);
        encodedValues.add(meta.collectionIndex.encodeFromJava(collectionIndex, Optional.of(cassandraOptions)));
        where.onlyIf(NotEq.of("collectionindex", QueryBuilder.bindMarker("collectionindex")));
        return EntityWithIndicesForJSON_Delete.E.this;
      }

      /**
       * Generate an ... <strong>IF collectionIndex = fromJson(?)</strong> */
      public final EntityWithIndicesForJSON_Delete.E Eq_FromJSON(final String collectionIndex) {
        boundValues.add(collectionIndex);
        encodedValues.add(collectionIndex);
        where.onlyIf(QueryBuilder.eq("collectionindex", QueryBuilder.fromJson(QueryBuilder.bindMarker("collectionindex"))));
        return EntityWithIndicesForJSON_Delete.E.this;
      }
    }

    public final class If_FullIndexOnCollection {
      /**
       * Generate an ... <strong>IF fullIndexOnCollection = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Delete.E Eq(final Set<String> fullIndexOnCollection) {
        boundValues.add(fullIndexOnCollection);
        encodedValues.add(meta.fullIndexOnCollection.encodeFromJava(fullIndexOnCollection, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.eq("fullindexoncollection", QueryBuilder.bindMarker("fullindexoncollection")));
        return EntityWithIndicesForJSON_Delete.E.this;
      }

      /**
       * Generate an ... <strong>IF fullIndexOnCollection > ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Delete.E Gt(final Set<String> fullIndexOnCollection) {
        boundValues.add(fullIndexOnCollection);
        encodedValues.add(meta.fullIndexOnCollection.encodeFromJava(fullIndexOnCollection, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.gt("fullindexoncollection", QueryBuilder.bindMarker("fullindexoncollection")));
        return EntityWithIndicesForJSON_Delete.E.this;
      }

      /**
       * Generate an ... <strong>IF fullIndexOnCollection >= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Delete.E Gte(final Set<String> fullIndexOnCollection) {
        boundValues.add(fullIndexOnCollection);
        encodedValues.add(meta.fullIndexOnCollection.encodeFromJava(fullIndexOnCollection, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.gte("fullindexoncollection", QueryBuilder.bindMarker("fullindexoncollection")));
        return EntityWithIndicesForJSON_Delete.E.this;
      }

      /**
       * Generate an ... <strong>IF fullIndexOnCollection < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Delete.E Lt(final Set<String> fullIndexOnCollection) {
        boundValues.add(fullIndexOnCollection);
        encodedValues.add(meta.fullIndexOnCollection.encodeFromJava(fullIndexOnCollection, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.lt("fullindexoncollection", QueryBuilder.bindMarker("fullindexoncollection")));
        return EntityWithIndicesForJSON_Delete.E.this;
      }

      /**
       * Generate an ... <strong>IF fullIndexOnCollection <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Delete.E Lte(final Set<String> fullIndexOnCollection) {
        boundValues.add(fullIndexOnCollection);
        encodedValues.add(meta.fullIndexOnCollection.encodeFromJava(fullIndexOnCollection, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.lte("fullindexoncollection", QueryBuilder.bindMarker("fullindexoncollection")));
        return EntityWithIndicesForJSON_Delete.E.this;
      }

      /**
       * Generate an  ... <strong>IF fullIndexOnCollection != ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Delete.E NotEq(final Set<String> fullIndexOnCollection) {
        boundValues.add(fullIndexOnCollection);
        encodedValues.add(meta.fullIndexOnCollection.encodeFromJava(fullIndexOnCollection, Optional.of(cassandraOptions)));
        where.onlyIf(NotEq.of("fullindexoncollection", QueryBuilder.bindMarker("fullindexoncollection")));
        return EntityWithIndicesForJSON_Delete.E.this;
      }

      /**
       * Generate an ... <strong>IF fullIndexOnCollection = fromJson(?)</strong> */
      public final EntityWithIndicesForJSON_Delete.E Eq_FromJSON(final String fullIndexOnCollection) {
        boundValues.add(fullIndexOnCollection);
        encodedValues.add(fullIndexOnCollection);
        where.onlyIf(QueryBuilder.eq("fullindexoncollection", QueryBuilder.fromJson(QueryBuilder.bindMarker("fullindexoncollection"))));
        return EntityWithIndicesForJSON_Delete.E.this;
      }
    }

    public final class If_IndexOnMapKey {
      /**
       * Generate an ... <strong>IF indexOnMapKey = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Delete.E Eq(final Map<String, String> indexOnMapKey) {
        boundValues.add(indexOnMapKey);
        encodedValues.add(meta.indexOnMapKey.encodeFromJava(indexOnMapKey, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.eq("indexonmapkey", QueryBuilder.bindMarker("indexonmapkey")));
        return EntityWithIndicesForJSON_Delete.E.this;
      }

      /**
       * Generate an ... <strong>IF indexOnMapKey > ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Delete.E Gt(final Map<String, String> indexOnMapKey) {
        boundValues.add(indexOnMapKey);
        encodedValues.add(meta.indexOnMapKey.encodeFromJava(indexOnMapKey, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.gt("indexonmapkey", QueryBuilder.bindMarker("indexonmapkey")));
        return EntityWithIndicesForJSON_Delete.E.this;
      }

      /**
       * Generate an ... <strong>IF indexOnMapKey >= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Delete.E Gte(final Map<String, String> indexOnMapKey) {
        boundValues.add(indexOnMapKey);
        encodedValues.add(meta.indexOnMapKey.encodeFromJava(indexOnMapKey, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.gte("indexonmapkey", QueryBuilder.bindMarker("indexonmapkey")));
        return EntityWithIndicesForJSON_Delete.E.this;
      }

      /**
       * Generate an ... <strong>IF indexOnMapKey < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Delete.E Lt(final Map<String, String> indexOnMapKey) {
        boundValues.add(indexOnMapKey);
        encodedValues.add(meta.indexOnMapKey.encodeFromJava(indexOnMapKey, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.lt("indexonmapkey", QueryBuilder.bindMarker("indexonmapkey")));
        return EntityWithIndicesForJSON_Delete.E.this;
      }

      /**
       * Generate an ... <strong>IF indexOnMapKey <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Delete.E Lte(final Map<String, String> indexOnMapKey) {
        boundValues.add(indexOnMapKey);
        encodedValues.add(meta.indexOnMapKey.encodeFromJava(indexOnMapKey, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.lte("indexonmapkey", QueryBuilder.bindMarker("indexonmapkey")));
        return EntityWithIndicesForJSON_Delete.E.this;
      }

      /**
       * Generate an  ... <strong>IF indexOnMapKey != ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Delete.E NotEq(final Map<String, String> indexOnMapKey) {
        boundValues.add(indexOnMapKey);
        encodedValues.add(meta.indexOnMapKey.encodeFromJava(indexOnMapKey, Optional.of(cassandraOptions)));
        where.onlyIf(NotEq.of("indexonmapkey", QueryBuilder.bindMarker("indexonmapkey")));
        return EntityWithIndicesForJSON_Delete.E.this;
      }

      /**
       * Generate an ... <strong>IF indexOnMapKey = fromJson(?)</strong> */
      public final EntityWithIndicesForJSON_Delete.E Eq_FromJSON(final String indexOnMapKey) {
        boundValues.add(indexOnMapKey);
        encodedValues.add(indexOnMapKey);
        where.onlyIf(QueryBuilder.eq("indexonmapkey", QueryBuilder.fromJson(QueryBuilder.bindMarker("indexonmapkey"))));
        return EntityWithIndicesForJSON_Delete.E.this;
      }
    }

    public final class If_IndexOnMapValue {
      /**
       * Generate an ... <strong>IF indexOnMapValue = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Delete.E Eq(final Map<Integer, String> indexOnMapValue) {
        boundValues.add(indexOnMapValue);
        encodedValues.add(meta.indexOnMapValue.encodeFromJava(indexOnMapValue, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.eq("indexonmapvalue", QueryBuilder.bindMarker("indexonmapvalue")));
        return EntityWithIndicesForJSON_Delete.E.this;
      }

      /**
       * Generate an ... <strong>IF indexOnMapValue > ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Delete.E Gt(final Map<Integer, String> indexOnMapValue) {
        boundValues.add(indexOnMapValue);
        encodedValues.add(meta.indexOnMapValue.encodeFromJava(indexOnMapValue, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.gt("indexonmapvalue", QueryBuilder.bindMarker("indexonmapvalue")));
        return EntityWithIndicesForJSON_Delete.E.this;
      }

      /**
       * Generate an ... <strong>IF indexOnMapValue >= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Delete.E Gte(final Map<Integer, String> indexOnMapValue) {
        boundValues.add(indexOnMapValue);
        encodedValues.add(meta.indexOnMapValue.encodeFromJava(indexOnMapValue, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.gte("indexonmapvalue", QueryBuilder.bindMarker("indexonmapvalue")));
        return EntityWithIndicesForJSON_Delete.E.this;
      }

      /**
       * Generate an ... <strong>IF indexOnMapValue < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Delete.E Lt(final Map<Integer, String> indexOnMapValue) {
        boundValues.add(indexOnMapValue);
        encodedValues.add(meta.indexOnMapValue.encodeFromJava(indexOnMapValue, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.lt("indexonmapvalue", QueryBuilder.bindMarker("indexonmapvalue")));
        return EntityWithIndicesForJSON_Delete.E.this;
      }

      /**
       * Generate an ... <strong>IF indexOnMapValue <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Delete.E Lte(final Map<Integer, String> indexOnMapValue) {
        boundValues.add(indexOnMapValue);
        encodedValues.add(meta.indexOnMapValue.encodeFromJava(indexOnMapValue, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.lte("indexonmapvalue", QueryBuilder.bindMarker("indexonmapvalue")));
        return EntityWithIndicesForJSON_Delete.E.this;
      }

      /**
       * Generate an  ... <strong>IF indexOnMapValue != ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Delete.E NotEq(final Map<Integer, String> indexOnMapValue) {
        boundValues.add(indexOnMapValue);
        encodedValues.add(meta.indexOnMapValue.encodeFromJava(indexOnMapValue, Optional.of(cassandraOptions)));
        where.onlyIf(NotEq.of("indexonmapvalue", QueryBuilder.bindMarker("indexonmapvalue")));
        return EntityWithIndicesForJSON_Delete.E.this;
      }

      /**
       * Generate an ... <strong>IF indexOnMapValue = fromJson(?)</strong> */
      public final EntityWithIndicesForJSON_Delete.E Eq_FromJSON(final String indexOnMapValue) {
        boundValues.add(indexOnMapValue);
        encodedValues.add(indexOnMapValue);
        where.onlyIf(QueryBuilder.eq("indexonmapvalue", QueryBuilder.fromJson(QueryBuilder.bindMarker("indexonmapvalue"))));
        return EntityWithIndicesForJSON_Delete.E.this;
      }
    }

    public final class If_IndexOnMapEntry {
      /**
       * Generate an ... <strong>IF indexOnMapEntry = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Delete.E Eq(final Map<Integer, String> indexOnMapEntry) {
        boundValues.add(indexOnMapEntry);
        encodedValues.add(meta.indexOnMapEntry.encodeFromJava(indexOnMapEntry, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.eq("indexonmapentry", QueryBuilder.bindMarker("indexonmapentry")));
        return EntityWithIndicesForJSON_Delete.E.this;
      }

      /**
       * Generate an ... <strong>IF indexOnMapEntry > ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Delete.E Gt(final Map<Integer, String> indexOnMapEntry) {
        boundValues.add(indexOnMapEntry);
        encodedValues.add(meta.indexOnMapEntry.encodeFromJava(indexOnMapEntry, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.gt("indexonmapentry", QueryBuilder.bindMarker("indexonmapentry")));
        return EntityWithIndicesForJSON_Delete.E.this;
      }

      /**
       * Generate an ... <strong>IF indexOnMapEntry >= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Delete.E Gte(final Map<Integer, String> indexOnMapEntry) {
        boundValues.add(indexOnMapEntry);
        encodedValues.add(meta.indexOnMapEntry.encodeFromJava(indexOnMapEntry, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.gte("indexonmapentry", QueryBuilder.bindMarker("indexonmapentry")));
        return EntityWithIndicesForJSON_Delete.E.this;
      }

      /**
       * Generate an ... <strong>IF indexOnMapEntry < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Delete.E Lt(final Map<Integer, String> indexOnMapEntry) {
        boundValues.add(indexOnMapEntry);
        encodedValues.add(meta.indexOnMapEntry.encodeFromJava(indexOnMapEntry, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.lt("indexonmapentry", QueryBuilder.bindMarker("indexonmapentry")));
        return EntityWithIndicesForJSON_Delete.E.this;
      }

      /**
       * Generate an ... <strong>IF indexOnMapEntry <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Delete.E Lte(final Map<Integer, String> indexOnMapEntry) {
        boundValues.add(indexOnMapEntry);
        encodedValues.add(meta.indexOnMapEntry.encodeFromJava(indexOnMapEntry, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.lte("indexonmapentry", QueryBuilder.bindMarker("indexonmapentry")));
        return EntityWithIndicesForJSON_Delete.E.this;
      }

      /**
       * Generate an  ... <strong>IF indexOnMapEntry != ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Delete.E NotEq(final Map<Integer, String> indexOnMapEntry) {
        boundValues.add(indexOnMapEntry);
        encodedValues.add(meta.indexOnMapEntry.encodeFromJava(indexOnMapEntry, Optional.of(cassandraOptions)));
        where.onlyIf(NotEq.of("indexonmapentry", QueryBuilder.bindMarker("indexonmapentry")));
        return EntityWithIndicesForJSON_Delete.E.this;
      }

      /**
       * Generate an ... <strong>IF indexOnMapEntry = fromJson(?)</strong> */
      public final EntityWithIndicesForJSON_Delete.E Eq_FromJSON(final String indexOnMapEntry) {
        boundValues.add(indexOnMapEntry);
        encodedValues.add(indexOnMapEntry);
        where.onlyIf(QueryBuilder.eq("indexonmapentry", QueryBuilder.fromJson(QueryBuilder.bindMarker("indexonmapentry"))));
        return EntityWithIndicesForJSON_Delete.E.this;
      }
    }
  }
}
