package info.archinnov.achilles.generated.dsl;

import com.datastax.driver.core.TupleType;
import com.datastax.driver.core.querybuilder.MapEntryClause;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import info.archinnov.achilles.generated.meta.entity.EntityWithIndicesForJSON_AchillesMeta;
import info.archinnov.achilles.internals.dsl.query.select.AbstractIndexSelectWhere;
import info.archinnov.achilles.internals.dsl.query.select.AbstractIndexSelectWhereJSON;
import info.archinnov.achilles.internals.dsl.query.select.AbstractIndexSelectWhereTypeMap;
import info.archinnov.achilles.internals.dsl.query.select.AbstractSelect;
import info.archinnov.achilles.internals.dsl.query.select.AbstractSelectColumns;
import info.archinnov.achilles.internals.dsl.query.select.AbstractSelectColumnsTypeMap;
import info.archinnov.achilles.internals.dsl.query.select.AbstractSelectFrom;
import info.archinnov.achilles.internals.dsl.query.select.AbstractSelectFromJSON;
import info.archinnov.achilles.internals.dsl.query.select.AbstractSelectFromTypeMap;
import info.archinnov.achilles.internals.dsl.query.select.AbstractSelectWherePartition;
import info.archinnov.achilles.internals.dsl.query.select.AbstractSelectWherePartitionJSON;
import info.archinnov.achilles.internals.dsl.query.select.AbstractSelectWherePartitionTypeMap;
import info.archinnov.achilles.internals.entities.EntityWithIndicesForJSON;
import info.archinnov.achilles.internals.metamodel.AbstractEntityProperty;
import info.archinnov.achilles.internals.metamodel.functions.FunctionCall;
import info.archinnov.achilles.internals.options.CassandraOptions;
import info.archinnov.achilles.internals.runtime.RuntimeEngine;
import info.archinnov.achilles.type.SchemaNameProvider;
import info.archinnov.achilles.validation.Validator;
import java.lang.Class;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;

public final class EntityWithIndicesForJSON_SelectIndex extends AbstractSelect {
  protected final EntityWithIndicesForJSON_AchillesMeta meta;

  protected final Class<EntityWithIndicesForJSON> entityClass = EntityWithIndicesForJSON.class;

  public EntityWithIndicesForJSON_SelectIndex(RuntimeEngine rte, EntityWithIndicesForJSON_AchillesMeta meta) {
    super(rte);
    this.meta = meta;
  }

  /**
   * Generate a SELECT ... <strong>id</strong> ... */
  public final EntityWithIndicesForJSON_SelectIndex.Cols id() {
    select.column("id");
    return new EntityWithIndicesForJSON_SelectIndex.Cols(select);
  }

  /**
   * Generate a SELECT ... <strong>clust1</strong> ... */
  public final EntityWithIndicesForJSON_SelectIndex.Cols clust1() {
    select.column("clust1");
    return new EntityWithIndicesForJSON_SelectIndex.Cols(select);
  }

  /**
   * Generate a SELECT ... <strong>clust2</strong> ... */
  public final EntityWithIndicesForJSON_SelectIndex.Cols clust2() {
    select.column("clust2");
    return new EntityWithIndicesForJSON_SelectIndex.Cols(select);
  }

  /**
   * Generate a SELECT ... <strong>clust3</strong> ... */
  public final EntityWithIndicesForJSON_SelectIndex.Cols clust3() {
    select.column("clust3");
    return new EntityWithIndicesForJSON_SelectIndex.Cols(select);
  }

  /**
   * Generate a SELECT ... <strong>simpleindex</strong> ... */
  public final EntityWithIndicesForJSON_SelectIndex.Cols simpleIndex() {
    select.column("simpleindex");
    return new EntityWithIndicesForJSON_SelectIndex.Cols(select);
  }

  /**
   * Generate a SELECT ... <strong>collectionindex</strong> ... */
  public final EntityWithIndicesForJSON_SelectIndex.Cols collectionIndex() {
    select.column("collectionindex");
    return new EntityWithIndicesForJSON_SelectIndex.Cols(select);
  }

  /**
   * Generate a SELECT ... <strong>fullindexoncollection</strong> ... */
  public final EntityWithIndicesForJSON_SelectIndex.Cols fullIndexOnCollection() {
    select.column("fullindexoncollection");
    return new EntityWithIndicesForJSON_SelectIndex.Cols(select);
  }

  /**
   * Generate a SELECT ... <strong>indexonmapkey</strong> ... */
  public final EntityWithIndicesForJSON_SelectIndex.Cols indexOnMapKey() {
    select.column("indexonmapkey");
    return new EntityWithIndicesForJSON_SelectIndex.Cols(select);
  }

  /**
   * Generate a SELECT ... <strong>indexonmapvalue</strong> ... */
  public final EntityWithIndicesForJSON_SelectIndex.Cols indexOnMapValue() {
    select.column("indexonmapvalue");
    return new EntityWithIndicesForJSON_SelectIndex.Cols(select);
  }

  /**
   * Generate a SELECT ... <strong>indexonmapentry</strong> ... */
  public final EntityWithIndicesForJSON_SelectIndex.Cols indexOnMapEntry() {
    select.column("indexonmapentry");
    return new EntityWithIndicesForJSON_SelectIndex.Cols(select);
  }

  /**
   * Use this method to call a system or user-defined function.<br/>All the system functions are accessible from the <strong>{@link info.archinnov.achilles.generated.function.SystemFunctions}</strong> class<br/>All the user-defined functions and aggregates are accessible from the <strong>{@link info.archinnov.achilles.generated.function.FunctionsRegistry}</strong> class<br/>System and user-defined functions accept only appropriate type. To pass in an entity field as function argument, use the generated <strong>manager.COLUMNS</strong> class which exposes all columns with their appropriate type<br/>Example: <pre class="code"><code class="java">
   *   {@literal @}Table
   *   public class MyEntity {
   *
   *       ...
   *
   *       {@literal @}Column("value_column")
   *       private String value;
   *
   *       {@literal @}Column("list_of_string")
   *       private List<String> strings;
   *
   *       ...
   *
   *   }
   *
   *   {@literal @}FunctionsRegistry
   *   public interface MyFunctions {
   *
   *        String convertListToJson(List<String> strings);
   *
   *   }
   *
   *
   *   ...
   *
   *
   *   manager
   *      .dsl()
   *      .select()
   *      // This call will generate SELECT cast(writetime(value_column) as text) AS writetimeOfValueAsString, ...
   *      .function(SystemFunctions.castAsText(SystemFunctions.writetime(manager.COLUMNS.VALUE)), "writetimeOfValueAsString")
   *      ...
   *
   *   manager
   *      .dsl()
   *      .select()
   *      // This call will generate SELECT convertlisttojson(list_of_string) AS strings_as_json, ...
   *      .function(FunctionsRegistry.convertListToJson(manager.COLUMNS.STRINGS), "strings_as_json")
   *      ...
   *
   * </code></pre>
   * <br/>
   * @param functionCall the function call object
   * @param alias mandatory alias for this function call for easier retrieval from the ResultSet
   * @return a built-in function call passed to the QueryBuilder object
   */
  public final EntityWithIndicesForJSON_SelectIndex.ColsTM function(final FunctionCall functionCall, final String alias) {
    functionCall.addToSelect(select, alias);
    return new EntityWithIndicesForJSON_SelectIndex.ColsTM(select);
  }

  /**
   * Generate ... * FROM ... */
  public final EntityWithIndicesForJSON_SelectIndex.F allColumns_FromBaseTable() {
    final Select.Where where = select.all().from(meta.getKeyspace().orElse("unknown_keyspace_for_" + meta.entityClass.getCanonicalName()), meta.getTableOrViewName()).where();
    return new EntityWithIndicesForJSON_SelectIndex.F(where, new CassandraOptions());
  }

  /**
   * Generate ... * FROM ... using the given SchemaNameProvider */
  public final EntityWithIndicesForJSON_SelectIndex.F allColumns_From(final SchemaNameProvider schemaNameProvider) {
    final String currentKeyspace = lookupKeyspace(schemaNameProvider, meta.entityClass);
    final String currentTable = lookupTable(schemaNameProvider, meta.entityClass);
    final Select.Where where = select.all().from(currentKeyspace, currentTable).where();
    return new EntityWithIndicesForJSON_SelectIndex.F(where, CassandraOptions.withSchemaNameProvider(schemaNameProvider));
  }

  /**
   * Generate ... * FROM ... */
  public final EntityWithIndicesForJSON_SelectIndex.F_J allColumnsAsJSON_FromBaseTable() {
    final Select.Where where = select.json().all().from(meta.getKeyspace().orElse("unknown_keyspace_for_" + meta.entityClass.getCanonicalName()), meta.getTableOrViewName()).where();
    return new EntityWithIndicesForJSON_SelectIndex.F_J(where, new CassandraOptions());
  }

  /**
   * Generate ... * FROM ... using the given SchemaNameProvider */
  public final EntityWithIndicesForJSON_SelectIndex.F_J allColumnsAsJSON_From(final SchemaNameProvider schemaNameProvider) {
    final String currentKeyspace = lookupKeyspace(schemaNameProvider, meta.entityClass);
    final String currentTable = lookupTable(schemaNameProvider, meta.entityClass);
    final Select.Where where = select.json().all().from(currentKeyspace, currentTable).where();
    return new EntityWithIndicesForJSON_SelectIndex.F_J(where, CassandraOptions.withSchemaNameProvider(schemaNameProvider));
  }

  public class Cols extends AbstractSelectColumns {
    public Cols(Select.Selection selection) {
      super(selection);
    }

    /**
     * Generate a SELECT ... <strong>id</strong> ... */
    public final EntityWithIndicesForJSON_SelectIndex.Cols id() {
      selection.column("id");
      return this;
    }

    /**
     * Generate a SELECT ... <strong>clust1</strong> ... */
    public final EntityWithIndicesForJSON_SelectIndex.Cols clust1() {
      selection.column("clust1");
      return this;
    }

    /**
     * Generate a SELECT ... <strong>clust2</strong> ... */
    public final EntityWithIndicesForJSON_SelectIndex.Cols clust2() {
      selection.column("clust2");
      return this;
    }

    /**
     * Generate a SELECT ... <strong>clust3</strong> ... */
    public final EntityWithIndicesForJSON_SelectIndex.Cols clust3() {
      selection.column("clust3");
      return this;
    }

    /**
     * Generate a SELECT ... <strong>simpleindex</strong> ... */
    public final EntityWithIndicesForJSON_SelectIndex.Cols simpleIndex() {
      selection.column("simpleindex");
      return this;
    }

    /**
     * Generate a SELECT ... <strong>collectionindex</strong> ... */
    public final EntityWithIndicesForJSON_SelectIndex.Cols collectionIndex() {
      selection.column("collectionindex");
      return this;
    }

    /**
     * Generate a SELECT ... <strong>fullindexoncollection</strong> ... */
    public final EntityWithIndicesForJSON_SelectIndex.Cols fullIndexOnCollection() {
      selection.column("fullindexoncollection");
      return this;
    }

    /**
     * Generate a SELECT ... <strong>indexonmapkey</strong> ... */
    public final EntityWithIndicesForJSON_SelectIndex.Cols indexOnMapKey() {
      selection.column("indexonmapkey");
      return this;
    }

    /**
     * Generate a SELECT ... <strong>indexonmapvalue</strong> ... */
    public final EntityWithIndicesForJSON_SelectIndex.Cols indexOnMapValue() {
      selection.column("indexonmapvalue");
      return this;
    }

    /**
     * Generate a SELECT ... <strong>indexonmapentry</strong> ... */
    public final EntityWithIndicesForJSON_SelectIndex.Cols indexOnMapEntry() {
      selection.column("indexonmapentry");
      return this;
    }

    /**
     * Use this method to call a system or user-defined function.<br/>All the system functions are accessible from the <strong>{@link info.archinnov.achilles.generated.function.SystemFunctions}</strong> class<br/>All the user-defined functions and aggregates are accessible from the <strong>{@link info.archinnov.achilles.generated.function.FunctionsRegistry}</strong> class<br/>System and user-defined functions accept only appropriate type. To pass in an entity field as function argument, use the generated <strong>manager.COLUMNS</strong> class which exposes all columns with their appropriate type<br/>Example: <pre class="code"><code class="java">
     *   {@literal @}Table
     *   public class MyEntity {
     *
     *       ...
     *
     *       {@literal @}Column("value_column")
     *       private String value;
     *
     *       {@literal @}Column("list_of_string")
     *       private List<String> strings;
     *
     *       ...
     *
     *   }
     *
     *   {@literal @}FunctionsRegistry
     *   public interface MyFunctions {
     *
     *        String convertListToJson(List<String> strings);
     *
     *   }
     *
     *
     *   ...
     *
     *
     *   manager
     *      .dsl()
     *      .select()
     *      // This call will generate SELECT cast(writetime(value_column) as text) AS writetimeOfValueAsString, ...
     *      .function(SystemFunctions.castAsText(SystemFunctions.writetime(manager.COLUMNS.VALUE)), "writetimeOfValueAsString")
     *      ...
     *
     *   manager
     *      .dsl()
     *      .select()
     *      // This call will generate SELECT convertlisttojson(list_of_string) AS strings_as_json, ...
     *      .function(FunctionsRegistry.convertListToJson(manager.COLUMNS.STRINGS), "strings_as_json")
     *      ...
     *
     * </code></pre>
     * <br/>
     * @param functionCall the function call object
     * @param alias mandatory alias for this function call for easier retrieval from the ResultSet
     * @return a built-in function call passed to the QueryBuilder object
     */
    public final EntityWithIndicesForJSON_SelectIndex.ColsTM function(final FunctionCall functionCall, final String alias) {
      functionCall.addToSelect(selection, alias);
      return new EntityWithIndicesForJSON_SelectIndex.ColsTM(select);
    }

    /**
     * Generate a ... <strong>FROM xxx</strong> ...  */
    public final EntityWithIndicesForJSON_SelectIndex.F fromBaseTable() {
      final Select.Where where = selection.from(meta.getKeyspace().orElse("unknown_keyspace_for_" + meta.entityClass.getCanonicalName()), meta.getTableOrViewName()).where();
      return new EntityWithIndicesForJSON_SelectIndex.F(where, new CassandraOptions());
    }

    /**
     * Generate a ... <strong>FROM xxx</strong> ... using the given SchemaNameProvider */
    public final EntityWithIndicesForJSON_SelectIndex.F from(final SchemaNameProvider schemaNameProvider) {
      final String currentKeyspace = lookupKeyspace(schemaNameProvider, meta.entityClass);
      final String currentTable = lookupTable(schemaNameProvider, meta.entityClass);
      final Select.Where where = selection.from(currentKeyspace, currentTable).where();
      return new EntityWithIndicesForJSON_SelectIndex.F(where, CassandraOptions.withSchemaNameProvider(schemaNameProvider));
    }
  }

  public class ColsTM extends AbstractSelectColumnsTypeMap {
    public ColsTM(Select.Selection selection) {
      super(selection);
    }

    /**
     * Generate a SELECT ... <strong>id</strong> ... */
    public final EntityWithIndicesForJSON_SelectIndex.ColsTM id() {
      selection.column("id");
      return this;
    }

    /**
     * Generate a SELECT ... <strong>clust1</strong> ... */
    public final EntityWithIndicesForJSON_SelectIndex.ColsTM clust1() {
      selection.column("clust1");
      return this;
    }

    /**
     * Generate a SELECT ... <strong>clust2</strong> ... */
    public final EntityWithIndicesForJSON_SelectIndex.ColsTM clust2() {
      selection.column("clust2");
      return this;
    }

    /**
     * Generate a SELECT ... <strong>clust3</strong> ... */
    public final EntityWithIndicesForJSON_SelectIndex.ColsTM clust3() {
      selection.column("clust3");
      return this;
    }

    /**
     * Generate a SELECT ... <strong>simpleindex</strong> ... */
    public final EntityWithIndicesForJSON_SelectIndex.ColsTM simpleIndex() {
      selection.column("simpleindex");
      return this;
    }

    /**
     * Generate a SELECT ... <strong>collectionindex</strong> ... */
    public final EntityWithIndicesForJSON_SelectIndex.ColsTM collectionIndex() {
      selection.column("collectionindex");
      return this;
    }

    /**
     * Generate a SELECT ... <strong>fullindexoncollection</strong> ... */
    public final EntityWithIndicesForJSON_SelectIndex.ColsTM fullIndexOnCollection() {
      selection.column("fullindexoncollection");
      return this;
    }

    /**
     * Generate a SELECT ... <strong>indexonmapkey</strong> ... */
    public final EntityWithIndicesForJSON_SelectIndex.ColsTM indexOnMapKey() {
      selection.column("indexonmapkey");
      return this;
    }

    /**
     * Generate a SELECT ... <strong>indexonmapvalue</strong> ... */
    public final EntityWithIndicesForJSON_SelectIndex.ColsTM indexOnMapValue() {
      selection.column("indexonmapvalue");
      return this;
    }

    /**
     * Generate a SELECT ... <strong>indexonmapentry</strong> ... */
    public final EntityWithIndicesForJSON_SelectIndex.ColsTM indexOnMapEntry() {
      selection.column("indexonmapentry");
      return this;
    }

    /**
     * Use this method to call a system or user-defined function.<br/>All the system functions are accessible from the <strong>{@link info.archinnov.achilles.generated.function.SystemFunctions}</strong> class<br/>All the user-defined functions and aggregates are accessible from the <strong>{@link info.archinnov.achilles.generated.function.FunctionsRegistry}</strong> class<br/>System and user-defined functions accept only appropriate type. To pass in an entity field as function argument, use the generated <strong>manager.COLUMNS</strong> class which exposes all columns with their appropriate type<br/>Example: <pre class="code"><code class="java">
     *   {@literal @}Table
     *   public class MyEntity {
     *
     *       ...
     *
     *       {@literal @}Column("value_column")
     *       private String value;
     *
     *       {@literal @}Column("list_of_string")
     *       private List<String> strings;
     *
     *       ...
     *
     *   }
     *
     *   {@literal @}FunctionsRegistry
     *   public interface MyFunctions {
     *
     *        String convertListToJson(List<String> strings);
     *
     *   }
     *
     *
     *   ...
     *
     *
     *   manager
     *      .dsl()
     *      .select()
     *      // This call will generate SELECT cast(writetime(value_column) as text) AS writetimeOfValueAsString, ...
     *      .function(SystemFunctions.castAsText(SystemFunctions.writetime(manager.COLUMNS.VALUE)), "writetimeOfValueAsString")
     *      ...
     *
     *   manager
     *      .dsl()
     *      .select()
     *      // This call will generate SELECT convertlisttojson(list_of_string) AS strings_as_json, ...
     *      .function(FunctionsRegistry.convertListToJson(manager.COLUMNS.STRINGS), "strings_as_json")
     *      ...
     *
     * </code></pre>
     * <br/>
     * @param functionCall the function call object
     * @param alias mandatory alias for this function call for easier retrieval from the ResultSet
     * @return a built-in function call passed to the QueryBuilder object
     */
    public final EntityWithIndicesForJSON_SelectIndex.ColsTM function(final FunctionCall functionCall, final String alias) {
      functionCall.addToSelect(selection, alias);
      return this;
    }

    /**
     * Generate a ... <strong>FROM xxx</strong> ...  */
    public final EntityWithIndicesForJSON_SelectIndex.F_TM fromBaseTable() {
      final Select.Where where = selection.from(meta.getKeyspace().orElse("unknown_keyspace_for_" + meta.entityClass.getCanonicalName()), meta.getTableOrViewName()).where();
      return new EntityWithIndicesForJSON_SelectIndex.F_TM(where, new CassandraOptions());
    }

    /**
     * Generate a ... <strong>FROM xxx</strong> ... using the given SchemaNameProvider */
    public final EntityWithIndicesForJSON_SelectIndex.F_TM from(final SchemaNameProvider schemaNameProvider) {
      final String currentKeyspace = lookupKeyspace(schemaNameProvider, meta.entityClass);
      final String currentTable = lookupTable(schemaNameProvider, meta.entityClass);
      final Select.Where where = selection.from(currentKeyspace, currentTable).where();
      return new EntityWithIndicesForJSON_SelectIndex.F_TM(where, CassandraOptions.withSchemaNameProvider(schemaNameProvider));
    }
  }

  public class F extends AbstractSelectFrom {
    F(Select.Where where, CassandraOptions cassandraOptions) {
      super(where, cassandraOptions);
    }

    /**
     * Generate a SELECT ... FROM ... <strong>WHERE</strong> ... */
    public final EntityWithIndicesForJSON_SelectIndex.W where() {
      return new EntityWithIndicesForJSON_SelectIndex.W(where, cassandraOptions);
    }

    /**
     * Generate a SELECT statement <strong>without</strong> the <strong>WHERE</strong> clause */
    public final EntityWithIndicesForJSON_SelectIndex.E without_WHERE_Clause() {
      return new EntityWithIndicesForJSON_SelectIndex.E(where, cassandraOptions);
    }
  }

  public class F_TM extends AbstractSelectFromTypeMap {
    F_TM(Select.Where where, CassandraOptions cassandraOptions) {
      super(where, cassandraOptions);
    }

    /**
     * Generate a SELECT ... FROM ... <strong>WHERE</strong> ... */
    public final EntityWithIndicesForJSON_SelectIndex.W_TM where() {
      return new EntityWithIndicesForJSON_SelectIndex.W_TM(where, cassandraOptions);
    }

    /**
     * Generate a SELECT statement <strong>without</strong> the <strong>WHERE</strong> clause */
    public final EntityWithIndicesForJSON_SelectIndex.E_TM without_WHERE_Clause() {
      return new EntityWithIndicesForJSON_SelectIndex.E_TM(where, cassandraOptions);
    }
  }

  public class F_J extends AbstractSelectFromJSON {
    F_J(Select.Where where, CassandraOptions cassandraOptions) {
      super(where, cassandraOptions);
    }

    /**
     * Generate a SELECT ... FROM ... <strong>WHERE</strong> ... */
    public final EntityWithIndicesForJSON_SelectIndex.W_J where() {
      return new EntityWithIndicesForJSON_SelectIndex.W_J(where, cassandraOptions);
    }

    /**
     * Generate a SELECT statement <strong>without</strong> the <strong>WHERE</strong> clause */
    public final EntityWithIndicesForJSON_SelectIndex.E_J without_WHERE_Clause() {
      return new EntityWithIndicesForJSON_SelectIndex.E_J(where, cassandraOptions);
    }
  }

  public final class W extends AbstractSelectWherePartition {
    public W(Select.Where where, CassandraOptions cassandraOptions) {
      super(where, cassandraOptions);
    }

    public final EntityWithIndicesForJSON_SelectIndex.W.CollectionIndex collectionIndex() {
      return new EntityWithIndicesForJSON_SelectIndex.W.CollectionIndex();
    }

    public final EntityWithIndicesForJSON_SelectIndex.W.FullIndexOnCollection fullIndexOnCollection() {
      return new EntityWithIndicesForJSON_SelectIndex.W.FullIndexOnCollection();
    }

    public final EntityWithIndicesForJSON_SelectIndex.W.IndexOnMapEntry indexOnMapEntry() {
      return new EntityWithIndicesForJSON_SelectIndex.W.IndexOnMapEntry();
    }

    public final EntityWithIndicesForJSON_SelectIndex.W.IndexOnMapKey indexOnMapKey() {
      return new EntityWithIndicesForJSON_SelectIndex.W.IndexOnMapKey();
    }

    public final EntityWithIndicesForJSON_SelectIndex.W.IndexOnMapValue indexOnMapValue() {
      return new EntityWithIndicesForJSON_SelectIndex.W.IndexOnMapValue();
    }

    public final EntityWithIndicesForJSON_SelectIndex.W.SimpleIndex simpleIndex() {
      return new EntityWithIndicesForJSON_SelectIndex.W.SimpleIndex();
    }

    public final class CollectionIndex {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>collectionindex CONTAINS ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E Contains(String collectionIndex_element) {
        where.and(QueryBuilder.contains("collectionindex", QueryBuilder.bindMarker("collectionindex")));
        boundValues.add(collectionIndex_element);
        encodedValues.add(meta.collectionIndex.encodeSingleElement(collectionIndex_element, Optional.of(cassandraOptions)));
        return new EntityWithIndicesForJSON_SelectIndex.E(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>collectionindex CONTAINS fromJson(?)</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E Contains_FromJson(String collectionIndex_JSONElement) {
        where.and(QueryBuilder.contains("collectionindex", QueryBuilder.fromJson(QueryBuilder.bindMarker("collectionindex"))));
        boundValues.add(collectionIndex_JSONElement);
        encodedValues.add(collectionIndex_JSONElement);
        return new EntityWithIndicesForJSON_SelectIndex.E(where, cassandraOptions);
      }
    }

    public final class FullIndexOnCollection {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>fullindexoncollection = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E Eq(Set<String> fullIndexOnCollection) {
        where.and(QueryBuilder.eq("fullindexoncollection", QueryBuilder.bindMarker("fullindexoncollection")));
        boundValues.add(fullIndexOnCollection);
        encodedValues.add(meta.fullIndexOnCollection.encodeFromJava(fullIndexOnCollection, Optional.of(cassandraOptions)));
        return new EntityWithIndicesForJSON_SelectIndex.E(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>fullindexoncollection  = fromJson(?) </strong> */
      public final EntityWithIndicesForJSON_SelectIndex.E Eq_FromJson(String fullIndexOnCollection) {
        where.and(QueryBuilder.eq("fullindexoncollection", QueryBuilder.fromJson(QueryBuilder.bindMarker("fullindexoncollection"))));
        boundValues.add(fullIndexOnCollection);
        encodedValues.add(fullIndexOnCollection);
        return new EntityWithIndicesForJSON_SelectIndex.E(where, cassandraOptions);
      }
    }

    public final class IndexOnMapEntry {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>indexonmapentry[?] = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E ContainsEntry(Integer indexOnMapEntry_key, String indexOnMapEntry_value) {
        where.and(MapEntryClause.of("indexonmapentry", QueryBuilder.bindMarker("indexOnMapEntry_key"), QueryBuilder.bindMarker("indexOnMapEntry_value")));
        boundValues.add(indexOnMapEntry_key);
        boundValues.add(indexOnMapEntry_value);
        encodedValues.add(meta.indexOnMapEntry.encodeSingleKeyElement(indexOnMapEntry_key, Optional.of(cassandraOptions)));
        encodedValues.add(meta.indexOnMapEntry.encodeSingleValueElement(indexOnMapEntry_value, Optional.of(cassandraOptions)));
        return new EntityWithIndicesForJSON_SelectIndex.E(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>indexonmapentry[fromJson(?)] = fromJson(?)</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E ContainsEntry_FromJSON(String indexOnMapEntry_JSONKey, String indexOnMapEntry_JSONValue) {
        where.and(MapEntryClause.of("indexonmapentry", QueryBuilder.fromJson(QueryBuilder.bindMarker("indexOnMapEntry_JSONKey")), QueryBuilder.fromJson(QueryBuilder.bindMarker("indexOnMapEntry_JSONValue"))));
        boundValues.add(indexOnMapEntry_JSONKey);
        boundValues.add(indexOnMapEntry_JSONValue);
        encodedValues.add(indexOnMapEntry_JSONKey);
        encodedValues.add(indexOnMapEntry_JSONValue);
        return new EntityWithIndicesForJSON_SelectIndex.E(where, cassandraOptions);
      }
    }

    public final class IndexOnMapKey {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>indexonmapkey CONTAINS KEY ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E ContainsKey(String indexOnMapKey_key) {
        where.and(QueryBuilder.containsKey("indexonmapkey", QueryBuilder.bindMarker("indexonmapkey")));
        boundValues.add(indexOnMapKey_key);
        encodedValues.add(meta.indexOnMapKey.encodeSingleKeyElement(indexOnMapKey_key, Optional.of(cassandraOptions)));
        return new EntityWithIndicesForJSON_SelectIndex.E(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>indexonmapkey CONTAINS KEY fromJson(?)</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E ContainsKey_FromJSON(String indexOnMapKey_JSONKey) {
        where.and(QueryBuilder.containsKey("indexonmapkey", QueryBuilder.fromJson(QueryBuilder.bindMarker("indexonmapkey"))));
        boundValues.add(indexOnMapKey_JSONKey);
        encodedValues.add(indexOnMapKey_JSONKey);
        return new EntityWithIndicesForJSON_SelectIndex.E(where, cassandraOptions);
      }
    }

    public final class IndexOnMapValue {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>indexonmapvalue CONTAINS ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E ContainsValue(String indexOnMapValue_value) {
        where.and(QueryBuilder.contains("indexonmapvalue", QueryBuilder.bindMarker("indexonmapvalue")));
        boundValues.add(indexOnMapValue_value);
        encodedValues.add(meta.indexOnMapValue.encodeSingleValueElement(indexOnMapValue_value, Optional.of(cassandraOptions)));
        return new EntityWithIndicesForJSON_SelectIndex.E(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>indexonmapvalue CONTAINS fromJson(?)</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E ContainsValue_FromJSON(String indexOnMapValue_JSONValue) {
        where.and(QueryBuilder.contains("indexonmapvalue", QueryBuilder.fromJson(QueryBuilder.bindMarker("indexonmapvalue"))));
        boundValues.add(indexOnMapValue_JSONValue);
        encodedValues.add(indexOnMapValue_JSONValue);
        return new EntityWithIndicesForJSON_SelectIndex.E(where, cassandraOptions);
      }
    }

    public final class SimpleIndex {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>simpleindex = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E Eq(String simpleIndex) {
        where.and(QueryBuilder.eq("simpleindex", QueryBuilder.bindMarker("simpleindex")));
        boundValues.add(simpleIndex);
        encodedValues.add(meta.simpleIndex.encodeFromJava(simpleIndex, Optional.of(cassandraOptions)));
        return new EntityWithIndicesForJSON_SelectIndex.E(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>simpleindex  = fromJson(?) </strong> */
      public final EntityWithIndicesForJSON_SelectIndex.E Eq_FromJson(String simpleIndex) {
        where.and(QueryBuilder.eq("simpleindex", QueryBuilder.fromJson(QueryBuilder.bindMarker("simpleindex"))));
        boundValues.add(simpleIndex);
        encodedValues.add(simpleIndex);
        return new EntityWithIndicesForJSON_SelectIndex.E(where, cassandraOptions);
      }
    }
  }

  public final class E extends AbstractIndexSelectWhere<EntityWithIndicesForJSON_SelectIndex.E, EntityWithIndicesForJSON> {
    public E(Select.Where where, CassandraOptions cassandraOptions) {
      super(where, cassandraOptions);
    }

    @Override
    protected final Class<EntityWithIndicesForJSON> getEntityClass() {
      return entityClass;
    }

    @Override
    protected final AbstractEntityProperty<EntityWithIndicesForJSON> getMetaInternal() {
      return meta;
    }

    @Override
    protected final RuntimeEngine getRte() {
      return rte;
    }

    @Override
    protected final CassandraOptions getOptions() {
      return cassandraOptions;
    }

    @Override
    protected final List<Object> getBoundValuesInternal() {
      return boundValues;
    }

    @Override
    protected final List<Object> getEncodedValuesInternal() {
      return encodedValues;
    }

    /**
     * Generate a SELECT ... FROM ... WHERE ... <strong>LIMIT :limit</strong> */
    public final EntityWithIndicesForJSON_SelectIndex.E limit(final Integer limit) {
      where.limit(QueryBuilder.bindMarker("lim"));
      boundValues.add(limit);
      encodedValues.add(limit);
      return this;
    }

    @Override
    protected final EntityWithIndicesForJSON_SelectIndex.E getThis() {
      return this;
    }

    public final EntityWithIndicesForJSON_SelectIndex.E.Id id() {
      return new EntityWithIndicesForJSON_SelectIndex.E.Id();
    }

    public final EntityWithIndicesForJSON_SelectIndex.E.Clust1 clust1() {
      return new EntityWithIndicesForJSON_SelectIndex.E.Clust1();
    }

    public final EntityWithIndicesForJSON_SelectIndex.E.Clust2 clust2() {
      return new EntityWithIndicesForJSON_SelectIndex.E.Clust2();
    }

    public final EntityWithIndicesForJSON_SelectIndex.E.Clust3 clust3() {
      return new EntityWithIndicesForJSON_SelectIndex.E.Clust3();
    }

    public final EntityWithIndicesForJSON_SelectIndex.E.CollectionIndex collectionIndex() {
      return new EntityWithIndicesForJSON_SelectIndex.E.CollectionIndex();
    }

    public final EntityWithIndicesForJSON_SelectIndex.E.FullIndexOnCollection fullIndexOnCollection() {
      return new EntityWithIndicesForJSON_SelectIndex.E.FullIndexOnCollection();
    }

    public final EntityWithIndicesForJSON_SelectIndex.E.IndexOnMapEntry indexOnMapEntry() {
      return new EntityWithIndicesForJSON_SelectIndex.E.IndexOnMapEntry();
    }

    public final EntityWithIndicesForJSON_SelectIndex.E.IndexOnMapKey indexOnMapKey() {
      return new EntityWithIndicesForJSON_SelectIndex.E.IndexOnMapKey();
    }

    public final EntityWithIndicesForJSON_SelectIndex.E.IndexOnMapValue indexOnMapValue() {
      return new EntityWithIndicesForJSON_SelectIndex.E.IndexOnMapValue();
    }

    public final EntityWithIndicesForJSON_SelectIndex.E.SimpleIndex simpleIndex() {
      return new EntityWithIndicesForJSON_SelectIndex.E.SimpleIndex();
    }

    public final EntityWithIndicesForJSON_SelectIndex.E.clust1_clust2 clust1_clust2() {
      return new EntityWithIndicesForJSON_SelectIndex.E.clust1_clust2();
    }

    public final EntityWithIndicesForJSON_SelectIndex.E.clust1_clust2_clust3 clust1_clust2_clust3() {
      return new EntityWithIndicesForJSON_SelectIndex.E.clust1_clust2_clust3();
    }

    /**
     * Generate a SELECT ... FROM ... WHERE ... <strong>ORDER BY clust1 ASC</strong> */
    public final EntityWithIndicesForJSON_SelectIndex.E orderByClust1Ascending() {
      where.orderBy(QueryBuilder.asc("clust1"));
      return this;
    }

    /**
     * Generate a SELECT ... FROM ... WHERE ... <strong>ORDER BY clust1 DESC</strong> */
    public final EntityWithIndicesForJSON_SelectIndex.E orderByClust1Descending() {
      where.orderBy(QueryBuilder.desc("clust1"));
      return this;
    }

    public final class Id {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>id = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E Eq(Long id) {
        where.and(QueryBuilder.eq("id", QueryBuilder.bindMarker("id")));
        boundValues.add(id);
        encodedValues.add(meta.id.encodeFromJava(id, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>id IN ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E IN(Long... id) {
        Validator.validateTrue(ArrayUtils.isNotEmpty(id), "Varargs for field '%s' should not be null/empty", "id");
        where.and(QueryBuilder.in("id",QueryBuilder.bindMarker("id")));
        final List<Object> varargs = Arrays.<Object>asList((Object[])id);
        final List<Object> encodedVarargs = Arrays.<Long>stream((Long[])id).map(x -> meta.id.encodeFromJava(x, Optional.of(cassandraOptions))).collect(Collectors.toList());
        boundValues.add(varargs);
        encodedValues.add(encodedVarargs);
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>id  = fromJson(?) </strong> */
      public final EntityWithIndicesForJSON_SelectIndex.E Eq_FromJson(String id) {
        where.and(QueryBuilder.eq("id", QueryBuilder.fromJson(QueryBuilder.bindMarker("id"))));
        boundValues.add(id);
        encodedValues.add(id);
        return new EntityWithIndicesForJSON_SelectIndex.E(where, cassandraOptions);
      }
    }

    public final class Clust1 {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust1 = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E Eq(int clust1) {
        where.and(QueryBuilder.eq("clust1", QueryBuilder.bindMarker("clust1")));
        boundValues.add(clust1);
        encodedValues.add(meta.clust1.encodeFromJava(clust1, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust1 IN ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E IN(int... clust1) {
        Validator.validateTrue(ArrayUtils.isNotEmpty(clust1), "Varargs for field '%s' should not be null/empty", "clust1");
        where.and(QueryBuilder.in("clust1",QueryBuilder.bindMarker("clust1")));
        final List<Object> varargs = Arrays.<Object>asList((int[])clust1);
        final List<Object> encodedVarargs = new ArrayList<>(clust1.length);;
        for(int clust1_element : clust1) {
          encodedVarargs.add(meta.clust1.encodeFromJava(clust1_element, Optional.of(cassandraOptions)));
        }
        boundValues.add(varargs);
        encodedValues.add(encodedVarargs);
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust1 > ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E Gt(int clust1) {
        where.and(QueryBuilder.gt("clust1", QueryBuilder.bindMarker("clust1")));
        boundValues.add(clust1);
        encodedValues.add(meta.clust1.encodeFromJava(clust1, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust1 >= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E Gte(int clust1) {
        where.and(QueryBuilder.gte("clust1", QueryBuilder.bindMarker("clust1")));
        boundValues.add(clust1);
        encodedValues.add(meta.clust1.encodeFromJava(clust1, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust1 < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E Lt(int clust1) {
        where.and(QueryBuilder.lt("clust1", QueryBuilder.bindMarker("clust1")));
        boundValues.add(clust1);
        encodedValues.add(meta.clust1.encodeFromJava(clust1, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust1 <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E Lte(int clust1) {
        where.and(QueryBuilder.lte("clust1", QueryBuilder.bindMarker("clust1")));
        boundValues.add(clust1);
        encodedValues.add(meta.clust1.encodeFromJava(clust1, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust1 > ? AND clust1 < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E Gt_And_Lt(int clust1_Gt, int clust1_Lt) {
        where.and(QueryBuilder.gt("clust1",QueryBuilder.bindMarker("clust1_Lt")));
        where.and(QueryBuilder.lt("clust1",QueryBuilder.bindMarker("clust1_Lt")));
        boundValues.add(clust1_Gt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lt, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust1 > ? AND clust1 <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E Gt_And_Lte(int clust1_Gt, int clust1_Lte) {
        where.and(QueryBuilder.gt("clust1",QueryBuilder.bindMarker("clust1_Lte")));
        where.and(QueryBuilder.lte("clust1",QueryBuilder.bindMarker("clust1_Lte")));
        boundValues.add(clust1_Gt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lte, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust1 >= ? AND clust1 < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E Gte_And_Lt(int clust1_Gte, int clust1_Lt) {
        where.and(QueryBuilder.gte("clust1",QueryBuilder.bindMarker("clust1_Lt")));
        where.and(QueryBuilder.lt("clust1",QueryBuilder.bindMarker("clust1_Lt")));
        boundValues.add(clust1_Gte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lt, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust1 >= ? AND clust1 <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E Gte_And_Lte(int clust1_Gte, int clust1_Lte) {
        where.and(QueryBuilder.gte("clust1",QueryBuilder.bindMarker("clust1_Lte")));
        where.and(QueryBuilder.lte("clust1",QueryBuilder.bindMarker("clust1_Lte")));
        boundValues.add(clust1_Gte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lte, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust1  = fromJson(?) </strong> */
      public final EntityWithIndicesForJSON_SelectIndex.E Eq_FromJson(String clust1) {
        where.and(QueryBuilder.eq("clust1", QueryBuilder.fromJson(QueryBuilder.bindMarker("clust1"))));
        boundValues.add(clust1);
        encodedValues.add(clust1);
        return new EntityWithIndicesForJSON_SelectIndex.E(where, cassandraOptions);
      }
    }

    public final class Clust2 {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust2 = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E Eq(int clust2) {
        where.and(QueryBuilder.eq("clust2", QueryBuilder.bindMarker("clust2")));
        boundValues.add(clust2);
        encodedValues.add(meta.clust2.encodeFromJava(clust2, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust2 IN ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E IN(int... clust2) {
        Validator.validateTrue(ArrayUtils.isNotEmpty(clust2), "Varargs for field '%s' should not be null/empty", "clust2");
        where.and(QueryBuilder.in("clust2",QueryBuilder.bindMarker("clust2")));
        final List<Object> varargs = Arrays.<Object>asList((int[])clust2);
        final List<Object> encodedVarargs = new ArrayList<>(clust2.length);;
        for(int clust2_element : clust2) {
          encodedVarargs.add(meta.clust2.encodeFromJava(clust2_element, Optional.of(cassandraOptions)));
        }
        boundValues.add(varargs);
        encodedValues.add(encodedVarargs);
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust2 > ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E Gt(int clust2) {
        where.and(QueryBuilder.gt("clust2", QueryBuilder.bindMarker("clust2")));
        boundValues.add(clust2);
        encodedValues.add(meta.clust2.encodeFromJava(clust2, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust2 >= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E Gte(int clust2) {
        where.and(QueryBuilder.gte("clust2", QueryBuilder.bindMarker("clust2")));
        boundValues.add(clust2);
        encodedValues.add(meta.clust2.encodeFromJava(clust2, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust2 < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E Lt(int clust2) {
        where.and(QueryBuilder.lt("clust2", QueryBuilder.bindMarker("clust2")));
        boundValues.add(clust2);
        encodedValues.add(meta.clust2.encodeFromJava(clust2, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust2 <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E Lte(int clust2) {
        where.and(QueryBuilder.lte("clust2", QueryBuilder.bindMarker("clust2")));
        boundValues.add(clust2);
        encodedValues.add(meta.clust2.encodeFromJava(clust2, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust2 > ? AND clust2 < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E Gt_And_Lt(int clust2_Gt, int clust2_Lt) {
        where.and(QueryBuilder.gt("clust2",QueryBuilder.bindMarker("clust2_Lt")));
        where.and(QueryBuilder.lt("clust2",QueryBuilder.bindMarker("clust2_Lt")));
        boundValues.add(clust2_Gt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lt, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust2 > ? AND clust2 <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E Gt_And_Lte(int clust2_Gt, int clust2_Lte) {
        where.and(QueryBuilder.gt("clust2",QueryBuilder.bindMarker("clust2_Lte")));
        where.and(QueryBuilder.lte("clust2",QueryBuilder.bindMarker("clust2_Lte")));
        boundValues.add(clust2_Gt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lte, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust2 >= ? AND clust2 < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E Gte_And_Lt(int clust2_Gte, int clust2_Lt) {
        where.and(QueryBuilder.gte("clust2",QueryBuilder.bindMarker("clust2_Lt")));
        where.and(QueryBuilder.lt("clust2",QueryBuilder.bindMarker("clust2_Lt")));
        boundValues.add(clust2_Gte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lt, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust2 >= ? AND clust2 <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E Gte_And_Lte(int clust2_Gte, int clust2_Lte) {
        where.and(QueryBuilder.gte("clust2",QueryBuilder.bindMarker("clust2_Lte")));
        where.and(QueryBuilder.lte("clust2",QueryBuilder.bindMarker("clust2_Lte")));
        boundValues.add(clust2_Gte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lte, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust2  = fromJson(?) </strong> */
      public final EntityWithIndicesForJSON_SelectIndex.E Eq_FromJson(String clust2) {
        where.and(QueryBuilder.eq("clust2", QueryBuilder.fromJson(QueryBuilder.bindMarker("clust2"))));
        boundValues.add(clust2);
        encodedValues.add(clust2);
        return new EntityWithIndicesForJSON_SelectIndex.E(where, cassandraOptions);
      }
    }

    public final class Clust3 {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust3 = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E Eq(String clust3) {
        where.and(QueryBuilder.eq("clust3", QueryBuilder.bindMarker("clust3")));
        boundValues.add(clust3);
        encodedValues.add(meta.clust3.encodeFromJava(clust3, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust3 IN ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E IN(String... clust3) {
        Validator.validateTrue(ArrayUtils.isNotEmpty(clust3), "Varargs for field '%s' should not be null/empty", "clust3");
        where.and(QueryBuilder.in("clust3",QueryBuilder.bindMarker("clust3")));
        final List<Object> varargs = Arrays.<Object>asList((Object[])clust3);
        final List<Object> encodedVarargs = Arrays.<String>stream((String[])clust3).map(x -> meta.clust3.encodeFromJava(x, Optional.of(cassandraOptions))).collect(Collectors.toList());
        boundValues.add(varargs);
        encodedValues.add(encodedVarargs);
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust3 > ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E Gt(String clust3) {
        where.and(QueryBuilder.gt("clust3", QueryBuilder.bindMarker("clust3")));
        boundValues.add(clust3);
        encodedValues.add(meta.clust3.encodeFromJava(clust3, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust3 >= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E Gte(String clust3) {
        where.and(QueryBuilder.gte("clust3", QueryBuilder.bindMarker("clust3")));
        boundValues.add(clust3);
        encodedValues.add(meta.clust3.encodeFromJava(clust3, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust3 < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E Lt(String clust3) {
        where.and(QueryBuilder.lt("clust3", QueryBuilder.bindMarker("clust3")));
        boundValues.add(clust3);
        encodedValues.add(meta.clust3.encodeFromJava(clust3, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust3 <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E Lte(String clust3) {
        where.and(QueryBuilder.lte("clust3", QueryBuilder.bindMarker("clust3")));
        boundValues.add(clust3);
        encodedValues.add(meta.clust3.encodeFromJava(clust3, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust3 > ? AND clust3 < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E Gt_And_Lt(String clust3_Gt, String clust3_Lt) {
        where.and(QueryBuilder.gt("clust3",QueryBuilder.bindMarker("clust3_Lt")));
        where.and(QueryBuilder.lt("clust3",QueryBuilder.bindMarker("clust3_Lt")));
        boundValues.add(clust3_Gt);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust3_Lt);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Lt, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust3 > ? AND clust3 <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E Gt_And_Lte(String clust3_Gt, String clust3_Lte) {
        where.and(QueryBuilder.gt("clust3",QueryBuilder.bindMarker("clust3_Lte")));
        where.and(QueryBuilder.lte("clust3",QueryBuilder.bindMarker("clust3_Lte")));
        boundValues.add(clust3_Gt);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust3_Lte);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Lte, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust3 >= ? AND clust3 < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E Gte_And_Lt(String clust3_Gte, String clust3_Lt) {
        where.and(QueryBuilder.gte("clust3",QueryBuilder.bindMarker("clust3_Lt")));
        where.and(QueryBuilder.lt("clust3",QueryBuilder.bindMarker("clust3_Lt")));
        boundValues.add(clust3_Gte);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust3_Lt);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Lt, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust3 >= ? AND clust3 <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E Gte_And_Lte(String clust3_Gte, String clust3_Lte) {
        where.and(QueryBuilder.gte("clust3",QueryBuilder.bindMarker("clust3_Lte")));
        where.and(QueryBuilder.lte("clust3",QueryBuilder.bindMarker("clust3_Lte")));
        boundValues.add(clust3_Gte);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust3_Lte);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Lte, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust3  = fromJson(?) </strong> */
      public final EntityWithIndicesForJSON_SelectIndex.E Eq_FromJson(String clust3) {
        where.and(QueryBuilder.eq("clust3", QueryBuilder.fromJson(QueryBuilder.bindMarker("clust3"))));
        boundValues.add(clust3);
        encodedValues.add(clust3);
        return new EntityWithIndicesForJSON_SelectIndex.E(where, cassandraOptions);
      }
    }

    public final class CollectionIndex {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>collectionindex CONTAINS ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E Contains(String collectionIndex_element) {
        where.and(QueryBuilder.contains("collectionindex", QueryBuilder.bindMarker("collectionindex")));
        boundValues.add(collectionIndex_element);
        encodedValues.add(meta.collectionIndex.encodeSingleElement(collectionIndex_element, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>collectionindex CONTAINS fromJson(?)</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E Contains_FromJson(String collectionIndex_JSONElement) {
        where.and(QueryBuilder.contains("collectionindex", QueryBuilder.fromJson(QueryBuilder.bindMarker("collectionindex"))));
        boundValues.add(collectionIndex_JSONElement);
        encodedValues.add(collectionIndex_JSONElement);
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }
    }

    public final class FullIndexOnCollection {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>fullindexoncollection = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E Eq(Set<String> fullIndexOnCollection) {
        where.and(QueryBuilder.eq("fullindexoncollection", QueryBuilder.bindMarker("fullindexoncollection")));
        boundValues.add(fullIndexOnCollection);
        encodedValues.add(meta.fullIndexOnCollection.encodeFromJava(fullIndexOnCollection, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>fullindexoncollection  = fromJson(?) </strong> */
      public final EntityWithIndicesForJSON_SelectIndex.E Eq_FromJson(String fullIndexOnCollection) {
        where.and(QueryBuilder.eq("fullindexoncollection", QueryBuilder.fromJson(QueryBuilder.bindMarker("fullindexoncollection"))));
        boundValues.add(fullIndexOnCollection);
        encodedValues.add(fullIndexOnCollection);
        return new EntityWithIndicesForJSON_SelectIndex.E(where, cassandraOptions);
      }
    }

    public final class IndexOnMapEntry {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>indexonmapentry[?] = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E ContainsEntry(Integer indexOnMapEntry_key, String indexOnMapEntry_value) {
        where.and(MapEntryClause.of("indexonmapentry", QueryBuilder.bindMarker("indexOnMapEntry_key"), QueryBuilder.bindMarker("indexOnMapEntry_value")));
        boundValues.add(indexOnMapEntry_key);
        boundValues.add(indexOnMapEntry_value);
        encodedValues.add(meta.indexOnMapEntry.encodeSingleKeyElement(indexOnMapEntry_key, Optional.of(cassandraOptions)));
        encodedValues.add(meta.indexOnMapEntry.encodeSingleValueElement(indexOnMapEntry_value, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>indexonmapentry[fromJson(?)] = fromJson(?)</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E ContainsEntry_FromJSON(String indexOnMapEntry_JSONKey, String indexOnMapEntry_JSONValue) {
        where.and(MapEntryClause.of("indexonmapentry", QueryBuilder.fromJson(QueryBuilder.bindMarker("indexOnMapEntry_JSONKey")), QueryBuilder.fromJson(QueryBuilder.bindMarker("indexOnMapEntry_JSONValue"))));
        boundValues.add(indexOnMapEntry_JSONKey);
        boundValues.add(indexOnMapEntry_JSONValue);
        encodedValues.add(indexOnMapEntry_JSONKey);
        encodedValues.add(indexOnMapEntry_JSONValue);
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }
    }

    public final class IndexOnMapKey {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>indexonmapkey CONTAINS KEY ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E ContainsKey(String indexOnMapKey_key) {
        where.and(QueryBuilder.containsKey("indexonmapkey", QueryBuilder.bindMarker("indexonmapkey")));
        boundValues.add(indexOnMapKey_key);
        encodedValues.add(meta.indexOnMapKey.encodeSingleKeyElement(indexOnMapKey_key, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>indexonmapkey CONTAINS KEY fromJson(?)</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E ContainsKey_FromJSON(String indexOnMapKey_JSONKey) {
        where.and(QueryBuilder.containsKey("indexonmapkey", QueryBuilder.fromJson(QueryBuilder.bindMarker("indexonmapkey"))));
        boundValues.add(indexOnMapKey_JSONKey);
        encodedValues.add(indexOnMapKey_JSONKey);
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }
    }

    public final class IndexOnMapValue {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>indexonmapvalue CONTAINS ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E ContainsValue(String indexOnMapValue_value) {
        where.and(QueryBuilder.contains("indexonmapvalue", QueryBuilder.bindMarker("indexonmapvalue")));
        boundValues.add(indexOnMapValue_value);
        encodedValues.add(meta.indexOnMapValue.encodeSingleValueElement(indexOnMapValue_value, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>indexonmapvalue CONTAINS fromJson(?)</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E ContainsValue_FromJSON(String indexOnMapValue_JSONValue) {
        where.and(QueryBuilder.contains("indexonmapvalue", QueryBuilder.fromJson(QueryBuilder.bindMarker("indexonmapvalue"))));
        boundValues.add(indexOnMapValue_JSONValue);
        encodedValues.add(indexOnMapValue_JSONValue);
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }
    }

    public final class SimpleIndex {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>simpleindex = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E Eq(String simpleIndex) {
        where.and(QueryBuilder.eq("simpleindex", QueryBuilder.bindMarker("simpleindex")));
        boundValues.add(simpleIndex);
        encodedValues.add(meta.simpleIndex.encodeFromJava(simpleIndex, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>simpleindex  = fromJson(?) </strong> */
      public final EntityWithIndicesForJSON_SelectIndex.E Eq_FromJson(String simpleIndex) {
        where.and(QueryBuilder.eq("simpleindex", QueryBuilder.fromJson(QueryBuilder.bindMarker("simpleindex"))));
        boundValues.add(simpleIndex);
        encodedValues.add(simpleIndex);
        return new EntityWithIndicesForJSON_SelectIndex.E(where, cassandraOptions);
      }
    }

    public final class clust1_clust2 {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2) > ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E Gt(final int clust1, final int clust2) {
        where.and(QueryBuilder.gt(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        final TupleType tupleType = rte.tupleTypeFactory.typeFor();
        boundValues.add(clust1);
        encodedValues.add(meta.clust1.encodeFromJava(clust1, Optional.of(cassandraOptions)));
        boundValues.add(clust2);
        encodedValues.add(meta.clust2.encodeFromJava(clust2, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2) >= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E Gte(final int clust1, final int clust2) {
        where.and(QueryBuilder.gte(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        final TupleType tupleType = rte.tupleTypeFactory.typeFor();
        boundValues.add(clust1);
        encodedValues.add(meta.clust1.encodeFromJava(clust1, Optional.of(cassandraOptions)));
        boundValues.add(clust2);
        encodedValues.add(meta.clust2.encodeFromJava(clust2, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2) < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E Lt(final int clust1, final int clust2) {
        where.and(QueryBuilder.lt(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        final TupleType tupleType = rte.tupleTypeFactory.typeFor();
        boundValues.add(clust1);
        encodedValues.add(meta.clust1.encodeFromJava(clust1, Optional.of(cassandraOptions)));
        boundValues.add(clust2);
        encodedValues.add(meta.clust2.encodeFromJava(clust2, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2) <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E Lte(final int clust1, final int clust2) {
        where.and(QueryBuilder.lte(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        final TupleType tupleType = rte.tupleTypeFactory.typeFor();
        boundValues.add(clust1);
        encodedValues.add(meta.clust1.encodeFromJava(clust1, Optional.of(cassandraOptions)));
        boundValues.add(clust2);
        encodedValues.add(meta.clust2.encodeFromJava(clust2, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2) > ? AND (clust1,clust2) < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E Gt_And_Lt(final int clust1_Gt, final int clust2_Gt, final int clust1_Lt, final int clust2_Lt) {
        where.and(QueryBuilder.gt(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lt(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Gt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lt, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lt, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2) > ? AND (clust1,clust2) <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E Gt_And_Lte(final int clust1_Gt, final int clust2_Gt, final int clust1_Lte, final int clust2_Lte) {
        where.and(QueryBuilder.gt(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lte(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Gt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lte, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lte, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2) >= ? AND (clust1,clust2) < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E Gte_And_Lt(final int clust1_Gte, final int clust2_Gte, final int clust1_Lt, final int clust2_Lt) {
        where.and(QueryBuilder.gte(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lt(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Gte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lt, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lt, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2) >= ? AND (clust1,clust2) <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E Gte_And_Lte(final int clust1_Gte, final int clust2_Gte, final int clust1_Lte, final int clust2_Lte) {
        where.and(QueryBuilder.gte(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lte(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Gte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lte, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lte, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2) > ? AND (clust1) < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E clust1_And_clust2_Gt_And_clust1_Lt(final int clust1_Gt, final int clust2_Gt, final int clust1_Lt) {
        where.and(QueryBuilder.gt(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lt(Arrays.asList("clust1"), Arrays.asList("clust1").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Gt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lt, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2) > ? AND (clust1) <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E clust1_And_clust2_Gt_And_clust1_Lte(final int clust1_Gt, final int clust2_Gt, final int clust1_Lte) {
        where.and(QueryBuilder.gt(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lte(Arrays.asList("clust1"), Arrays.asList("clust1").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Gt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lte, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2) >= ? AND (clust1) < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E clust1_And_clust2_Gte_And_clust1_Lt(final int clust1_Gte, final int clust2_Gte, final int clust1_Lt) {
        where.and(QueryBuilder.gte(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lt(Arrays.asList("clust1"), Arrays.asList("clust1").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Gte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lt, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2) >= ? AND (clust1) <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E clust1_And_clust2_Gte_And_clust1_Lte(final int clust1_Gte, final int clust2_Gte, final int clust1_Lte) {
        where.and(QueryBuilder.gte(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lte(Arrays.asList("clust1"), Arrays.asList("clust1").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Gte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lte, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1) > ? AND (clust1,clust2) < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E clust1_Gt_And_clust1_And_clust2_Lt(final int clust1_Gt, final int clust1_Lt, final int clust2_Lt) {
        where.and(QueryBuilder.gt(Arrays.asList("clust1"), Arrays.asList("clust1").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lt(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lt, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lt, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1) > ? AND (clust1,clust2) <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E clust1_Gt_And_clust1_And_clust2_Lte(final int clust1_Gt, final int clust1_Lte, final int clust2_Lte) {
        where.and(QueryBuilder.gt(Arrays.asList("clust1"), Arrays.asList("clust1").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lte(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lte, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lte, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1) >= ? AND (clust1,clust2) < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E clust1_Gte_And_clust1_And_clust2_Lt(final int clust1_Gte, final int clust1_Lt, final int clust2_Lt) {
        where.and(QueryBuilder.gte(Arrays.asList("clust1"), Arrays.asList("clust1").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lt(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lt, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lt, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1) >= ? AND (clust1,clust2) <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E clust1_Gte_And_clust1_And_clust2_Lte(final int clust1_Gte, final int clust1_Lte, final int clust2_Lte) {
        where.and(QueryBuilder.gte(Arrays.asList("clust1"), Arrays.asList("clust1").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lte(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lte, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lte, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }
    }

    public final class clust1_clust2_clust3 {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2,clust3) > ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E Gt(final int clust1, final int clust2, final String clust3) {
        where.and(QueryBuilder.gt(Arrays.asList("clust1","clust2","clust3"), Arrays.asList("clust1","clust2","clust3").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        final TupleType tupleType = rte.tupleTypeFactory.typeFor();
        boundValues.add(clust1);
        encodedValues.add(meta.clust1.encodeFromJava(clust1, Optional.of(cassandraOptions)));
        boundValues.add(clust2);
        encodedValues.add(meta.clust2.encodeFromJava(clust2, Optional.of(cassandraOptions)));
        boundValues.add(clust3);
        encodedValues.add(meta.clust3.encodeFromJava(clust3, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2,clust3) >= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E Gte(final int clust1, final int clust2, final String clust3) {
        where.and(QueryBuilder.gte(Arrays.asList("clust1","clust2","clust3"), Arrays.asList("clust1","clust2","clust3").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        final TupleType tupleType = rte.tupleTypeFactory.typeFor();
        boundValues.add(clust1);
        encodedValues.add(meta.clust1.encodeFromJava(clust1, Optional.of(cassandraOptions)));
        boundValues.add(clust2);
        encodedValues.add(meta.clust2.encodeFromJava(clust2, Optional.of(cassandraOptions)));
        boundValues.add(clust3);
        encodedValues.add(meta.clust3.encodeFromJava(clust3, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2,clust3) < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E Lt(final int clust1, final int clust2, final String clust3) {
        where.and(QueryBuilder.lt(Arrays.asList("clust1","clust2","clust3"), Arrays.asList("clust1","clust2","clust3").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        final TupleType tupleType = rte.tupleTypeFactory.typeFor();
        boundValues.add(clust1);
        encodedValues.add(meta.clust1.encodeFromJava(clust1, Optional.of(cassandraOptions)));
        boundValues.add(clust2);
        encodedValues.add(meta.clust2.encodeFromJava(clust2, Optional.of(cassandraOptions)));
        boundValues.add(clust3);
        encodedValues.add(meta.clust3.encodeFromJava(clust3, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2,clust3) <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E Lte(final int clust1, final int clust2, final String clust3) {
        where.and(QueryBuilder.lte(Arrays.asList("clust1","clust2","clust3"), Arrays.asList("clust1","clust2","clust3").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        final TupleType tupleType = rte.tupleTypeFactory.typeFor();
        boundValues.add(clust1);
        encodedValues.add(meta.clust1.encodeFromJava(clust1, Optional.of(cassandraOptions)));
        boundValues.add(clust2);
        encodedValues.add(meta.clust2.encodeFromJava(clust2, Optional.of(cassandraOptions)));
        boundValues.add(clust3);
        encodedValues.add(meta.clust3.encodeFromJava(clust3, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2,clust3) > ? AND (clust1,clust2,clust3) < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E Gt_And_Lt(final int clust1_Gt, final int clust2_Gt, final String clust3_Gt, final int clust1_Lt, final int clust2_Lt, final String clust3_Lt) {
        where.and(QueryBuilder.gt(Arrays.asList("clust1","clust2","clust3"), Arrays.asList("clust1","clust2","clust3").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lt(Arrays.asList("clust1","clust2","clust3"), Arrays.asList("clust1","clust2","clust3").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Gt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust3_Gt);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lt, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lt, Optional.of(cassandraOptions)));
        boundValues.add(clust3_Lt);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Lt, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2,clust3) > ? AND (clust1,clust2,clust3) <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E Gt_And_Lte(final int clust1_Gt, final int clust2_Gt, final String clust3_Gt, final int clust1_Lte, final int clust2_Lte, final String clust3_Lte) {
        where.and(QueryBuilder.gt(Arrays.asList("clust1","clust2","clust3"), Arrays.asList("clust1","clust2","clust3").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lte(Arrays.asList("clust1","clust2","clust3"), Arrays.asList("clust1","clust2","clust3").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Gt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust3_Gt);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lte, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lte, Optional.of(cassandraOptions)));
        boundValues.add(clust3_Lte);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Lte, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2,clust3) >= ? AND (clust1,clust2,clust3) < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E Gte_And_Lt(final int clust1_Gte, final int clust2_Gte, final String clust3_Gte, final int clust1_Lt, final int clust2_Lt, final String clust3_Lt) {
        where.and(QueryBuilder.gte(Arrays.asList("clust1","clust2","clust3"), Arrays.asList("clust1","clust2","clust3").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lt(Arrays.asList("clust1","clust2","clust3"), Arrays.asList("clust1","clust2","clust3").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Gte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust3_Gte);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lt, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lt, Optional.of(cassandraOptions)));
        boundValues.add(clust3_Lt);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Lt, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2,clust3) >= ? AND (clust1,clust2,clust3) <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E Gte_And_Lte(final int clust1_Gte, final int clust2_Gte, final String clust3_Gte, final int clust1_Lte, final int clust2_Lte, final String clust3_Lte) {
        where.and(QueryBuilder.gte(Arrays.asList("clust1","clust2","clust3"), Arrays.asList("clust1","clust2","clust3").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lte(Arrays.asList("clust1","clust2","clust3"), Arrays.asList("clust1","clust2","clust3").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Gte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust3_Gte);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lte, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lte, Optional.of(cassandraOptions)));
        boundValues.add(clust3_Lte);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Lte, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2,clust3) > ? AND (clust1,clust2) < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E clust1_And_clust2_And_clust3_Gt_And_clust1_And_clust2_Lt(final int clust1_Gt, final int clust2_Gt, final String clust3_Gt, final int clust1_Lt, final int clust2_Lt) {
        where.and(QueryBuilder.gt(Arrays.asList("clust1","clust2","clust3"), Arrays.asList("clust1","clust2","clust3").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lt(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Gt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust3_Gt);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lt, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lt, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2,clust3) > ? AND (clust1,clust2) <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E clust1_And_clust2_And_clust3_Gt_And_clust1_And_clust2_Lte(final int clust1_Gt, final int clust2_Gt, final String clust3_Gt, final int clust1_Lte, final int clust2_Lte) {
        where.and(QueryBuilder.gt(Arrays.asList("clust1","clust2","clust3"), Arrays.asList("clust1","clust2","clust3").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lte(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Gt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust3_Gt);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lte, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lte, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2,clust3) >= ? AND (clust1,clust2) < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E clust1_And_clust2_And_clust3_Gte_And_clust1_And_clust2_Lt(final int clust1_Gte, final int clust2_Gte, final String clust3_Gte, final int clust1_Lt, final int clust2_Lt) {
        where.and(QueryBuilder.gte(Arrays.asList("clust1","clust2","clust3"), Arrays.asList("clust1","clust2","clust3").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lt(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Gte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust3_Gte);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lt, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lt, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2,clust3) >= ? AND (clust1,clust2) <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E clust1_And_clust2_And_clust3_Gte_And_clust1_And_clust2_Lte(final int clust1_Gte, final int clust2_Gte, final String clust3_Gte, final int clust1_Lte, final int clust2_Lte) {
        where.and(QueryBuilder.gte(Arrays.asList("clust1","clust2","clust3"), Arrays.asList("clust1","clust2","clust3").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lte(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Gte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust3_Gte);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lte, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lte, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2) > ? AND (clust1,clust2,clust3) < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E clust1_And_clust2_Gt_And_clust1_And_clust2_And_clust3_Lt(final int clust1_Gt, final int clust2_Gt, final int clust1_Lt, final int clust2_Lt, final String clust3_Lt) {
        where.and(QueryBuilder.gt(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lt(Arrays.asList("clust1","clust2","clust3"), Arrays.asList("clust1","clust2","clust3").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Gt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lt, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lt, Optional.of(cassandraOptions)));
        boundValues.add(clust3_Lt);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Lt, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2) > ? AND (clust1,clust2,clust3) <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E clust1_And_clust2_Gt_And_clust1_And_clust2_And_clust3_Lte(final int clust1_Gt, final int clust2_Gt, final int clust1_Lte, final int clust2_Lte, final String clust3_Lte) {
        where.and(QueryBuilder.gt(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lte(Arrays.asList("clust1","clust2","clust3"), Arrays.asList("clust1","clust2","clust3").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Gt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lte, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lte, Optional.of(cassandraOptions)));
        boundValues.add(clust3_Lte);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Lte, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2) >= ? AND (clust1,clust2,clust3) < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E clust1_And_clust2_Gte_And_clust1_And_clust2_And_clust3_Lt(final int clust1_Gte, final int clust2_Gte, final int clust1_Lt, final int clust2_Lt, final String clust3_Lt) {
        where.and(QueryBuilder.gte(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lt(Arrays.asList("clust1","clust2","clust3"), Arrays.asList("clust1","clust2","clust3").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Gte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lt, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lt, Optional.of(cassandraOptions)));
        boundValues.add(clust3_Lt);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Lt, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2) >= ? AND (clust1,clust2,clust3) <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E clust1_And_clust2_Gte_And_clust1_And_clust2_And_clust3_Lte(final int clust1_Gte, final int clust2_Gte, final int clust1_Lte, final int clust2_Lte, final String clust3_Lte) {
        where.and(QueryBuilder.gte(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lte(Arrays.asList("clust1","clust2","clust3"), Arrays.asList("clust1","clust2","clust3").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Gte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lte, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lte, Optional.of(cassandraOptions)));
        boundValues.add(clust3_Lte);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Lte, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E.this;
      }
    }
  }

  public final class W_TM extends AbstractSelectWherePartitionTypeMap {
    public W_TM(Select.Where where, CassandraOptions cassandraOptions) {
      super(where, cassandraOptions);
    }

    public final EntityWithIndicesForJSON_SelectIndex.W_TM.CollectionIndex collectionIndex() {
      return new EntityWithIndicesForJSON_SelectIndex.W_TM.CollectionIndex();
    }

    public final EntityWithIndicesForJSON_SelectIndex.W_TM.FullIndexOnCollection fullIndexOnCollection() {
      return new EntityWithIndicesForJSON_SelectIndex.W_TM.FullIndexOnCollection();
    }

    public final EntityWithIndicesForJSON_SelectIndex.W_TM.IndexOnMapEntry indexOnMapEntry() {
      return new EntityWithIndicesForJSON_SelectIndex.W_TM.IndexOnMapEntry();
    }

    public final EntityWithIndicesForJSON_SelectIndex.W_TM.IndexOnMapKey indexOnMapKey() {
      return new EntityWithIndicesForJSON_SelectIndex.W_TM.IndexOnMapKey();
    }

    public final EntityWithIndicesForJSON_SelectIndex.W_TM.IndexOnMapValue indexOnMapValue() {
      return new EntityWithIndicesForJSON_SelectIndex.W_TM.IndexOnMapValue();
    }

    public final EntityWithIndicesForJSON_SelectIndex.W_TM.SimpleIndex simpleIndex() {
      return new EntityWithIndicesForJSON_SelectIndex.W_TM.SimpleIndex();
    }

    public final class CollectionIndex {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>collectionindex CONTAINS ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM Contains(String collectionIndex_element) {
        where.and(QueryBuilder.contains("collectionindex", QueryBuilder.bindMarker("collectionindex")));
        boundValues.add(collectionIndex_element);
        encodedValues.add(meta.collectionIndex.encodeSingleElement(collectionIndex_element, Optional.of(cassandraOptions)));
        return new EntityWithIndicesForJSON_SelectIndex.E_TM(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>collectionindex CONTAINS fromJson(?)</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM Contains_FromJson(String collectionIndex_JSONElement) {
        where.and(QueryBuilder.contains("collectionindex", QueryBuilder.fromJson(QueryBuilder.bindMarker("collectionindex"))));
        boundValues.add(collectionIndex_JSONElement);
        encodedValues.add(collectionIndex_JSONElement);
        return new EntityWithIndicesForJSON_SelectIndex.E_TM(where, cassandraOptions);
      }
    }

    public final class FullIndexOnCollection {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>fullindexoncollection = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM Eq(Set<String> fullIndexOnCollection) {
        where.and(QueryBuilder.eq("fullindexoncollection", QueryBuilder.bindMarker("fullindexoncollection")));
        boundValues.add(fullIndexOnCollection);
        encodedValues.add(meta.fullIndexOnCollection.encodeFromJava(fullIndexOnCollection, Optional.of(cassandraOptions)));
        return new EntityWithIndicesForJSON_SelectIndex.E_TM(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>fullindexoncollection  = fromJson(?) </strong> */
      public final EntityWithIndicesForJSON_SelectIndex.E_TM Eq_FromJson(String fullIndexOnCollection) {
        where.and(QueryBuilder.eq("fullindexoncollection", QueryBuilder.fromJson(QueryBuilder.bindMarker("fullindexoncollection"))));
        boundValues.add(fullIndexOnCollection);
        encodedValues.add(fullIndexOnCollection);
        return new EntityWithIndicesForJSON_SelectIndex.E_TM(where, cassandraOptions);
      }
    }

    public final class IndexOnMapEntry {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>indexonmapentry[?] = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM ContainsEntry(Integer indexOnMapEntry_key, String indexOnMapEntry_value) {
        where.and(MapEntryClause.of("indexonmapentry", QueryBuilder.bindMarker("indexOnMapEntry_key"), QueryBuilder.bindMarker("indexOnMapEntry_value")));
        boundValues.add(indexOnMapEntry_key);
        boundValues.add(indexOnMapEntry_value);
        encodedValues.add(meta.indexOnMapEntry.encodeSingleKeyElement(indexOnMapEntry_key, Optional.of(cassandraOptions)));
        encodedValues.add(meta.indexOnMapEntry.encodeSingleValueElement(indexOnMapEntry_value, Optional.of(cassandraOptions)));
        return new EntityWithIndicesForJSON_SelectIndex.E_TM(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>indexonmapentry[fromJson(?)] = fromJson(?)</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM ContainsEntry_FromJSON(String indexOnMapEntry_JSONKey, String indexOnMapEntry_JSONValue) {
        where.and(MapEntryClause.of("indexonmapentry", QueryBuilder.fromJson(QueryBuilder.bindMarker("indexOnMapEntry_JSONKey")), QueryBuilder.fromJson(QueryBuilder.bindMarker("indexOnMapEntry_JSONValue"))));
        boundValues.add(indexOnMapEntry_JSONKey);
        boundValues.add(indexOnMapEntry_JSONValue);
        encodedValues.add(indexOnMapEntry_JSONKey);
        encodedValues.add(indexOnMapEntry_JSONValue);
        return new EntityWithIndicesForJSON_SelectIndex.E_TM(where, cassandraOptions);
      }
    }

    public final class IndexOnMapKey {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>indexonmapkey CONTAINS KEY ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM ContainsKey(String indexOnMapKey_key) {
        where.and(QueryBuilder.containsKey("indexonmapkey", QueryBuilder.bindMarker("indexonmapkey")));
        boundValues.add(indexOnMapKey_key);
        encodedValues.add(meta.indexOnMapKey.encodeSingleKeyElement(indexOnMapKey_key, Optional.of(cassandraOptions)));
        return new EntityWithIndicesForJSON_SelectIndex.E_TM(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>indexonmapkey CONTAINS KEY fromJson(?)</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM ContainsKey_FromJSON(String indexOnMapKey_JSONKey) {
        where.and(QueryBuilder.containsKey("indexonmapkey", QueryBuilder.fromJson(QueryBuilder.bindMarker("indexonmapkey"))));
        boundValues.add(indexOnMapKey_JSONKey);
        encodedValues.add(indexOnMapKey_JSONKey);
        return new EntityWithIndicesForJSON_SelectIndex.E_TM(where, cassandraOptions);
      }
    }

    public final class IndexOnMapValue {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>indexonmapvalue CONTAINS ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM ContainsValue(String indexOnMapValue_value) {
        where.and(QueryBuilder.contains("indexonmapvalue", QueryBuilder.bindMarker("indexonmapvalue")));
        boundValues.add(indexOnMapValue_value);
        encodedValues.add(meta.indexOnMapValue.encodeSingleValueElement(indexOnMapValue_value, Optional.of(cassandraOptions)));
        return new EntityWithIndicesForJSON_SelectIndex.E_TM(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>indexonmapvalue CONTAINS fromJson(?)</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM ContainsValue_FromJSON(String indexOnMapValue_JSONValue) {
        where.and(QueryBuilder.contains("indexonmapvalue", QueryBuilder.fromJson(QueryBuilder.bindMarker("indexonmapvalue"))));
        boundValues.add(indexOnMapValue_JSONValue);
        encodedValues.add(indexOnMapValue_JSONValue);
        return new EntityWithIndicesForJSON_SelectIndex.E_TM(where, cassandraOptions);
      }
    }

    public final class SimpleIndex {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>simpleindex = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM Eq(String simpleIndex) {
        where.and(QueryBuilder.eq("simpleindex", QueryBuilder.bindMarker("simpleindex")));
        boundValues.add(simpleIndex);
        encodedValues.add(meta.simpleIndex.encodeFromJava(simpleIndex, Optional.of(cassandraOptions)));
        return new EntityWithIndicesForJSON_SelectIndex.E_TM(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>simpleindex  = fromJson(?) </strong> */
      public final EntityWithIndicesForJSON_SelectIndex.E_TM Eq_FromJson(String simpleIndex) {
        where.and(QueryBuilder.eq("simpleindex", QueryBuilder.fromJson(QueryBuilder.bindMarker("simpleindex"))));
        boundValues.add(simpleIndex);
        encodedValues.add(simpleIndex);
        return new EntityWithIndicesForJSON_SelectIndex.E_TM(where, cassandraOptions);
      }
    }
  }

  public final class E_TM extends AbstractIndexSelectWhereTypeMap<EntityWithIndicesForJSON_SelectIndex.E_TM, EntityWithIndicesForJSON> {
    public E_TM(Select.Where where, CassandraOptions cassandraOptions) {
      super(where, cassandraOptions);
    }

    @Override
    protected final Class<EntityWithIndicesForJSON> getEntityClass() {
      return entityClass;
    }

    @Override
    protected final AbstractEntityProperty<EntityWithIndicesForJSON> getMetaInternal() {
      return meta;
    }

    @Override
    protected final RuntimeEngine getRte() {
      return rte;
    }

    @Override
    protected final CassandraOptions getOptions() {
      return cassandraOptions;
    }

    @Override
    protected final List<Object> getBoundValuesInternal() {
      return boundValues;
    }

    @Override
    protected final List<Object> getEncodedValuesInternal() {
      return encodedValues;
    }

    /**
     * Generate a SELECT ... FROM ... WHERE ... <strong>LIMIT :limit</strong> */
    public final EntityWithIndicesForJSON_SelectIndex.E_TM limit(final Integer limit) {
      where.limit(QueryBuilder.bindMarker("lim"));
      boundValues.add(limit);
      encodedValues.add(limit);
      return this;
    }

    @Override
    protected final EntityWithIndicesForJSON_SelectIndex.E_TM getThis() {
      return this;
    }

    public final EntityWithIndicesForJSON_SelectIndex.E_TM.Id id() {
      return new EntityWithIndicesForJSON_SelectIndex.E_TM.Id();
    }

    public final EntityWithIndicesForJSON_SelectIndex.E_TM.Clust1 clust1() {
      return new EntityWithIndicesForJSON_SelectIndex.E_TM.Clust1();
    }

    public final EntityWithIndicesForJSON_SelectIndex.E_TM.Clust2 clust2() {
      return new EntityWithIndicesForJSON_SelectIndex.E_TM.Clust2();
    }

    public final EntityWithIndicesForJSON_SelectIndex.E_TM.Clust3 clust3() {
      return new EntityWithIndicesForJSON_SelectIndex.E_TM.Clust3();
    }

    public final EntityWithIndicesForJSON_SelectIndex.E_TM.CollectionIndex collectionIndex() {
      return new EntityWithIndicesForJSON_SelectIndex.E_TM.CollectionIndex();
    }

    public final EntityWithIndicesForJSON_SelectIndex.E_TM.FullIndexOnCollection fullIndexOnCollection() {
      return new EntityWithIndicesForJSON_SelectIndex.E_TM.FullIndexOnCollection();
    }

    public final EntityWithIndicesForJSON_SelectIndex.E_TM.IndexOnMapEntry indexOnMapEntry() {
      return new EntityWithIndicesForJSON_SelectIndex.E_TM.IndexOnMapEntry();
    }

    public final EntityWithIndicesForJSON_SelectIndex.E_TM.IndexOnMapKey indexOnMapKey() {
      return new EntityWithIndicesForJSON_SelectIndex.E_TM.IndexOnMapKey();
    }

    public final EntityWithIndicesForJSON_SelectIndex.E_TM.IndexOnMapValue indexOnMapValue() {
      return new EntityWithIndicesForJSON_SelectIndex.E_TM.IndexOnMapValue();
    }

    public final EntityWithIndicesForJSON_SelectIndex.E_TM.SimpleIndex simpleIndex() {
      return new EntityWithIndicesForJSON_SelectIndex.E_TM.SimpleIndex();
    }

    public final EntityWithIndicesForJSON_SelectIndex.E_TM.clust1_clust2 clust1_clust2() {
      return new EntityWithIndicesForJSON_SelectIndex.E_TM.clust1_clust2();
    }

    public final EntityWithIndicesForJSON_SelectIndex.E_TM.clust1_clust2_clust3 clust1_clust2_clust3() {
      return new EntityWithIndicesForJSON_SelectIndex.E_TM.clust1_clust2_clust3();
    }

    /**
     * Generate a SELECT ... FROM ... WHERE ... <strong>ORDER BY clust1 ASC</strong> */
    public final EntityWithIndicesForJSON_SelectIndex.E_TM orderByClust1Ascending() {
      where.orderBy(QueryBuilder.asc("clust1"));
      return this;
    }

    /**
     * Generate a SELECT ... FROM ... WHERE ... <strong>ORDER BY clust1 DESC</strong> */
    public final EntityWithIndicesForJSON_SelectIndex.E_TM orderByClust1Descending() {
      where.orderBy(QueryBuilder.desc("clust1"));
      return this;
    }

    public final class Id {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>id = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM Eq(Long id) {
        where.and(QueryBuilder.eq("id", QueryBuilder.bindMarker("id")));
        boundValues.add(id);
        encodedValues.add(meta.id.encodeFromJava(id, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>id IN ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM IN(Long... id) {
        Validator.validateTrue(ArrayUtils.isNotEmpty(id), "Varargs for field '%s' should not be null/empty", "id");
        where.and(QueryBuilder.in("id",QueryBuilder.bindMarker("id")));
        final List<Object> varargs = Arrays.<Object>asList((Object[])id);
        final List<Object> encodedVarargs = Arrays.<Long>stream((Long[])id).map(x -> meta.id.encodeFromJava(x, Optional.of(cassandraOptions))).collect(Collectors.toList());
        boundValues.add(varargs);
        encodedValues.add(encodedVarargs);
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>id  = fromJson(?) </strong> */
      public final EntityWithIndicesForJSON_SelectIndex.E_TM Eq_FromJson(String id) {
        where.and(QueryBuilder.eq("id", QueryBuilder.fromJson(QueryBuilder.bindMarker("id"))));
        boundValues.add(id);
        encodedValues.add(id);
        return new EntityWithIndicesForJSON_SelectIndex.E_TM(where, cassandraOptions);
      }
    }

    public final class Clust1 {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust1 = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM Eq(int clust1) {
        where.and(QueryBuilder.eq("clust1", QueryBuilder.bindMarker("clust1")));
        boundValues.add(clust1);
        encodedValues.add(meta.clust1.encodeFromJava(clust1, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust1 IN ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM IN(int... clust1) {
        Validator.validateTrue(ArrayUtils.isNotEmpty(clust1), "Varargs for field '%s' should not be null/empty", "clust1");
        where.and(QueryBuilder.in("clust1",QueryBuilder.bindMarker("clust1")));
        final List<Object> varargs = Arrays.<Object>asList((int[])clust1);
        final List<Object> encodedVarargs = new ArrayList<>(clust1.length);;
        for(int clust1_element : clust1) {
          encodedVarargs.add(meta.clust1.encodeFromJava(clust1_element, Optional.of(cassandraOptions)));
        }
        boundValues.add(varargs);
        encodedValues.add(encodedVarargs);
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust1 > ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM Gt(int clust1) {
        where.and(QueryBuilder.gt("clust1", QueryBuilder.bindMarker("clust1")));
        boundValues.add(clust1);
        encodedValues.add(meta.clust1.encodeFromJava(clust1, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust1 >= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM Gte(int clust1) {
        where.and(QueryBuilder.gte("clust1", QueryBuilder.bindMarker("clust1")));
        boundValues.add(clust1);
        encodedValues.add(meta.clust1.encodeFromJava(clust1, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust1 < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM Lt(int clust1) {
        where.and(QueryBuilder.lt("clust1", QueryBuilder.bindMarker("clust1")));
        boundValues.add(clust1);
        encodedValues.add(meta.clust1.encodeFromJava(clust1, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust1 <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM Lte(int clust1) {
        where.and(QueryBuilder.lte("clust1", QueryBuilder.bindMarker("clust1")));
        boundValues.add(clust1);
        encodedValues.add(meta.clust1.encodeFromJava(clust1, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust1 > ? AND clust1 < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM Gt_And_Lt(int clust1_Gt, int clust1_Lt) {
        where.and(QueryBuilder.gt("clust1",QueryBuilder.bindMarker("clust1_Lt")));
        where.and(QueryBuilder.lt("clust1",QueryBuilder.bindMarker("clust1_Lt")));
        boundValues.add(clust1_Gt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lt, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust1 > ? AND clust1 <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM Gt_And_Lte(int clust1_Gt, int clust1_Lte) {
        where.and(QueryBuilder.gt("clust1",QueryBuilder.bindMarker("clust1_Lte")));
        where.and(QueryBuilder.lte("clust1",QueryBuilder.bindMarker("clust1_Lte")));
        boundValues.add(clust1_Gt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lte, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust1 >= ? AND clust1 < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM Gte_And_Lt(int clust1_Gte, int clust1_Lt) {
        where.and(QueryBuilder.gte("clust1",QueryBuilder.bindMarker("clust1_Lt")));
        where.and(QueryBuilder.lt("clust1",QueryBuilder.bindMarker("clust1_Lt")));
        boundValues.add(clust1_Gte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lt, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust1 >= ? AND clust1 <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM Gte_And_Lte(int clust1_Gte, int clust1_Lte) {
        where.and(QueryBuilder.gte("clust1",QueryBuilder.bindMarker("clust1_Lte")));
        where.and(QueryBuilder.lte("clust1",QueryBuilder.bindMarker("clust1_Lte")));
        boundValues.add(clust1_Gte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lte, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust1  = fromJson(?) </strong> */
      public final EntityWithIndicesForJSON_SelectIndex.E_TM Eq_FromJson(String clust1) {
        where.and(QueryBuilder.eq("clust1", QueryBuilder.fromJson(QueryBuilder.bindMarker("clust1"))));
        boundValues.add(clust1);
        encodedValues.add(clust1);
        return new EntityWithIndicesForJSON_SelectIndex.E_TM(where, cassandraOptions);
      }
    }

    public final class Clust2 {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust2 = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM Eq(int clust2) {
        where.and(QueryBuilder.eq("clust2", QueryBuilder.bindMarker("clust2")));
        boundValues.add(clust2);
        encodedValues.add(meta.clust2.encodeFromJava(clust2, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust2 IN ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM IN(int... clust2) {
        Validator.validateTrue(ArrayUtils.isNotEmpty(clust2), "Varargs for field '%s' should not be null/empty", "clust2");
        where.and(QueryBuilder.in("clust2",QueryBuilder.bindMarker("clust2")));
        final List<Object> varargs = Arrays.<Object>asList((int[])clust2);
        final List<Object> encodedVarargs = new ArrayList<>(clust2.length);;
        for(int clust2_element : clust2) {
          encodedVarargs.add(meta.clust2.encodeFromJava(clust2_element, Optional.of(cassandraOptions)));
        }
        boundValues.add(varargs);
        encodedValues.add(encodedVarargs);
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust2 > ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM Gt(int clust2) {
        where.and(QueryBuilder.gt("clust2", QueryBuilder.bindMarker("clust2")));
        boundValues.add(clust2);
        encodedValues.add(meta.clust2.encodeFromJava(clust2, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust2 >= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM Gte(int clust2) {
        where.and(QueryBuilder.gte("clust2", QueryBuilder.bindMarker("clust2")));
        boundValues.add(clust2);
        encodedValues.add(meta.clust2.encodeFromJava(clust2, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust2 < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM Lt(int clust2) {
        where.and(QueryBuilder.lt("clust2", QueryBuilder.bindMarker("clust2")));
        boundValues.add(clust2);
        encodedValues.add(meta.clust2.encodeFromJava(clust2, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust2 <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM Lte(int clust2) {
        where.and(QueryBuilder.lte("clust2", QueryBuilder.bindMarker("clust2")));
        boundValues.add(clust2);
        encodedValues.add(meta.clust2.encodeFromJava(clust2, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust2 > ? AND clust2 < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM Gt_And_Lt(int clust2_Gt, int clust2_Lt) {
        where.and(QueryBuilder.gt("clust2",QueryBuilder.bindMarker("clust2_Lt")));
        where.and(QueryBuilder.lt("clust2",QueryBuilder.bindMarker("clust2_Lt")));
        boundValues.add(clust2_Gt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lt, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust2 > ? AND clust2 <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM Gt_And_Lte(int clust2_Gt, int clust2_Lte) {
        where.and(QueryBuilder.gt("clust2",QueryBuilder.bindMarker("clust2_Lte")));
        where.and(QueryBuilder.lte("clust2",QueryBuilder.bindMarker("clust2_Lte")));
        boundValues.add(clust2_Gt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lte, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust2 >= ? AND clust2 < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM Gte_And_Lt(int clust2_Gte, int clust2_Lt) {
        where.and(QueryBuilder.gte("clust2",QueryBuilder.bindMarker("clust2_Lt")));
        where.and(QueryBuilder.lt("clust2",QueryBuilder.bindMarker("clust2_Lt")));
        boundValues.add(clust2_Gte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lt, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust2 >= ? AND clust2 <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM Gte_And_Lte(int clust2_Gte, int clust2_Lte) {
        where.and(QueryBuilder.gte("clust2",QueryBuilder.bindMarker("clust2_Lte")));
        where.and(QueryBuilder.lte("clust2",QueryBuilder.bindMarker("clust2_Lte")));
        boundValues.add(clust2_Gte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lte, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust2  = fromJson(?) </strong> */
      public final EntityWithIndicesForJSON_SelectIndex.E_TM Eq_FromJson(String clust2) {
        where.and(QueryBuilder.eq("clust2", QueryBuilder.fromJson(QueryBuilder.bindMarker("clust2"))));
        boundValues.add(clust2);
        encodedValues.add(clust2);
        return new EntityWithIndicesForJSON_SelectIndex.E_TM(where, cassandraOptions);
      }
    }

    public final class Clust3 {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust3 = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM Eq(String clust3) {
        where.and(QueryBuilder.eq("clust3", QueryBuilder.bindMarker("clust3")));
        boundValues.add(clust3);
        encodedValues.add(meta.clust3.encodeFromJava(clust3, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust3 IN ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM IN(String... clust3) {
        Validator.validateTrue(ArrayUtils.isNotEmpty(clust3), "Varargs for field '%s' should not be null/empty", "clust3");
        where.and(QueryBuilder.in("clust3",QueryBuilder.bindMarker("clust3")));
        final List<Object> varargs = Arrays.<Object>asList((Object[])clust3);
        final List<Object> encodedVarargs = Arrays.<String>stream((String[])clust3).map(x -> meta.clust3.encodeFromJava(x, Optional.of(cassandraOptions))).collect(Collectors.toList());
        boundValues.add(varargs);
        encodedValues.add(encodedVarargs);
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust3 > ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM Gt(String clust3) {
        where.and(QueryBuilder.gt("clust3", QueryBuilder.bindMarker("clust3")));
        boundValues.add(clust3);
        encodedValues.add(meta.clust3.encodeFromJava(clust3, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust3 >= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM Gte(String clust3) {
        where.and(QueryBuilder.gte("clust3", QueryBuilder.bindMarker("clust3")));
        boundValues.add(clust3);
        encodedValues.add(meta.clust3.encodeFromJava(clust3, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust3 < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM Lt(String clust3) {
        where.and(QueryBuilder.lt("clust3", QueryBuilder.bindMarker("clust3")));
        boundValues.add(clust3);
        encodedValues.add(meta.clust3.encodeFromJava(clust3, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust3 <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM Lte(String clust3) {
        where.and(QueryBuilder.lte("clust3", QueryBuilder.bindMarker("clust3")));
        boundValues.add(clust3);
        encodedValues.add(meta.clust3.encodeFromJava(clust3, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust3 > ? AND clust3 < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM Gt_And_Lt(String clust3_Gt, String clust3_Lt) {
        where.and(QueryBuilder.gt("clust3",QueryBuilder.bindMarker("clust3_Lt")));
        where.and(QueryBuilder.lt("clust3",QueryBuilder.bindMarker("clust3_Lt")));
        boundValues.add(clust3_Gt);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust3_Lt);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Lt, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust3 > ? AND clust3 <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM Gt_And_Lte(String clust3_Gt, String clust3_Lte) {
        where.and(QueryBuilder.gt("clust3",QueryBuilder.bindMarker("clust3_Lte")));
        where.and(QueryBuilder.lte("clust3",QueryBuilder.bindMarker("clust3_Lte")));
        boundValues.add(clust3_Gt);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust3_Lte);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Lte, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust3 >= ? AND clust3 < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM Gte_And_Lt(String clust3_Gte, String clust3_Lt) {
        where.and(QueryBuilder.gte("clust3",QueryBuilder.bindMarker("clust3_Lt")));
        where.and(QueryBuilder.lt("clust3",QueryBuilder.bindMarker("clust3_Lt")));
        boundValues.add(clust3_Gte);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust3_Lt);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Lt, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust3 >= ? AND clust3 <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM Gte_And_Lte(String clust3_Gte, String clust3_Lte) {
        where.and(QueryBuilder.gte("clust3",QueryBuilder.bindMarker("clust3_Lte")));
        where.and(QueryBuilder.lte("clust3",QueryBuilder.bindMarker("clust3_Lte")));
        boundValues.add(clust3_Gte);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust3_Lte);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Lte, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust3  = fromJson(?) </strong> */
      public final EntityWithIndicesForJSON_SelectIndex.E_TM Eq_FromJson(String clust3) {
        where.and(QueryBuilder.eq("clust3", QueryBuilder.fromJson(QueryBuilder.bindMarker("clust3"))));
        boundValues.add(clust3);
        encodedValues.add(clust3);
        return new EntityWithIndicesForJSON_SelectIndex.E_TM(where, cassandraOptions);
      }
    }

    public final class CollectionIndex {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>collectionindex CONTAINS ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM Contains(String collectionIndex_element) {
        where.and(QueryBuilder.contains("collectionindex", QueryBuilder.bindMarker("collectionindex")));
        boundValues.add(collectionIndex_element);
        encodedValues.add(meta.collectionIndex.encodeSingleElement(collectionIndex_element, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>collectionindex CONTAINS fromJson(?)</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM Contains_FromJson(String collectionIndex_JSONElement) {
        where.and(QueryBuilder.contains("collectionindex", QueryBuilder.fromJson(QueryBuilder.bindMarker("collectionindex"))));
        boundValues.add(collectionIndex_JSONElement);
        encodedValues.add(collectionIndex_JSONElement);
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }
    }

    public final class FullIndexOnCollection {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>fullindexoncollection = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM Eq(Set<String> fullIndexOnCollection) {
        where.and(QueryBuilder.eq("fullindexoncollection", QueryBuilder.bindMarker("fullindexoncollection")));
        boundValues.add(fullIndexOnCollection);
        encodedValues.add(meta.fullIndexOnCollection.encodeFromJava(fullIndexOnCollection, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>fullindexoncollection  = fromJson(?) </strong> */
      public final EntityWithIndicesForJSON_SelectIndex.E_TM Eq_FromJson(String fullIndexOnCollection) {
        where.and(QueryBuilder.eq("fullindexoncollection", QueryBuilder.fromJson(QueryBuilder.bindMarker("fullindexoncollection"))));
        boundValues.add(fullIndexOnCollection);
        encodedValues.add(fullIndexOnCollection);
        return new EntityWithIndicesForJSON_SelectIndex.E_TM(where, cassandraOptions);
      }
    }

    public final class IndexOnMapEntry {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>indexonmapentry[?] = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM ContainsEntry(Integer indexOnMapEntry_key, String indexOnMapEntry_value) {
        where.and(MapEntryClause.of("indexonmapentry", QueryBuilder.bindMarker("indexOnMapEntry_key"), QueryBuilder.bindMarker("indexOnMapEntry_value")));
        boundValues.add(indexOnMapEntry_key);
        boundValues.add(indexOnMapEntry_value);
        encodedValues.add(meta.indexOnMapEntry.encodeSingleKeyElement(indexOnMapEntry_key, Optional.of(cassandraOptions)));
        encodedValues.add(meta.indexOnMapEntry.encodeSingleValueElement(indexOnMapEntry_value, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>indexonmapentry[fromJson(?)] = fromJson(?)</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM ContainsEntry_FromJSON(String indexOnMapEntry_JSONKey, String indexOnMapEntry_JSONValue) {
        where.and(MapEntryClause.of("indexonmapentry", QueryBuilder.fromJson(QueryBuilder.bindMarker("indexOnMapEntry_JSONKey")), QueryBuilder.fromJson(QueryBuilder.bindMarker("indexOnMapEntry_JSONValue"))));
        boundValues.add(indexOnMapEntry_JSONKey);
        boundValues.add(indexOnMapEntry_JSONValue);
        encodedValues.add(indexOnMapEntry_JSONKey);
        encodedValues.add(indexOnMapEntry_JSONValue);
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }
    }

    public final class IndexOnMapKey {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>indexonmapkey CONTAINS KEY ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM ContainsKey(String indexOnMapKey_key) {
        where.and(QueryBuilder.containsKey("indexonmapkey", QueryBuilder.bindMarker("indexonmapkey")));
        boundValues.add(indexOnMapKey_key);
        encodedValues.add(meta.indexOnMapKey.encodeSingleKeyElement(indexOnMapKey_key, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>indexonmapkey CONTAINS KEY fromJson(?)</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM ContainsKey_FromJSON(String indexOnMapKey_JSONKey) {
        where.and(QueryBuilder.containsKey("indexonmapkey", QueryBuilder.fromJson(QueryBuilder.bindMarker("indexonmapkey"))));
        boundValues.add(indexOnMapKey_JSONKey);
        encodedValues.add(indexOnMapKey_JSONKey);
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }
    }

    public final class IndexOnMapValue {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>indexonmapvalue CONTAINS ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM ContainsValue(String indexOnMapValue_value) {
        where.and(QueryBuilder.contains("indexonmapvalue", QueryBuilder.bindMarker("indexonmapvalue")));
        boundValues.add(indexOnMapValue_value);
        encodedValues.add(meta.indexOnMapValue.encodeSingleValueElement(indexOnMapValue_value, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>indexonmapvalue CONTAINS fromJson(?)</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM ContainsValue_FromJSON(String indexOnMapValue_JSONValue) {
        where.and(QueryBuilder.contains("indexonmapvalue", QueryBuilder.fromJson(QueryBuilder.bindMarker("indexonmapvalue"))));
        boundValues.add(indexOnMapValue_JSONValue);
        encodedValues.add(indexOnMapValue_JSONValue);
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }
    }

    public final class SimpleIndex {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>simpleindex = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM Eq(String simpleIndex) {
        where.and(QueryBuilder.eq("simpleindex", QueryBuilder.bindMarker("simpleindex")));
        boundValues.add(simpleIndex);
        encodedValues.add(meta.simpleIndex.encodeFromJava(simpleIndex, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>simpleindex  = fromJson(?) </strong> */
      public final EntityWithIndicesForJSON_SelectIndex.E_TM Eq_FromJson(String simpleIndex) {
        where.and(QueryBuilder.eq("simpleindex", QueryBuilder.fromJson(QueryBuilder.bindMarker("simpleindex"))));
        boundValues.add(simpleIndex);
        encodedValues.add(simpleIndex);
        return new EntityWithIndicesForJSON_SelectIndex.E_TM(where, cassandraOptions);
      }
    }

    public final class clust1_clust2 {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2) > ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM Gt(final int clust1, final int clust2) {
        where.and(QueryBuilder.gt(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        final TupleType tupleType = rte.tupleTypeFactory.typeFor();
        boundValues.add(clust1);
        encodedValues.add(meta.clust1.encodeFromJava(clust1, Optional.of(cassandraOptions)));
        boundValues.add(clust2);
        encodedValues.add(meta.clust2.encodeFromJava(clust2, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2) >= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM Gte(final int clust1, final int clust2) {
        where.and(QueryBuilder.gte(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        final TupleType tupleType = rte.tupleTypeFactory.typeFor();
        boundValues.add(clust1);
        encodedValues.add(meta.clust1.encodeFromJava(clust1, Optional.of(cassandraOptions)));
        boundValues.add(clust2);
        encodedValues.add(meta.clust2.encodeFromJava(clust2, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2) < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM Lt(final int clust1, final int clust2) {
        where.and(QueryBuilder.lt(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        final TupleType tupleType = rte.tupleTypeFactory.typeFor();
        boundValues.add(clust1);
        encodedValues.add(meta.clust1.encodeFromJava(clust1, Optional.of(cassandraOptions)));
        boundValues.add(clust2);
        encodedValues.add(meta.clust2.encodeFromJava(clust2, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2) <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM Lte(final int clust1, final int clust2) {
        where.and(QueryBuilder.lte(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        final TupleType tupleType = rte.tupleTypeFactory.typeFor();
        boundValues.add(clust1);
        encodedValues.add(meta.clust1.encodeFromJava(clust1, Optional.of(cassandraOptions)));
        boundValues.add(clust2);
        encodedValues.add(meta.clust2.encodeFromJava(clust2, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2) > ? AND (clust1,clust2) < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM Gt_And_Lt(final int clust1_Gt, final int clust2_Gt, final int clust1_Lt, final int clust2_Lt) {
        where.and(QueryBuilder.gt(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lt(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Gt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lt, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lt, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2) > ? AND (clust1,clust2) <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM Gt_And_Lte(final int clust1_Gt, final int clust2_Gt, final int clust1_Lte, final int clust2_Lte) {
        where.and(QueryBuilder.gt(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lte(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Gt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lte, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lte, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2) >= ? AND (clust1,clust2) < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM Gte_And_Lt(final int clust1_Gte, final int clust2_Gte, final int clust1_Lt, final int clust2_Lt) {
        where.and(QueryBuilder.gte(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lt(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Gte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lt, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lt, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2) >= ? AND (clust1,clust2) <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM Gte_And_Lte(final int clust1_Gte, final int clust2_Gte, final int clust1_Lte, final int clust2_Lte) {
        where.and(QueryBuilder.gte(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lte(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Gte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lte, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lte, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2) > ? AND (clust1) < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM clust1_And_clust2_Gt_And_clust1_Lt(final int clust1_Gt, final int clust2_Gt, final int clust1_Lt) {
        where.and(QueryBuilder.gt(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lt(Arrays.asList("clust1"), Arrays.asList("clust1").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Gt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lt, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2) > ? AND (clust1) <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM clust1_And_clust2_Gt_And_clust1_Lte(final int clust1_Gt, final int clust2_Gt, final int clust1_Lte) {
        where.and(QueryBuilder.gt(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lte(Arrays.asList("clust1"), Arrays.asList("clust1").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Gt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lte, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2) >= ? AND (clust1) < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM clust1_And_clust2_Gte_And_clust1_Lt(final int clust1_Gte, final int clust2_Gte, final int clust1_Lt) {
        where.and(QueryBuilder.gte(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lt(Arrays.asList("clust1"), Arrays.asList("clust1").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Gte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lt, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2) >= ? AND (clust1) <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM clust1_And_clust2_Gte_And_clust1_Lte(final int clust1_Gte, final int clust2_Gte, final int clust1_Lte) {
        where.and(QueryBuilder.gte(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lte(Arrays.asList("clust1"), Arrays.asList("clust1").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Gte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lte, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1) > ? AND (clust1,clust2) < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM clust1_Gt_And_clust1_And_clust2_Lt(final int clust1_Gt, final int clust1_Lt, final int clust2_Lt) {
        where.and(QueryBuilder.gt(Arrays.asList("clust1"), Arrays.asList("clust1").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lt(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lt, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lt, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1) > ? AND (clust1,clust2) <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM clust1_Gt_And_clust1_And_clust2_Lte(final int clust1_Gt, final int clust1_Lte, final int clust2_Lte) {
        where.and(QueryBuilder.gt(Arrays.asList("clust1"), Arrays.asList("clust1").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lte(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lte, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lte, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1) >= ? AND (clust1,clust2) < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM clust1_Gte_And_clust1_And_clust2_Lt(final int clust1_Gte, final int clust1_Lt, final int clust2_Lt) {
        where.and(QueryBuilder.gte(Arrays.asList("clust1"), Arrays.asList("clust1").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lt(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lt, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lt, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1) >= ? AND (clust1,clust2) <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM clust1_Gte_And_clust1_And_clust2_Lte(final int clust1_Gte, final int clust1_Lte, final int clust2_Lte) {
        where.and(QueryBuilder.gte(Arrays.asList("clust1"), Arrays.asList("clust1").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lte(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lte, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lte, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }
    }

    public final class clust1_clust2_clust3 {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2,clust3) > ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM Gt(final int clust1, final int clust2, final String clust3) {
        where.and(QueryBuilder.gt(Arrays.asList("clust1","clust2","clust3"), Arrays.asList("clust1","clust2","clust3").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        final TupleType tupleType = rte.tupleTypeFactory.typeFor();
        boundValues.add(clust1);
        encodedValues.add(meta.clust1.encodeFromJava(clust1, Optional.of(cassandraOptions)));
        boundValues.add(clust2);
        encodedValues.add(meta.clust2.encodeFromJava(clust2, Optional.of(cassandraOptions)));
        boundValues.add(clust3);
        encodedValues.add(meta.clust3.encodeFromJava(clust3, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2,clust3) >= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM Gte(final int clust1, final int clust2, final String clust3) {
        where.and(QueryBuilder.gte(Arrays.asList("clust1","clust2","clust3"), Arrays.asList("clust1","clust2","clust3").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        final TupleType tupleType = rte.tupleTypeFactory.typeFor();
        boundValues.add(clust1);
        encodedValues.add(meta.clust1.encodeFromJava(clust1, Optional.of(cassandraOptions)));
        boundValues.add(clust2);
        encodedValues.add(meta.clust2.encodeFromJava(clust2, Optional.of(cassandraOptions)));
        boundValues.add(clust3);
        encodedValues.add(meta.clust3.encodeFromJava(clust3, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2,clust3) < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM Lt(final int clust1, final int clust2, final String clust3) {
        where.and(QueryBuilder.lt(Arrays.asList("clust1","clust2","clust3"), Arrays.asList("clust1","clust2","clust3").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        final TupleType tupleType = rte.tupleTypeFactory.typeFor();
        boundValues.add(clust1);
        encodedValues.add(meta.clust1.encodeFromJava(clust1, Optional.of(cassandraOptions)));
        boundValues.add(clust2);
        encodedValues.add(meta.clust2.encodeFromJava(clust2, Optional.of(cassandraOptions)));
        boundValues.add(clust3);
        encodedValues.add(meta.clust3.encodeFromJava(clust3, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2,clust3) <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM Lte(final int clust1, final int clust2, final String clust3) {
        where.and(QueryBuilder.lte(Arrays.asList("clust1","clust2","clust3"), Arrays.asList("clust1","clust2","clust3").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        final TupleType tupleType = rte.tupleTypeFactory.typeFor();
        boundValues.add(clust1);
        encodedValues.add(meta.clust1.encodeFromJava(clust1, Optional.of(cassandraOptions)));
        boundValues.add(clust2);
        encodedValues.add(meta.clust2.encodeFromJava(clust2, Optional.of(cassandraOptions)));
        boundValues.add(clust3);
        encodedValues.add(meta.clust3.encodeFromJava(clust3, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2,clust3) > ? AND (clust1,clust2,clust3) < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM Gt_And_Lt(final int clust1_Gt, final int clust2_Gt, final String clust3_Gt, final int clust1_Lt, final int clust2_Lt, final String clust3_Lt) {
        where.and(QueryBuilder.gt(Arrays.asList("clust1","clust2","clust3"), Arrays.asList("clust1","clust2","clust3").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lt(Arrays.asList("clust1","clust2","clust3"), Arrays.asList("clust1","clust2","clust3").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Gt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust3_Gt);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lt, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lt, Optional.of(cassandraOptions)));
        boundValues.add(clust3_Lt);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Lt, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2,clust3) > ? AND (clust1,clust2,clust3) <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM Gt_And_Lte(final int clust1_Gt, final int clust2_Gt, final String clust3_Gt, final int clust1_Lte, final int clust2_Lte, final String clust3_Lte) {
        where.and(QueryBuilder.gt(Arrays.asList("clust1","clust2","clust3"), Arrays.asList("clust1","clust2","clust3").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lte(Arrays.asList("clust1","clust2","clust3"), Arrays.asList("clust1","clust2","clust3").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Gt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust3_Gt);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lte, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lte, Optional.of(cassandraOptions)));
        boundValues.add(clust3_Lte);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Lte, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2,clust3) >= ? AND (clust1,clust2,clust3) < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM Gte_And_Lt(final int clust1_Gte, final int clust2_Gte, final String clust3_Gte, final int clust1_Lt, final int clust2_Lt, final String clust3_Lt) {
        where.and(QueryBuilder.gte(Arrays.asList("clust1","clust2","clust3"), Arrays.asList("clust1","clust2","clust3").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lt(Arrays.asList("clust1","clust2","clust3"), Arrays.asList("clust1","clust2","clust3").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Gte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust3_Gte);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lt, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lt, Optional.of(cassandraOptions)));
        boundValues.add(clust3_Lt);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Lt, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2,clust3) >= ? AND (clust1,clust2,clust3) <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM Gte_And_Lte(final int clust1_Gte, final int clust2_Gte, final String clust3_Gte, final int clust1_Lte, final int clust2_Lte, final String clust3_Lte) {
        where.and(QueryBuilder.gte(Arrays.asList("clust1","clust2","clust3"), Arrays.asList("clust1","clust2","clust3").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lte(Arrays.asList("clust1","clust2","clust3"), Arrays.asList("clust1","clust2","clust3").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Gte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust3_Gte);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lte, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lte, Optional.of(cassandraOptions)));
        boundValues.add(clust3_Lte);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Lte, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2,clust3) > ? AND (clust1,clust2) < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM clust1_And_clust2_And_clust3_Gt_And_clust1_And_clust2_Lt(final int clust1_Gt, final int clust2_Gt, final String clust3_Gt, final int clust1_Lt, final int clust2_Lt) {
        where.and(QueryBuilder.gt(Arrays.asList("clust1","clust2","clust3"), Arrays.asList("clust1","clust2","clust3").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lt(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Gt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust3_Gt);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lt, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lt, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2,clust3) > ? AND (clust1,clust2) <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM clust1_And_clust2_And_clust3_Gt_And_clust1_And_clust2_Lte(final int clust1_Gt, final int clust2_Gt, final String clust3_Gt, final int clust1_Lte, final int clust2_Lte) {
        where.and(QueryBuilder.gt(Arrays.asList("clust1","clust2","clust3"), Arrays.asList("clust1","clust2","clust3").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lte(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Gt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust3_Gt);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lte, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lte, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2,clust3) >= ? AND (clust1,clust2) < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM clust1_And_clust2_And_clust3_Gte_And_clust1_And_clust2_Lt(final int clust1_Gte, final int clust2_Gte, final String clust3_Gte, final int clust1_Lt, final int clust2_Lt) {
        where.and(QueryBuilder.gte(Arrays.asList("clust1","clust2","clust3"), Arrays.asList("clust1","clust2","clust3").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lt(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Gte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust3_Gte);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lt, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lt, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2,clust3) >= ? AND (clust1,clust2) <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM clust1_And_clust2_And_clust3_Gte_And_clust1_And_clust2_Lte(final int clust1_Gte, final int clust2_Gte, final String clust3_Gte, final int clust1_Lte, final int clust2_Lte) {
        where.and(QueryBuilder.gte(Arrays.asList("clust1","clust2","clust3"), Arrays.asList("clust1","clust2","clust3").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lte(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Gte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust3_Gte);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lte, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lte, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2) > ? AND (clust1,clust2,clust3) < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM clust1_And_clust2_Gt_And_clust1_And_clust2_And_clust3_Lt(final int clust1_Gt, final int clust2_Gt, final int clust1_Lt, final int clust2_Lt, final String clust3_Lt) {
        where.and(QueryBuilder.gt(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lt(Arrays.asList("clust1","clust2","clust3"), Arrays.asList("clust1","clust2","clust3").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Gt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lt, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lt, Optional.of(cassandraOptions)));
        boundValues.add(clust3_Lt);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Lt, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2) > ? AND (clust1,clust2,clust3) <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM clust1_And_clust2_Gt_And_clust1_And_clust2_And_clust3_Lte(final int clust1_Gt, final int clust2_Gt, final int clust1_Lte, final int clust2_Lte, final String clust3_Lte) {
        where.and(QueryBuilder.gt(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lte(Arrays.asList("clust1","clust2","clust3"), Arrays.asList("clust1","clust2","clust3").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Gt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lte, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lte, Optional.of(cassandraOptions)));
        boundValues.add(clust3_Lte);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Lte, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2) >= ? AND (clust1,clust2,clust3) < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM clust1_And_clust2_Gte_And_clust1_And_clust2_And_clust3_Lt(final int clust1_Gte, final int clust2_Gte, final int clust1_Lt, final int clust2_Lt, final String clust3_Lt) {
        where.and(QueryBuilder.gte(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lt(Arrays.asList("clust1","clust2","clust3"), Arrays.asList("clust1","clust2","clust3").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Gte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lt, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lt, Optional.of(cassandraOptions)));
        boundValues.add(clust3_Lt);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Lt, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2) >= ? AND (clust1,clust2,clust3) <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_TM clust1_And_clust2_Gte_And_clust1_And_clust2_And_clust3_Lte(final int clust1_Gte, final int clust2_Gte, final int clust1_Lte, final int clust2_Lte, final String clust3_Lte) {
        where.and(QueryBuilder.gte(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lte(Arrays.asList("clust1","clust2","clust3"), Arrays.asList("clust1","clust2","clust3").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Gte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lte, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lte, Optional.of(cassandraOptions)));
        boundValues.add(clust3_Lte);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Lte, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_TM.this;
      }
    }
  }

  public final class W_J extends AbstractSelectWherePartitionJSON {
    public W_J(Select.Where where, CassandraOptions cassandraOptions) {
      super(where, cassandraOptions);
    }

    public final EntityWithIndicesForJSON_SelectIndex.W_J.CollectionIndex collectionIndex() {
      return new EntityWithIndicesForJSON_SelectIndex.W_J.CollectionIndex();
    }

    public final EntityWithIndicesForJSON_SelectIndex.W_J.FullIndexOnCollection fullIndexOnCollection() {
      return new EntityWithIndicesForJSON_SelectIndex.W_J.FullIndexOnCollection();
    }

    public final EntityWithIndicesForJSON_SelectIndex.W_J.IndexOnMapEntry indexOnMapEntry() {
      return new EntityWithIndicesForJSON_SelectIndex.W_J.IndexOnMapEntry();
    }

    public final EntityWithIndicesForJSON_SelectIndex.W_J.IndexOnMapKey indexOnMapKey() {
      return new EntityWithIndicesForJSON_SelectIndex.W_J.IndexOnMapKey();
    }

    public final EntityWithIndicesForJSON_SelectIndex.W_J.IndexOnMapValue indexOnMapValue() {
      return new EntityWithIndicesForJSON_SelectIndex.W_J.IndexOnMapValue();
    }

    public final EntityWithIndicesForJSON_SelectIndex.W_J.SimpleIndex simpleIndex() {
      return new EntityWithIndicesForJSON_SelectIndex.W_J.SimpleIndex();
    }

    public final class CollectionIndex {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>collectionindex CONTAINS ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J Contains(String collectionIndex_element) {
        where.and(QueryBuilder.contains("collectionindex", QueryBuilder.bindMarker("collectionindex")));
        boundValues.add(collectionIndex_element);
        encodedValues.add(meta.collectionIndex.encodeSingleElement(collectionIndex_element, Optional.of(cassandraOptions)));
        return new EntityWithIndicesForJSON_SelectIndex.E_J(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>collectionindex CONTAINS fromJson(?)</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J Contains_FromJson(String collectionIndex_JSONElement) {
        where.and(QueryBuilder.contains("collectionindex", QueryBuilder.fromJson(QueryBuilder.bindMarker("collectionindex"))));
        boundValues.add(collectionIndex_JSONElement);
        encodedValues.add(collectionIndex_JSONElement);
        return new EntityWithIndicesForJSON_SelectIndex.E_J(where, cassandraOptions);
      }
    }

    public final class FullIndexOnCollection {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>fullindexoncollection = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J Eq(Set<String> fullIndexOnCollection) {
        where.and(QueryBuilder.eq("fullindexoncollection", QueryBuilder.bindMarker("fullindexoncollection")));
        boundValues.add(fullIndexOnCollection);
        encodedValues.add(meta.fullIndexOnCollection.encodeFromJava(fullIndexOnCollection, Optional.of(cassandraOptions)));
        return new EntityWithIndicesForJSON_SelectIndex.E_J(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>fullindexoncollection  = fromJson(?) </strong> */
      public final EntityWithIndicesForJSON_SelectIndex.E_J Eq_FromJson(String fullIndexOnCollection) {
        where.and(QueryBuilder.eq("fullindexoncollection", QueryBuilder.fromJson(QueryBuilder.bindMarker("fullindexoncollection"))));
        boundValues.add(fullIndexOnCollection);
        encodedValues.add(fullIndexOnCollection);
        return new EntityWithIndicesForJSON_SelectIndex.E_J(where, cassandraOptions);
      }
    }

    public final class IndexOnMapEntry {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>indexonmapentry[?] = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J ContainsEntry(Integer indexOnMapEntry_key, String indexOnMapEntry_value) {
        where.and(MapEntryClause.of("indexonmapentry", QueryBuilder.bindMarker("indexOnMapEntry_key"), QueryBuilder.bindMarker("indexOnMapEntry_value")));
        boundValues.add(indexOnMapEntry_key);
        boundValues.add(indexOnMapEntry_value);
        encodedValues.add(meta.indexOnMapEntry.encodeSingleKeyElement(indexOnMapEntry_key, Optional.of(cassandraOptions)));
        encodedValues.add(meta.indexOnMapEntry.encodeSingleValueElement(indexOnMapEntry_value, Optional.of(cassandraOptions)));
        return new EntityWithIndicesForJSON_SelectIndex.E_J(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>indexonmapentry[fromJson(?)] = fromJson(?)</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J ContainsEntry_FromJSON(String indexOnMapEntry_JSONKey, String indexOnMapEntry_JSONValue) {
        where.and(MapEntryClause.of("indexonmapentry", QueryBuilder.fromJson(QueryBuilder.bindMarker("indexOnMapEntry_JSONKey")), QueryBuilder.fromJson(QueryBuilder.bindMarker("indexOnMapEntry_JSONValue"))));
        boundValues.add(indexOnMapEntry_JSONKey);
        boundValues.add(indexOnMapEntry_JSONValue);
        encodedValues.add(indexOnMapEntry_JSONKey);
        encodedValues.add(indexOnMapEntry_JSONValue);
        return new EntityWithIndicesForJSON_SelectIndex.E_J(where, cassandraOptions);
      }
    }

    public final class IndexOnMapKey {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>indexonmapkey CONTAINS KEY ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J ContainsKey(String indexOnMapKey_key) {
        where.and(QueryBuilder.containsKey("indexonmapkey", QueryBuilder.bindMarker("indexonmapkey")));
        boundValues.add(indexOnMapKey_key);
        encodedValues.add(meta.indexOnMapKey.encodeSingleKeyElement(indexOnMapKey_key, Optional.of(cassandraOptions)));
        return new EntityWithIndicesForJSON_SelectIndex.E_J(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>indexonmapkey CONTAINS KEY fromJson(?)</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J ContainsKey_FromJSON(String indexOnMapKey_JSONKey) {
        where.and(QueryBuilder.containsKey("indexonmapkey", QueryBuilder.fromJson(QueryBuilder.bindMarker("indexonmapkey"))));
        boundValues.add(indexOnMapKey_JSONKey);
        encodedValues.add(indexOnMapKey_JSONKey);
        return new EntityWithIndicesForJSON_SelectIndex.E_J(where, cassandraOptions);
      }
    }

    public final class IndexOnMapValue {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>indexonmapvalue CONTAINS ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J ContainsValue(String indexOnMapValue_value) {
        where.and(QueryBuilder.contains("indexonmapvalue", QueryBuilder.bindMarker("indexonmapvalue")));
        boundValues.add(indexOnMapValue_value);
        encodedValues.add(meta.indexOnMapValue.encodeSingleValueElement(indexOnMapValue_value, Optional.of(cassandraOptions)));
        return new EntityWithIndicesForJSON_SelectIndex.E_J(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>indexonmapvalue CONTAINS fromJson(?)</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J ContainsValue_FromJSON(String indexOnMapValue_JSONValue) {
        where.and(QueryBuilder.contains("indexonmapvalue", QueryBuilder.fromJson(QueryBuilder.bindMarker("indexonmapvalue"))));
        boundValues.add(indexOnMapValue_JSONValue);
        encodedValues.add(indexOnMapValue_JSONValue);
        return new EntityWithIndicesForJSON_SelectIndex.E_J(where, cassandraOptions);
      }
    }

    public final class SimpleIndex {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>simpleindex = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J Eq(String simpleIndex) {
        where.and(QueryBuilder.eq("simpleindex", QueryBuilder.bindMarker("simpleindex")));
        boundValues.add(simpleIndex);
        encodedValues.add(meta.simpleIndex.encodeFromJava(simpleIndex, Optional.of(cassandraOptions)));
        return new EntityWithIndicesForJSON_SelectIndex.E_J(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>simpleindex  = fromJson(?) </strong> */
      public final EntityWithIndicesForJSON_SelectIndex.E_J Eq_FromJson(String simpleIndex) {
        where.and(QueryBuilder.eq("simpleindex", QueryBuilder.fromJson(QueryBuilder.bindMarker("simpleindex"))));
        boundValues.add(simpleIndex);
        encodedValues.add(simpleIndex);
        return new EntityWithIndicesForJSON_SelectIndex.E_J(where, cassandraOptions);
      }
    }
  }

  public final class E_J extends AbstractIndexSelectWhereJSON<EntityWithIndicesForJSON_SelectIndex.E_J, EntityWithIndicesForJSON> {
    public E_J(Select.Where where, CassandraOptions cassandraOptions) {
      super(where, cassandraOptions);
    }

    @Override
    protected final Class<EntityWithIndicesForJSON> getEntityClass() {
      return entityClass;
    }

    @Override
    protected final AbstractEntityProperty<EntityWithIndicesForJSON> getMetaInternal() {
      return meta;
    }

    @Override
    protected final RuntimeEngine getRte() {
      return rte;
    }

    @Override
    protected final CassandraOptions getOptions() {
      return cassandraOptions;
    }

    @Override
    protected final List<Object> getBoundValuesInternal() {
      return boundValues;
    }

    @Override
    protected final List<Object> getEncodedValuesInternal() {
      return encodedValues;
    }

    /**
     * Generate a SELECT ... FROM ... WHERE ... <strong>LIMIT :limit</strong> */
    public final EntityWithIndicesForJSON_SelectIndex.E_J limit(final Integer limit) {
      where.limit(QueryBuilder.bindMarker("lim"));
      boundValues.add(limit);
      encodedValues.add(limit);
      return this;
    }

    @Override
    protected final EntityWithIndicesForJSON_SelectIndex.E_J getThis() {
      return this;
    }

    public final EntityWithIndicesForJSON_SelectIndex.E_J.Id id() {
      return new EntityWithIndicesForJSON_SelectIndex.E_J.Id();
    }

    public final EntityWithIndicesForJSON_SelectIndex.E_J.Clust1 clust1() {
      return new EntityWithIndicesForJSON_SelectIndex.E_J.Clust1();
    }

    public final EntityWithIndicesForJSON_SelectIndex.E_J.Clust2 clust2() {
      return new EntityWithIndicesForJSON_SelectIndex.E_J.Clust2();
    }

    public final EntityWithIndicesForJSON_SelectIndex.E_J.Clust3 clust3() {
      return new EntityWithIndicesForJSON_SelectIndex.E_J.Clust3();
    }

    public final EntityWithIndicesForJSON_SelectIndex.E_J.CollectionIndex collectionIndex() {
      return new EntityWithIndicesForJSON_SelectIndex.E_J.CollectionIndex();
    }

    public final EntityWithIndicesForJSON_SelectIndex.E_J.FullIndexOnCollection fullIndexOnCollection() {
      return new EntityWithIndicesForJSON_SelectIndex.E_J.FullIndexOnCollection();
    }

    public final EntityWithIndicesForJSON_SelectIndex.E_J.IndexOnMapEntry indexOnMapEntry() {
      return new EntityWithIndicesForJSON_SelectIndex.E_J.IndexOnMapEntry();
    }

    public final EntityWithIndicesForJSON_SelectIndex.E_J.IndexOnMapKey indexOnMapKey() {
      return new EntityWithIndicesForJSON_SelectIndex.E_J.IndexOnMapKey();
    }

    public final EntityWithIndicesForJSON_SelectIndex.E_J.IndexOnMapValue indexOnMapValue() {
      return new EntityWithIndicesForJSON_SelectIndex.E_J.IndexOnMapValue();
    }

    public final EntityWithIndicesForJSON_SelectIndex.E_J.SimpleIndex simpleIndex() {
      return new EntityWithIndicesForJSON_SelectIndex.E_J.SimpleIndex();
    }

    public final EntityWithIndicesForJSON_SelectIndex.E_J.clust1_clust2 clust1_clust2() {
      return new EntityWithIndicesForJSON_SelectIndex.E_J.clust1_clust2();
    }

    public final EntityWithIndicesForJSON_SelectIndex.E_J.clust1_clust2_clust3 clust1_clust2_clust3() {
      return new EntityWithIndicesForJSON_SelectIndex.E_J.clust1_clust2_clust3();
    }

    /**
     * Generate a SELECT ... FROM ... WHERE ... <strong>ORDER BY clust1 ASC</strong> */
    public final EntityWithIndicesForJSON_SelectIndex.E_J orderByClust1Ascending() {
      where.orderBy(QueryBuilder.asc("clust1"));
      return this;
    }

    /**
     * Generate a SELECT ... FROM ... WHERE ... <strong>ORDER BY clust1 DESC</strong> */
    public final EntityWithIndicesForJSON_SelectIndex.E_J orderByClust1Descending() {
      where.orderBy(QueryBuilder.desc("clust1"));
      return this;
    }

    public final class Id {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>id = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J Eq(Long id) {
        where.and(QueryBuilder.eq("id", QueryBuilder.bindMarker("id")));
        boundValues.add(id);
        encodedValues.add(meta.id.encodeFromJava(id, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>id IN ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J IN(Long... id) {
        Validator.validateTrue(ArrayUtils.isNotEmpty(id), "Varargs for field '%s' should not be null/empty", "id");
        where.and(QueryBuilder.in("id",QueryBuilder.bindMarker("id")));
        final List<Object> varargs = Arrays.<Object>asList((Object[])id);
        final List<Object> encodedVarargs = Arrays.<Long>stream((Long[])id).map(x -> meta.id.encodeFromJava(x, Optional.of(cassandraOptions))).collect(Collectors.toList());
        boundValues.add(varargs);
        encodedValues.add(encodedVarargs);
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>id  = fromJson(?) </strong> */
      public final EntityWithIndicesForJSON_SelectIndex.E_J Eq_FromJson(String id) {
        where.and(QueryBuilder.eq("id", QueryBuilder.fromJson(QueryBuilder.bindMarker("id"))));
        boundValues.add(id);
        encodedValues.add(id);
        return new EntityWithIndicesForJSON_SelectIndex.E_J(where, cassandraOptions);
      }
    }

    public final class Clust1 {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust1 = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J Eq(int clust1) {
        where.and(QueryBuilder.eq("clust1", QueryBuilder.bindMarker("clust1")));
        boundValues.add(clust1);
        encodedValues.add(meta.clust1.encodeFromJava(clust1, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust1 IN ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J IN(int... clust1) {
        Validator.validateTrue(ArrayUtils.isNotEmpty(clust1), "Varargs for field '%s' should not be null/empty", "clust1");
        where.and(QueryBuilder.in("clust1",QueryBuilder.bindMarker("clust1")));
        final List<Object> varargs = Arrays.<Object>asList((int[])clust1);
        final List<Object> encodedVarargs = new ArrayList<>(clust1.length);;
        for(int clust1_element : clust1) {
          encodedVarargs.add(meta.clust1.encodeFromJava(clust1_element, Optional.of(cassandraOptions)));
        }
        boundValues.add(varargs);
        encodedValues.add(encodedVarargs);
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust1 > ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J Gt(int clust1) {
        where.and(QueryBuilder.gt("clust1", QueryBuilder.bindMarker("clust1")));
        boundValues.add(clust1);
        encodedValues.add(meta.clust1.encodeFromJava(clust1, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust1 >= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J Gte(int clust1) {
        where.and(QueryBuilder.gte("clust1", QueryBuilder.bindMarker("clust1")));
        boundValues.add(clust1);
        encodedValues.add(meta.clust1.encodeFromJava(clust1, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust1 < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J Lt(int clust1) {
        where.and(QueryBuilder.lt("clust1", QueryBuilder.bindMarker("clust1")));
        boundValues.add(clust1);
        encodedValues.add(meta.clust1.encodeFromJava(clust1, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust1 <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J Lte(int clust1) {
        where.and(QueryBuilder.lte("clust1", QueryBuilder.bindMarker("clust1")));
        boundValues.add(clust1);
        encodedValues.add(meta.clust1.encodeFromJava(clust1, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust1 > ? AND clust1 < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J Gt_And_Lt(int clust1_Gt, int clust1_Lt) {
        where.and(QueryBuilder.gt("clust1",QueryBuilder.bindMarker("clust1_Lt")));
        where.and(QueryBuilder.lt("clust1",QueryBuilder.bindMarker("clust1_Lt")));
        boundValues.add(clust1_Gt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lt, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust1 > ? AND clust1 <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J Gt_And_Lte(int clust1_Gt, int clust1_Lte) {
        where.and(QueryBuilder.gt("clust1",QueryBuilder.bindMarker("clust1_Lte")));
        where.and(QueryBuilder.lte("clust1",QueryBuilder.bindMarker("clust1_Lte")));
        boundValues.add(clust1_Gt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lte, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust1 >= ? AND clust1 < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J Gte_And_Lt(int clust1_Gte, int clust1_Lt) {
        where.and(QueryBuilder.gte("clust1",QueryBuilder.bindMarker("clust1_Lt")));
        where.and(QueryBuilder.lt("clust1",QueryBuilder.bindMarker("clust1_Lt")));
        boundValues.add(clust1_Gte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lt, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust1 >= ? AND clust1 <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J Gte_And_Lte(int clust1_Gte, int clust1_Lte) {
        where.and(QueryBuilder.gte("clust1",QueryBuilder.bindMarker("clust1_Lte")));
        where.and(QueryBuilder.lte("clust1",QueryBuilder.bindMarker("clust1_Lte")));
        boundValues.add(clust1_Gte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lte, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust1  = fromJson(?) </strong> */
      public final EntityWithIndicesForJSON_SelectIndex.E_J Eq_FromJson(String clust1) {
        where.and(QueryBuilder.eq("clust1", QueryBuilder.fromJson(QueryBuilder.bindMarker("clust1"))));
        boundValues.add(clust1);
        encodedValues.add(clust1);
        return new EntityWithIndicesForJSON_SelectIndex.E_J(where, cassandraOptions);
      }
    }

    public final class Clust2 {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust2 = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J Eq(int clust2) {
        where.and(QueryBuilder.eq("clust2", QueryBuilder.bindMarker("clust2")));
        boundValues.add(clust2);
        encodedValues.add(meta.clust2.encodeFromJava(clust2, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust2 IN ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J IN(int... clust2) {
        Validator.validateTrue(ArrayUtils.isNotEmpty(clust2), "Varargs for field '%s' should not be null/empty", "clust2");
        where.and(QueryBuilder.in("clust2",QueryBuilder.bindMarker("clust2")));
        final List<Object> varargs = Arrays.<Object>asList((int[])clust2);
        final List<Object> encodedVarargs = new ArrayList<>(clust2.length);;
        for(int clust2_element : clust2) {
          encodedVarargs.add(meta.clust2.encodeFromJava(clust2_element, Optional.of(cassandraOptions)));
        }
        boundValues.add(varargs);
        encodedValues.add(encodedVarargs);
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust2 > ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J Gt(int clust2) {
        where.and(QueryBuilder.gt("clust2", QueryBuilder.bindMarker("clust2")));
        boundValues.add(clust2);
        encodedValues.add(meta.clust2.encodeFromJava(clust2, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust2 >= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J Gte(int clust2) {
        where.and(QueryBuilder.gte("clust2", QueryBuilder.bindMarker("clust2")));
        boundValues.add(clust2);
        encodedValues.add(meta.clust2.encodeFromJava(clust2, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust2 < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J Lt(int clust2) {
        where.and(QueryBuilder.lt("clust2", QueryBuilder.bindMarker("clust2")));
        boundValues.add(clust2);
        encodedValues.add(meta.clust2.encodeFromJava(clust2, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust2 <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J Lte(int clust2) {
        where.and(QueryBuilder.lte("clust2", QueryBuilder.bindMarker("clust2")));
        boundValues.add(clust2);
        encodedValues.add(meta.clust2.encodeFromJava(clust2, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust2 > ? AND clust2 < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J Gt_And_Lt(int clust2_Gt, int clust2_Lt) {
        where.and(QueryBuilder.gt("clust2",QueryBuilder.bindMarker("clust2_Lt")));
        where.and(QueryBuilder.lt("clust2",QueryBuilder.bindMarker("clust2_Lt")));
        boundValues.add(clust2_Gt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lt, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust2 > ? AND clust2 <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J Gt_And_Lte(int clust2_Gt, int clust2_Lte) {
        where.and(QueryBuilder.gt("clust2",QueryBuilder.bindMarker("clust2_Lte")));
        where.and(QueryBuilder.lte("clust2",QueryBuilder.bindMarker("clust2_Lte")));
        boundValues.add(clust2_Gt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lte, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust2 >= ? AND clust2 < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J Gte_And_Lt(int clust2_Gte, int clust2_Lt) {
        where.and(QueryBuilder.gte("clust2",QueryBuilder.bindMarker("clust2_Lt")));
        where.and(QueryBuilder.lt("clust2",QueryBuilder.bindMarker("clust2_Lt")));
        boundValues.add(clust2_Gte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lt, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust2 >= ? AND clust2 <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J Gte_And_Lte(int clust2_Gte, int clust2_Lte) {
        where.and(QueryBuilder.gte("clust2",QueryBuilder.bindMarker("clust2_Lte")));
        where.and(QueryBuilder.lte("clust2",QueryBuilder.bindMarker("clust2_Lte")));
        boundValues.add(clust2_Gte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lte, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust2  = fromJson(?) </strong> */
      public final EntityWithIndicesForJSON_SelectIndex.E_J Eq_FromJson(String clust2) {
        where.and(QueryBuilder.eq("clust2", QueryBuilder.fromJson(QueryBuilder.bindMarker("clust2"))));
        boundValues.add(clust2);
        encodedValues.add(clust2);
        return new EntityWithIndicesForJSON_SelectIndex.E_J(where, cassandraOptions);
      }
    }

    public final class Clust3 {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust3 = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J Eq(String clust3) {
        where.and(QueryBuilder.eq("clust3", QueryBuilder.bindMarker("clust3")));
        boundValues.add(clust3);
        encodedValues.add(meta.clust3.encodeFromJava(clust3, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust3 IN ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J IN(String... clust3) {
        Validator.validateTrue(ArrayUtils.isNotEmpty(clust3), "Varargs for field '%s' should not be null/empty", "clust3");
        where.and(QueryBuilder.in("clust3",QueryBuilder.bindMarker("clust3")));
        final List<Object> varargs = Arrays.<Object>asList((Object[])clust3);
        final List<Object> encodedVarargs = Arrays.<String>stream((String[])clust3).map(x -> meta.clust3.encodeFromJava(x, Optional.of(cassandraOptions))).collect(Collectors.toList());
        boundValues.add(varargs);
        encodedValues.add(encodedVarargs);
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust3 > ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J Gt(String clust3) {
        where.and(QueryBuilder.gt("clust3", QueryBuilder.bindMarker("clust3")));
        boundValues.add(clust3);
        encodedValues.add(meta.clust3.encodeFromJava(clust3, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust3 >= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J Gte(String clust3) {
        where.and(QueryBuilder.gte("clust3", QueryBuilder.bindMarker("clust3")));
        boundValues.add(clust3);
        encodedValues.add(meta.clust3.encodeFromJava(clust3, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust3 < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J Lt(String clust3) {
        where.and(QueryBuilder.lt("clust3", QueryBuilder.bindMarker("clust3")));
        boundValues.add(clust3);
        encodedValues.add(meta.clust3.encodeFromJava(clust3, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust3 <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J Lte(String clust3) {
        where.and(QueryBuilder.lte("clust3", QueryBuilder.bindMarker("clust3")));
        boundValues.add(clust3);
        encodedValues.add(meta.clust3.encodeFromJava(clust3, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust3 > ? AND clust3 < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J Gt_And_Lt(String clust3_Gt, String clust3_Lt) {
        where.and(QueryBuilder.gt("clust3",QueryBuilder.bindMarker("clust3_Lt")));
        where.and(QueryBuilder.lt("clust3",QueryBuilder.bindMarker("clust3_Lt")));
        boundValues.add(clust3_Gt);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust3_Lt);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Lt, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust3 > ? AND clust3 <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J Gt_And_Lte(String clust3_Gt, String clust3_Lte) {
        where.and(QueryBuilder.gt("clust3",QueryBuilder.bindMarker("clust3_Lte")));
        where.and(QueryBuilder.lte("clust3",QueryBuilder.bindMarker("clust3_Lte")));
        boundValues.add(clust3_Gt);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust3_Lte);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Lte, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust3 >= ? AND clust3 < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J Gte_And_Lt(String clust3_Gte, String clust3_Lt) {
        where.and(QueryBuilder.gte("clust3",QueryBuilder.bindMarker("clust3_Lt")));
        where.and(QueryBuilder.lt("clust3",QueryBuilder.bindMarker("clust3_Lt")));
        boundValues.add(clust3_Gte);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust3_Lt);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Lt, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust3 >= ? AND clust3 <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J Gte_And_Lte(String clust3_Gte, String clust3_Lte) {
        where.and(QueryBuilder.gte("clust3",QueryBuilder.bindMarker("clust3_Lte")));
        where.and(QueryBuilder.lte("clust3",QueryBuilder.bindMarker("clust3_Lte")));
        boundValues.add(clust3_Gte);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust3_Lte);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Lte, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust3  = fromJson(?) </strong> */
      public final EntityWithIndicesForJSON_SelectIndex.E_J Eq_FromJson(String clust3) {
        where.and(QueryBuilder.eq("clust3", QueryBuilder.fromJson(QueryBuilder.bindMarker("clust3"))));
        boundValues.add(clust3);
        encodedValues.add(clust3);
        return new EntityWithIndicesForJSON_SelectIndex.E_J(where, cassandraOptions);
      }
    }

    public final class CollectionIndex {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>collectionindex CONTAINS ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J Contains(String collectionIndex_element) {
        where.and(QueryBuilder.contains("collectionindex", QueryBuilder.bindMarker("collectionindex")));
        boundValues.add(collectionIndex_element);
        encodedValues.add(meta.collectionIndex.encodeSingleElement(collectionIndex_element, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>collectionindex CONTAINS fromJson(?)</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J Contains_FromJson(String collectionIndex_JSONElement) {
        where.and(QueryBuilder.contains("collectionindex", QueryBuilder.fromJson(QueryBuilder.bindMarker("collectionindex"))));
        boundValues.add(collectionIndex_JSONElement);
        encodedValues.add(collectionIndex_JSONElement);
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }
    }

    public final class FullIndexOnCollection {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>fullindexoncollection = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J Eq(Set<String> fullIndexOnCollection) {
        where.and(QueryBuilder.eq("fullindexoncollection", QueryBuilder.bindMarker("fullindexoncollection")));
        boundValues.add(fullIndexOnCollection);
        encodedValues.add(meta.fullIndexOnCollection.encodeFromJava(fullIndexOnCollection, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>fullindexoncollection  = fromJson(?) </strong> */
      public final EntityWithIndicesForJSON_SelectIndex.E_J Eq_FromJson(String fullIndexOnCollection) {
        where.and(QueryBuilder.eq("fullindexoncollection", QueryBuilder.fromJson(QueryBuilder.bindMarker("fullindexoncollection"))));
        boundValues.add(fullIndexOnCollection);
        encodedValues.add(fullIndexOnCollection);
        return new EntityWithIndicesForJSON_SelectIndex.E_J(where, cassandraOptions);
      }
    }

    public final class IndexOnMapEntry {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>indexonmapentry[?] = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J ContainsEntry(Integer indexOnMapEntry_key, String indexOnMapEntry_value) {
        where.and(MapEntryClause.of("indexonmapentry", QueryBuilder.bindMarker("indexOnMapEntry_key"), QueryBuilder.bindMarker("indexOnMapEntry_value")));
        boundValues.add(indexOnMapEntry_key);
        boundValues.add(indexOnMapEntry_value);
        encodedValues.add(meta.indexOnMapEntry.encodeSingleKeyElement(indexOnMapEntry_key, Optional.of(cassandraOptions)));
        encodedValues.add(meta.indexOnMapEntry.encodeSingleValueElement(indexOnMapEntry_value, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>indexonmapentry[fromJson(?)] = fromJson(?)</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J ContainsEntry_FromJSON(String indexOnMapEntry_JSONKey, String indexOnMapEntry_JSONValue) {
        where.and(MapEntryClause.of("indexonmapentry", QueryBuilder.fromJson(QueryBuilder.bindMarker("indexOnMapEntry_JSONKey")), QueryBuilder.fromJson(QueryBuilder.bindMarker("indexOnMapEntry_JSONValue"))));
        boundValues.add(indexOnMapEntry_JSONKey);
        boundValues.add(indexOnMapEntry_JSONValue);
        encodedValues.add(indexOnMapEntry_JSONKey);
        encodedValues.add(indexOnMapEntry_JSONValue);
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }
    }

    public final class IndexOnMapKey {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>indexonmapkey CONTAINS KEY ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J ContainsKey(String indexOnMapKey_key) {
        where.and(QueryBuilder.containsKey("indexonmapkey", QueryBuilder.bindMarker("indexonmapkey")));
        boundValues.add(indexOnMapKey_key);
        encodedValues.add(meta.indexOnMapKey.encodeSingleKeyElement(indexOnMapKey_key, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>indexonmapkey CONTAINS KEY fromJson(?)</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J ContainsKey_FromJSON(String indexOnMapKey_JSONKey) {
        where.and(QueryBuilder.containsKey("indexonmapkey", QueryBuilder.fromJson(QueryBuilder.bindMarker("indexonmapkey"))));
        boundValues.add(indexOnMapKey_JSONKey);
        encodedValues.add(indexOnMapKey_JSONKey);
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }
    }

    public final class IndexOnMapValue {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>indexonmapvalue CONTAINS ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J ContainsValue(String indexOnMapValue_value) {
        where.and(QueryBuilder.contains("indexonmapvalue", QueryBuilder.bindMarker("indexonmapvalue")));
        boundValues.add(indexOnMapValue_value);
        encodedValues.add(meta.indexOnMapValue.encodeSingleValueElement(indexOnMapValue_value, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>indexonmapvalue CONTAINS fromJson(?)</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J ContainsValue_FromJSON(String indexOnMapValue_JSONValue) {
        where.and(QueryBuilder.contains("indexonmapvalue", QueryBuilder.fromJson(QueryBuilder.bindMarker("indexonmapvalue"))));
        boundValues.add(indexOnMapValue_JSONValue);
        encodedValues.add(indexOnMapValue_JSONValue);
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }
    }

    public final class SimpleIndex {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>simpleindex = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J Eq(String simpleIndex) {
        where.and(QueryBuilder.eq("simpleindex", QueryBuilder.bindMarker("simpleindex")));
        boundValues.add(simpleIndex);
        encodedValues.add(meta.simpleIndex.encodeFromJava(simpleIndex, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>simpleindex  = fromJson(?) </strong> */
      public final EntityWithIndicesForJSON_SelectIndex.E_J Eq_FromJson(String simpleIndex) {
        where.and(QueryBuilder.eq("simpleindex", QueryBuilder.fromJson(QueryBuilder.bindMarker("simpleindex"))));
        boundValues.add(simpleIndex);
        encodedValues.add(simpleIndex);
        return new EntityWithIndicesForJSON_SelectIndex.E_J(where, cassandraOptions);
      }
    }

    public final class clust1_clust2 {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2) > ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J Gt(final int clust1, final int clust2) {
        where.and(QueryBuilder.gt(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        final TupleType tupleType = rte.tupleTypeFactory.typeFor();
        boundValues.add(clust1);
        encodedValues.add(meta.clust1.encodeFromJava(clust1, Optional.of(cassandraOptions)));
        boundValues.add(clust2);
        encodedValues.add(meta.clust2.encodeFromJava(clust2, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2) >= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J Gte(final int clust1, final int clust2) {
        where.and(QueryBuilder.gte(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        final TupleType tupleType = rte.tupleTypeFactory.typeFor();
        boundValues.add(clust1);
        encodedValues.add(meta.clust1.encodeFromJava(clust1, Optional.of(cassandraOptions)));
        boundValues.add(clust2);
        encodedValues.add(meta.clust2.encodeFromJava(clust2, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2) < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J Lt(final int clust1, final int clust2) {
        where.and(QueryBuilder.lt(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        final TupleType tupleType = rte.tupleTypeFactory.typeFor();
        boundValues.add(clust1);
        encodedValues.add(meta.clust1.encodeFromJava(clust1, Optional.of(cassandraOptions)));
        boundValues.add(clust2);
        encodedValues.add(meta.clust2.encodeFromJava(clust2, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2) <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J Lte(final int clust1, final int clust2) {
        where.and(QueryBuilder.lte(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        final TupleType tupleType = rte.tupleTypeFactory.typeFor();
        boundValues.add(clust1);
        encodedValues.add(meta.clust1.encodeFromJava(clust1, Optional.of(cassandraOptions)));
        boundValues.add(clust2);
        encodedValues.add(meta.clust2.encodeFromJava(clust2, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2) > ? AND (clust1,clust2) < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J Gt_And_Lt(final int clust1_Gt, final int clust2_Gt, final int clust1_Lt, final int clust2_Lt) {
        where.and(QueryBuilder.gt(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lt(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Gt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lt, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lt, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2) > ? AND (clust1,clust2) <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J Gt_And_Lte(final int clust1_Gt, final int clust2_Gt, final int clust1_Lte, final int clust2_Lte) {
        where.and(QueryBuilder.gt(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lte(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Gt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lte, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lte, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2) >= ? AND (clust1,clust2) < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J Gte_And_Lt(final int clust1_Gte, final int clust2_Gte, final int clust1_Lt, final int clust2_Lt) {
        where.and(QueryBuilder.gte(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lt(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Gte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lt, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lt, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2) >= ? AND (clust1,clust2) <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J Gte_And_Lte(final int clust1_Gte, final int clust2_Gte, final int clust1_Lte, final int clust2_Lte) {
        where.and(QueryBuilder.gte(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lte(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Gte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lte, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lte, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2) > ? AND (clust1) < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J clust1_And_clust2_Gt_And_clust1_Lt(final int clust1_Gt, final int clust2_Gt, final int clust1_Lt) {
        where.and(QueryBuilder.gt(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lt(Arrays.asList("clust1"), Arrays.asList("clust1").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Gt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lt, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2) > ? AND (clust1) <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J clust1_And_clust2_Gt_And_clust1_Lte(final int clust1_Gt, final int clust2_Gt, final int clust1_Lte) {
        where.and(QueryBuilder.gt(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lte(Arrays.asList("clust1"), Arrays.asList("clust1").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Gt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lte, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2) >= ? AND (clust1) < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J clust1_And_clust2_Gte_And_clust1_Lt(final int clust1_Gte, final int clust2_Gte, final int clust1_Lt) {
        where.and(QueryBuilder.gte(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lt(Arrays.asList("clust1"), Arrays.asList("clust1").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Gte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lt, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2) >= ? AND (clust1) <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J clust1_And_clust2_Gte_And_clust1_Lte(final int clust1_Gte, final int clust2_Gte, final int clust1_Lte) {
        where.and(QueryBuilder.gte(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lte(Arrays.asList("clust1"), Arrays.asList("clust1").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Gte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lte, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1) > ? AND (clust1,clust2) < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J clust1_Gt_And_clust1_And_clust2_Lt(final int clust1_Gt, final int clust1_Lt, final int clust2_Lt) {
        where.and(QueryBuilder.gt(Arrays.asList("clust1"), Arrays.asList("clust1").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lt(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lt, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lt, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1) > ? AND (clust1,clust2) <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J clust1_Gt_And_clust1_And_clust2_Lte(final int clust1_Gt, final int clust1_Lte, final int clust2_Lte) {
        where.and(QueryBuilder.gt(Arrays.asList("clust1"), Arrays.asList("clust1").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lte(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lte, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lte, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1) >= ? AND (clust1,clust2) < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J clust1_Gte_And_clust1_And_clust2_Lt(final int clust1_Gte, final int clust1_Lt, final int clust2_Lt) {
        where.and(QueryBuilder.gte(Arrays.asList("clust1"), Arrays.asList("clust1").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lt(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lt, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lt, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1) >= ? AND (clust1,clust2) <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J clust1_Gte_And_clust1_And_clust2_Lte(final int clust1_Gte, final int clust1_Lte, final int clust2_Lte) {
        where.and(QueryBuilder.gte(Arrays.asList("clust1"), Arrays.asList("clust1").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lte(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lte, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lte, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }
    }

    public final class clust1_clust2_clust3 {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2,clust3) > ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J Gt(final int clust1, final int clust2, final String clust3) {
        where.and(QueryBuilder.gt(Arrays.asList("clust1","clust2","clust3"), Arrays.asList("clust1","clust2","clust3").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        final TupleType tupleType = rte.tupleTypeFactory.typeFor();
        boundValues.add(clust1);
        encodedValues.add(meta.clust1.encodeFromJava(clust1, Optional.of(cassandraOptions)));
        boundValues.add(clust2);
        encodedValues.add(meta.clust2.encodeFromJava(clust2, Optional.of(cassandraOptions)));
        boundValues.add(clust3);
        encodedValues.add(meta.clust3.encodeFromJava(clust3, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2,clust3) >= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J Gte(final int clust1, final int clust2, final String clust3) {
        where.and(QueryBuilder.gte(Arrays.asList("clust1","clust2","clust3"), Arrays.asList("clust1","clust2","clust3").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        final TupleType tupleType = rte.tupleTypeFactory.typeFor();
        boundValues.add(clust1);
        encodedValues.add(meta.clust1.encodeFromJava(clust1, Optional.of(cassandraOptions)));
        boundValues.add(clust2);
        encodedValues.add(meta.clust2.encodeFromJava(clust2, Optional.of(cassandraOptions)));
        boundValues.add(clust3);
        encodedValues.add(meta.clust3.encodeFromJava(clust3, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2,clust3) < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J Lt(final int clust1, final int clust2, final String clust3) {
        where.and(QueryBuilder.lt(Arrays.asList("clust1","clust2","clust3"), Arrays.asList("clust1","clust2","clust3").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        final TupleType tupleType = rte.tupleTypeFactory.typeFor();
        boundValues.add(clust1);
        encodedValues.add(meta.clust1.encodeFromJava(clust1, Optional.of(cassandraOptions)));
        boundValues.add(clust2);
        encodedValues.add(meta.clust2.encodeFromJava(clust2, Optional.of(cassandraOptions)));
        boundValues.add(clust3);
        encodedValues.add(meta.clust3.encodeFromJava(clust3, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2,clust3) <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J Lte(final int clust1, final int clust2, final String clust3) {
        where.and(QueryBuilder.lte(Arrays.asList("clust1","clust2","clust3"), Arrays.asList("clust1","clust2","clust3").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        final TupleType tupleType = rte.tupleTypeFactory.typeFor();
        boundValues.add(clust1);
        encodedValues.add(meta.clust1.encodeFromJava(clust1, Optional.of(cassandraOptions)));
        boundValues.add(clust2);
        encodedValues.add(meta.clust2.encodeFromJava(clust2, Optional.of(cassandraOptions)));
        boundValues.add(clust3);
        encodedValues.add(meta.clust3.encodeFromJava(clust3, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2,clust3) > ? AND (clust1,clust2,clust3) < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J Gt_And_Lt(final int clust1_Gt, final int clust2_Gt, final String clust3_Gt, final int clust1_Lt, final int clust2_Lt, final String clust3_Lt) {
        where.and(QueryBuilder.gt(Arrays.asList("clust1","clust2","clust3"), Arrays.asList("clust1","clust2","clust3").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lt(Arrays.asList("clust1","clust2","clust3"), Arrays.asList("clust1","clust2","clust3").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Gt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust3_Gt);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lt, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lt, Optional.of(cassandraOptions)));
        boundValues.add(clust3_Lt);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Lt, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2,clust3) > ? AND (clust1,clust2,clust3) <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J Gt_And_Lte(final int clust1_Gt, final int clust2_Gt, final String clust3_Gt, final int clust1_Lte, final int clust2_Lte, final String clust3_Lte) {
        where.and(QueryBuilder.gt(Arrays.asList("clust1","clust2","clust3"), Arrays.asList("clust1","clust2","clust3").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lte(Arrays.asList("clust1","clust2","clust3"), Arrays.asList("clust1","clust2","clust3").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Gt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust3_Gt);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lte, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lte, Optional.of(cassandraOptions)));
        boundValues.add(clust3_Lte);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Lte, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2,clust3) >= ? AND (clust1,clust2,clust3) < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J Gte_And_Lt(final int clust1_Gte, final int clust2_Gte, final String clust3_Gte, final int clust1_Lt, final int clust2_Lt, final String clust3_Lt) {
        where.and(QueryBuilder.gte(Arrays.asList("clust1","clust2","clust3"), Arrays.asList("clust1","clust2","clust3").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lt(Arrays.asList("clust1","clust2","clust3"), Arrays.asList("clust1","clust2","clust3").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Gte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust3_Gte);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lt, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lt, Optional.of(cassandraOptions)));
        boundValues.add(clust3_Lt);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Lt, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2,clust3) >= ? AND (clust1,clust2,clust3) <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J Gte_And_Lte(final int clust1_Gte, final int clust2_Gte, final String clust3_Gte, final int clust1_Lte, final int clust2_Lte, final String clust3_Lte) {
        where.and(QueryBuilder.gte(Arrays.asList("clust1","clust2","clust3"), Arrays.asList("clust1","clust2","clust3").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lte(Arrays.asList("clust1","clust2","clust3"), Arrays.asList("clust1","clust2","clust3").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Gte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust3_Gte);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lte, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lte, Optional.of(cassandraOptions)));
        boundValues.add(clust3_Lte);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Lte, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2,clust3) > ? AND (clust1,clust2) < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J clust1_And_clust2_And_clust3_Gt_And_clust1_And_clust2_Lt(final int clust1_Gt, final int clust2_Gt, final String clust3_Gt, final int clust1_Lt, final int clust2_Lt) {
        where.and(QueryBuilder.gt(Arrays.asList("clust1","clust2","clust3"), Arrays.asList("clust1","clust2","clust3").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lt(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Gt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust3_Gt);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lt, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lt, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2,clust3) > ? AND (clust1,clust2) <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J clust1_And_clust2_And_clust3_Gt_And_clust1_And_clust2_Lte(final int clust1_Gt, final int clust2_Gt, final String clust3_Gt, final int clust1_Lte, final int clust2_Lte) {
        where.and(QueryBuilder.gt(Arrays.asList("clust1","clust2","clust3"), Arrays.asList("clust1","clust2","clust3").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lte(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Gt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust3_Gt);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lte, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lte, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2,clust3) >= ? AND (clust1,clust2) < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J clust1_And_clust2_And_clust3_Gte_And_clust1_And_clust2_Lt(final int clust1_Gte, final int clust2_Gte, final String clust3_Gte, final int clust1_Lt, final int clust2_Lt) {
        where.and(QueryBuilder.gte(Arrays.asList("clust1","clust2","clust3"), Arrays.asList("clust1","clust2","clust3").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lt(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Gte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust3_Gte);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lt, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lt, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2,clust3) >= ? AND (clust1,clust2) <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J clust1_And_clust2_And_clust3_Gte_And_clust1_And_clust2_Lte(final int clust1_Gte, final int clust2_Gte, final String clust3_Gte, final int clust1_Lte, final int clust2_Lte) {
        where.and(QueryBuilder.gte(Arrays.asList("clust1","clust2","clust3"), Arrays.asList("clust1","clust2","clust3").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lte(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Gte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust3_Gte);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lte, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lte, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2) > ? AND (clust1,clust2,clust3) < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J clust1_And_clust2_Gt_And_clust1_And_clust2_And_clust3_Lt(final int clust1_Gt, final int clust2_Gt, final int clust1_Lt, final int clust2_Lt, final String clust3_Lt) {
        where.and(QueryBuilder.gt(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lt(Arrays.asList("clust1","clust2","clust3"), Arrays.asList("clust1","clust2","clust3").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Gt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lt, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lt, Optional.of(cassandraOptions)));
        boundValues.add(clust3_Lt);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Lt, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2) > ? AND (clust1,clust2,clust3) <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J clust1_And_clust2_Gt_And_clust1_And_clust2_And_clust3_Lte(final int clust1_Gt, final int clust2_Gt, final int clust1_Lte, final int clust2_Lte, final String clust3_Lte) {
        where.and(QueryBuilder.gt(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lte(Arrays.asList("clust1","clust2","clust3"), Arrays.asList("clust1","clust2","clust3").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Gt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gt, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lte, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lte, Optional.of(cassandraOptions)));
        boundValues.add(clust3_Lte);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Lte, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2) >= ? AND (clust1,clust2,clust3) < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J clust1_And_clust2_Gte_And_clust1_And_clust2_And_clust3_Lt(final int clust1_Gte, final int clust2_Gte, final int clust1_Lt, final int clust2_Lt, final String clust3_Lt) {
        where.and(QueryBuilder.gte(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lt(Arrays.asList("clust1","clust2","clust3"), Arrays.asList("clust1","clust2","clust3").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Gte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lt);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lt, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lt);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lt, Optional.of(cassandraOptions)));
        boundValues.add(clust3_Lt);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Lt, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>(clust1,clust2) >= ? AND (clust1,clust2,clust3) <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_SelectIndex.E_J clust1_And_clust2_Gte_And_clust1_And_clust2_And_clust3_Lte(final int clust1_Gte, final int clust2_Gte, final int clust1_Lte, final int clust2_Lte, final String clust3_Lte) {
        where.and(QueryBuilder.gte(Arrays.asList("clust1","clust2"), Arrays.asList("clust1","clust2").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        where.and(QueryBuilder.lte(Arrays.asList("clust1","clust2","clust3"), Arrays.asList("clust1","clust2","clust3").stream().map(QueryBuilder::bindMarker).collect(Collectors.toList())));
        boundValues.add(clust1_Gte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Gte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Gte, Optional.of(cassandraOptions)));
        boundValues.add(clust1_Lte);
        encodedValues.add(meta.clust1.encodeFromJava(clust1_Lte, Optional.of(cassandraOptions)));
        boundValues.add(clust2_Lte);
        encodedValues.add(meta.clust2.encodeFromJava(clust2_Lte, Optional.of(cassandraOptions)));
        boundValues.add(clust3_Lte);
        encodedValues.add(meta.clust3.encodeFromJava(clust3_Lte, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_SelectIndex.E_J.this;
      }
    }
  }
}
