package info.archinnov.achilles.generated.dsl;

import com.datastax.driver.core.querybuilder.NonEscapingSetAssignment;
import com.datastax.driver.core.querybuilder.NotEq;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Update;
import info.archinnov.achilles.generated.meta.entity.EntityWithIndicesForJSON_AchillesMeta;
import info.archinnov.achilles.internals.dsl.query.update.AbstractUpdate;
import info.archinnov.achilles.internals.dsl.query.update.AbstractUpdateColumns;
import info.archinnov.achilles.internals.dsl.query.update.AbstractUpdateEnd;
import info.archinnov.achilles.internals.dsl.query.update.AbstractUpdateFrom;
import info.archinnov.achilles.internals.dsl.query.update.AbstractUpdateWhere;
import info.archinnov.achilles.internals.entities.EntityWithIndicesForJSON;
import info.archinnov.achilles.internals.metamodel.AbstractEntityProperty;
import info.archinnov.achilles.internals.options.CassandraOptions;
import info.archinnov.achilles.internals.runtime.RuntimeEngine;
import info.archinnov.achilles.type.SchemaNameProvider;
import info.archinnov.achilles.validation.Validator;
import java.lang.Class;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;

public final class EntityWithIndicesForJSON_Update extends AbstractUpdate {
  protected final EntityWithIndicesForJSON_AchillesMeta meta;

  protected final Class<EntityWithIndicesForJSON> entityClass = EntityWithIndicesForJSON.class;

  public EntityWithIndicesForJSON_Update(RuntimeEngine rte, EntityWithIndicesForJSON_AchillesMeta meta) {
    super(rte);
    this.meta = meta;
  }

  /**
   * Generate an UPDATE <strong>FROM</strong> ... */
  public final EntityWithIndicesForJSON_Update.F fromBaseTable() {
    final String currentKeyspace = meta.getKeyspace().orElse("unknown_keyspace_for_" + meta.entityClass.getCanonicalName());
    final Update.Where where = QueryBuilder.update(currentKeyspace, meta.getTableOrViewName()).where();
    return new EntityWithIndicesForJSON_Update.F(where, new CassandraOptions());
  }

  /**
   * Generate an UPDATE <strong>FROM</strong> ... using the given SchemaNameProvider */
  public final EntityWithIndicesForJSON_Update.F from(final SchemaNameProvider schemaNameProvider) {
    final String currentKeyspace = lookupKeyspace(schemaNameProvider, meta.entityClass);
    final String currentTable = lookupTable(schemaNameProvider, meta.entityClass);
    final Update.Where where = QueryBuilder.update(currentKeyspace, currentTable).where();
    return new EntityWithIndicesForJSON_Update.F(where, CassandraOptions.withSchemaNameProvider(schemaNameProvider));
  }

  public class Cols extends AbstractUpdateColumns {
    Cols(Update.Where where, CassandraOptions cassandraOptions) {
      super(where, cassandraOptions);
    }

    public final Cols.SimpleIndex simpleIndex() {
      return new Cols.SimpleIndex();
    }

    public final Cols.CollectionIndex collectionIndex() {
      return new Cols.CollectionIndex();
    }

    public final Cols.FullIndexOnCollection fullIndexOnCollection() {
      return new Cols.FullIndexOnCollection();
    }

    public final Cols.IndexOnMapKey indexOnMapKey() {
      return new Cols.IndexOnMapKey();
    }

    public final Cols.IndexOnMapValue indexOnMapValue() {
      return new Cols.IndexOnMapValue();
    }

    public final Cols.IndexOnMapEntry indexOnMapEntry() {
      return new Cols.IndexOnMapEntry();
    }

    public final EntityWithIndicesForJSON_Update.W_Id where() {
      return new EntityWithIndicesForJSON_Update.W_Id(where, cassandraOptions);
    }

    public final class SimpleIndex {
      /**
       * Generate an UPDATE FROM ... <strong>SET simpleindex = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.Cols Set(final String simpleIndex) {
        where.with(NonEscapingSetAssignment.of("simpleindex", QueryBuilder.bindMarker("simpleindex")));
        boundValues.add(simpleIndex);
        encodedValues.add(meta.simpleIndex.encodeFromJava(simpleIndex, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_Update.Cols.this;
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET simpleindex = fromJson(?)</strong> */
      public final EntityWithIndicesForJSON_Update.Cols Set_FromJSON(final String simpleIndex_element) {
        where.with(NonEscapingSetAssignment.of("simpleindex", QueryBuilder.fromJson(QueryBuilder.bindMarker("simpleindex"))));
        boundValues.add(simpleIndex_element);
        encodedValues.add(simpleIndex_element);
        return EntityWithIndicesForJSON_Update.Cols.this;
      }
    }

    public final class CollectionIndex {
      /**
       * Generate an UPDATE FROM ... <strong>SET collectionindex = collectionindex + [?]</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.Cols AppendTo(final String collectionIndex_element) {
        where.with(QueryBuilder.appendAll("collectionindex", QueryBuilder.bindMarker("collectionindex")));
        boundValues.add(Arrays.asList(collectionIndex_element));
        encodedValues.add(meta.collectionIndex.encodeFromJava(Arrays.asList(collectionIndex_element), Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_Update.Cols.this;
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET collectionIndex = collectionIndex + ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.Cols AppendAllTo(final List<String> collectionIndex_element) {
        where.with(QueryBuilder.appendAll("collectionindex", QueryBuilder.bindMarker("collectionindex")));
        boundValues.add(collectionIndex_element);
        encodedValues.add(meta.collectionIndex.encodeFromJava(collectionIndex_element, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_Update.Cols.this;
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET collectionIndex = [?] + collectionIndex</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.Cols PrependTo(final String collectionIndex_element) {
        where.with(QueryBuilder.prependAll("collectionindex", QueryBuilder.bindMarker("collectionindex")));
        boundValues.add(Arrays.asList(collectionIndex_element));
        encodedValues.add(meta.collectionIndex.encodeFromJava(Arrays.asList(collectionIndex_element), Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_Update.Cols.this;
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET collectionIndex = ? + collectionIndex</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.Cols PrependAllTo(final List<String> collectionIndex_element) {
        where.with(QueryBuilder.prependAll("collectionindex", QueryBuilder.bindMarker("collectionindex")));
        boundValues.add(collectionIndex_element);
        encodedValues.add(meta.collectionIndex.encodeFromJava(collectionIndex_element, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_Update.Cols.this;
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET collectionIndex[index] = ?</strong> */
      public final EntityWithIndicesForJSON_Update.Cols SetAtIndex(final int index, final String collectionIndex_element) {
        where.with(QueryBuilder.setIdx("collectionindex", index, QueryBuilder.bindMarker("collectionindex")));
        boundValues.add(collectionIndex_element);
        encodedValues.add(meta.collectionIndex.valueProperty.encodeFromJava(collectionIndex_element, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_Update.Cols.this;
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET collectionIndex[index] = null</strong> */
      public final EntityWithIndicesForJSON_Update.Cols RemoveAtIndex(final int index) {
        where.with(QueryBuilder.setIdx("collectionindex", index, QueryBuilder.bindMarker("collectionindex")));
        boundValues.add(null);
        encodedValues.add(null);
        return EntityWithIndicesForJSON_Update.Cols.this;
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET collectionIndex = collectionIndex - [?]</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.Cols RemoveFrom(final String collectionIndex_element) {
        where.with(QueryBuilder.discardAll("collectionindex", QueryBuilder.bindMarker("collectionindex")));
        boundValues.add(Arrays.asList(collectionIndex_element));
        encodedValues.add(meta.collectionIndex.encodeFromJava(Arrays.asList(collectionIndex_element), Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_Update.Cols.this;
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET collectionIndex = collectionIndex - ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.Cols RemoveAllFrom(final List<String> collectionIndex_element) {
        where.with(QueryBuilder.discardAll("collectionindex", QueryBuilder.bindMarker("collectionindex")));
        boundValues.add(collectionIndex_element);
        encodedValues.add(meta.collectionIndex.encodeFromJava(collectionIndex_element, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_Update.Cols.this;
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET collectionIndex = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.Cols Set(final List<String> collectionIndex_element) {
        where.with(NonEscapingSetAssignment.of("collectionindex", QueryBuilder.bindMarker("collectionindex")));
        boundValues.add(collectionIndex_element);
        encodedValues.add(meta.collectionIndex.encodeFromJava(collectionIndex_element, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_Update.Cols.this;
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET collectionindex = fromJson(?)</strong> */
      public final EntityWithIndicesForJSON_Update.Cols Set_FromJSON(final String collectionIndex_element) {
        where.with(NonEscapingSetAssignment.of("collectionindex", QueryBuilder.fromJson(QueryBuilder.bindMarker("collectionindex"))));
        boundValues.add(collectionIndex_element);
        encodedValues.add(collectionIndex_element);
        return EntityWithIndicesForJSON_Update.Cols.this;
      }
    }

    public final class FullIndexOnCollection {
      /**
       * Generate an UPDATE FROM ... <strong>SET fullIndexOnCollection = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.Cols Set(final Set<String> fullIndexOnCollection_element) {
        where.with(NonEscapingSetAssignment.of("fullindexoncollection", QueryBuilder.bindMarker("fullindexoncollection")));
        boundValues.add(fullIndexOnCollection_element);
        encodedValues.add(meta.fullIndexOnCollection.encodeFromJava(fullIndexOnCollection_element, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_Update.Cols.this;
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET fullindexoncollection = fromJson(?)</strong> */
      public final EntityWithIndicesForJSON_Update.Cols Set_FromJSON(final String fullIndexOnCollection_element) {
        where.with(NonEscapingSetAssignment.of("fullindexoncollection", QueryBuilder.fromJson(QueryBuilder.bindMarker("fullindexoncollection"))));
        boundValues.add(fullIndexOnCollection_element);
        encodedValues.add(fullIndexOnCollection_element);
        return EntityWithIndicesForJSON_Update.Cols.this;
      }
    }

    public final class IndexOnMapKey {
      /**
       * Generate an UPDATE FROM ... <strong>SET indexonmapkey[?] = ?</strong> */
      public final EntityWithIndicesForJSON_Update.Cols PutTo(final String indexOnMapKey_key, final String indexOnMapKey_value) {
        where.with(QueryBuilder.put("indexonmapkey", QueryBuilder.bindMarker("indexOnMapKey_key"), QueryBuilder.bindMarker("indexOnMapKey_value")));
        boundValues.add(indexOnMapKey_key);
        boundValues.add(indexOnMapKey_value);
        encodedValues.add(meta.indexOnMapKey.keyProperty.encodeFromJava(indexOnMapKey_key, Optional.of(cassandraOptions)));
        encodedValues.add(meta.indexOnMapKey.valueProperty.encodeFromJava(indexOnMapKey_value, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_Update.Cols.this;
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET indexOnMapKey = indexOnMapKey + ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.Cols AddAllTo(final Map<String, String> indexOnMapKey) {
        where.with(QueryBuilder.addAll("indexonmapkey", QueryBuilder.bindMarker("indexonmapkey")));
        boundValues.add(indexOnMapKey);
        encodedValues.add(meta.indexOnMapKey.encodeFromJava(indexOnMapKey, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_Update.Cols.this;
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET indexOnMapKey[?] = null</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.Cols RemoveByKey(final String indexOnMapKey_key) {
        where.with(QueryBuilder.put("indexonmapkey", QueryBuilder.bindMarker("indexOnMapKey_key"), QueryBuilder.bindMarker("indexOnMapKey_value")));
        boundValues.add(indexOnMapKey_key);
        boundValues.add(null);
        encodedValues.add(meta.indexOnMapKey.keyProperty.encodeFromJava(indexOnMapKey_key, Optional.of(cassandraOptions)));
        encodedValues.add(null);
        return EntityWithIndicesForJSON_Update.Cols.this;
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET indexOnMapKey = ? */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.Cols Set(final Map<String, String> indexOnMapKey) {
        where.with(NonEscapingSetAssignment.of("indexonmapkey", QueryBuilder.bindMarker("indexonmapkey")));
        boundValues.add(indexOnMapKey);
        encodedValues.add(meta.indexOnMapKey.encodeFromJava(indexOnMapKey, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_Update.Cols.this;
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET indexonmapkey = fromJson(?)</strong> */
      public final EntityWithIndicesForJSON_Update.Cols Set_FromJSON(final String indexOnMapKey_element) {
        where.with(NonEscapingSetAssignment.of("indexonmapkey", QueryBuilder.fromJson(QueryBuilder.bindMarker("indexonmapkey"))));
        boundValues.add(indexOnMapKey_element);
        encodedValues.add(indexOnMapKey_element);
        return EntityWithIndicesForJSON_Update.Cols.this;
      }
    }

    public final class IndexOnMapValue {
      /**
       * Generate an UPDATE FROM ... <strong>SET indexonmapvalue[?] = ?</strong> */
      public final EntityWithIndicesForJSON_Update.Cols PutTo(final Integer indexOnMapValue_key, final String indexOnMapValue_value) {
        where.with(QueryBuilder.put("indexonmapvalue", QueryBuilder.bindMarker("indexOnMapValue_key"), QueryBuilder.bindMarker("indexOnMapValue_value")));
        boundValues.add(indexOnMapValue_key);
        boundValues.add(indexOnMapValue_value);
        encodedValues.add(meta.indexOnMapValue.keyProperty.encodeFromJava(indexOnMapValue_key, Optional.of(cassandraOptions)));
        encodedValues.add(meta.indexOnMapValue.valueProperty.encodeFromJava(indexOnMapValue_value, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_Update.Cols.this;
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET indexOnMapValue = indexOnMapValue + ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.Cols AddAllTo(final Map<Integer, String> indexOnMapValue) {
        where.with(QueryBuilder.addAll("indexonmapvalue", QueryBuilder.bindMarker("indexonmapvalue")));
        boundValues.add(indexOnMapValue);
        encodedValues.add(meta.indexOnMapValue.encodeFromJava(indexOnMapValue, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_Update.Cols.this;
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET indexOnMapValue[?] = null</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.Cols RemoveByKey(final Integer indexOnMapValue_key) {
        where.with(QueryBuilder.put("indexonmapvalue", QueryBuilder.bindMarker("indexOnMapValue_key"), QueryBuilder.bindMarker("indexOnMapValue_value")));
        boundValues.add(indexOnMapValue_key);
        boundValues.add(null);
        encodedValues.add(meta.indexOnMapValue.keyProperty.encodeFromJava(indexOnMapValue_key, Optional.of(cassandraOptions)));
        encodedValues.add(null);
        return EntityWithIndicesForJSON_Update.Cols.this;
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET indexOnMapValue = ? */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.Cols Set(final Map<Integer, String> indexOnMapValue) {
        where.with(NonEscapingSetAssignment.of("indexonmapvalue", QueryBuilder.bindMarker("indexonmapvalue")));
        boundValues.add(indexOnMapValue);
        encodedValues.add(meta.indexOnMapValue.encodeFromJava(indexOnMapValue, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_Update.Cols.this;
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET indexonmapvalue = fromJson(?)</strong> */
      public final EntityWithIndicesForJSON_Update.Cols Set_FromJSON(final String indexOnMapValue_element) {
        where.with(NonEscapingSetAssignment.of("indexonmapvalue", QueryBuilder.fromJson(QueryBuilder.bindMarker("indexonmapvalue"))));
        boundValues.add(indexOnMapValue_element);
        encodedValues.add(indexOnMapValue_element);
        return EntityWithIndicesForJSON_Update.Cols.this;
      }
    }

    public final class IndexOnMapEntry {
      /**
       * Generate an UPDATE FROM ... <strong>SET indexonmapentry[?] = ?</strong> */
      public final EntityWithIndicesForJSON_Update.Cols PutTo(final Integer indexOnMapEntry_key, final String indexOnMapEntry_value) {
        where.with(QueryBuilder.put("indexonmapentry", QueryBuilder.bindMarker("indexOnMapEntry_key"), QueryBuilder.bindMarker("indexOnMapEntry_value")));
        boundValues.add(indexOnMapEntry_key);
        boundValues.add(indexOnMapEntry_value);
        encodedValues.add(meta.indexOnMapEntry.keyProperty.encodeFromJava(indexOnMapEntry_key, Optional.of(cassandraOptions)));
        encodedValues.add(meta.indexOnMapEntry.valueProperty.encodeFromJava(indexOnMapEntry_value, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_Update.Cols.this;
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET indexOnMapEntry = indexOnMapEntry + ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.Cols AddAllTo(final Map<Integer, String> indexOnMapEntry) {
        where.with(QueryBuilder.addAll("indexonmapentry", QueryBuilder.bindMarker("indexonmapentry")));
        boundValues.add(indexOnMapEntry);
        encodedValues.add(meta.indexOnMapEntry.encodeFromJava(indexOnMapEntry, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_Update.Cols.this;
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET indexOnMapEntry[?] = null</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.Cols RemoveByKey(final Integer indexOnMapEntry_key) {
        where.with(QueryBuilder.put("indexonmapentry", QueryBuilder.bindMarker("indexOnMapEntry_key"), QueryBuilder.bindMarker("indexOnMapEntry_value")));
        boundValues.add(indexOnMapEntry_key);
        boundValues.add(null);
        encodedValues.add(meta.indexOnMapEntry.keyProperty.encodeFromJava(indexOnMapEntry_key, Optional.of(cassandraOptions)));
        encodedValues.add(null);
        return EntityWithIndicesForJSON_Update.Cols.this;
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET indexOnMapEntry = ? */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.Cols Set(final Map<Integer, String> indexOnMapEntry) {
        where.with(NonEscapingSetAssignment.of("indexonmapentry", QueryBuilder.bindMarker("indexonmapentry")));
        boundValues.add(indexOnMapEntry);
        encodedValues.add(meta.indexOnMapEntry.encodeFromJava(indexOnMapEntry, Optional.of(cassandraOptions)));
        return EntityWithIndicesForJSON_Update.Cols.this;
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET indexonmapentry = fromJson(?)</strong> */
      public final EntityWithIndicesForJSON_Update.Cols Set_FromJSON(final String indexOnMapEntry_element) {
        where.with(NonEscapingSetAssignment.of("indexonmapentry", QueryBuilder.fromJson(QueryBuilder.bindMarker("indexonmapentry"))));
        boundValues.add(indexOnMapEntry_element);
        encodedValues.add(indexOnMapEntry_element);
        return EntityWithIndicesForJSON_Update.Cols.this;
      }
    }
  }

  public class F extends AbstractUpdateFrom {
    F(Update.Where where, CassandraOptions cassandraOptions) {
      super(where, cassandraOptions);
    }

    public final F.SimpleIndex simpleIndex() {
      return new F.SimpleIndex();
    }

    public final F.CollectionIndex collectionIndex() {
      return new F.CollectionIndex();
    }

    public final F.FullIndexOnCollection fullIndexOnCollection() {
      return new F.FullIndexOnCollection();
    }

    public final F.IndexOnMapKey indexOnMapKey() {
      return new F.IndexOnMapKey();
    }

    public final F.IndexOnMapValue indexOnMapValue() {
      return new F.IndexOnMapValue();
    }

    public final F.IndexOnMapEntry indexOnMapEntry() {
      return new F.IndexOnMapEntry();
    }

    public final class SimpleIndex {
      /**
       * Generate an UPDATE FROM ... <strong>SET simpleindex = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.Cols Set(final String simpleIndex) {
        where.with(NonEscapingSetAssignment.of("simpleindex", QueryBuilder.bindMarker("simpleindex")));
        boundValues.add(simpleIndex);
        encodedValues.add(meta.simpleIndex.encodeFromJava(simpleIndex, Optional.of(cassandraOptions)));
        return new EntityWithIndicesForJSON_Update.Cols(where, cassandraOptions);
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET simpleindex = fromJson(?)</strong> */
      public final EntityWithIndicesForJSON_Update.Cols Set_FromJSON(final String simpleIndex_element) {
        where.with(NonEscapingSetAssignment.of("simpleindex", QueryBuilder.fromJson(QueryBuilder.bindMarker("simpleindex"))));
        boundValues.add(simpleIndex_element);
        encodedValues.add(simpleIndex_element);
        return new EntityWithIndicesForJSON_Update.Cols(where, cassandraOptions);
      }
    }

    public final class CollectionIndex {
      /**
       * Generate an UPDATE FROM ... <strong>SET collectionindex = collectionindex + [?]</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.Cols AppendTo(final String collectionIndex_element) {
        where.with(QueryBuilder.appendAll("collectionindex", QueryBuilder.bindMarker("collectionindex")));
        boundValues.add(Arrays.asList(collectionIndex_element));
        encodedValues.add(meta.collectionIndex.encodeFromJava(Arrays.asList(collectionIndex_element), Optional.of(cassandraOptions)));
        return new EntityWithIndicesForJSON_Update.Cols(where, cassandraOptions);
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET collectionIndex = collectionIndex + ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.Cols AppendAllTo(final List<String> collectionIndex_element) {
        where.with(QueryBuilder.appendAll("collectionindex", QueryBuilder.bindMarker("collectionindex")));
        boundValues.add(collectionIndex_element);
        encodedValues.add(meta.collectionIndex.encodeFromJava(collectionIndex_element, Optional.of(cassandraOptions)));
        return new EntityWithIndicesForJSON_Update.Cols(where, cassandraOptions);
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET collectionIndex = [?] + collectionIndex</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.Cols PrependTo(final String collectionIndex_element) {
        where.with(QueryBuilder.prependAll("collectionindex", QueryBuilder.bindMarker("collectionindex")));
        boundValues.add(Arrays.asList(collectionIndex_element));
        encodedValues.add(meta.collectionIndex.encodeFromJava(Arrays.asList(collectionIndex_element), Optional.of(cassandraOptions)));
        return new EntityWithIndicesForJSON_Update.Cols(where, cassandraOptions);
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET collectionIndex = ? + collectionIndex</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.Cols PrependAllTo(final List<String> collectionIndex_element) {
        where.with(QueryBuilder.prependAll("collectionindex", QueryBuilder.bindMarker("collectionindex")));
        boundValues.add(collectionIndex_element);
        encodedValues.add(meta.collectionIndex.encodeFromJava(collectionIndex_element, Optional.of(cassandraOptions)));
        return new EntityWithIndicesForJSON_Update.Cols(where, cassandraOptions);
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET collectionIndex[index] = ?</strong> */
      public final EntityWithIndicesForJSON_Update.Cols SetAtIndex(final int index, final String collectionIndex_element) {
        where.with(QueryBuilder.setIdx("collectionindex", index, QueryBuilder.bindMarker("collectionindex")));
        boundValues.add(collectionIndex_element);
        encodedValues.add(meta.collectionIndex.valueProperty.encodeFromJava(collectionIndex_element, Optional.of(cassandraOptions)));
        return new EntityWithIndicesForJSON_Update.Cols(where, cassandraOptions);
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET collectionIndex[index] = null</strong> */
      public final EntityWithIndicesForJSON_Update.Cols RemoveAtIndex(final int index) {
        where.with(QueryBuilder.setIdx("collectionindex", index, QueryBuilder.bindMarker("collectionindex")));
        boundValues.add(null);
        encodedValues.add(null);
        return new EntityWithIndicesForJSON_Update.Cols(where, cassandraOptions);
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET collectionIndex = collectionIndex - [?]</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.Cols RemoveFrom(final String collectionIndex_element) {
        where.with(QueryBuilder.discardAll("collectionindex", QueryBuilder.bindMarker("collectionindex")));
        boundValues.add(Arrays.asList(collectionIndex_element));
        encodedValues.add(meta.collectionIndex.encodeFromJava(Arrays.asList(collectionIndex_element), Optional.of(cassandraOptions)));
        return new EntityWithIndicesForJSON_Update.Cols(where, cassandraOptions);
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET collectionIndex = collectionIndex - ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.Cols RemoveAllFrom(final List<String> collectionIndex_element) {
        where.with(QueryBuilder.discardAll("collectionindex", QueryBuilder.bindMarker("collectionindex")));
        boundValues.add(collectionIndex_element);
        encodedValues.add(meta.collectionIndex.encodeFromJava(collectionIndex_element, Optional.of(cassandraOptions)));
        return new EntityWithIndicesForJSON_Update.Cols(where, cassandraOptions);
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET collectionIndex = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.Cols Set(final List<String> collectionIndex_element) {
        where.with(NonEscapingSetAssignment.of("collectionindex", QueryBuilder.bindMarker("collectionindex")));
        boundValues.add(collectionIndex_element);
        encodedValues.add(meta.collectionIndex.encodeFromJava(collectionIndex_element, Optional.of(cassandraOptions)));
        return new EntityWithIndicesForJSON_Update.Cols(where, cassandraOptions);
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET collectionindex = fromJson(?)</strong> */
      public final EntityWithIndicesForJSON_Update.Cols Set_FromJSON(final String collectionIndex_element) {
        where.with(NonEscapingSetAssignment.of("collectionindex", QueryBuilder.fromJson(QueryBuilder.bindMarker("collectionindex"))));
        boundValues.add(collectionIndex_element);
        encodedValues.add(collectionIndex_element);
        return new EntityWithIndicesForJSON_Update.Cols(where, cassandraOptions);
      }
    }

    public final class FullIndexOnCollection {
      /**
       * Generate an UPDATE FROM ... <strong>SET fullIndexOnCollection = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.Cols Set(final Set<String> fullIndexOnCollection_element) {
        where.with(NonEscapingSetAssignment.of("fullindexoncollection", QueryBuilder.bindMarker("fullindexoncollection")));
        boundValues.add(fullIndexOnCollection_element);
        encodedValues.add(meta.fullIndexOnCollection.encodeFromJava(fullIndexOnCollection_element, Optional.of(cassandraOptions)));
        return new EntityWithIndicesForJSON_Update.Cols(where, cassandraOptions);
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET fullindexoncollection = fromJson(?)</strong> */
      public final EntityWithIndicesForJSON_Update.Cols Set_FromJSON(final String fullIndexOnCollection_element) {
        where.with(NonEscapingSetAssignment.of("fullindexoncollection", QueryBuilder.fromJson(QueryBuilder.bindMarker("fullindexoncollection"))));
        boundValues.add(fullIndexOnCollection_element);
        encodedValues.add(fullIndexOnCollection_element);
        return new EntityWithIndicesForJSON_Update.Cols(where, cassandraOptions);
      }
    }

    public final class IndexOnMapKey {
      /**
       * Generate an UPDATE FROM ... <strong>SET indexonmapkey[?] = ?</strong> */
      public final EntityWithIndicesForJSON_Update.Cols PutTo(final String indexOnMapKey_key, final String indexOnMapKey_value) {
        where.with(QueryBuilder.put("indexonmapkey", QueryBuilder.bindMarker("indexOnMapKey_key"), QueryBuilder.bindMarker("indexOnMapKey_value")));
        boundValues.add(indexOnMapKey_key);
        boundValues.add(indexOnMapKey_value);
        encodedValues.add(meta.indexOnMapKey.keyProperty.encodeFromJava(indexOnMapKey_key, Optional.of(cassandraOptions)));
        encodedValues.add(meta.indexOnMapKey.valueProperty.encodeFromJava(indexOnMapKey_value, Optional.of(cassandraOptions)));
        return new EntityWithIndicesForJSON_Update.Cols(where, cassandraOptions);
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET indexOnMapKey = indexOnMapKey + ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.Cols AddAllTo(final Map<String, String> indexOnMapKey) {
        where.with(QueryBuilder.addAll("indexonmapkey", QueryBuilder.bindMarker("indexonmapkey")));
        boundValues.add(indexOnMapKey);
        encodedValues.add(meta.indexOnMapKey.encodeFromJava(indexOnMapKey, Optional.of(cassandraOptions)));
        return new EntityWithIndicesForJSON_Update.Cols(where, cassandraOptions);
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET indexOnMapKey[?] = null</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.Cols RemoveByKey(final String indexOnMapKey_key) {
        where.with(QueryBuilder.put("indexonmapkey", QueryBuilder.bindMarker("indexOnMapKey_key"), QueryBuilder.bindMarker("indexOnMapKey_value")));
        boundValues.add(indexOnMapKey_key);
        boundValues.add(null);
        encodedValues.add(meta.indexOnMapKey.keyProperty.encodeFromJava(indexOnMapKey_key, Optional.of(cassandraOptions)));
        encodedValues.add(null);
        return new EntityWithIndicesForJSON_Update.Cols(where, cassandraOptions);
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET indexOnMapKey = ? */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.Cols Set(final Map<String, String> indexOnMapKey) {
        where.with(NonEscapingSetAssignment.of("indexonmapkey", QueryBuilder.bindMarker("indexonmapkey")));
        boundValues.add(indexOnMapKey);
        encodedValues.add(meta.indexOnMapKey.encodeFromJava(indexOnMapKey, Optional.of(cassandraOptions)));
        return new EntityWithIndicesForJSON_Update.Cols(where, cassandraOptions);
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET indexonmapkey = fromJson(?)</strong> */
      public final EntityWithIndicesForJSON_Update.Cols Set_FromJSON(final String indexOnMapKey_element) {
        where.with(NonEscapingSetAssignment.of("indexonmapkey", QueryBuilder.fromJson(QueryBuilder.bindMarker("indexonmapkey"))));
        boundValues.add(indexOnMapKey_element);
        encodedValues.add(indexOnMapKey_element);
        return new EntityWithIndicesForJSON_Update.Cols(where, cassandraOptions);
      }
    }

    public final class IndexOnMapValue {
      /**
       * Generate an UPDATE FROM ... <strong>SET indexonmapvalue[?] = ?</strong> */
      public final EntityWithIndicesForJSON_Update.Cols PutTo(final Integer indexOnMapValue_key, final String indexOnMapValue_value) {
        where.with(QueryBuilder.put("indexonmapvalue", QueryBuilder.bindMarker("indexOnMapValue_key"), QueryBuilder.bindMarker("indexOnMapValue_value")));
        boundValues.add(indexOnMapValue_key);
        boundValues.add(indexOnMapValue_value);
        encodedValues.add(meta.indexOnMapValue.keyProperty.encodeFromJava(indexOnMapValue_key, Optional.of(cassandraOptions)));
        encodedValues.add(meta.indexOnMapValue.valueProperty.encodeFromJava(indexOnMapValue_value, Optional.of(cassandraOptions)));
        return new EntityWithIndicesForJSON_Update.Cols(where, cassandraOptions);
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET indexOnMapValue = indexOnMapValue + ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.Cols AddAllTo(final Map<Integer, String> indexOnMapValue) {
        where.with(QueryBuilder.addAll("indexonmapvalue", QueryBuilder.bindMarker("indexonmapvalue")));
        boundValues.add(indexOnMapValue);
        encodedValues.add(meta.indexOnMapValue.encodeFromJava(indexOnMapValue, Optional.of(cassandraOptions)));
        return new EntityWithIndicesForJSON_Update.Cols(where, cassandraOptions);
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET indexOnMapValue[?] = null</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.Cols RemoveByKey(final Integer indexOnMapValue_key) {
        where.with(QueryBuilder.put("indexonmapvalue", QueryBuilder.bindMarker("indexOnMapValue_key"), QueryBuilder.bindMarker("indexOnMapValue_value")));
        boundValues.add(indexOnMapValue_key);
        boundValues.add(null);
        encodedValues.add(meta.indexOnMapValue.keyProperty.encodeFromJava(indexOnMapValue_key, Optional.of(cassandraOptions)));
        encodedValues.add(null);
        return new EntityWithIndicesForJSON_Update.Cols(where, cassandraOptions);
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET indexOnMapValue = ? */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.Cols Set(final Map<Integer, String> indexOnMapValue) {
        where.with(NonEscapingSetAssignment.of("indexonmapvalue", QueryBuilder.bindMarker("indexonmapvalue")));
        boundValues.add(indexOnMapValue);
        encodedValues.add(meta.indexOnMapValue.encodeFromJava(indexOnMapValue, Optional.of(cassandraOptions)));
        return new EntityWithIndicesForJSON_Update.Cols(where, cassandraOptions);
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET indexonmapvalue = fromJson(?)</strong> */
      public final EntityWithIndicesForJSON_Update.Cols Set_FromJSON(final String indexOnMapValue_element) {
        where.with(NonEscapingSetAssignment.of("indexonmapvalue", QueryBuilder.fromJson(QueryBuilder.bindMarker("indexonmapvalue"))));
        boundValues.add(indexOnMapValue_element);
        encodedValues.add(indexOnMapValue_element);
        return new EntityWithIndicesForJSON_Update.Cols(where, cassandraOptions);
      }
    }

    public final class IndexOnMapEntry {
      /**
       * Generate an UPDATE FROM ... <strong>SET indexonmapentry[?] = ?</strong> */
      public final EntityWithIndicesForJSON_Update.Cols PutTo(final Integer indexOnMapEntry_key, final String indexOnMapEntry_value) {
        where.with(QueryBuilder.put("indexonmapentry", QueryBuilder.bindMarker("indexOnMapEntry_key"), QueryBuilder.bindMarker("indexOnMapEntry_value")));
        boundValues.add(indexOnMapEntry_key);
        boundValues.add(indexOnMapEntry_value);
        encodedValues.add(meta.indexOnMapEntry.keyProperty.encodeFromJava(indexOnMapEntry_key, Optional.of(cassandraOptions)));
        encodedValues.add(meta.indexOnMapEntry.valueProperty.encodeFromJava(indexOnMapEntry_value, Optional.of(cassandraOptions)));
        return new EntityWithIndicesForJSON_Update.Cols(where, cassandraOptions);
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET indexOnMapEntry = indexOnMapEntry + ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.Cols AddAllTo(final Map<Integer, String> indexOnMapEntry) {
        where.with(QueryBuilder.addAll("indexonmapentry", QueryBuilder.bindMarker("indexonmapentry")));
        boundValues.add(indexOnMapEntry);
        encodedValues.add(meta.indexOnMapEntry.encodeFromJava(indexOnMapEntry, Optional.of(cassandraOptions)));
        return new EntityWithIndicesForJSON_Update.Cols(where, cassandraOptions);
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET indexOnMapEntry[?] = null</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.Cols RemoveByKey(final Integer indexOnMapEntry_key) {
        where.with(QueryBuilder.put("indexonmapentry", QueryBuilder.bindMarker("indexOnMapEntry_key"), QueryBuilder.bindMarker("indexOnMapEntry_value")));
        boundValues.add(indexOnMapEntry_key);
        boundValues.add(null);
        encodedValues.add(meta.indexOnMapEntry.keyProperty.encodeFromJava(indexOnMapEntry_key, Optional.of(cassandraOptions)));
        encodedValues.add(null);
        return new EntityWithIndicesForJSON_Update.Cols(where, cassandraOptions);
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET indexOnMapEntry = ? */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.Cols Set(final Map<Integer, String> indexOnMapEntry) {
        where.with(NonEscapingSetAssignment.of("indexonmapentry", QueryBuilder.bindMarker("indexonmapentry")));
        boundValues.add(indexOnMapEntry);
        encodedValues.add(meta.indexOnMapEntry.encodeFromJava(indexOnMapEntry, Optional.of(cassandraOptions)));
        return new EntityWithIndicesForJSON_Update.Cols(where, cassandraOptions);
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET indexonmapentry = fromJson(?)</strong> */
      public final EntityWithIndicesForJSON_Update.Cols Set_FromJSON(final String indexOnMapEntry_element) {
        where.with(NonEscapingSetAssignment.of("indexonmapentry", QueryBuilder.fromJson(QueryBuilder.bindMarker("indexonmapentry"))));
        boundValues.add(indexOnMapEntry_element);
        encodedValues.add(indexOnMapEntry_element);
        return new EntityWithIndicesForJSON_Update.Cols(where, cassandraOptions);
      }
    }
  }

  public final class W_Id extends AbstractUpdateWhere {
    public W_Id(Update.Where where, CassandraOptions cassandraOptions) {
      super(where, cassandraOptions);
    }

    public final EntityWithIndicesForJSON_Update.W_Id.Relation id() {
      return new EntityWithIndicesForJSON_Update.W_Id.Relation();
    }

    public final class Relation {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>id = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.W_Clust1 Eq(Long id) {
        where.and(QueryBuilder.eq("id", QueryBuilder.bindMarker("id")));
        boundValues.add(id);
        encodedValues.add(meta.id.encodeFromJava(id, Optional.of(cassandraOptions)));
        return new EntityWithIndicesForJSON_Update.W_Clust1(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>id IN ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.W_Clust1 IN(Long... id) {
        Validator.validateTrue(ArrayUtils.isNotEmpty(id), "Varargs for field '%s' should not be null/empty", "id");
        where.and(QueryBuilder.in("id",QueryBuilder.bindMarker("id")));
        final List<Object> varargs = Arrays.<Object>asList((Object[])id);
        final List<Object> encodedVarargs = Arrays.<Long>stream((Long[])id).map(x -> meta.id.encodeFromJava(x, Optional.of(cassandraOptions))).collect(Collectors.toList());
        boundValues.add(varargs);
        encodedValues.add(encodedVarargs);
        return new EntityWithIndicesForJSON_Update.W_Clust1(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>id  = fromJson(?) </strong> */
      public final EntityWithIndicesForJSON_Update.W_Clust1 Eq_FromJson(String id) {
        where.and(QueryBuilder.eq("id", QueryBuilder.fromJson(QueryBuilder.bindMarker("id"))));
        boundValues.add(id);
        encodedValues.add(id);
        return new EntityWithIndicesForJSON_Update.W_Clust1(where, cassandraOptions);
      }
    }
  }

  public final class W_Clust1 extends AbstractUpdateWhere {
    public W_Clust1(Update.Where where, CassandraOptions cassandraOptions) {
      super(where, cassandraOptions);
    }

    public final EntityWithIndicesForJSON_Update.W_Clust1.Relation clust1() {
      return new EntityWithIndicesForJSON_Update.W_Clust1.Relation();
    }

    public final class Relation {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust1 = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.W_Clust2 Eq(int clust1) {
        where.and(QueryBuilder.eq("clust1", QueryBuilder.bindMarker("clust1")));
        boundValues.add(clust1);
        encodedValues.add(meta.clust1.encodeFromJava(clust1, Optional.of(cassandraOptions)));
        return new EntityWithIndicesForJSON_Update.W_Clust2(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust1  = fromJson(?) </strong> */
      public final EntityWithIndicesForJSON_Update.W_Clust2 Eq_FromJson(String clust1) {
        where.and(QueryBuilder.eq("clust1", QueryBuilder.fromJson(QueryBuilder.bindMarker("clust1"))));
        boundValues.add(clust1);
        encodedValues.add(clust1);
        return new EntityWithIndicesForJSON_Update.W_Clust2(where, cassandraOptions);
      }
    }
  }

  public final class W_Clust2 extends AbstractUpdateWhere {
    public W_Clust2(Update.Where where, CassandraOptions cassandraOptions) {
      super(where, cassandraOptions);
    }

    public final EntityWithIndicesForJSON_Update.W_Clust2.Relation clust2() {
      return new EntityWithIndicesForJSON_Update.W_Clust2.Relation();
    }

    public final class Relation {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust2 = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.W_Clust3 Eq(int clust2) {
        where.and(QueryBuilder.eq("clust2", QueryBuilder.bindMarker("clust2")));
        boundValues.add(clust2);
        encodedValues.add(meta.clust2.encodeFromJava(clust2, Optional.of(cassandraOptions)));
        return new EntityWithIndicesForJSON_Update.W_Clust3(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust2  = fromJson(?) </strong> */
      public final EntityWithIndicesForJSON_Update.W_Clust3 Eq_FromJson(String clust2) {
        where.and(QueryBuilder.eq("clust2", QueryBuilder.fromJson(QueryBuilder.bindMarker("clust2"))));
        boundValues.add(clust2);
        encodedValues.add(clust2);
        return new EntityWithIndicesForJSON_Update.W_Clust3(where, cassandraOptions);
      }
    }
  }

  public final class W_Clust3 extends AbstractUpdateWhere {
    public W_Clust3(Update.Where where, CassandraOptions cassandraOptions) {
      super(where, cassandraOptions);
    }

    public final EntityWithIndicesForJSON_Update.W_Clust3.Relation clust3() {
      return new EntityWithIndicesForJSON_Update.W_Clust3.Relation();
    }

    public final class Relation {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust3 = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.E Eq(String clust3) {
        where.and(QueryBuilder.eq("clust3", QueryBuilder.bindMarker("clust3")));
        boundValues.add(clust3);
        encodedValues.add(meta.clust3.encodeFromJava(clust3, Optional.of(cassandraOptions)));
        return new EntityWithIndicesForJSON_Update.E(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust3  = fromJson(?) </strong> */
      public final EntityWithIndicesForJSON_Update.E Eq_FromJson(String clust3) {
        where.and(QueryBuilder.eq("clust3", QueryBuilder.fromJson(QueryBuilder.bindMarker("clust3"))));
        boundValues.add(clust3);
        encodedValues.add(clust3);
        return new EntityWithIndicesForJSON_Update.E(where, cassandraOptions);
      }
    }
  }

  public final class E extends AbstractUpdateEnd<EntityWithIndicesForJSON_Update.E, EntityWithIndicesForJSON> {
    public E(Update.Where where, CassandraOptions cassandraOptions) {
      super(where, cassandraOptions);
    }

    @Override
    protected final Class<EntityWithIndicesForJSON> getEntityClass() {
      return entityClass;
    }

    @Override
    protected final AbstractEntityProperty<EntityWithIndicesForJSON> getMetaInternal() {
      return meta;
    }

    @Override
    protected final RuntimeEngine getRte() {
      return rte;
    }

    @Override
    protected final CassandraOptions getOptions() {
      return cassandraOptions;
    }

    @Override
    protected final List<Object> getBoundValuesInternal() {
      return boundValues;
    }

    @Override
    protected final List<Object> getEncodedValuesInternal() {
      return encodedValues;
    }

    @Override
    protected final EntityWithIndicesForJSON_Update.E getThis() {
      return this;
    }

    public final E.If_SimpleIndex if_SimpleIndex() {
      return new E.If_SimpleIndex();
    }

    public final E.If_CollectionIndex if_CollectionIndex() {
      return new E.If_CollectionIndex();
    }

    public final E.If_FullIndexOnCollection if_FullIndexOnCollection() {
      return new E.If_FullIndexOnCollection();
    }

    public final E.If_IndexOnMapKey if_IndexOnMapKey() {
      return new E.If_IndexOnMapKey();
    }

    public final E.If_IndexOnMapValue if_IndexOnMapValue() {
      return new E.If_IndexOnMapValue();
    }

    public final E.If_IndexOnMapEntry if_IndexOnMapEntry() {
      return new E.If_IndexOnMapEntry();
    }

    public final class If_SimpleIndex {
      /**
       * Generate an ... <strong>IF simpleIndex = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.E Eq(final String simpleIndex) {
        boundValues.add(simpleIndex);
        encodedValues.add(meta.simpleIndex.encodeFromJava(simpleIndex, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.eq("simpleindex", QueryBuilder.bindMarker("simpleindex")));
        return EntityWithIndicesForJSON_Update.E.this;
      }

      /**
       * Generate an ... <strong>IF simpleIndex > ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.E Gt(final String simpleIndex) {
        boundValues.add(simpleIndex);
        encodedValues.add(meta.simpleIndex.encodeFromJava(simpleIndex, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.gt("simpleindex", QueryBuilder.bindMarker("simpleindex")));
        return EntityWithIndicesForJSON_Update.E.this;
      }

      /**
       * Generate an ... <strong>IF simpleIndex >= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.E Gte(final String simpleIndex) {
        boundValues.add(simpleIndex);
        encodedValues.add(meta.simpleIndex.encodeFromJava(simpleIndex, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.gte("simpleindex", QueryBuilder.bindMarker("simpleindex")));
        return EntityWithIndicesForJSON_Update.E.this;
      }

      /**
       * Generate an ... <strong>IF simpleIndex < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.E Lt(final String simpleIndex) {
        boundValues.add(simpleIndex);
        encodedValues.add(meta.simpleIndex.encodeFromJava(simpleIndex, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.lt("simpleindex", QueryBuilder.bindMarker("simpleindex")));
        return EntityWithIndicesForJSON_Update.E.this;
      }

      /**
       * Generate an ... <strong>IF simpleIndex <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.E Lte(final String simpleIndex) {
        boundValues.add(simpleIndex);
        encodedValues.add(meta.simpleIndex.encodeFromJava(simpleIndex, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.lte("simpleindex", QueryBuilder.bindMarker("simpleindex")));
        return EntityWithIndicesForJSON_Update.E.this;
      }

      /**
       * Generate an  ... <strong>IF simpleIndex != ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.E NotEq(final String simpleIndex) {
        boundValues.add(simpleIndex);
        encodedValues.add(meta.simpleIndex.encodeFromJava(simpleIndex, Optional.of(cassandraOptions)));
        where.onlyIf(NotEq.of("simpleindex", QueryBuilder.bindMarker("simpleindex")));
        return EntityWithIndicesForJSON_Update.E.this;
      }

      /**
       * Generate an ... <strong>IF simpleIndex = fromJson(?)</strong> */
      public final EntityWithIndicesForJSON_Update.E Eq_FromJSON(final String simpleIndex) {
        boundValues.add(simpleIndex);
        encodedValues.add(simpleIndex);
        where.onlyIf(QueryBuilder.eq("simpleindex", QueryBuilder.fromJson(QueryBuilder.bindMarker("simpleindex"))));
        return EntityWithIndicesForJSON_Update.E.this;
      }
    }

    public final class If_CollectionIndex {
      /**
       * Generate an ... <strong>IF collectionIndex = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.E Eq(final List<String> collectionIndex) {
        boundValues.add(collectionIndex);
        encodedValues.add(meta.collectionIndex.encodeFromJava(collectionIndex, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.eq("collectionindex", QueryBuilder.bindMarker("collectionindex")));
        return EntityWithIndicesForJSON_Update.E.this;
      }

      /**
       * Generate an ... <strong>IF collectionIndex > ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.E Gt(final List<String> collectionIndex) {
        boundValues.add(collectionIndex);
        encodedValues.add(meta.collectionIndex.encodeFromJava(collectionIndex, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.gt("collectionindex", QueryBuilder.bindMarker("collectionindex")));
        return EntityWithIndicesForJSON_Update.E.this;
      }

      /**
       * Generate an ... <strong>IF collectionIndex >= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.E Gte(final List<String> collectionIndex) {
        boundValues.add(collectionIndex);
        encodedValues.add(meta.collectionIndex.encodeFromJava(collectionIndex, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.gte("collectionindex", QueryBuilder.bindMarker("collectionindex")));
        return EntityWithIndicesForJSON_Update.E.this;
      }

      /**
       * Generate an ... <strong>IF collectionIndex < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.E Lt(final List<String> collectionIndex) {
        boundValues.add(collectionIndex);
        encodedValues.add(meta.collectionIndex.encodeFromJava(collectionIndex, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.lt("collectionindex", QueryBuilder.bindMarker("collectionindex")));
        return EntityWithIndicesForJSON_Update.E.this;
      }

      /**
       * Generate an ... <strong>IF collectionIndex <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.E Lte(final List<String> collectionIndex) {
        boundValues.add(collectionIndex);
        encodedValues.add(meta.collectionIndex.encodeFromJava(collectionIndex, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.lte("collectionindex", QueryBuilder.bindMarker("collectionindex")));
        return EntityWithIndicesForJSON_Update.E.this;
      }

      /**
       * Generate an  ... <strong>IF collectionIndex != ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.E NotEq(final List<String> collectionIndex) {
        boundValues.add(collectionIndex);
        encodedValues.add(meta.collectionIndex.encodeFromJava(collectionIndex, Optional.of(cassandraOptions)));
        where.onlyIf(NotEq.of("collectionindex", QueryBuilder.bindMarker("collectionindex")));
        return EntityWithIndicesForJSON_Update.E.this;
      }

      /**
       * Generate an ... <strong>IF collectionIndex = fromJson(?)</strong> */
      public final EntityWithIndicesForJSON_Update.E Eq_FromJSON(final String collectionIndex) {
        boundValues.add(collectionIndex);
        encodedValues.add(collectionIndex);
        where.onlyIf(QueryBuilder.eq("collectionindex", QueryBuilder.fromJson(QueryBuilder.bindMarker("collectionindex"))));
        return EntityWithIndicesForJSON_Update.E.this;
      }
    }

    public final class If_FullIndexOnCollection {
      /**
       * Generate an ... <strong>IF fullIndexOnCollection = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.E Eq(final Set<String> fullIndexOnCollection) {
        boundValues.add(fullIndexOnCollection);
        encodedValues.add(meta.fullIndexOnCollection.encodeFromJava(fullIndexOnCollection, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.eq("fullindexoncollection", QueryBuilder.bindMarker("fullindexoncollection")));
        return EntityWithIndicesForJSON_Update.E.this;
      }

      /**
       * Generate an ... <strong>IF fullIndexOnCollection > ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.E Gt(final Set<String> fullIndexOnCollection) {
        boundValues.add(fullIndexOnCollection);
        encodedValues.add(meta.fullIndexOnCollection.encodeFromJava(fullIndexOnCollection, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.gt("fullindexoncollection", QueryBuilder.bindMarker("fullindexoncollection")));
        return EntityWithIndicesForJSON_Update.E.this;
      }

      /**
       * Generate an ... <strong>IF fullIndexOnCollection >= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.E Gte(final Set<String> fullIndexOnCollection) {
        boundValues.add(fullIndexOnCollection);
        encodedValues.add(meta.fullIndexOnCollection.encodeFromJava(fullIndexOnCollection, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.gte("fullindexoncollection", QueryBuilder.bindMarker("fullindexoncollection")));
        return EntityWithIndicesForJSON_Update.E.this;
      }

      /**
       * Generate an ... <strong>IF fullIndexOnCollection < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.E Lt(final Set<String> fullIndexOnCollection) {
        boundValues.add(fullIndexOnCollection);
        encodedValues.add(meta.fullIndexOnCollection.encodeFromJava(fullIndexOnCollection, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.lt("fullindexoncollection", QueryBuilder.bindMarker("fullindexoncollection")));
        return EntityWithIndicesForJSON_Update.E.this;
      }

      /**
       * Generate an ... <strong>IF fullIndexOnCollection <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.E Lte(final Set<String> fullIndexOnCollection) {
        boundValues.add(fullIndexOnCollection);
        encodedValues.add(meta.fullIndexOnCollection.encodeFromJava(fullIndexOnCollection, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.lte("fullindexoncollection", QueryBuilder.bindMarker("fullindexoncollection")));
        return EntityWithIndicesForJSON_Update.E.this;
      }

      /**
       * Generate an  ... <strong>IF fullIndexOnCollection != ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.E NotEq(final Set<String> fullIndexOnCollection) {
        boundValues.add(fullIndexOnCollection);
        encodedValues.add(meta.fullIndexOnCollection.encodeFromJava(fullIndexOnCollection, Optional.of(cassandraOptions)));
        where.onlyIf(NotEq.of("fullindexoncollection", QueryBuilder.bindMarker("fullindexoncollection")));
        return EntityWithIndicesForJSON_Update.E.this;
      }

      /**
       * Generate an ... <strong>IF fullIndexOnCollection = fromJson(?)</strong> */
      public final EntityWithIndicesForJSON_Update.E Eq_FromJSON(final String fullIndexOnCollection) {
        boundValues.add(fullIndexOnCollection);
        encodedValues.add(fullIndexOnCollection);
        where.onlyIf(QueryBuilder.eq("fullindexoncollection", QueryBuilder.fromJson(QueryBuilder.bindMarker("fullindexoncollection"))));
        return EntityWithIndicesForJSON_Update.E.this;
      }
    }

    public final class If_IndexOnMapKey {
      /**
       * Generate an ... <strong>IF indexOnMapKey = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.E Eq(final Map<String, String> indexOnMapKey) {
        boundValues.add(indexOnMapKey);
        encodedValues.add(meta.indexOnMapKey.encodeFromJava(indexOnMapKey, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.eq("indexonmapkey", QueryBuilder.bindMarker("indexonmapkey")));
        return EntityWithIndicesForJSON_Update.E.this;
      }

      /**
       * Generate an ... <strong>IF indexOnMapKey > ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.E Gt(final Map<String, String> indexOnMapKey) {
        boundValues.add(indexOnMapKey);
        encodedValues.add(meta.indexOnMapKey.encodeFromJava(indexOnMapKey, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.gt("indexonmapkey", QueryBuilder.bindMarker("indexonmapkey")));
        return EntityWithIndicesForJSON_Update.E.this;
      }

      /**
       * Generate an ... <strong>IF indexOnMapKey >= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.E Gte(final Map<String, String> indexOnMapKey) {
        boundValues.add(indexOnMapKey);
        encodedValues.add(meta.indexOnMapKey.encodeFromJava(indexOnMapKey, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.gte("indexonmapkey", QueryBuilder.bindMarker("indexonmapkey")));
        return EntityWithIndicesForJSON_Update.E.this;
      }

      /**
       * Generate an ... <strong>IF indexOnMapKey < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.E Lt(final Map<String, String> indexOnMapKey) {
        boundValues.add(indexOnMapKey);
        encodedValues.add(meta.indexOnMapKey.encodeFromJava(indexOnMapKey, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.lt("indexonmapkey", QueryBuilder.bindMarker("indexonmapkey")));
        return EntityWithIndicesForJSON_Update.E.this;
      }

      /**
       * Generate an ... <strong>IF indexOnMapKey <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.E Lte(final Map<String, String> indexOnMapKey) {
        boundValues.add(indexOnMapKey);
        encodedValues.add(meta.indexOnMapKey.encodeFromJava(indexOnMapKey, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.lte("indexonmapkey", QueryBuilder.bindMarker("indexonmapkey")));
        return EntityWithIndicesForJSON_Update.E.this;
      }

      /**
       * Generate an  ... <strong>IF indexOnMapKey != ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.E NotEq(final Map<String, String> indexOnMapKey) {
        boundValues.add(indexOnMapKey);
        encodedValues.add(meta.indexOnMapKey.encodeFromJava(indexOnMapKey, Optional.of(cassandraOptions)));
        where.onlyIf(NotEq.of("indexonmapkey", QueryBuilder.bindMarker("indexonmapkey")));
        return EntityWithIndicesForJSON_Update.E.this;
      }

      /**
       * Generate an ... <strong>IF indexOnMapKey = fromJson(?)</strong> */
      public final EntityWithIndicesForJSON_Update.E Eq_FromJSON(final String indexOnMapKey) {
        boundValues.add(indexOnMapKey);
        encodedValues.add(indexOnMapKey);
        where.onlyIf(QueryBuilder.eq("indexonmapkey", QueryBuilder.fromJson(QueryBuilder.bindMarker("indexonmapkey"))));
        return EntityWithIndicesForJSON_Update.E.this;
      }
    }

    public final class If_IndexOnMapValue {
      /**
       * Generate an ... <strong>IF indexOnMapValue = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.E Eq(final Map<Integer, String> indexOnMapValue) {
        boundValues.add(indexOnMapValue);
        encodedValues.add(meta.indexOnMapValue.encodeFromJava(indexOnMapValue, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.eq("indexonmapvalue", QueryBuilder.bindMarker("indexonmapvalue")));
        return EntityWithIndicesForJSON_Update.E.this;
      }

      /**
       * Generate an ... <strong>IF indexOnMapValue > ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.E Gt(final Map<Integer, String> indexOnMapValue) {
        boundValues.add(indexOnMapValue);
        encodedValues.add(meta.indexOnMapValue.encodeFromJava(indexOnMapValue, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.gt("indexonmapvalue", QueryBuilder.bindMarker("indexonmapvalue")));
        return EntityWithIndicesForJSON_Update.E.this;
      }

      /**
       * Generate an ... <strong>IF indexOnMapValue >= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.E Gte(final Map<Integer, String> indexOnMapValue) {
        boundValues.add(indexOnMapValue);
        encodedValues.add(meta.indexOnMapValue.encodeFromJava(indexOnMapValue, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.gte("indexonmapvalue", QueryBuilder.bindMarker("indexonmapvalue")));
        return EntityWithIndicesForJSON_Update.E.this;
      }

      /**
       * Generate an ... <strong>IF indexOnMapValue < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.E Lt(final Map<Integer, String> indexOnMapValue) {
        boundValues.add(indexOnMapValue);
        encodedValues.add(meta.indexOnMapValue.encodeFromJava(indexOnMapValue, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.lt("indexonmapvalue", QueryBuilder.bindMarker("indexonmapvalue")));
        return EntityWithIndicesForJSON_Update.E.this;
      }

      /**
       * Generate an ... <strong>IF indexOnMapValue <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.E Lte(final Map<Integer, String> indexOnMapValue) {
        boundValues.add(indexOnMapValue);
        encodedValues.add(meta.indexOnMapValue.encodeFromJava(indexOnMapValue, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.lte("indexonmapvalue", QueryBuilder.bindMarker("indexonmapvalue")));
        return EntityWithIndicesForJSON_Update.E.this;
      }

      /**
       * Generate an  ... <strong>IF indexOnMapValue != ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.E NotEq(final Map<Integer, String> indexOnMapValue) {
        boundValues.add(indexOnMapValue);
        encodedValues.add(meta.indexOnMapValue.encodeFromJava(indexOnMapValue, Optional.of(cassandraOptions)));
        where.onlyIf(NotEq.of("indexonmapvalue", QueryBuilder.bindMarker("indexonmapvalue")));
        return EntityWithIndicesForJSON_Update.E.this;
      }

      /**
       * Generate an ... <strong>IF indexOnMapValue = fromJson(?)</strong> */
      public final EntityWithIndicesForJSON_Update.E Eq_FromJSON(final String indexOnMapValue) {
        boundValues.add(indexOnMapValue);
        encodedValues.add(indexOnMapValue);
        where.onlyIf(QueryBuilder.eq("indexonmapvalue", QueryBuilder.fromJson(QueryBuilder.bindMarker("indexonmapvalue"))));
        return EntityWithIndicesForJSON_Update.E.this;
      }
    }

    public final class If_IndexOnMapEntry {
      /**
       * Generate an ... <strong>IF indexOnMapEntry = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.E Eq(final Map<Integer, String> indexOnMapEntry) {
        boundValues.add(indexOnMapEntry);
        encodedValues.add(meta.indexOnMapEntry.encodeFromJava(indexOnMapEntry, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.eq("indexonmapentry", QueryBuilder.bindMarker("indexonmapentry")));
        return EntityWithIndicesForJSON_Update.E.this;
      }

      /**
       * Generate an ... <strong>IF indexOnMapEntry > ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.E Gt(final Map<Integer, String> indexOnMapEntry) {
        boundValues.add(indexOnMapEntry);
        encodedValues.add(meta.indexOnMapEntry.encodeFromJava(indexOnMapEntry, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.gt("indexonmapentry", QueryBuilder.bindMarker("indexonmapentry")));
        return EntityWithIndicesForJSON_Update.E.this;
      }

      /**
       * Generate an ... <strong>IF indexOnMapEntry >= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.E Gte(final Map<Integer, String> indexOnMapEntry) {
        boundValues.add(indexOnMapEntry);
        encodedValues.add(meta.indexOnMapEntry.encodeFromJava(indexOnMapEntry, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.gte("indexonmapentry", QueryBuilder.bindMarker("indexonmapentry")));
        return EntityWithIndicesForJSON_Update.E.this;
      }

      /**
       * Generate an ... <strong>IF indexOnMapEntry < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.E Lt(final Map<Integer, String> indexOnMapEntry) {
        boundValues.add(indexOnMapEntry);
        encodedValues.add(meta.indexOnMapEntry.encodeFromJava(indexOnMapEntry, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.lt("indexonmapentry", QueryBuilder.bindMarker("indexonmapentry")));
        return EntityWithIndicesForJSON_Update.E.this;
      }

      /**
       * Generate an ... <strong>IF indexOnMapEntry <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.E Lte(final Map<Integer, String> indexOnMapEntry) {
        boundValues.add(indexOnMapEntry);
        encodedValues.add(meta.indexOnMapEntry.encodeFromJava(indexOnMapEntry, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.lte("indexonmapentry", QueryBuilder.bindMarker("indexonmapentry")));
        return EntityWithIndicesForJSON_Update.E.this;
      }

      /**
       * Generate an  ... <strong>IF indexOnMapEntry != ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithIndicesForJSON_Update.E NotEq(final Map<Integer, String> indexOnMapEntry) {
        boundValues.add(indexOnMapEntry);
        encodedValues.add(meta.indexOnMapEntry.encodeFromJava(indexOnMapEntry, Optional.of(cassandraOptions)));
        where.onlyIf(NotEq.of("indexonmapentry", QueryBuilder.bindMarker("indexonmapentry")));
        return EntityWithIndicesForJSON_Update.E.this;
      }

      /**
       * Generate an ... <strong>IF indexOnMapEntry = fromJson(?)</strong> */
      public final EntityWithIndicesForJSON_Update.E Eq_FromJSON(final String indexOnMapEntry) {
        boundValues.add(indexOnMapEntry);
        encodedValues.add(indexOnMapEntry);
        where.onlyIf(QueryBuilder.eq("indexonmapentry", QueryBuilder.fromJson(QueryBuilder.bindMarker("indexonmapentry"))));
        return EntityWithIndicesForJSON_Update.E.this;
      }
    }
  }
}
