package info.archinnov.achilles.generated.dsl;

import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.NotEq;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import info.archinnov.achilles.generated.meta.entity.EntityWithNoKeyspaceUDT_AchillesMeta;
import info.archinnov.achilles.internals.dsl.query.delete.AbstractDelete;
import info.archinnov.achilles.internals.dsl.query.delete.AbstractDeleteColumns;
import info.archinnov.achilles.internals.dsl.query.delete.AbstractDeleteEnd;
import info.archinnov.achilles.internals.dsl.query.delete.AbstractDeleteFrom;
import info.archinnov.achilles.internals.dsl.query.delete.AbstractDeleteWhere;
import info.archinnov.achilles.internals.dsl.query.delete.AbstractDeleteWherePartition;
import info.archinnov.achilles.internals.entities.EntityWithNoKeyspaceUDT;
import info.archinnov.achilles.internals.entities.NoKeyspaceUDT;
import info.archinnov.achilles.internals.metamodel.AbstractEntityProperty;
import info.archinnov.achilles.internals.options.CassandraOptions;
import info.archinnov.achilles.internals.runtime.RuntimeEngine;
import info.archinnov.achilles.type.SchemaNameProvider;
import info.archinnov.achilles.validation.Validator;
import java.lang.Class;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;

public final class EntityWithNoKeyspaceUDT_Delete extends AbstractDelete {
  protected final EntityWithNoKeyspaceUDT_AchillesMeta meta;

  protected final Class<EntityWithNoKeyspaceUDT> entityClass = EntityWithNoKeyspaceUDT.class;

  public EntityWithNoKeyspaceUDT_Delete(RuntimeEngine rte, EntityWithNoKeyspaceUDT_AchillesMeta meta) {
    super(rte);
    this.meta = meta;
  }

  /**
   * Generate DELETE <strong>udt</strong> ... */
  public final EntityWithNoKeyspaceUDT_Delete.Cols udt() {
    delete.column("udt");
    return new EntityWithNoKeyspaceUDT_Delete.Cols(delete);
  }

  /**
   * Generate ... * FROM ... */
  public final EntityWithNoKeyspaceUDT_Delete.F allColumns_FromBaseTable() {
    final Delete.Where where = delete.all().from(meta.getKeyspace().orElse("unknown_keyspace_for_" + meta.entityClass.getCanonicalName()), meta.getTableOrViewName()).where();
    return new EntityWithNoKeyspaceUDT_Delete.F(where, new CassandraOptions());
  }

  /**
   * Generate ... * FROM ... using the given SchemaNameProvider */
  public final EntityWithNoKeyspaceUDT_Delete.F allColumns_From(final SchemaNameProvider schemaNameProvider) {
    final String currentKeyspace = lookupKeyspace(schemaNameProvider, meta.entityClass);
    final String currentTable = lookupTable(schemaNameProvider, meta.entityClass);
    final Delete.Where where = delete.all().from(currentKeyspace, currentTable).where();
    return new EntityWithNoKeyspaceUDT_Delete.F(where, CassandraOptions.withSchemaNameProvider(schemaNameProvider));
  }

  public class Cols extends AbstractDeleteColumns {
    Cols(Delete.Selection deleteColumns) {
      super(deleteColumns);
    }

    /**
     * Generate DELETE <strong>udt</strong> ... */
    public final EntityWithNoKeyspaceUDT_Delete.Cols udt() {
      delete.column("udt");
      return this;
    }

    /**
     * Generate a ... <strong>FROM xxx</strong> ...  */
    public final EntityWithNoKeyspaceUDT_Delete.F fromBaseTable() {
      final Delete.Where where = deleteColumns.from(meta.getKeyspace().orElse("unknown_keyspace_for_" + meta.entityClass.getCanonicalName()), meta.getTableOrViewName()).where();
      return new EntityWithNoKeyspaceUDT_Delete.F(where, new CassandraOptions());
    }

    /**
     * Generate a ... <strong>FROM xxx</strong> ... using the given SchemaNameProvider */
    public final EntityWithNoKeyspaceUDT_Delete.F from(final SchemaNameProvider schemaNameProvider) {
      final String currentKeyspace = lookupKeyspace(schemaNameProvider, meta.entityClass);
      final String currentTable = lookupTable(schemaNameProvider, meta.entityClass);
      final Delete.Where where = deleteColumns.from(currentKeyspace, currentTable).where();
      return new EntityWithNoKeyspaceUDT_Delete.F(where, CassandraOptions.withSchemaNameProvider(schemaNameProvider));
    }
  }

  public class F extends AbstractDeleteFrom {
    F(Delete.Where where, CassandraOptions cassandraOptions) {
      super(where, cassandraOptions);
    }

    public final EntityWithNoKeyspaceUDT_Delete.W_Id where() {
      return new EntityWithNoKeyspaceUDT_Delete.W_Id(where, cassandraOptions);
    }
  }

  public final class W_Id extends AbstractDeleteWherePartition {
    public W_Id(Delete.Where where, CassandraOptions cassandraOptions) {
      super(where, cassandraOptions);
    }

    public final EntityWithNoKeyspaceUDT_Delete.W_Id.Relation id() {
      return new EntityWithNoKeyspaceUDT_Delete.W_Id.Relation();
    }

    public final class Relation {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>id = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithNoKeyspaceUDT_Delete.W_Clust Eq(Long id) {
        where.and(QueryBuilder.eq("id", QueryBuilder.bindMarker("id")));
        boundValues.add(id);
        encodedValues.add(meta.id.encodeFromJava(id, Optional.of(cassandraOptions)));
        return new EntityWithNoKeyspaceUDT_Delete.W_Clust(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>id IN ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithNoKeyspaceUDT_Delete.W_Clust IN(Long... id) {
        Validator.validateTrue(ArrayUtils.isNotEmpty(id), "Varargs for field '%s' should not be null/empty", "id");
        where.and(QueryBuilder.in("id",QueryBuilder.bindMarker("id")));
        final List<Object> varargs = Arrays.<Object>asList((Object[])id);
        final List<Object> encodedVarargs = Arrays.<Long>stream((Long[])id).map(x -> meta.id.encodeFromJava(x, Optional.of(cassandraOptions))).collect(Collectors.toList());
        boundValues.add(varargs);
        encodedValues.add(encodedVarargs);
        return new EntityWithNoKeyspaceUDT_Delete.W_Clust(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>id  = fromJson(?) </strong> */
      public final EntityWithNoKeyspaceUDT_Delete.W_Clust Eq_FromJson(String id) {
        where.and(QueryBuilder.eq("id", QueryBuilder.fromJson(QueryBuilder.bindMarker("id"))));
        boundValues.add(id);
        encodedValues.add(id);
        return new EntityWithNoKeyspaceUDT_Delete.W_Clust(where, cassandraOptions);
      }
    }
  }

  public final class W_Clust extends AbstractDeleteWhere {
    public W_Clust(Delete.Where where, CassandraOptions cassandraOptions) {
      super(where, cassandraOptions);
    }

    public final EntityWithNoKeyspaceUDT_Delete.W_Clust.Relation clust() {
      return new EntityWithNoKeyspaceUDT_Delete.W_Clust.Relation();
    }

    public final class Relation {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithNoKeyspaceUDT_Delete.E Eq(NoKeyspaceUDT clust) {
        where.and(QueryBuilder.eq("clust", QueryBuilder.bindMarker("clust")));
        boundValues.add(clust);
        encodedValues.add(meta.clust.encodeFromJava(clust, Optional.of(cassandraOptions)));
        return new EntityWithNoKeyspaceUDT_Delete.E(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust  = fromJson(?) </strong> */
      public final EntityWithNoKeyspaceUDT_Delete.E Eq_FromJson(String clust) {
        where.and(QueryBuilder.eq("clust", QueryBuilder.fromJson(QueryBuilder.bindMarker("clust"))));
        boundValues.add(clust);
        encodedValues.add(clust);
        return new EntityWithNoKeyspaceUDT_Delete.E(where, cassandraOptions);
      }
    }
  }

  public final class E extends AbstractDeleteEnd<EntityWithNoKeyspaceUDT_Delete.E, EntityWithNoKeyspaceUDT> {
    public E(Delete.Where where, CassandraOptions cassandraOptions) {
      super(where, cassandraOptions);
    }

    @Override
    protected final Class<EntityWithNoKeyspaceUDT> getEntityClass() {
      return entityClass;
    }

    @Override
    protected final AbstractEntityProperty<EntityWithNoKeyspaceUDT> getMetaInternal() {
      return meta;
    }

    @Override
    protected final RuntimeEngine getRte() {
      return rte;
    }

    @Override
    protected final CassandraOptions getOptions() {
      return cassandraOptions;
    }

    @Override
    protected final List<Object> getBoundValuesInternal() {
      return boundValues;
    }

    @Override
    protected final List<Object> getEncodedValuesInternal() {
      return encodedValues;
    }

    @Override
    protected final EntityWithNoKeyspaceUDT_Delete.E getThis() {
      return this;
    }

    public final E.If_Udt if_Udt() {
      return new E.If_Udt();
    }

    public final class If_Udt {
      /**
       * Generate an ... <strong>IF udt = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithNoKeyspaceUDT_Delete.E Eq(final NoKeyspaceUDT udt) {
        boundValues.add(udt);
        encodedValues.add(meta.udt.encodeFromJava(udt, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.eq("udt", QueryBuilder.bindMarker("udt")));
        return EntityWithNoKeyspaceUDT_Delete.E.this;
      }

      /**
       * Generate an ... <strong>IF udt > ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithNoKeyspaceUDT_Delete.E Gt(final NoKeyspaceUDT udt) {
        boundValues.add(udt);
        encodedValues.add(meta.udt.encodeFromJava(udt, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.gt("udt", QueryBuilder.bindMarker("udt")));
        return EntityWithNoKeyspaceUDT_Delete.E.this;
      }

      /**
       * Generate an ... <strong>IF udt >= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithNoKeyspaceUDT_Delete.E Gte(final NoKeyspaceUDT udt) {
        boundValues.add(udt);
        encodedValues.add(meta.udt.encodeFromJava(udt, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.gte("udt", QueryBuilder.bindMarker("udt")));
        return EntityWithNoKeyspaceUDT_Delete.E.this;
      }

      /**
       * Generate an ... <strong>IF udt < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithNoKeyspaceUDT_Delete.E Lt(final NoKeyspaceUDT udt) {
        boundValues.add(udt);
        encodedValues.add(meta.udt.encodeFromJava(udt, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.lt("udt", QueryBuilder.bindMarker("udt")));
        return EntityWithNoKeyspaceUDT_Delete.E.this;
      }

      /**
       * Generate an ... <strong>IF udt <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithNoKeyspaceUDT_Delete.E Lte(final NoKeyspaceUDT udt) {
        boundValues.add(udt);
        encodedValues.add(meta.udt.encodeFromJava(udt, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.lte("udt", QueryBuilder.bindMarker("udt")));
        return EntityWithNoKeyspaceUDT_Delete.E.this;
      }

      /**
       * Generate an  ... <strong>IF udt != ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithNoKeyspaceUDT_Delete.E NotEq(final NoKeyspaceUDT udt) {
        boundValues.add(udt);
        encodedValues.add(meta.udt.encodeFromJava(udt, Optional.of(cassandraOptions)));
        where.onlyIf(NotEq.of("udt", QueryBuilder.bindMarker("udt")));
        return EntityWithNoKeyspaceUDT_Delete.E.this;
      }

      /**
       * Generate an ... <strong>IF udt = fromJson(?)</strong> */
      public final EntityWithNoKeyspaceUDT_Delete.E Eq_FromJSON(final String udt) {
        boundValues.add(udt);
        encodedValues.add(udt);
        where.onlyIf(QueryBuilder.eq("udt", QueryBuilder.fromJson(QueryBuilder.bindMarker("udt"))));
        return EntityWithNoKeyspaceUDT_Delete.E.this;
      }
    }
  }
}
