package info.archinnov.achilles.generated.dsl;

import com.datastax.driver.core.querybuilder.NonEscapingSetAssignment;
import com.datastax.driver.core.querybuilder.NotEq;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Update;
import info.archinnov.achilles.generated.meta.entity.EntityWithNoKeyspaceUDT_AchillesMeta;
import info.archinnov.achilles.internals.dsl.query.update.AbstractUpdate;
import info.archinnov.achilles.internals.dsl.query.update.AbstractUpdateColumns;
import info.archinnov.achilles.internals.dsl.query.update.AbstractUpdateEnd;
import info.archinnov.achilles.internals.dsl.query.update.AbstractUpdateFrom;
import info.archinnov.achilles.internals.dsl.query.update.AbstractUpdateWhere;
import info.archinnov.achilles.internals.entities.EntityWithNoKeyspaceUDT;
import info.archinnov.achilles.internals.entities.NoKeyspaceUDT;
import info.archinnov.achilles.internals.metamodel.AbstractEntityProperty;
import info.archinnov.achilles.internals.options.CassandraOptions;
import info.archinnov.achilles.internals.runtime.RuntimeEngine;
import info.archinnov.achilles.type.SchemaNameProvider;
import info.archinnov.achilles.validation.Validator;
import java.lang.Class;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;

public final class EntityWithNoKeyspaceUDT_Update extends AbstractUpdate {
  protected final EntityWithNoKeyspaceUDT_AchillesMeta meta;

  protected final Class<EntityWithNoKeyspaceUDT> entityClass = EntityWithNoKeyspaceUDT.class;

  public EntityWithNoKeyspaceUDT_Update(RuntimeEngine rte, EntityWithNoKeyspaceUDT_AchillesMeta meta) {
    super(rte);
    this.meta = meta;
  }

  /**
   * Generate an UPDATE <strong>FROM</strong> ... */
  public final EntityWithNoKeyspaceUDT_Update.F fromBaseTable() {
    final String currentKeyspace = meta.getKeyspace().orElse("unknown_keyspace_for_" + meta.entityClass.getCanonicalName());
    final Update.Where where = QueryBuilder.update(currentKeyspace, meta.getTableOrViewName()).where();
    return new EntityWithNoKeyspaceUDT_Update.F(where, new CassandraOptions());
  }

  /**
   * Generate an UPDATE <strong>FROM</strong> ... using the given SchemaNameProvider */
  public final EntityWithNoKeyspaceUDT_Update.F from(final SchemaNameProvider schemaNameProvider) {
    final String currentKeyspace = lookupKeyspace(schemaNameProvider, meta.entityClass);
    final String currentTable = lookupTable(schemaNameProvider, meta.entityClass);
    final Update.Where where = QueryBuilder.update(currentKeyspace, currentTable).where();
    return new EntityWithNoKeyspaceUDT_Update.F(where, CassandraOptions.withSchemaNameProvider(schemaNameProvider));
  }

  public class Cols extends AbstractUpdateColumns {
    Cols(Update.Where where, CassandraOptions cassandraOptions) {
      super(where, cassandraOptions);
    }

    public final Cols.Udt udt() {
      return new Cols.Udt();
    }

    public final EntityWithNoKeyspaceUDT_Update.W_Id where() {
      return new EntityWithNoKeyspaceUDT_Update.W_Id(where, cassandraOptions);
    }

    public final class Udt {
      /**
       * Generate an UPDATE FROM ... <strong>SET udt = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithNoKeyspaceUDT_Update.Cols Set(final NoKeyspaceUDT udt) {
        where.with(NonEscapingSetAssignment.of("udt", QueryBuilder.bindMarker("udt")));
        boundValues.add(udt);
        encodedValues.add(meta.udt.encodeFromJava(udt, Optional.of(cassandraOptions)));
        return EntityWithNoKeyspaceUDT_Update.Cols.this;
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET udt = fromJson(?)</strong> */
      public final EntityWithNoKeyspaceUDT_Update.Cols Set_FromJSON(final String udt_element) {
        where.with(NonEscapingSetAssignment.of("udt", QueryBuilder.fromJson(QueryBuilder.bindMarker("udt"))));
        boundValues.add(udt_element);
        encodedValues.add(udt_element);
        return EntityWithNoKeyspaceUDT_Update.Cols.this;
      }
    }
  }

  public class F extends AbstractUpdateFrom {
    F(Update.Where where, CassandraOptions cassandraOptions) {
      super(where, cassandraOptions);
    }

    public final F.Udt udt() {
      return new F.Udt();
    }

    public final class Udt {
      /**
       * Generate an UPDATE FROM ... <strong>SET udt = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithNoKeyspaceUDT_Update.Cols Set(final NoKeyspaceUDT udt) {
        where.with(NonEscapingSetAssignment.of("udt", QueryBuilder.bindMarker("udt")));
        boundValues.add(udt);
        encodedValues.add(meta.udt.encodeFromJava(udt, Optional.of(cassandraOptions)));
        return new EntityWithNoKeyspaceUDT_Update.Cols(where, cassandraOptions);
      }

      /**
       * Generate an UPDATE FROM ... <strong>SET udt = fromJson(?)</strong> */
      public final EntityWithNoKeyspaceUDT_Update.Cols Set_FromJSON(final String udt_element) {
        where.with(NonEscapingSetAssignment.of("udt", QueryBuilder.fromJson(QueryBuilder.bindMarker("udt"))));
        boundValues.add(udt_element);
        encodedValues.add(udt_element);
        return new EntityWithNoKeyspaceUDT_Update.Cols(where, cassandraOptions);
      }
    }
  }

  public final class W_Id extends AbstractUpdateWhere {
    public W_Id(Update.Where where, CassandraOptions cassandraOptions) {
      super(where, cassandraOptions);
    }

    public final EntityWithNoKeyspaceUDT_Update.W_Id.Relation id() {
      return new EntityWithNoKeyspaceUDT_Update.W_Id.Relation();
    }

    public final class Relation {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>id = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithNoKeyspaceUDT_Update.W_Clust Eq(Long id) {
        where.and(QueryBuilder.eq("id", QueryBuilder.bindMarker("id")));
        boundValues.add(id);
        encodedValues.add(meta.id.encodeFromJava(id, Optional.of(cassandraOptions)));
        return new EntityWithNoKeyspaceUDT_Update.W_Clust(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>id IN ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithNoKeyspaceUDT_Update.W_Clust IN(Long... id) {
        Validator.validateTrue(ArrayUtils.isNotEmpty(id), "Varargs for field '%s' should not be null/empty", "id");
        where.and(QueryBuilder.in("id",QueryBuilder.bindMarker("id")));
        final List<Object> varargs = Arrays.<Object>asList((Object[])id);
        final List<Object> encodedVarargs = Arrays.<Long>stream((Long[])id).map(x -> meta.id.encodeFromJava(x, Optional.of(cassandraOptions))).collect(Collectors.toList());
        boundValues.add(varargs);
        encodedValues.add(encodedVarargs);
        return new EntityWithNoKeyspaceUDT_Update.W_Clust(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>id  = fromJson(?) </strong> */
      public final EntityWithNoKeyspaceUDT_Update.W_Clust Eq_FromJson(String id) {
        where.and(QueryBuilder.eq("id", QueryBuilder.fromJson(QueryBuilder.bindMarker("id"))));
        boundValues.add(id);
        encodedValues.add(id);
        return new EntityWithNoKeyspaceUDT_Update.W_Clust(where, cassandraOptions);
      }
    }
  }

  public final class W_Clust extends AbstractUpdateWhere {
    public W_Clust(Update.Where where, CassandraOptions cassandraOptions) {
      super(where, cassandraOptions);
    }

    public final EntityWithNoKeyspaceUDT_Update.W_Clust.Relation clust() {
      return new EntityWithNoKeyspaceUDT_Update.W_Clust.Relation();
    }

    public final class Relation {
      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithNoKeyspaceUDT_Update.E Eq(NoKeyspaceUDT clust) {
        where.and(QueryBuilder.eq("clust", QueryBuilder.bindMarker("clust")));
        boundValues.add(clust);
        encodedValues.add(meta.clust.encodeFromJava(clust, Optional.of(cassandraOptions)));
        return new EntityWithNoKeyspaceUDT_Update.E(where, cassandraOptions);
      }

      /**
       * Generate a SELECT ... FROM ... WHERE ... <strong>clust  = fromJson(?) </strong> */
      public final EntityWithNoKeyspaceUDT_Update.E Eq_FromJson(String clust) {
        where.and(QueryBuilder.eq("clust", QueryBuilder.fromJson(QueryBuilder.bindMarker("clust"))));
        boundValues.add(clust);
        encodedValues.add(clust);
        return new EntityWithNoKeyspaceUDT_Update.E(where, cassandraOptions);
      }
    }
  }

  public final class E extends AbstractUpdateEnd<EntityWithNoKeyspaceUDT_Update.E, EntityWithNoKeyspaceUDT> {
    public E(Update.Where where, CassandraOptions cassandraOptions) {
      super(where, cassandraOptions);
    }

    @Override
    protected final Class<EntityWithNoKeyspaceUDT> getEntityClass() {
      return entityClass;
    }

    @Override
    protected final AbstractEntityProperty<EntityWithNoKeyspaceUDT> getMetaInternal() {
      return meta;
    }

    @Override
    protected final RuntimeEngine getRte() {
      return rte;
    }

    @Override
    protected final CassandraOptions getOptions() {
      return cassandraOptions;
    }

    @Override
    protected final List<Object> getBoundValuesInternal() {
      return boundValues;
    }

    @Override
    protected final List<Object> getEncodedValuesInternal() {
      return encodedValues;
    }

    @Override
    protected final EntityWithNoKeyspaceUDT_Update.E getThis() {
      return this;
    }

    public final E.If_Udt if_Udt() {
      return new E.If_Udt();
    }

    public final class If_Udt {
      /**
       * Generate an ... <strong>IF udt = ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithNoKeyspaceUDT_Update.E Eq(final NoKeyspaceUDT udt) {
        boundValues.add(udt);
        encodedValues.add(meta.udt.encodeFromJava(udt, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.eq("udt", QueryBuilder.bindMarker("udt")));
        return EntityWithNoKeyspaceUDT_Update.E.this;
      }

      /**
       * Generate an ... <strong>IF udt > ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithNoKeyspaceUDT_Update.E Gt(final NoKeyspaceUDT udt) {
        boundValues.add(udt);
        encodedValues.add(meta.udt.encodeFromJava(udt, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.gt("udt", QueryBuilder.bindMarker("udt")));
        return EntityWithNoKeyspaceUDT_Update.E.this;
      }

      /**
       * Generate an ... <strong>IF udt >= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithNoKeyspaceUDT_Update.E Gte(final NoKeyspaceUDT udt) {
        boundValues.add(udt);
        encodedValues.add(meta.udt.encodeFromJava(udt, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.gte("udt", QueryBuilder.bindMarker("udt")));
        return EntityWithNoKeyspaceUDT_Update.E.this;
      }

      /**
       * Generate an ... <strong>IF udt < ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithNoKeyspaceUDT_Update.E Lt(final NoKeyspaceUDT udt) {
        boundValues.add(udt);
        encodedValues.add(meta.udt.encodeFromJava(udt, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.lt("udt", QueryBuilder.bindMarker("udt")));
        return EntityWithNoKeyspaceUDT_Update.E.this;
      }

      /**
       * Generate an ... <strong>IF udt <= ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithNoKeyspaceUDT_Update.E Lte(final NoKeyspaceUDT udt) {
        boundValues.add(udt);
        encodedValues.add(meta.udt.encodeFromJava(udt, Optional.of(cassandraOptions)));
        where.onlyIf(QueryBuilder.lte("udt", QueryBuilder.bindMarker("udt")));
        return EntityWithNoKeyspaceUDT_Update.E.this;
      }

      /**
       * Generate an  ... <strong>IF udt != ?</strong> */
      @SuppressWarnings("static-access")
      public final EntityWithNoKeyspaceUDT_Update.E NotEq(final NoKeyspaceUDT udt) {
        boundValues.add(udt);
        encodedValues.add(meta.udt.encodeFromJava(udt, Optional.of(cassandraOptions)));
        where.onlyIf(NotEq.of("udt", QueryBuilder.bindMarker("udt")));
        return EntityWithNoKeyspaceUDT_Update.E.this;
      }

      /**
       * Generate an ... <strong>IF udt = fromJson(?)</strong> */
      public final EntityWithNoKeyspaceUDT_Update.E Eq_FromJSON(final String udt) {
        boundValues.add(udt);
        encodedValues.add(udt);
        where.onlyIf(QueryBuilder.eq("udt", QueryBuilder.fromJson(QueryBuilder.bindMarker("udt"))));
        return EntityWithNoKeyspaceUDT_Update.E.this;
      }
    }
  }
}
