package info.archinnov.achilles.generated.function;

import com.datastax.driver.core.querybuilder.QueryBuilder;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

/**
 * This class is the common registry for all registered user-defined functions */
public final class FunctionsRegistry {
  /**
   * Call "convertToLong" function with given parameters */
  public static final Long_Type convertToLong(final String_Type longValue) {
    final List<Object> params = new ArrayList<>();
    if (longValue.isFunctionCall()) {
      params.add(longValue.buildRecursive());
    } else {
      params.add(longValue.hasLiteralValue() ? longValue.getValue() : QueryBuilder.column((String)longValue.getValue()));
    }
    return new Long_Type(Optional.empty()) {
      @Override
      public boolean isFunctionCall() {
        return true;
      }

      @Override
      public String functionName() {
        return "convertToLong";
      }

      @Override
      public List<Object> parameters() {
        return params;
      }
    };
  }

  /**
   * Call "convertListToJson" function with given parameters */
  public static final String_Type convertListToJson(final List_Optional_String_Type strings) {
    final List<Object> params = new ArrayList<>();
    if (strings.isFunctionCall()) {
      params.add(strings.buildRecursive());
    } else {
      params.add(strings.hasLiteralValue() ? strings.getValue() : QueryBuilder.column((String)strings.getValue()));
    }
    return new String_Type(Optional.empty()) {
      @Override
      public boolean isFunctionCall() {
        return true;
      }

      @Override
      public String functionName() {
        return "convertListToJson";
      }

      @Override
      public List<Object> parameters() {
        return params;
      }
    };
  }

  /**
   * Call "convertConsistencyLevelList" function with given parameters */
  public static final String_Type convertConsistencyLevelList(final List_ConsistencyLevel_Type consistencyLevels) {
    final List<Object> params = new ArrayList<>();
    if (consistencyLevels.isFunctionCall()) {
      params.add(consistencyLevels.buildRecursive());
    } else {
      params.add(consistencyLevels.hasLiteralValue() ? consistencyLevels.getValue() : QueryBuilder.column((String)consistencyLevels.getValue()));
    }
    return new String_Type(Optional.empty()) {
      @Override
      public boolean isFunctionCall() {
        return true;
      }

      @Override
      public String functionName() {
        return "convertConsistencyLevelList";
      }

      @Override
      public List<Object> parameters() {
        return params;
      }
    };
  }

  /**
   * Call "stringifyComplexNestingMap" function with given parameters */
  public static final String_Type stringifyComplexNestingMap(final Map_TestUDT_Map_Integer_Tuple3_Integer_Integer_ConsistencyLevel_Type map) {
    final List<Object> params = new ArrayList<>();
    if (map.isFunctionCall()) {
      params.add(map.buildRecursive());
    } else {
      params.add(map.hasLiteralValue() ? map.getValue() : QueryBuilder.column((String)map.getValue()));
    }
    return new String_Type(Optional.empty()) {
      @Override
      public boolean isFunctionCall() {
        return true;
      }

      @Override
      public String functionName() {
        return "stringifyComplexNestingMap";
      }

      @Override
      public List<Object> parameters() {
        return params;
      }
    };
  }
}
