package info.archinnov.achilles.generated.manager;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import info.archinnov.achilles.generated.dsl.EntityForJSONCall_Delete;
import info.archinnov.achilles.generated.dsl.EntityForJSONCall_Select;
import info.archinnov.achilles.generated.dsl.EntityForJSONCall_Update;
import info.archinnov.achilles.generated.meta.entity.EntityForJSONCall_AchillesMeta;
import info.archinnov.achilles.internals.dsl.crud.DeleteByPartitionWithOptions;
import info.archinnov.achilles.internals.dsl.crud.DeleteWithOptions;
import info.archinnov.achilles.internals.dsl.crud.FindWithOptions;
import info.archinnov.achilles.internals.dsl.crud.InsertJSONWithOptions;
import info.archinnov.achilles.internals.dsl.crud.InsertWithOptions;
import info.archinnov.achilles.internals.dsl.crud.UpdateWithOptions;
import info.archinnov.achilles.internals.dsl.raw.NativeQuery;
import info.archinnov.achilles.internals.dsl.raw.TypedQuery;
import info.archinnov.achilles.internals.entities.EntityForJSONCall;
import info.archinnov.achilles.internals.options.CassandraOptions;
import info.archinnov.achilles.internals.runtime.AbstractManager;
import info.archinnov.achilles.internals.runtime.RuntimeEngine;
import info.archinnov.achilles.type.SchemaNameProvider;
import info.archinnov.achilles.validation.Validator;
import java.lang.Class;
import java.lang.Long;
import java.lang.Object;
import java.lang.String;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public final class EntityForJSONCall_Manager extends AbstractManager<EntityForJSONCall> {
  public final EntityForJSONCall_AchillesMeta meta;

  public EntityForJSONCall_Manager(final Class<EntityForJSONCall> entityClass, final EntityForJSONCall_AchillesMeta meta, final RuntimeEngine rte) {
    super(entityClass, meta, rte);
    this.meta = meta;
  }

  /**
   * Provide CRUD operations: <br/>
   * <ul>
   *    <li>FIND BY ID</li>
   *    <li>INSERT</li>
   *    <li>INSERT STATIC</li>
   *    <li>INSERT IF NOT EXISTS</li>
   *    <li>DELETE BY ID</li>
   *    <li>DELETE BY ID IF NOT EXISTS</li>
   *    <li>DELETE BY PARTITION</li>
   * </ul>
   */
  public final EntityForJSONCall_CRUD crud() {
    return new EntityForJSONCall_CRUD();
  }

  /**
   * Provide DSL methods: <br/>
   * <ul>
   *    <li>SELECT</li>
   *    <li>ITERATION ON SELECT</li>
   *    <li>UPDATE</li>
   *    <li>DELETE</li>
   * </ul>
   */
  public final EntityForJSONCall_DSL dsl() {
    return new EntityForJSONCall_DSL();
  }

  /**
   * Provide Raw query methods: <br/>
   * <ul>
   *    <li>Typed Queries (for SELECT only)</li>
   *    <li>Native Queries (for any kind of statement)</li>
   * </ul>
   */
  public final EntityForJSONCall_RAW_QUERY raw() {
    return new EntityForJSONCall_RAW_QUERY();
  }

  public final class EntityForJSONCall_CRUD {
    private Optional<CassandraOptions> cassandraOptions = Optional.empty();
    ;

    public EntityForJSONCall_Manager.EntityForJSONCall_CRUD withSchemaNameProvider(final SchemaNameProvider schemaNameProvider) {
      Validator.validateNotNull(schemaNameProvider,"The provided schemaNameProvider should not be null");
      this.cassandraOptions = Optional.of(CassandraOptions.withSchemaNameProvider(schemaNameProvider));
      return this;
    }

    /**
     * Find an entity by its complete primary key@param id partition key 'id'@param clust clustering column 'clust'@return FindWithOptions<EntityForJSONCall> */
    public FindWithOptions<EntityForJSONCall> findById(final Long id, final Long clust) {
      List<Object> keys = new ArrayList<>();
      List<Object> encodedKeys = new ArrayList<>();
      Validator.validateNotNull(id, "Partition key '%s' should not be null", "id");
      keys.add(id);
      encodedKeys.add(EntityForJSONCall_AchillesMeta.id.encodeFromJava(id, cassandraOptions));
      Validator.validateNotNull(clust, "Partition key '%s' should not be null", "clust");
      keys.add(clust);
      encodedKeys.add(EntityForJSONCall_AchillesMeta.clust.encodeFromJava(clust, cassandraOptions));
      final Object[] primaryKeyValues = keys.toArray();
      final Object[] encodedPrimaryKeyValues = encodedKeys.toArray();
      return new FindWithOptions<EntityForJSONCall>(entityClass, meta, rte, primaryKeyValues, encodedPrimaryKeyValues, cassandraOptions);
    }

    /**
     * Delete an entity instance by extracting its primary keyRemark: <strong>Achilles will throw an exception if any column being part of the primary key is NULL</strong>@param an instance of EntityForJSONCall to be delete@return DeleteWithOptions<EntityForJSONCall> */
    public DeleteWithOptions<EntityForJSONCall> delete(final EntityForJSONCall instance) {
      return deleteInternal(instance, cassandraOptions);
    }

    /**
     * Delete an entity using its complete primary key@param id partition key 'id'@param clust clustering column 'clust'@return DeleteWithOptions<EntityForJSONCall> */
    public DeleteWithOptions<EntityForJSONCall> deleteById(final Long id, final Long clust) {
      List<Object> keys = new ArrayList<>();
      List<Object> encodedKeys = new ArrayList<>();
      Validator.validateNotNull(id, "Partition key '%s' should not be null", "id");
      keys.add(id);
      encodedKeys.add(EntityForJSONCall_AchillesMeta.id.encodeFromJava(id, cassandraOptions));
      Validator.validateNotNull(clust, "Partition key '%s' should not be null", "clust");
      keys.add(clust);
      encodedKeys.add(EntityForJSONCall_AchillesMeta.clust.encodeFromJava(clust, cassandraOptions));
      final Object[] partitionKeysValues = keys.toArray();
      final Object[] encodedPartitionKeyValues = encodedKeys.toArray();
      return new DeleteWithOptions<EntityForJSONCall>(entityClass, meta, rte, partitionKeysValues, encodedPartitionKeyValues, Optional.empty(), cassandraOptions);
    }

    /**
     * Insert this entity
     *
     * @param instance an instance of EntityForJSONCall
     * @return InsertWithOptions<EntityForJSONCall> */
    public final InsertWithOptions<EntityForJSONCall> insert(final EntityForJSONCall instance) {
      return insertInternal(instance, false, cassandraOptions);
    }

    /**
     * Update the cassandra table with <strong>NOT NULL</strong> fields extracted from this entity
     *
     * @param instance an instance of EntityForJSONCall
     * @return InsertWithOptions<EntityForJSONCall> */
    public final UpdateWithOptions<EntityForJSONCall> update(final EntityForJSONCall instance) {
      return updateInternal(instance, false, cassandraOptions);
    }

    /**
     * Delete a whole partition using the partition key@param id partition key 'id'@return DeleteByPartitionWithOptions<EntityForJSONCall> */
    public DeleteByPartitionWithOptions<EntityForJSONCall> deleteByPartitionKeys(final Long id) {
      List<Object> keys = new ArrayList<>();
      List<Object> encodedKeys = new ArrayList<>();
      Validator.validateNotNull(id, "Partition key '%s' should not be null", "id");
      keys.add(id);
      encodedKeys.add(EntityForJSONCall_AchillesMeta.id.encodeFromJava(id, cassandraOptions));
      final Object[] partitionKeys = keys.toArray();
      final Object[] encodedPartitionKeys = encodedKeys.toArray();
      return new DeleteByPartitionWithOptions<EntityForJSONCall>(meta, rte, partitionKeys, encodedPartitionKeys, cassandraOptions);
    }

    /**
     * Insert using a JSON payload
     *
     * @json the JSON string representing an instance of EntityForJSONCall
     * @return InsertJSONWithOptions */
    public final InsertJSONWithOptions insertJSON(final String json) {
      return insertJSONInternal(json, cassandraOptions);
    }
  }

  public final class EntityForJSONCall_DSL {
    /**
     * Generate a <strong>SELECT</strong> statement@return EntityForJSONCall_Select */
    public final EntityForJSONCall_Select select() {
      return new EntityForJSONCall_Select(rte, meta);
    }

    /**
     * Generate a <strong>DELETE</strong> statement@return EntityForJSONCall_Delete */
    public final EntityForJSONCall_Delete delete() {
      return new EntityForJSONCall_Delete(rte, meta);
    }

    /**
     * Generate an <strong>UPDATE</strong> statement@return EntityForJSONCall_Update */
    public final EntityForJSONCall_Update update() {
      return new EntityForJSONCall_Update(rte, meta);
    }
  }

  public final class EntityForJSONCall_RAW_QUERY {
    /**
     * Execute the bound statement and map the result back into an instance of EntityForJSONCall <br/>
     * Remark: the bound statement should be a <strong>SELECT</strong> statement@param boundStatement a bound statement@return TypedQuery<EntityForJSONCall> */
    public final TypedQuery<EntityForJSONCall> typedQueryForSelect(BoundStatement boundStatement) {
      return typedQueryForSelectInternal(boundStatement);
    }

    /**
     * Execute the prepared statement and map the result back into an instance of EntityForJSONCall <br/>
     * Remark: the prepared statement should be a <strong>SELECT</strong> statement@param preparedStatement a prepared statement@return TypedQuery<EntityForJSONCall> */
    public final TypedQuery<EntityForJSONCall> typedQueryForSelect(PreparedStatement preparedStatement, Object... encodedBoundValues) {
      return typedQueryForSelectInternal(preparedStatement, encodedBoundValues);
    }

    /**
     * Execute the regular statement and map the result back into an instance of EntityForJSONCall <br/>
     * Remark: the regular statement should be a <strong>SELECT</strong> statement@param regularStatement a regular statement@return TypedQuery<EntityForJSONCall> */
    public final TypedQuery<EntityForJSONCall> typedQueryForSelect(RegularStatement regularStatement, Object... encodedBoundValues) {
      return typedQueryForSelectInternal(regularStatement, encodedBoundValues);
    }

    /**
     * Execute the native bound statement@param boundStatement a bound statement@return NativeQuery */
    public final NativeQuery nativeQuery(BoundStatement boundStatement) {
      return nativeQueryInternal(boundStatement);
    }

    /**
     * Execute the native prepared statement@param preparedStatement a prepared statement@return NativeQuery */
    public final NativeQuery nativeQuery(PreparedStatement preparedStatement, Object... encodedBoundValues) {
      return nativeQueryInternal(preparedStatement, encodedBoundValues);
    }

    /**
     * Execute the native regular statement@param regularStatement a regular statement@return NativeQuery */
    public final NativeQuery nativeQuery(RegularStatement regularStatement, Object... encodedBoundValues) {
      return nativeQueryInternal(regularStatement, encodedBoundValues);
    }
  }
}
