package info.archinnov.achilles.generated.manager;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import info.archinnov.achilles.generated.dsl.EntityWithIndicesForJSON_Delete;
import info.archinnov.achilles.generated.dsl.EntityWithIndicesForJSON_Select;
import info.archinnov.achilles.generated.dsl.EntityWithIndicesForJSON_SelectIndex;
import info.archinnov.achilles.generated.dsl.EntityWithIndicesForJSON_Update;
import info.archinnov.achilles.generated.meta.entity.EntityWithIndicesForJSON_AchillesMeta;
import info.archinnov.achilles.internals.dsl.crud.DeleteByPartitionWithOptions;
import info.archinnov.achilles.internals.dsl.crud.DeleteWithOptions;
import info.archinnov.achilles.internals.dsl.crud.FindWithOptions;
import info.archinnov.achilles.internals.dsl.crud.InsertJSONWithOptions;
import info.archinnov.achilles.internals.dsl.crud.InsertWithOptions;
import info.archinnov.achilles.internals.dsl.crud.UpdateWithOptions;
import info.archinnov.achilles.internals.dsl.raw.NativeQuery;
import info.archinnov.achilles.internals.dsl.raw.TypedQuery;
import info.archinnov.achilles.internals.entities.EntityWithIndicesForJSON;
import info.archinnov.achilles.internals.options.CassandraOptions;
import info.archinnov.achilles.internals.runtime.AbstractManager;
import info.archinnov.achilles.internals.runtime.RuntimeEngine;
import info.archinnov.achilles.type.SchemaNameProvider;
import info.archinnov.achilles.validation.Validator;
import java.lang.Class;
import java.lang.Long;
import java.lang.Object;
import java.lang.String;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public final class EntityWithIndicesForJSON_Manager extends AbstractManager<EntityWithIndicesForJSON> {
  public final EntityWithIndicesForJSON_AchillesMeta meta;

  public EntityWithIndicesForJSON_Manager(final Class<EntityWithIndicesForJSON> entityClass, final EntityWithIndicesForJSON_AchillesMeta meta, final RuntimeEngine rte) {
    super(entityClass, meta, rte);
    this.meta = meta;
  }

  /**
   * Provide CRUD operations: <br/>
   * <ul>
   *    <li>FIND BY ID</li>
   *    <li>INSERT</li>
   *    <li>INSERT STATIC</li>
   *    <li>INSERT IF NOT EXISTS</li>
   *    <li>DELETE BY ID</li>
   *    <li>DELETE BY ID IF NOT EXISTS</li>
   *    <li>DELETE BY PARTITION</li>
   * </ul>
   */
  public final EntityWithIndicesForJSON_CRUD crud() {
    return new EntityWithIndicesForJSON_CRUD();
  }

  /**
   * Provide DSL methods: <br/>
   * <ul>
   *    <li>SELECT</li>
   *    <li>ITERATION ON SELECT</li>
   *    <li>UPDATE</li>
   *    <li>DELETE</li>
   * </ul>
   */
  public final EntityWithIndicesForJSON_DSL dsl() {
    return new EntityWithIndicesForJSON_DSL();
  }

  /**
   * Provide Raw query methods: <br/>
   * <ul>
   *    <li>Typed Queries (for SELECT only)</li>
   *    <li>Native Queries (for any kind of statement)</li>
   * </ul>
   */
  public final EntityWithIndicesForJSON_RAW_QUERY raw() {
    return new EntityWithIndicesForJSON_RAW_QUERY();
  }

  /**
   * Provide INDEX query methods: <br/>
   * <ul>
   *    <li>SELECT</li>
   *    <li>ITERATION ON SELECT</li>
   * </ul>
   */
  public final EntityWithIndicesForJSON_INDEX indexed() {
    return new EntityWithIndicesForJSON_INDEX();
  }

  public final class EntityWithIndicesForJSON_INDEX {
    /**
     * Generate a <strong>SELECT</strong> statement@return EntityWithIndicesForJSON_SelectIndex */
    public final EntityWithIndicesForJSON_SelectIndex select() {
      return new EntityWithIndicesForJSON_SelectIndex(rte, meta);
    }
  }

  public final class EntityWithIndicesForJSON_CRUD {
    private Optional<CassandraOptions> cassandraOptions = Optional.empty();
    ;

    public EntityWithIndicesForJSON_Manager.EntityWithIndicesForJSON_CRUD withSchemaNameProvider(final SchemaNameProvider schemaNameProvider) {
      Validator.validateNotNull(schemaNameProvider,"The provided schemaNameProvider should not be null");
      this.cassandraOptions = Optional.of(CassandraOptions.withSchemaNameProvider(schemaNameProvider));
      return this;
    }

    /**
     * Find an entity by its complete primary key@param id partition key 'id'@param clust1 clustering column 'clust1'@param clust2 clustering column 'clust2'@param clust3 clustering column 'clust3'@return FindWithOptions<EntityWithIndicesForJSON> */
    public FindWithOptions<EntityWithIndicesForJSON> findById(final Long id, final int clust1, final int clust2, final String clust3) {
      List<Object> keys = new ArrayList<>();
      List<Object> encodedKeys = new ArrayList<>();
      Validator.validateNotNull(id, "Partition key '%s' should not be null", "id");
      keys.add(id);
      encodedKeys.add(EntityWithIndicesForJSON_AchillesMeta.id.encodeFromJava(id, cassandraOptions));
      Validator.validateNotNull(clust1, "Partition key '%s' should not be null", "clust1");
      keys.add(clust1);
      encodedKeys.add(EntityWithIndicesForJSON_AchillesMeta.clust1.encodeFromJava(clust1, cassandraOptions));
      Validator.validateNotNull(clust2, "Partition key '%s' should not be null", "clust2");
      keys.add(clust2);
      encodedKeys.add(EntityWithIndicesForJSON_AchillesMeta.clust2.encodeFromJava(clust2, cassandraOptions));
      Validator.validateNotNull(clust3, "Partition key '%s' should not be null", "clust3");
      keys.add(clust3);
      encodedKeys.add(EntityWithIndicesForJSON_AchillesMeta.clust3.encodeFromJava(clust3, cassandraOptions));
      final Object[] primaryKeyValues = keys.toArray();
      final Object[] encodedPrimaryKeyValues = encodedKeys.toArray();
      return new FindWithOptions<EntityWithIndicesForJSON>(entityClass, meta, rte, primaryKeyValues, encodedPrimaryKeyValues, cassandraOptions);
    }

    /**
     * Delete an entity instance by extracting its primary keyRemark: <strong>Achilles will throw an exception if any column being part of the primary key is NULL</strong>@param an instance of EntityWithIndicesForJSON to be delete@return DeleteWithOptions<EntityWithIndicesForJSON> */
    public DeleteWithOptions<EntityWithIndicesForJSON> delete(final EntityWithIndicesForJSON instance) {
      return deleteInternal(instance, cassandraOptions);
    }

    /**
     * Delete an entity using its complete primary key@param id partition key 'id'@param clust1 clustering column 'clust1'@param clust2 clustering column 'clust2'@param clust3 clustering column 'clust3'@return DeleteWithOptions<EntityWithIndicesForJSON> */
    public DeleteWithOptions<EntityWithIndicesForJSON> deleteById(final Long id, final int clust1, final int clust2, final String clust3) {
      List<Object> keys = new ArrayList<>();
      List<Object> encodedKeys = new ArrayList<>();
      Validator.validateNotNull(id, "Partition key '%s' should not be null", "id");
      keys.add(id);
      encodedKeys.add(EntityWithIndicesForJSON_AchillesMeta.id.encodeFromJava(id, cassandraOptions));
      Validator.validateNotNull(clust1, "Partition key '%s' should not be null", "clust1");
      keys.add(clust1);
      encodedKeys.add(EntityWithIndicesForJSON_AchillesMeta.clust1.encodeFromJava(clust1, cassandraOptions));
      Validator.validateNotNull(clust2, "Partition key '%s' should not be null", "clust2");
      keys.add(clust2);
      encodedKeys.add(EntityWithIndicesForJSON_AchillesMeta.clust2.encodeFromJava(clust2, cassandraOptions));
      Validator.validateNotNull(clust3, "Partition key '%s' should not be null", "clust3");
      keys.add(clust3);
      encodedKeys.add(EntityWithIndicesForJSON_AchillesMeta.clust3.encodeFromJava(clust3, cassandraOptions));
      final Object[] partitionKeysValues = keys.toArray();
      final Object[] encodedPartitionKeyValues = encodedKeys.toArray();
      return new DeleteWithOptions<EntityWithIndicesForJSON>(entityClass, meta, rte, partitionKeysValues, encodedPartitionKeyValues, Optional.empty(), cassandraOptions);
    }

    /**
     * Insert this entity
     *
     * @param instance an instance of EntityWithIndicesForJSON
     * @return InsertWithOptions<EntityWithIndicesForJSON> */
    public final InsertWithOptions<EntityWithIndicesForJSON> insert(final EntityWithIndicesForJSON instance) {
      return insertInternal(instance, false, cassandraOptions);
    }

    /**
     * Update the cassandra table with <strong>NOT NULL</strong> fields extracted from this entity
     *
     * @param instance an instance of EntityWithIndicesForJSON
     * @return InsertWithOptions<EntityWithIndicesForJSON> */
    public final UpdateWithOptions<EntityWithIndicesForJSON> update(final EntityWithIndicesForJSON instance) {
      return updateInternal(instance, false, cassandraOptions);
    }

    /**
     * Delete a whole partition using the partition key@param id partition key 'id'@return DeleteByPartitionWithOptions<EntityWithIndicesForJSON> */
    public DeleteByPartitionWithOptions<EntityWithIndicesForJSON> deleteByPartitionKeys(final Long id) {
      List<Object> keys = new ArrayList<>();
      List<Object> encodedKeys = new ArrayList<>();
      Validator.validateNotNull(id, "Partition key '%s' should not be null", "id");
      keys.add(id);
      encodedKeys.add(EntityWithIndicesForJSON_AchillesMeta.id.encodeFromJava(id, cassandraOptions));
      final Object[] partitionKeys = keys.toArray();
      final Object[] encodedPartitionKeys = encodedKeys.toArray();
      return new DeleteByPartitionWithOptions<EntityWithIndicesForJSON>(meta, rte, partitionKeys, encodedPartitionKeys, cassandraOptions);
    }

    /**
     * Insert using a JSON payload
     *
     * @json the JSON string representing an instance of EntityWithIndicesForJSON
     * @return InsertJSONWithOptions */
    public final InsertJSONWithOptions insertJSON(final String json) {
      return insertJSONInternal(json, cassandraOptions);
    }
  }

  public final class EntityWithIndicesForJSON_DSL {
    /**
     * Generate a <strong>SELECT</strong> statement@return EntityWithIndicesForJSON_Select */
    public final EntityWithIndicesForJSON_Select select() {
      return new EntityWithIndicesForJSON_Select(rte, meta);
    }

    /**
     * Generate a <strong>DELETE</strong> statement@return EntityWithIndicesForJSON_Delete */
    public final EntityWithIndicesForJSON_Delete delete() {
      return new EntityWithIndicesForJSON_Delete(rte, meta);
    }

    /**
     * Generate an <strong>UPDATE</strong> statement@return EntityWithIndicesForJSON_Update */
    public final EntityWithIndicesForJSON_Update update() {
      return new EntityWithIndicesForJSON_Update(rte, meta);
    }
  }

  public final class EntityWithIndicesForJSON_RAW_QUERY {
    /**
     * Execute the bound statement and map the result back into an instance of EntityWithIndicesForJSON <br/>
     * Remark: the bound statement should be a <strong>SELECT</strong> statement@param boundStatement a bound statement@return TypedQuery<EntityWithIndicesForJSON> */
    public final TypedQuery<EntityWithIndicesForJSON> typedQueryForSelect(BoundStatement boundStatement) {
      return typedQueryForSelectInternal(boundStatement);
    }

    /**
     * Execute the prepared statement and map the result back into an instance of EntityWithIndicesForJSON <br/>
     * Remark: the prepared statement should be a <strong>SELECT</strong> statement@param preparedStatement a prepared statement@return TypedQuery<EntityWithIndicesForJSON> */
    public final TypedQuery<EntityWithIndicesForJSON> typedQueryForSelect(PreparedStatement preparedStatement, Object... encodedBoundValues) {
      return typedQueryForSelectInternal(preparedStatement, encodedBoundValues);
    }

    /**
     * Execute the regular statement and map the result back into an instance of EntityWithIndicesForJSON <br/>
     * Remark: the regular statement should be a <strong>SELECT</strong> statement@param regularStatement a regular statement@return TypedQuery<EntityWithIndicesForJSON> */
    public final TypedQuery<EntityWithIndicesForJSON> typedQueryForSelect(RegularStatement regularStatement, Object... encodedBoundValues) {
      return typedQueryForSelectInternal(regularStatement, encodedBoundValues);
    }

    /**
     * Execute the native bound statement@param boundStatement a bound statement@return NativeQuery */
    public final NativeQuery nativeQuery(BoundStatement boundStatement) {
      return nativeQueryInternal(boundStatement);
    }

    /**
     * Execute the native prepared statement@param preparedStatement a prepared statement@return NativeQuery */
    public final NativeQuery nativeQuery(PreparedStatement preparedStatement, Object... encodedBoundValues) {
      return nativeQueryInternal(preparedStatement, encodedBoundValues);
    }

    /**
     * Execute the native regular statement@param regularStatement a regular statement@return NativeQuery */
    public final NativeQuery nativeQuery(RegularStatement regularStatement, Object... encodedBoundValues) {
      return nativeQueryInternal(regularStatement, encodedBoundValues);
    }
  }
}
