/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.elm_modelinfo.r1.serializing.jaxb;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.hl7.elm_modelinfo.r1.ModelInfo;
import org.hl7.elm_modelinfo.r1.ObjectFactory;
import org.hl7.elm_modelinfo.r1.serializing.ModelInfoReader;

public class XmlModelInfoReader
implements ModelInfoReader {
    private final Map<String, String> properties = new HashMap<String, String>();
    private final Unmarshaller unmarshaller;

    public XmlModelInfoReader() {
        this.properties.put("jakarta.xml.bind.JAXBContextFactory", "org.eclipse.persistence.jaxb.JAXBContextFactory");
        try {
            this.unmarshaller = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class}, this.properties).createUnmarshaller();
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    private Unmarshaller getUnmarshaller() {
        return this.unmarshaller;
    }

    private ModelInfo toModelInfo(Object obj) {
        return (ModelInfo)((JAXBElement)obj).getValue();
    }

    public ModelInfo read(File src) throws IOException {
        try {
            return this.toModelInfo(this.getUnmarshaller().unmarshal(src));
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
    }

    public ModelInfo read(Reader src) throws IOException {
        try {
            return this.toModelInfo(this.getUnmarshaller().unmarshal(src));
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
    }

    public ModelInfo read(InputStream src) throws IOException {
        try {
            return this.toModelInfo(this.getUnmarshaller().unmarshal(src));
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
    }

    public ModelInfo read(URL url) throws IOException {
        try {
            return this.toModelInfo(this.getUnmarshaller().unmarshal(url));
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
    }

    public ModelInfo read(URI uri) throws IOException {
        try {
            return this.toModelInfo(this.getUnmarshaller().unmarshal(uri.toURL()));
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
    }

    public ModelInfo read(String string) throws IOException {
        try {
            return this.toModelInfo(this.getUnmarshaller().unmarshal((InputStream)new ByteArrayInputStream(string.getBytes())));
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
    }
}

