/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.tools.xsd2modelinfo;

import jakarta.xml.bind.JAXB;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.cqframework.cql.tools.xsd2modelinfo.ModelImporter;
import org.cqframework.cql.tools.xsd2modelinfo.ModelImporterOptions;
import org.hl7.elm_modelinfo.r1.ModelInfo;
import org.hl7.elm_modelinfo.r1.ObjectFactory;

public class Main {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, JAXBException {
        File outputfile;
        File configFile;
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec schemaOpt = parser.accepts("schema").withRequiredArg().ofType(File.class).required();
        ArgumentAcceptingOptionSpec modelOpt = parser.accepts("model").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec configOpt = parser.accepts("config").withOptionalArg().ofType(File.class);
        ArgumentAcceptingOptionSpec outputOpt = parser.accepts("output").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec normalizePrefixOpt = parser.accepts("normalize-prefix").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec choiceTypeOpt = parser.accepts("choicetype-policy").withRequiredArg().ofType(ModelImporterOptions.ChoiceTypePolicy.class);
        ArgumentAcceptingOptionSpec stRestrictionsOpt = parser.accepts("simpletype-restriction-policy").withRequiredArg().ofType(ModelImporterOptions.SimpleTypeRestrictionPolicy.class);
        ArgumentAcceptingOptionSpec redeclarationsOpt = parser.accepts("element-redeclaration-policy").withRequiredArg().ofType(ModelImporterOptions.ElementRedeclarationPolicy.class);
        ArgumentAcceptingOptionSpec versionPolicyOpt = parser.accepts("version-policy").withRequiredArg().ofType(ModelImporterOptions.VersionPolicy.class);
        ArgumentAcceptingOptionSpec optionsFileOpt = parser.accepts("options-file").withRequiredArg().ofType(File.class);
        OptionSet options = parser.parse(args);
        File schemaFile = (File)schemaOpt.value(options);
        FileInputStream is = new FileInputStream(schemaFile);
        XmlSchemaCollection schemaCol = new XmlSchemaCollection();
        schemaCol.setBaseUri(schemaFile.getParent());
        XmlSchema schema = schemaCol.read((Source)new StreamSource(is));
        ModelImporterOptions importerOptions = options.has((OptionSpec)optionsFileOpt) ? ModelImporterOptions.loadFromProperties((File)optionsFileOpt.value(options)) : new ModelImporterOptions();
        if (options.has((OptionSpec)modelOpt)) {
            importerOptions.setModel((String)modelOpt.value(options));
        }
        if (options.has((OptionSpec)choiceTypeOpt)) {
            importerOptions.setChoiceTypePolicy((ModelImporterOptions.ChoiceTypePolicy)((Object)choiceTypeOpt.value(options)));
        }
        if (options.has((OptionSpec)stRestrictionsOpt)) {
            importerOptions.setSimpleTypeRestrictionPolicy((ModelImporterOptions.SimpleTypeRestrictionPolicy)((Object)stRestrictionsOpt.value(options)));
        }
        if (options.has((OptionSpec)redeclarationsOpt)) {
            importerOptions.setElementRedeclarationPolicy((ModelImporterOptions.ElementRedeclarationPolicy)((Object)redeclarationsOpt.value(options)));
        }
        if (options.has((OptionSpec)versionPolicyOpt)) {
            importerOptions.setVersionPolicy((ModelImporterOptions.VersionPolicy)((Object)versionPolicyOpt.value(options)));
        }
        if (options.has((OptionSpec)normalizePrefixOpt)) {
            importerOptions.setNormalizePrefix((String)normalizePrefixOpt.value(options));
        }
        ModelInfo config = null;
        if (configOpt != null && (configFile = (File)configOpt.value(options)) != null) {
            config = (ModelInfo)JAXB.unmarshal((File)configFile, ModelInfo.class);
        }
        ModelInfo modelInfo = ModelImporter.fromXsd(schema, importerOptions, config);
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{ModelInfo.class});
        Marshaller marshaller = jc.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        if (!options.has((OptionSpec)outputOpt) || ((File)outputOpt.value(options)).isDirectory()) {
            String name = String.format("%s-modelinfo.xml", modelInfo.getTargetQualifier());
            String basePath = options.has((OptionSpec)outputOpt) ? ((File)outputOpt.value(options)).getAbsolutePath() : schemaFile.getParent();
            outputfile = new File(basePath + File.separator + name);
        } else {
            outputfile = (File)outputOpt.value(options);
        }
        if (outputfile.equals(schemaFile)) {
            throw new IllegalArgumentException("input schema file and output file must be different!");
        }
        try (FileOutputStream os = new FileOutputStream(outputfile, false);){
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)os, "UTF-8");
            marshaller.marshal((Object)new ObjectFactory().createModelInfo(modelInfo), (Writer)writer);
        }
    }
}

