/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.tools.xsd2modelinfo;

import jakarta.xml.bind.JAXB;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaAll;
import org.apache.ws.commons.schema.XmlSchemaAllMember;
import org.apache.ws.commons.schema.XmlSchemaAttribute;
import org.apache.ws.commons.schema.XmlSchemaAttributeGroup;
import org.apache.ws.commons.schema.XmlSchemaAttributeGroupMember;
import org.apache.ws.commons.schema.XmlSchemaAttributeGroupRef;
import org.apache.ws.commons.schema.XmlSchemaAttributeOrGroupRef;
import org.apache.ws.commons.schema.XmlSchemaChoice;
import org.apache.ws.commons.schema.XmlSchemaChoiceMember;
import org.apache.ws.commons.schema.XmlSchemaComplexContentExtension;
import org.apache.ws.commons.schema.XmlSchemaComplexContentRestriction;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaContent;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaGroupRef;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaSequenceMember;
import org.apache.ws.commons.schema.XmlSchemaSimpleContentExtension;
import org.apache.ws.commons.schema.XmlSchemaSimpleContentRestriction;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeRestriction;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.apache.ws.commons.schema.XmlSchemaUse;
import org.cqframework.cql.tools.xsd2modelinfo.ModelImporterMapperValue;
import org.cqframework.cql.tools.xsd2modelinfo.ModelImporterOptions;
import org.hl7.cql.model.ChoiceType;
import org.hl7.cql.model.ClassType;
import org.hl7.cql.model.ClassTypeElement;
import org.hl7.cql.model.DataType;
import org.hl7.cql.model.IntervalType;
import org.hl7.cql.model.InvalidRedeclarationException;
import org.hl7.cql.model.ListType;
import org.hl7.cql.model.NamedType;
import org.hl7.cql.model.SimpleType;
import org.hl7.cql.model.TupleType;
import org.hl7.cql.model.TupleTypeElement;
import org.hl7.cql.model.TypeParameter;
import org.hl7.elm_modelinfo.r1.ChoiceTypeSpecifier;
import org.hl7.elm_modelinfo.r1.ClassInfo;
import org.hl7.elm_modelinfo.r1.ClassInfoElement;
import org.hl7.elm_modelinfo.r1.IntervalTypeInfo;
import org.hl7.elm_modelinfo.r1.IntervalTypeSpecifier;
import org.hl7.elm_modelinfo.r1.ListTypeInfo;
import org.hl7.elm_modelinfo.r1.ListTypeSpecifier;
import org.hl7.elm_modelinfo.r1.ModelInfo;
import org.hl7.elm_modelinfo.r1.NamedTypeSpecifier;
import org.hl7.elm_modelinfo.r1.SimpleTypeInfo;
import org.hl7.elm_modelinfo.r1.TupleTypeInfo;
import org.hl7.elm_modelinfo.r1.TupleTypeInfoElement;
import org.hl7.elm_modelinfo.r1.TypeInfo;
import org.hl7.elm_modelinfo.r1.TypeParameterInfo;
import org.hl7.elm_modelinfo.r1.TypeSpecifier;

public class ModelImporter {
    private static final Map<String, DataType> SYSTEM_CATALOG = ModelImporter.getSystemCatalog();
    private final XmlSchema schema;
    private final ModelInfo config;
    private final ModelImporterOptions options;
    private final Map<String, DataType> dataTypes;
    private final Map<String, String> namespaces;

    private static Map<String, DataType> getSystemCatalog() {
        ModelInfo systemModelInfo = (ModelInfo)JAXB.unmarshal((InputStream)ModelImporter.class.getResourceAsStream("/org/hl7/elm/r1/system-modelinfo.xml"), ModelInfo.class);
        HashMap<String, DataType> map = new HashMap<String, DataType>();
        for (TypeInfo info : systemModelInfo.getTypeInfo()) {
            String qualifiedName;
            if (info instanceof SimpleTypeInfo) {
                SimpleTypeInfo sInfo = (SimpleTypeInfo)info;
                qualifiedName = ModelImporter.getQualifiedName(systemModelInfo.getName(), sInfo.getName());
                map.put(qualifiedName, (DataType)new SimpleType(qualifiedName));
                continue;
            }
            if (!(info instanceof ClassInfo)) continue;
            ClassInfo cInfo = (ClassInfo)info;
            qualifiedName = ModelImporter.getQualifiedName(systemModelInfo.getName(), cInfo.getName());
            map.put(qualifiedName, (DataType)new ClassType(qualifiedName));
        }
        return map;
    }

    private static String getQualifiedName(String modelName, String name) {
        if (name.startsWith(modelName + ".")) {
            return name;
        }
        return String.format("%s.%s", modelName, name);
    }

    private ModelImporter(XmlSchema schema, ModelImporterOptions options, ModelInfo config) {
        ModelImporterOptions tmpOptions;
        this.schema = schema;
        this.config = config;
        this.dataTypes = new HashMap<String, DataType>();
        this.namespaces = new HashMap<String, String>();
        try (InputStream defaultPropertiesIS = this.getClass().getResourceAsStream("default_options.properties");){
            tmpOptions = ModelImporterOptions.loadFromProperties(defaultPropertiesIS);
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not load default properties", e);
        }
        if (options != null) {
            tmpOptions.applyProperties(options.exportProperties());
        }
        this.options = tmpOptions;
    }

    public static ModelInfo fromXsd(XmlSchema schema, ModelImporterOptions options, ModelInfo config) {
        ModelImporter importer = new ModelImporter(schema, options, config);
        return importer.importXsd();
    }

    public ModelInfo importXsd() {
        if (this.options.getModel() == null || this.options.getModel().isEmpty()) {
            throw new IllegalArgumentException("Model name is required.");
        }
        this.namespaces.put(this.schema.getTargetNamespace(), this.options.getModel());
        for (XmlSchemaType schemaType : this.schema.getSchemaTypes().values()) {
            this.resolveType(schemaType);
        }
        return new ModelInfo().withName(this.options.getModel()).withTargetQualifier(this.options.getModel().toLowerCase()).withUrl(this.schema.getTargetNamespace()).withPatientClassName(this.config != null ? this.config.getPatientClassName() : null).withPatientClassIdentifier(this.config != null ? this.config.getPatientClassIdentifier() : null).withPatientBirthDatePropertyName(this.config != null ? this.config.getPatientBirthDatePropertyName() : null).withTypeInfo((Collection)this.dataTypes.values().stream().map(this::toTypeInfo).collect(Collectors.toList()));
    }

    private TypeInfo toTypeInfo(DataType dataType) {
        if (dataType == null) {
            throw new IllegalArgumentException("dataType is null");
        }
        if (dataType instanceof SimpleType) {
            return this.toSimpleTypeInfo((SimpleType)dataType);
        }
        if (dataType instanceof ClassType) {
            return this.toClassInfo((ClassType)dataType);
        }
        if (dataType instanceof IntervalType) {
            return this.toIntervalTypeInfo((IntervalType)dataType);
        }
        if (dataType instanceof ListType) {
            return this.toListTypeInfo((ListType)dataType);
        }
        if (dataType instanceof TupleType) {
            return this.toTupleTypeInfo((TupleType)dataType);
        }
        throw new IllegalArgumentException(String.format("Unknown data type class: %s", dataType.getClass().getName()));
    }

    private String toTypeName(NamedTypeSpecifier typeSpecifier) {
        if (typeSpecifier.getModelName() != null) {
            return String.format("%s.%s", typeSpecifier.getModelName(), typeSpecifier.getName());
        }
        return typeSpecifier.getName();
    }

    private void setBaseType(TypeInfo typeInfo, DataType baseType) {
        TypeSpecifier baseTypeSpecifier = this.toTypeSpecifier(baseType);
        if (baseTypeSpecifier instanceof NamedTypeSpecifier) {
            typeInfo.setBaseType(this.toTypeName((NamedTypeSpecifier)baseTypeSpecifier));
        } else {
            typeInfo.setBaseTypeSpecifier(baseTypeSpecifier);
        }
    }

    private SimpleTypeInfo toSimpleTypeInfo(SimpleType dataType) {
        SimpleTypeInfo result = new SimpleTypeInfo();
        result.setName(dataType.getSimpleName());
        if (dataType.getBaseType() != null) {
            this.setBaseType((TypeInfo)result, dataType.getBaseType());
        }
        return result;
    }

    private ClassInfo toClassInfo(ClassType dataType) {
        ClassInfo result = new ClassInfo();
        result.setName(dataType.getSimpleName());
        if (dataType.getBaseType() != null) {
            this.setBaseType((TypeInfo)result, dataType.getBaseType());
        }
        if (dataType.getLabel() != null) {
            result.setLabel(dataType.getLabel());
        } else if (this.options.getNormalizePrefix() != null && dataType.getName().startsWith(this.options.getNormalizePrefix())) {
            result.setLabel(dataType.getName().substring(this.options.getNormalizePrefix().length()));
        }
        result.setIdentifier(dataType.getIdentifier());
        result.setRetrievable(Boolean.valueOf(dataType.isRetrievable()));
        result.setPrimaryCodePath(dataType.getPrimaryCodePath());
        for (TypeParameter genericParameter : dataType.getGenericParameters()) {
            TypeParameterInfo parameterInfo = new TypeParameterInfo();
            parameterInfo.setName(genericParameter.getIdentifier());
            parameterInfo.setConstraint(genericParameter.getConstraint().name());
            parameterInfo.setConstraintType(this.getTypeName(genericParameter.getConstraintType()));
            result.getParameter().add(parameterInfo);
        }
        for (ClassTypeElement element : dataType.getElements()) {
            ClassInfoElement cie = new ClassInfoElement().withName(element.getName());
            TypeSpecifier elementTypeSpecifier = this.toTypeSpecifier(element.getType());
            if (elementTypeSpecifier instanceof NamedTypeSpecifier) {
                cie.setElementType(this.toTypeName((NamedTypeSpecifier)elementTypeSpecifier));
                if (this.options.getVersionPolicy() == ModelImporterOptions.VersionPolicy.INCLUDE_DEPRECATED) {
                    cie.setType(this.toTypeName((NamedTypeSpecifier)elementTypeSpecifier));
                }
            } else {
                cie.setElementTypeSpecifier(elementTypeSpecifier);
                if (this.options.getVersionPolicy() == ModelImporterOptions.VersionPolicy.INCLUDE_DEPRECATED) {
                    cie.setTypeSpecifier(elementTypeSpecifier);
                }
            }
            if (element.isProhibited()) {
                cie.setProhibited(Boolean.valueOf(true));
            }
            result.getElement().add(cie);
        }
        return result;
    }

    private IntervalTypeInfo toIntervalTypeInfo(IntervalType dataType) {
        IntervalTypeInfo result = new IntervalTypeInfo();
        TypeSpecifier pointTypeSpecifier = this.toTypeSpecifier(dataType.getPointType());
        if (pointTypeSpecifier instanceof NamedTypeSpecifier) {
            result.setPointType(this.toTypeName((NamedTypeSpecifier)pointTypeSpecifier));
        } else {
            result.setPointTypeSpecifier(pointTypeSpecifier);
        }
        return result;
    }

    private ListTypeInfo toListTypeInfo(ListType dataType) {
        ListTypeInfo result = new ListTypeInfo();
        TypeSpecifier elementTypeSpecifier = this.toTypeSpecifier(dataType.getElementType());
        if (elementTypeSpecifier instanceof NamedTypeSpecifier) {
            result.setElementType(this.toTypeName((NamedTypeSpecifier)elementTypeSpecifier));
        } else {
            result.setElementTypeSpecifier(elementTypeSpecifier);
        }
        return result;
    }

    private TupleTypeInfo toTupleTypeInfo(TupleType dataType) {
        TupleTypeInfo result = new TupleTypeInfo();
        if (dataType.getBaseType() != null) {
            this.setBaseType((TypeInfo)result, dataType.getBaseType());
        }
        for (TupleTypeElement element : dataType.getElements()) {
            TupleTypeInfoElement infoElement = new TupleTypeInfoElement().withName(element.getName());
            TypeSpecifier elementTypeSpecifier = this.toTypeSpecifier(element.getType());
            if (elementTypeSpecifier instanceof NamedTypeSpecifier) {
                infoElement.setElementType(this.toTypeName((NamedTypeSpecifier)elementTypeSpecifier));
                if (this.options.getVersionPolicy() == ModelImporterOptions.VersionPolicy.INCLUDE_DEPRECATED) {
                    infoElement.setType(this.toTypeName((NamedTypeSpecifier)elementTypeSpecifier));
                }
            } else {
                infoElement.setElementTypeSpecifier(elementTypeSpecifier);
                if (this.options.getVersionPolicy() == ModelImporterOptions.VersionPolicy.INCLUDE_DEPRECATED) {
                    infoElement.setTypeSpecifier(elementTypeSpecifier);
                }
            }
            result.getElement().add(infoElement);
        }
        return result;
    }

    private TypeSpecifier toTypeSpecifier(DataType dataType) {
        if (dataType == null) {
            throw new IllegalArgumentException("dataType is null");
        }
        if (dataType instanceof SimpleType) {
            return this.toNamedTypeSpecifier((NamedType)((SimpleType)dataType));
        }
        if (dataType instanceof ClassType) {
            return this.toNamedTypeSpecifier((NamedType)((ClassType)dataType));
        }
        if (dataType instanceof IntervalType) {
            return this.toIntervalTypeSpecifier((IntervalType)dataType);
        }
        if (dataType instanceof ListType) {
            return this.toListTypeSpecifier((ListType)dataType);
        }
        if (dataType instanceof ChoiceType) {
            return this.toChoiceTypeSpecifier((ChoiceType)dataType);
        }
        if (dataType instanceof TupleType) {
            throw new IllegalArgumentException("Tuple types cannot be used in type specifiers.");
        }
        throw new IllegalArgumentException(String.format("Unknown data type class: %s", dataType.getClass().getName()));
    }

    private TypeSpecifier toNamedTypeSpecifier(NamedType dataType) {
        NamedTypeSpecifier namedTypeSpecifier = new NamedTypeSpecifier().withModelName(dataType.getNamespace()).withName(dataType.getSimpleName());
        return namedTypeSpecifier;
    }

    private TypeSpecifier toIntervalTypeSpecifier(IntervalType dataType) {
        IntervalTypeSpecifier intervalTypeSpecifier = new IntervalTypeSpecifier();
        TypeSpecifier pointTypeSpecifier = this.toTypeSpecifier(dataType.getPointType());
        if (pointTypeSpecifier instanceof NamedTypeSpecifier) {
            intervalTypeSpecifier.setPointType(this.toTypeName((NamedTypeSpecifier)pointTypeSpecifier));
        } else {
            intervalTypeSpecifier.setPointTypeSpecifier(pointTypeSpecifier);
        }
        return intervalTypeSpecifier;
    }

    private TypeSpecifier toListTypeSpecifier(ListType dataType) {
        ListTypeSpecifier listTypeSpecifier = new ListTypeSpecifier();
        TypeSpecifier elementTypeSpecifier = this.toTypeSpecifier(dataType.getElementType());
        if (elementTypeSpecifier instanceof NamedTypeSpecifier) {
            listTypeSpecifier.setElementType(this.toTypeName((NamedTypeSpecifier)elementTypeSpecifier));
        } else {
            listTypeSpecifier.setElementTypeSpecifier(elementTypeSpecifier);
        }
        return listTypeSpecifier;
    }

    private TypeSpecifier toChoiceTypeSpecifier(ChoiceType dataType) {
        ArrayList<TypeSpecifier> choiceTypes = new ArrayList<TypeSpecifier>();
        for (DataType choice : dataType.getTypes()) {
            choiceTypes.add(this.toTypeSpecifier(choice));
        }
        ChoiceTypeSpecifier choiceTypeSpecifier = new ChoiceTypeSpecifier().withChoice(choiceTypes);
        return choiceTypeSpecifier;
    }

    private String getTypeName(QName schemaTypeName, Map<String, String> namespaces) {
        if (schemaTypeName == null) {
            throw new IllegalArgumentException("schemaTypeName is null");
        }
        String modelName = namespaces.get(schemaTypeName.getNamespaceURI());
        if (modelName == null && (modelName = schemaTypeName.getPrefix()) != null && !modelName.isEmpty()) {
            namespaces.put(schemaTypeName.getNamespaceURI(), modelName);
        }
        if (modelName != null && !modelName.isEmpty()) {
            return modelName + "." + schemaTypeName.getLocalPart().replace('-', '_');
        }
        return schemaTypeName.getLocalPart();
    }

    private DataType resolveType(QName schemaTypeName) {
        if (schemaTypeName == null) {
            return null;
        }
        ModelImporterMapperValue mapping = this.options.getTypeMap().get(schemaTypeName);
        if (mapping != null && mapping.getRelationship() == ModelImporterMapperValue.Relationship.RETYPE) {
            return SYSTEM_CATALOG.get(mapping.getTargetSystemClass());
        }
        XmlSchemaType schemaType = this.schema.getTypeByName(schemaTypeName);
        if (schemaType == null) {
            String typeName = this.getTypeName(schemaTypeName, this.namespaces);
            DataType resultType = this.dataTypes.get(typeName);
            if (resultType == null) {
                resultType = mapping != null && mapping.getRelationship() == ModelImporterMapperValue.Relationship.EXTEND ? new SimpleType(typeName, SYSTEM_CATALOG.get(mapping.getTargetSystemClass())) : new SimpleType(typeName);
                this.dataTypes.put(typeName, resultType);
            }
            return resultType;
        }
        return this.resolveType(schemaType);
    }

    private DataType resolveType(XmlSchemaType schemaType) {
        if (schemaType instanceof XmlSchemaSimpleType) {
            return this.resolveSimpleType((XmlSchemaSimpleType)schemaType);
        }
        if (schemaType instanceof XmlSchemaComplexType) {
            return this.resolveComplexType((XmlSchemaComplexType)schemaType);
        }
        return null;
    }

    private DataType resolveSimpleType(XmlSchemaSimpleType simpleType) {
        if (simpleType.isAnonymous()) {
            return null;
        }
        ModelImporterMapperValue mapping = this.options.getTypeMap().get(simpleType.getQName());
        if (mapping != null && mapping.getRelationship() == ModelImporterMapperValue.Relationship.RETYPE) {
            return SYSTEM_CATALOG.get(mapping.getTargetSystemClass());
        }
        String typeName = this.getTypeName(simpleType.getQName(), this.namespaces);
        DataType resultType = this.dataTypes.get(typeName);
        if (resultType == null) {
            DataType baseType = null;
            boolean retypeToBase = false;
            if (mapping != null && mapping.getRelationship() == ModelImporterMapperValue.Relationship.EXTEND) {
                baseType = SYSTEM_CATALOG.get(mapping.getTargetSystemClass());
            } else if (simpleType.getContent() instanceof XmlSchemaSimpleTypeRestriction) {
                baseType = this.resolveType(((XmlSchemaSimpleTypeRestriction)simpleType.getContent()).getBaseTypeName());
                switch (this.options.getSimpleTypeRestrictionPolicy()) {
                    case EXTEND_BASETYPE: {
                        break;
                    }
                    case IGNORE: {
                        baseType = null;
                        break;
                    }
                    default: {
                        retypeToBase = true;
                    }
                }
            }
            if (retypeToBase) {
                resultType = baseType;
            } else {
                resultType = new SimpleType(typeName, baseType);
                this.dataTypes.put(typeName, resultType);
            }
        }
        return resultType;
    }

    private void applyConfig(ClassType classType) {
        if (this.config != null) {
            for (int i = 0; i < this.config.getTypeInfo().size(); ++i) {
                ClassInfo classConfig;
                TypeInfo typeConfig = (TypeInfo)this.config.getTypeInfo().get(i);
                if (!(typeConfig instanceof ClassInfo) || !(classConfig = (ClassInfo)typeConfig).getName().equals(classType.getName())) continue;
                classType.setIdentifier(classConfig.getIdentifier());
                classType.setLabel(classConfig.getLabel());
                classType.setRetrievable(classConfig.isRetrievable());
                classType.setPrimaryCodePath(classConfig.getPrimaryCodePath());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DataType resolveComplexType(XmlSchemaComplexType complexType) {
        XmlSchemaParticle particleContent;
        List attributeContent;
        if (complexType.isAnonymous()) {
            return null;
        }
        ModelImporterMapperValue mapping = this.options.getTypeMap().get(complexType.getQName());
        if (mapping != null && mapping.getRelationship() == ModelImporterMapperValue.Relationship.RETYPE) {
            return SYSTEM_CATALOG.get(mapping.getTargetSystemClass());
        }
        String typeName = this.getTypeName(complexType.getQName(), this.namespaces);
        DataType resultType = this.dataTypes.get(typeName);
        if (resultType != null) return resultType;
        DataType baseType = null;
        if (mapping != null && mapping.getRelationship() == ModelImporterMapperValue.Relationship.EXTEND) {
            baseType = SYSTEM_CATALOG.get(mapping.getTargetSystemClass());
        } else if (complexType.getBaseSchemaTypeName() != null) {
            baseType = this.resolveType(this.schema.getTypeByName(complexType.getBaseSchemaTypeName()));
        }
        ClassType classType = new ClassType(typeName, baseType);
        this.dataTypes.put(typeName, (DataType)classType);
        this.applyConfig(classType);
        ArrayList<ClassTypeElement> elements = new ArrayList<ClassTypeElement>();
        if (complexType.getContentModel() != null) {
            ClassTypeElement valueElement;
            DataType valueType;
            XmlSchemaComplexContentExtension extensionContent;
            XmlSchemaComplexContentRestriction restrictionContent;
            XmlSchemaContent content = complexType.getContentModel().getContent();
            if (content instanceof XmlSchemaComplexContentRestriction) {
                restrictionContent = (XmlSchemaComplexContentRestriction)content;
                attributeContent = restrictionContent.getAttributes();
                particleContent = restrictionContent.getParticle();
            } else if (content instanceof XmlSchemaComplexContentExtension) {
                extensionContent = (XmlSchemaComplexContentExtension)content;
                attributeContent = extensionContent.getAttributes();
                particleContent = extensionContent.getParticle();
            } else if (content instanceof XmlSchemaSimpleContentRestriction) {
                restrictionContent = (XmlSchemaSimpleContentRestriction)content;
                valueType = this.resolveType(restrictionContent.getBaseTypeName());
                valueElement = new ClassTypeElement("value", valueType, Boolean.valueOf(false), Boolean.valueOf(false), null);
                elements.add(valueElement);
                attributeContent = restrictionContent.getAttributes();
                particleContent = null;
            } else {
                if (!(content instanceof XmlSchemaSimpleContentExtension)) throw new IllegalArgumentException("Unrecognized Schema Content: " + content.toString());
                extensionContent = (XmlSchemaSimpleContentExtension)content;
                attributeContent = extensionContent.getAttributes();
                particleContent = null;
                valueType = this.resolveType(extensionContent.getBaseTypeName());
                valueElement = new ClassTypeElement("value", valueType, Boolean.valueOf(false), Boolean.valueOf(false), null);
                elements.add(valueElement);
            }
        } else {
            attributeContent = complexType.getAttributes();
            particleContent = complexType.getParticle();
        }
        for (XmlSchemaAttributeOrGroupRef attribute : attributeContent) {
            this.resolveClassTypeElements(attribute, elements);
        }
        if (particleContent != null) {
            XmlSchemaParticle particle = particleContent;
            this.resolveClassTypeElements(particle, elements);
        }
        if (baseType instanceof ClassType) {
            ClassType cBase = (ClassType)baseType;
            elements.removeAll(cBase.getAllElements());
        }
        Iterator iterator = elements.iterator();
        block7: while (iterator.hasNext()) {
            ClassTypeElement element = (ClassTypeElement)iterator.next();
            try {
                classType.addElement(element);
            }
            catch (InvalidRedeclarationException e) {
                switch (this.options.getElementRedeclarationPolicy()) {
                    case FAIL_INVALID_REDECLARATIONS: {
                        System.err.println("Redeclaration failed.  Either fix the XSD or choose a different element-redeclaration-policy.");
                        throw e;
                    }
                    case DISCARD_INVALID_REDECLARATIONS: {
                        System.err.printf("%s. Discarding element redeclaration.%n", e.getMessage());
                        continue block7;
                    }
                }
                String tName = this.getTypeName(element.getType());
                StringBuilder name = new StringBuilder(element.getName()).append(Character.toUpperCase(tName.charAt(0)));
                if (tName.length() > 1) {
                    name.append(tName.substring(1));
                }
                System.err.printf("%s. Renaming element to %s.%n", e.getMessage(), name.toString());
                classType.addElement(new ClassTypeElement(name.toString(), element.getType(), Boolean.valueOf(element.isProhibited()), Boolean.valueOf(element.isOneBased()), null));
            }
        }
        return classType;
    }

    private String getTypeName(DataType type) {
        Object typeName;
        if (type instanceof ClassType) {
            typeName = ((ClassType)type).getSimpleName();
        } else if (type instanceof SimpleType) {
            typeName = ((SimpleType)type).getSimpleName();
        } else if (type instanceof ListType) {
            DataType elementType = ((ListType)type).getElementType();
            typeName = this.getTypeName(elementType) + "List";
        } else if (type instanceof IntervalType) {
            DataType pointType = ((IntervalType)type).getPointType();
            typeName = this.getTypeName(pointType) + "Interval";
        } else {
            typeName = type instanceof TupleType ? "Tuple" : (type instanceof TypeParameter ? "Parameter" : "Type");
        }
        return typeName;
    }

    private int indexOfFirstDifference(String original, String comparison) {
        if (original == null) {
            throw new IllegalArgumentException("original is null");
        }
        if (comparison == null) {
            throw new IllegalArgumentException("comparison is null");
        }
        int result = -1;
        while (++result < original.length() && result < comparison.length() && original.charAt(result) == comparison.charAt(result)) {
        }
        return result;
    }

    private void resolveClassTypeElements(XmlSchemaParticle particle, List<ClassTypeElement> elements) {
        if (particle instanceof XmlSchemaElement) {
            ClassTypeElement element = this.resolveClassTypeElement((XmlSchemaElement)particle);
            if (element != null) {
                elements.add(element);
            }
        } else if (particle instanceof XmlSchemaSequence) {
            XmlSchemaSequence sequence = (XmlSchemaSequence)particle;
            for (XmlSchemaSequenceMember member : sequence.getItems()) {
                if (!(member instanceof XmlSchemaParticle)) continue;
                this.resolveClassTypeElements((XmlSchemaParticle)member, elements);
            }
        } else if (particle instanceof XmlSchemaAll) {
            XmlSchemaAll all = (XmlSchemaAll)particle;
            for (XmlSchemaAllMember member : all.getItems()) {
                if (!(member instanceof XmlSchemaParticle)) continue;
                this.resolveClassTypeElements((XmlSchemaParticle)member, elements);
            }
        } else if (particle instanceof XmlSchemaChoice) {
            XmlSchemaChoice choice = (XmlSchemaChoice)particle;
            boolean choiceCreated = false;
            if (this.options.getChoiceTypePolicy() == ModelImporterOptions.ChoiceTypePolicy.USE_CHOICE) {
                ArrayList<DataType> choices = new ArrayList<DataType>();
                String elementName = null;
                for (XmlSchemaChoiceMember member : choice.getItems()) {
                    ClassTypeElement choiceElement = this.resolveClassTypeElement((XmlSchemaElement)member);
                    if (choiceElement == null) continue;
                    if (elementName == null) {
                        elementName = choiceElement.getName();
                    } else {
                        int firstDifference = this.indexOfFirstDifference(elementName, choiceElement.getName());
                        if (firstDifference < elementName.length()) {
                            elementName = elementName.substring(0, firstDifference);
                        }
                    }
                    choices.add(choiceElement.getType());
                }
                if (elementName != null && !elementName.isEmpty()) {
                    ChoiceType choiceType = new ChoiceType(choices);
                    ClassTypeElement element = new ClassTypeElement(elementName, (DataType)choiceType, Boolean.valueOf(false), Boolean.valueOf(false), null);
                    elements.add(element);
                    choiceCreated = true;
                }
            }
            if (!choiceCreated) {
                for (XmlSchemaChoiceMember member : choice.getItems()) {
                    ClassTypeElement element;
                    if (!(member instanceof XmlSchemaElement) || (element = this.resolveClassTypeElement((XmlSchemaElement)member)) == null) continue;
                    elements.add(element);
                }
            }
        } else if (particle instanceof XmlSchemaGroupRef) {
            XmlSchemaGroupRef ref = (XmlSchemaGroupRef)particle;
            this.resolveClassTypeElements((XmlSchemaParticle)ref.getParticle(), elements);
        }
    }

    private ClassTypeElement resolveClassTypeElement(XmlSchemaElement element) {
        boolean isList;
        boolean bl = isList = element.getMaxOccurs() > 1L;
        if (element.isRef()) {
            element = (XmlSchemaElement)element.getRef().getTarget();
        }
        DataType elementType = null;
        XmlSchemaType schemaType = element.getSchemaType();
        if (schemaType != null) {
            elementType = this.resolveType(schemaType);
        } else {
            QName schemaTypeName = element.getSchemaTypeName();
            if (schemaTypeName != null) {
                elementType = this.resolveType(schemaTypeName);
            }
        }
        if (elementType == null) {
            return null;
        }
        if (isList) {
            elementType = new ListType(elementType);
        }
        boolean isProhibited = element.getMinOccurs() == 0L && element.getMaxOccurs() == 0L;
        return new ClassTypeElement(element.getName(), elementType, Boolean.valueOf(isProhibited), Boolean.valueOf(false), null);
    }

    private ClassTypeElement resolveClassTypeElement(XmlSchemaAttribute attribute) {
        if (attribute.isRef()) {
            attribute = (XmlSchemaAttribute)attribute.getRef().getTarget();
        }
        DataType elementType = null;
        XmlSchemaSimpleType schemaType = attribute.getSchemaType();
        if (schemaType != null) {
            elementType = this.resolveType((XmlSchemaType)schemaType);
        } else {
            QName schemaTypeName = attribute.getSchemaTypeName();
            if (schemaTypeName != null) {
                elementType = this.resolveType(schemaTypeName);
            }
        }
        if (elementType == null) {
            return null;
        }
        return new ClassTypeElement(attribute.getName(), elementType, Boolean.valueOf(attribute.getUse() == XmlSchemaUse.PROHIBITED), Boolean.valueOf(false), null);
    }

    private void resolveClassTypeElements(XmlSchemaAttributeOrGroupRef attribute, List<ClassTypeElement> elements) {
        if (attribute instanceof XmlSchemaAttribute) {
            ClassTypeElement element = this.resolveClassTypeElement((XmlSchemaAttribute)attribute);
            if (element != null) {
                elements.add(element);
            }
        } else if (attribute instanceof XmlSchemaAttributeGroupRef) {
            this.resolveClassTypeElements((XmlSchemaAttributeGroup)((XmlSchemaAttributeGroupRef)attribute).getRef().getTarget(), elements);
        }
    }

    private void resolveClassTypeElements(XmlSchemaAttributeGroup attributeGroup, List<ClassTypeElement> elements) {
        for (XmlSchemaAttributeGroupMember member : attributeGroup.getAttributes()) {
            if (member instanceof XmlSchemaAttribute) {
                ClassTypeElement element = this.resolveClassTypeElement((XmlSchemaAttribute)member);
                if (element == null) continue;
                elements.add(element);
                continue;
            }
            if (member instanceof XmlSchemaAttributeGroupRef) {
                this.resolveClassTypeElements((XmlSchemaAttributeGroup)((XmlSchemaAttributeGroupRef)member).getRef().getTarget(), elements);
                continue;
            }
            if (!(member instanceof XmlSchemaAttributeGroup)) continue;
            this.resolveClassTypeElements((XmlSchemaAttributeGroup)member, elements);
        }
    }
}

