/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.tools.xsd2modelinfo;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.cqframework.cql.tools.xsd2modelinfo.ModelImporterMapperValue;

public class ModelImporterOptions {
    private static final Pattern RETYPE_PATTERN = Pattern.compile("\\s*retype\\.(.+)\\s*");
    private static final Pattern EXTEND_PATTERN = Pattern.compile("\\s*extend\\.([^\\[]+)\\s*");
    private static final Pattern EXTEND_EL_PATTERN = Pattern.compile("\\s*extend\\.([^\\[]+)\\[([^\\]]+)\\]\\s*");
    private String model = null;
    private ChoiceTypePolicy choiceTypePolicy = null;
    private SimpleTypeRestrictionPolicy simpleTypeRestrictionPolicy = null;
    private ElementRedeclarationPolicy elementRedeclarationPolicy = null;
    private VersionPolicy versionPolicy = null;
    private String normalizePrefix = null;
    private final Map<QName, ModelImporterMapperValue> typeMap = new HashMap<QName, ModelImporterMapperValue>();

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public ModelImporterOptions withModel(String model) {
        this.model = model;
        return this;
    }

    public ChoiceTypePolicy getChoiceTypePolicy() {
        return this.choiceTypePolicy != null ? this.choiceTypePolicy : ChoiceTypePolicy.EXPAND;
    }

    public void setChoiceTypePolicy(ChoiceTypePolicy choiceTypePolicy) {
        this.choiceTypePolicy = choiceTypePolicy;
    }

    public ModelImporterOptions withChoiceTypePolicy(ChoiceTypePolicy choiceTypePolicy) {
        this.choiceTypePolicy = choiceTypePolicy;
        return this;
    }

    public SimpleTypeRestrictionPolicy getSimpleTypeRestrictionPolicy() {
        return this.simpleTypeRestrictionPolicy != null ? this.simpleTypeRestrictionPolicy : SimpleTypeRestrictionPolicy.USE_BASETYPE;
    }

    public void setSimpleTypeRestrictionPolicy(SimpleTypeRestrictionPolicy simpleTypeRestrictionPolicy) {
        this.simpleTypeRestrictionPolicy = simpleTypeRestrictionPolicy;
    }

    public ModelImporterOptions withSimpleTypeRestrictionPolicy(SimpleTypeRestrictionPolicy simpleTypeRestrictionPolicy) {
        this.simpleTypeRestrictionPolicy = simpleTypeRestrictionPolicy;
        return this;
    }

    public ElementRedeclarationPolicy getElementRedeclarationPolicy() {
        return this.elementRedeclarationPolicy != null ? this.elementRedeclarationPolicy : ElementRedeclarationPolicy.FAIL_INVALID_REDECLARATIONS;
    }

    public void setElementRedeclarationPolicy(ElementRedeclarationPolicy elementRedeclarationPolicy) {
        this.elementRedeclarationPolicy = elementRedeclarationPolicy;
    }

    public ModelImporterOptions withElementRedeclarationPolicy(ElementRedeclarationPolicy elementRedeclarationPolicy) {
        this.elementRedeclarationPolicy = elementRedeclarationPolicy;
        return this;
    }

    public VersionPolicy getVersionPolicy() {
        return this.versionPolicy != null ? this.versionPolicy : VersionPolicy.CURRENT;
    }

    public void setVersionPolicy(VersionPolicy versionPolicy) {
        this.versionPolicy = versionPolicy;
    }

    public ModelImporterOptions withVersionPolicy(VersionPolicy versionPolicy) {
        this.versionPolicy = versionPolicy;
        return this;
    }

    public String getNormalizePrefix() {
        return this.normalizePrefix;
    }

    public void setNormalizePrefix(String normalizePrefix) {
        this.normalizePrefix = normalizePrefix;
    }

    public ModelImporterOptions withNormalizePrefix(String normalizePrefix) {
        this.normalizePrefix = normalizePrefix;
        return this;
    }

    public Map<QName, ModelImporterMapperValue> getTypeMap() {
        return this.typeMap;
    }

    public void applyProperties(Properties properties) {
        String versionPolicy;
        String elementRedeclarationPolicy;
        String simpleTypeRestrictionPolicy;
        String choiceTypePolicy;
        String normalizePrefix;
        String model = properties.getProperty("model");
        if (model != null && !model.isEmpty()) {
            this.setModel(model);
        }
        if ((normalizePrefix = properties.getProperty("normalize-prefix")) != null && !normalizePrefix.isEmpty()) {
            this.setNormalizePrefix(normalizePrefix);
        }
        if ((choiceTypePolicy = properties.getProperty("choicetype-policy")) != null && !choiceTypePolicy.isEmpty()) {
            this.setChoiceTypePolicy(ChoiceTypePolicy.valueOf(choiceTypePolicy));
        }
        if ((simpleTypeRestrictionPolicy = properties.getProperty("simpletype-restriction-policy")) != null && !simpleTypeRestrictionPolicy.isEmpty()) {
            this.setSimpleTypeRestrictionPolicy(SimpleTypeRestrictionPolicy.valueOf(simpleTypeRestrictionPolicy));
        }
        if ((elementRedeclarationPolicy = properties.getProperty("element-redeclaration-policy")) != null && !elementRedeclarationPolicy.isEmpty()) {
            this.setElementRedeclarationPolicy(ElementRedeclarationPolicy.valueOf(elementRedeclarationPolicy));
        }
        if ((versionPolicy = properties.getProperty("version-policy")) != null && !versionPolicy.isEmpty()) {
            this.setVersionPolicy(VersionPolicy.valueOf(versionPolicy));
        }
        for (String p : properties.stringPropertyNames().stream().sorted().collect(Collectors.toList())) {
            Matcher matcher = RETYPE_PATTERN.matcher(p);
            if (matcher.matches()) {
                this.typeMap.put(QName.valueOf(matcher.group(1)), ModelImporterMapperValue.newRetype(properties.getProperty(p)));
                continue;
            }
            matcher = EXTEND_PATTERN.matcher(p);
            if (matcher.matches()) {
                this.typeMap.put(QName.valueOf(matcher.group(1)), ModelImporterMapperValue.newExtend(properties.getProperty(p)));
                continue;
            }
            matcher = EXTEND_EL_PATTERN.matcher(p);
            if (!matcher.matches()) continue;
            ModelImporterMapperValue value = this.typeMap.get(QName.valueOf(matcher.group(1)));
            if (value == null) {
                throw new IllegalArgumentException(String.format("Class element mapping declared before class mapping: %s", p));
            }
            if (value.getRelationship() == ModelImporterMapperValue.Relationship.RETYPE) {
                throw new IllegalArgumentException(String.format("Cannot map class elements for retyped classes: %s", p));
            }
            value.addClassElementMapping(matcher.group(2), properties.getProperty(p));
        }
    }

    public Properties exportProperties() {
        Properties properties = new Properties();
        if (this.model != null) {
            properties.setProperty("model", this.model);
        }
        if (this.normalizePrefix != null) {
            properties.setProperty("normalize-prefix", this.normalizePrefix);
        }
        if (this.choiceTypePolicy != null) {
            properties.setProperty("choicetype-policy", this.choiceTypePolicy.name());
        }
        if (this.simpleTypeRestrictionPolicy != null) {
            properties.setProperty("simpletype-restriction-policy", this.simpleTypeRestrictionPolicy.name());
        }
        if (this.elementRedeclarationPolicy != null) {
            properties.setProperty("element-redeclaration-policy", this.elementRedeclarationPolicy.name());
        }
        if (this.versionPolicy != null) {
            properties.setProperty("version-policy", this.versionPolicy.name());
        }
        if (!this.typeMap.isEmpty()) {
            for (Map.Entry<QName, ModelImporterMapperValue> entry : this.typeMap.entrySet()) {
                QName key = entry.getKey();
                ModelImporterMapperValue value = entry.getValue();
                if (value.getRelationship() == ModelImporterMapperValue.Relationship.RETYPE) {
                    properties.setProperty(String.format("retype.%s", key.toString()), value.getTargetSystemClass());
                    continue;
                }
                if (value.getRelationship() != ModelImporterMapperValue.Relationship.EXTEND) continue;
                properties.setProperty(String.format("extend.%s", key.toString()), value.getTargetSystemClass());
                for (String el : value.getTargetClassElementMap().keySet()) {
                    String elValue = value.getTargetClassElementMap().get(el);
                    properties.setProperty(String.format("extend.%s[%s]", key.toString(), el), elValue);
                }
            }
        }
        return properties;
    }

    public static ModelImporterOptions loadFromProperties(InputStream propertiesIS) throws IOException {
        Properties properties = new Properties();
        properties.load(propertiesIS);
        ModelImporterOptions options = new ModelImporterOptions();
        options.applyProperties(properties);
        return options;
    }

    public static ModelImporterOptions loadFromProperties(File propertiesFile) throws IOException {
        try (FileInputStream is = new FileInputStream(propertiesFile);){
            ModelImporterOptions modelImporterOptions = ModelImporterOptions.loadFromProperties(is);
            return modelImporterOptions;
        }
    }

    public static enum ChoiceTypePolicy {
        USE_CHOICE,
        EXPAND;

    }

    public static enum SimpleTypeRestrictionPolicy {
        USE_BASETYPE,
        EXTEND_BASETYPE,
        IGNORE;

    }

    public static enum ElementRedeclarationPolicy {
        DISCARD_INVALID_REDECLARATIONS,
        RENAME_INVALID_REDECLARATIONS,
        FAIL_INVALID_REDECLARATIONS;

    }

    public static enum VersionPolicy {
        CURRENT,
        INCLUDE_DEPRECATED;

    }
}

