/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.jruby;

import cucumber.api.Scenario;
import cucumber.runtime.HookDefinition;
import cucumber.runtime.jruby.JRubyBackend;
import gherkin.TagExpression;
import gherkin.formatter.model.Tag;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jruby.RubyObject;

public class JRubyHookDefinition
implements HookDefinition {
    private final TagExpression tagExpression;
    private final RubyObject hookRunner;
    private String file;
    private Long line;
    private final JRubyBackend jRubyBackend;

    public JRubyHookDefinition(JRubyBackend jRubyBackend, String[] tagExpressions, RubyObject hookRunner) {
        this.jRubyBackend = jRubyBackend;
        this.tagExpression = new TagExpression(Arrays.asList(tagExpressions));
        this.hookRunner = hookRunner;
    }

    public String getLocation(boolean detail) {
        if (this.file == null) {
            List fileAndLine = (List)this.hookRunner.callMethod("file_and_line").toJava(List.class);
            this.file = (String)fileAndLine.get(0);
            this.line = (Long)fileAndLine.get(1);
        }
        return this.file + ":" + this.line;
    }

    public void execute(Scenario scenario) throws Throwable {
        this.jRubyBackend.executeHook(this.hookRunner, scenario);
    }

    public boolean matches(Collection<Tag> tags) {
        return this.tagExpression.evaluate(tags);
    }

    public int getOrder() {
        return 0;
    }

    public boolean isScenarioScoped() {
        return false;
    }
}

