/*
 * The MIT License
 *
 * Copyright 2015 tibo.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package info.debatty.java.lsh.examples;

import info.debatty.java.lsh.SuperBit;
import java.util.Random;

/**
 *
 * @author Thibault Debatty
 */
public class SuperBitExample {

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        
        int n = 10;
        
        SuperBit sb = new SuperBit(n);
        
        Random rand = new Random();
        double[] v1 = new double[n];
        double[] v2 = new double[n];
        for (int i = 0; i < n; i++) {
            v1[i] = rand.nextInt();
            v2[i] = rand.nextInt();
        }

        boolean[] sig1 = sb.signature(v1);
        boolean[] sig2 = sb.signature(v2);
        
        System.out.println("Signature (estimated) similarity: " + 
                sb.similarity(sig1, sig2));
        System.out.println("Real (cosine) similarity: " + 
                SuperBit.cosineSimilarity(v1, v2));
        
        double error = 0;
        int iterations = 100;
        for (int j = 0; j < iterations; j++) {
            for (int i = 0; i < n; i++) {
                v1[i] = rand.nextInt();
                v2[i] = rand.nextInt();
            }
            
            double similarity = SuperBit.cosineSimilarity(v1, v2);
            double estimated_similarity = sb.similarity(sb.signature(v1), sb.signature(v2));
            error += Math.abs(similarity - estimated_similarity);
        }
        
        System.out.printf(
                "Error after %d iterations: %f\n",
                iterations,
                error / iterations);
    }
    
}
