/*
 * Decompiled with CFR 0.152.
 */
package info.earty.application;

import info.earty.application.PartnerInbox;
import info.earty.domain.model.Aggregate;
import info.earty.domain.model.AggregateId;
import info.earty.domain.model.PartnerAggregateId;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class Inbox<A extends Aggregate<A>> {
    private final AggregateId<A> aggregateId;
    private final Map<PartnerAggregateId, PartnerInbox> partnerInboxes;

    public AggregateId<A> aggregateId() {
        return this.aggregateId;
    }

    public Inbox(AggregateId<A> aggregateId) {
        Objects.requireNonNull(aggregateId, this.getClass().getSimpleName() + " : aggregate id cannot be null");
        this.aggregateId = aggregateId;
        this.partnerInboxes = new HashMap<PartnerAggregateId, PartnerInbox>();
    }

    public void eventProcessed(PartnerAggregateId partnerId, int eventId) {
        if (!this.partnerInboxes.containsKey(partnerId)) {
            this.partnerInboxes.put(partnerId, new PartnerInbox(partnerId));
        }
        this.partnerInboxes.get(partnerId).eventProcessed(eventId);
    }

    public boolean duplicateEvent(PartnerAggregateId partnerId, int eventId) {
        return this.partnerInboxes.containsKey(partnerId) && this.partnerInboxes.get(partnerId).duplicateEvent(eventId);
    }

    private Inbox(AggregateId<A> aggregateId, Map<PartnerAggregateId, PartnerInbox> partnerInboxes) {
        this.aggregateId = aggregateId;
        this.partnerInboxes = partnerInboxes;
    }

    public static <A extends Aggregate<A>> Inbox<A> _load(AggregateId<A> aggregateId, Map<PartnerAggregateId, PartnerInbox> partnerInboxes) {
        return new Inbox<A>(aggregateId, partnerInboxes);
    }

    public Map<PartnerAggregateId, PartnerInbox> _partnerInboxes() {
        return this.partnerInboxes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Inbox)) {
            return false;
        }
        Inbox other = (Inbox)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AggregateId<A> this$aggregateId = this.aggregateId;
        AggregateId<A> other$aggregateId = other.aggregateId;
        return !(this$aggregateId == null ? other$aggregateId != null : !this$aggregateId.equals(other$aggregateId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Inbox;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AggregateId<A> $aggregateId = this.aggregateId;
        result = result * 59 + ($aggregateId == null ? 43 : $aggregateId.hashCode());
        return result;
    }
}

