/*
 * Decompiled with CFR 0.152.
 */
package info.earty.application;

import info.earty.application.Outbox;
import info.earty.application.OutboxRepository;
import info.earty.application.StoredEventPublisher;
import info.earty.application.UnitOfWork;
import info.earty.application.UnitOfWorkProvider;
import info.earty.domain.model.Aggregate;
import info.earty.domain.model.AggregateId;
import java.util.Collection;
import java.util.Optional;

public class NotificationService<A extends Aggregate<A>> {
    private final OutboxRepository<A> outboxRepository;
    private final UnitOfWorkProvider unitOfWorkProvider;
    private final StoredEventPublisher<A> storedEventPublisher;

    public void publishNotifications() {
        Collection<Outbox<A>> candidateOutboxes = this.outboxRepository.findByEventQueueNotEmpty();
        candidateOutboxes.forEach(candidateOutbox -> this.publishNotifications(candidateOutbox.aggregateId()));
    }

    private void publishNotifications(AggregateId<A> aggregateId) {
        UnitOfWork unitOfWork = this.unitOfWorkProvider.start();
        try {
            this.unitOfWorkProvider.start();
            Optional<Outbox<A>> optionalOutbox = this.outboxRepository.findByAggregateId(aggregateId);
            optionalOutbox.ifPresent(outbox -> {
                while (!outbox.empty()) {
                    this.storedEventPublisher.send(outbox.dequeue());
                }
            });
            unitOfWork.commit();
        }
        catch (Throwable t) {
            unitOfWork.rollback();
            throw t;
        }
    }

    public NotificationService(OutboxRepository<A> outboxRepository, UnitOfWorkProvider unitOfWorkProvider, StoredEventPublisher<A> storedEventPublisher) {
        this.outboxRepository = outboxRepository;
        this.unitOfWorkProvider = unitOfWorkProvider;
        this.storedEventPublisher = storedEventPublisher;
    }
}

