/*
 * Decompiled with CFR 0.152.
 */
package info.earty.application;

import info.earty.application.StoredEvent;
import info.earty.domain.model.Aggregate;
import info.earty.domain.model.AggregateId;
import info.earty.domain.model.DomainEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Outbox<A extends Aggregate<A>> {
    private static final int INITIAL_EVENT_ID = 1;
    private final AggregateId<A> aggregateId;
    private int nextEventId;
    private final List<StoredEvent<A>> eventQueue;

    public Outbox(AggregateId<A> aggregateId) {
        Objects.requireNonNull(aggregateId, this.getClass().getSimpleName() + " : aggregate id cannot be null");
        this.aggregateId = aggregateId;
        this.eventQueue = new ArrayList<StoredEvent<A>>();
        this.nextEventId = 1;
    }

    public AggregateId<A> aggregateId() {
        return this.aggregateId;
    }

    public void enqueue(DomainEvent<A> aDomainEvent) {
        Objects.requireNonNull(aDomainEvent, this.getClass().getSimpleName() + " : domain event cannot be null");
        this.eventQueue.add(new StoredEvent<A>(this.nextEventId(), aDomainEvent));
    }

    public StoredEvent<A> dequeue() {
        return this.eventQueue.remove(0);
    }

    public boolean empty() {
        return this.eventQueue.isEmpty();
    }

    private int nextEventId() {
        int nextEventId = this.nextEventId++;
        return nextEventId;
    }

    private Outbox(AggregateId<A> aggregateId, int nextEventId, List<StoredEvent<A>> eventQueue) {
        this.aggregateId = aggregateId;
        this.nextEventId = nextEventId;
        this.eventQueue = eventQueue;
    }

    public static <A extends Aggregate<A>> Outbox<A> _load(AggregateId<A> aggregateId, int nextEventId, List<StoredEvent<A>> eventQueue) {
        return new Outbox<A>(aggregateId, nextEventId, eventQueue);
    }

    public int _nextEventId() {
        return this.nextEventId;
    }

    public List<StoredEvent<A>> _eventQueue() {
        return this.eventQueue;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Outbox)) {
            return false;
        }
        Outbox other = (Outbox)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AggregateId<A> this$aggregateId = this.aggregateId;
        AggregateId<A> other$aggregateId = other.aggregateId;
        return !(this$aggregateId == null ? other$aggregateId != null : !this$aggregateId.equals(other$aggregateId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Outbox;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AggregateId<A> $aggregateId = this.aggregateId;
        result = result * 59 + ($aggregateId == null ? 43 : $aggregateId.hashCode());
        return result;
    }
}

