/*
 * Decompiled with CFR 0.152.
 */
package info.earty.application;

import info.earty.domain.model.Aggregate;
import info.earty.domain.model.DomainEvent;
import java.util.Objects;

public final class StoredEvent<A extends Aggregate<A>> {
    private final int id;
    private final DomainEvent<A> domainEvent;

    public StoredEvent(int id, DomainEvent<A> domainEvent) {
        Objects.requireNonNull(domainEvent, this.getClass().getSimpleName() + " : domain event cannot be null");
        this.id = id;
        this.domainEvent = domainEvent;
    }

    public int id() {
        return this.id;
    }

    public DomainEvent<A> domainEvent() {
        return this.domainEvent;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StoredEvent)) {
            return false;
        }
        StoredEvent other = (StoredEvent)o;
        if (this.id() != other.id()) {
            return false;
        }
        DomainEvent<A> this$domainEvent = this.domainEvent();
        DomainEvent<A> other$domainEvent = other.domainEvent();
        return !(this$domainEvent == null ? other$domainEvent != null : !this$domainEvent.equals(other$domainEvent));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.id();
        DomainEvent<A> $domainEvent = this.domainEvent();
        result = result * 59 + ($domainEvent == null ? 43 : $domainEvent.hashCode());
        return result;
    }

    public String toString() {
        return "StoredEvent(id=" + this.id() + ", domainEvent=" + this.domainEvent() + ")";
    }
}

