/*
 * Decompiled with CFR 0.152.
 */
package info.earty.application.aspect;

import info.earty.application.OutboxEnqueueSubscriber;
import info.earty.application.OutboxRepository;
import info.earty.application.UnitOfWorkProvider;
import info.earty.application.aspect.UnitOfWork;
import info.earty.domain.model.Aggregate;
import info.earty.domain.model.DomainEventPublisher;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;

@Aspect
public class UnitOfWorkAspect {
    private final UnitOfWorkProvider unitOfWorkProvider;
    private final Map<Class<? extends Aggregate<?>>, OutboxRepository<?>> outboxRepositoryMap;

    public UnitOfWorkAspect(UnitOfWorkProvider unitOfWorkProvider, List<OutboxRepository<?>> outboxRepositories) {
        this.unitOfWorkProvider = unitOfWorkProvider;
        this.outboxRepositoryMap = outboxRepositories.stream().collect(Collectors.toMap(OutboxRepository::aggregateType, Function.identity()));
    }

    @Around(value="@annotation(unitOfWork))")
    public Object unitOfWorkAroundAdvice(ProceedingJoinPoint joinPoint, UnitOfWork unitOfWork) throws Throwable {
        return this.unitOfWorkAdvice(joinPoint, unitOfWork);
    }

    @Around(value="@within(unitOfWork) && !@annotation(info.earty.application.aspect.UnitOfWork)")
    public Object unitOfWorkWithinAdvice(ProceedingJoinPoint joinPoint, UnitOfWork unitOfWork) throws Throwable {
        return this.unitOfWorkAdvice(joinPoint, unitOfWork);
    }

    private Object unitOfWorkAdvice(ProceedingJoinPoint joinPoint, UnitOfWork unitOfWorkAnnotation) throws Throwable {
        DomainEventPublisher.instance().reset();
        for (Class<? extends Aggregate<?>> aggregateType : unitOfWorkAnnotation.outboxEnqueuers()) {
            DomainEventPublisher.instance().subscribe(new OutboxEnqueueSubscriber(aggregateType, this.outboxRepositoryMap.get(aggregateType)));
        }
        info.earty.application.UnitOfWork unitOfWork = this.unitOfWorkProvider.start();
        try {
            Object result = joinPoint.proceed();
            unitOfWork.commit();
            return result;
        }
        catch (Throwable t) {
            unitOfWork.rollback();
            throw t;
        }
    }
}

