/*
 * Decompiled with CFR 0.152.
 */
package info.freelibrary.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.jar.JarFile;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IOUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(IOUtils.class);

    private IOUtils() {
    }

    public static void closeQuietly(Reader aReader) {
        if (aReader != null) {
            try {
                aReader.close();
            }
            catch (IOException details) {
                LOGGER.error(details.getMessage(), (Throwable)details);
            }
        }
    }

    public static void closeQuietly(Writer aWriter) {
        if (aWriter != null) {
            try {
                aWriter.close();
            }
            catch (IOException details) {
                LOGGER.error(details.getMessage(), (Throwable)details);
            }
        }
    }

    public static void closeQuietly(InputStream aInputStream) {
        if (aInputStream != null) {
            try {
                aInputStream.close();
            }
            catch (IOException details) {
                LOGGER.error(details.getMessage(), (Throwable)details);
            }
        }
    }

    public static void closeQuietly(ImageInputStream aImageInputStream) {
        if (aImageInputStream != null) {
            try {
                aImageInputStream.close();
            }
            catch (IOException details) {
                LOGGER.error(details.getMessage(), (Throwable)details);
            }
        }
    }

    public static void closeQuietly(ImageOutputStream aImageOutputStream) {
        if (aImageOutputStream != null) {
            try {
                aImageOutputStream.close();
            }
            catch (IOException details) {
                LOGGER.error(details.getMessage(), (Throwable)details);
            }
        }
    }

    public static void closeQuietly(OutputStream aOutputStream) {
        if (aOutputStream != null) {
            try {
                aOutputStream.close();
            }
            catch (IOException details) {
                LOGGER.error(details.getMessage(), (Throwable)details);
            }
        }
    }

    public static void closeQuietly(JarFile aJarFile) {
        if (aJarFile != null) {
            try {
                aJarFile.close();
            }
            catch (IOException details) {
                LOGGER.error(details.getMessage(), (Throwable)details);
            }
        }
    }

    public static void copyStream(InputStream aInStream, OutputStream aOutStream) throws IOException {
        BufferedOutputStream outStream = new BufferedOutputStream(aOutStream);
        BufferedInputStream inStream = new BufferedInputStream(aInStream);
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int bytesRead = 0;
        while ((bytesRead = inStream.read(buffer)) != -1) {
            byteStream.write(buffer, 0, bytesRead);
        }
        outStream.write(byteStream.toByteArray());
        outStream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStream(File aFile, OutputStream aOutStream) throws IOException {
        FileInputStream input = new FileInputStream(aFile);
        FileChannel channel = input.getChannel();
        byte[] buffer = new byte[262144];
        ByteBuffer byteBuffer = ByteBuffer.wrap(buffer);
        try {
            int length = 0;
            while ((length = channel.read(byteBuffer)) != -1) {
                aOutStream.write(buffer, 0, length);
                byteBuffer.clear();
            }
        }
        finally {
            input.close();
        }
    }

    public static byte[] readBytes(InputStream aInputStream) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int read = 0;
        while (read != -1) {
            read = aInputStream.read(buffer);
            if (read <= 0) continue;
            baos.write(buffer, 0, read);
        }
        IOUtils.closeQuietly(aInputStream);
        return baos.toByteArray();
    }
}

