/*
 * Decompiled with CFR 0.152.
 */
package info.freelibrary.util;

import info.freelibrary.util.JarUtils;
import info.freelibrary.util.Logger;
import info.freelibrary.util.LoggerFactory;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;

public class JarClassLoader
extends URLClassLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(JarClassLoader.class, "freelib-utils_messages");

    public JarClassLoader(String aMainClassName) throws IOException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException, ClassNotFoundException {
        super(JarUtils.getJarURLs());
        LOGGER.debug("UTIL-001", (Object)aMainClassName);
        this.loadClass(aMainClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public JarClassLoader(URL[] aURLs, String aMainClassName) throws IOException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException, ClassNotFoundException {
        super(aURLs);
        this.loadClass(aMainClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public JarClassLoader(List<URL> aListOfURLs, String aMainClassName) throws IOException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException, ClassNotFoundException {
        super(aListOfURLs.toArray(new URL[0]));
        this.loadClass(aMainClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    @Override
    public Class<?> loadClass(String aName) throws ClassNotFoundException {
        Class<?> loadedClass = this.findLoadedClass(aName);
        if (loadedClass == null) {
            try {
                loadedClass = this.findClass(aName);
            }
            catch (ClassNotFoundException details) {
                LOGGER.trace("Class for {} not found... trying super class", (Object)aName, (Object)details);
                loadedClass = super.loadClass(aName);
            }
        }
        return loadedClass;
    }
}

