/*
 * Decompiled with CFR 0.152.
 */
package info.freelibrary.util;

import info.freelibrary.util.I18nObject;
import info.freelibrary.util.StringUtils;
import org.slf4j.MDC;
import org.slf4j.Marker;

public class Logger
extends I18nObject
implements org.slf4j.Logger {
    private static final String EOL_RE = "(\\n|\\r|\\r\\n)";
    private static final String LINE_NUM = "line";
    private final org.slf4j.Logger myLogger;

    Logger(org.slf4j.Logger aLogger) {
        this.myLogger = aLogger;
    }

    Logger(org.slf4j.Logger aLogger, String aBundleName) {
        super(aBundleName);
        this.myLogger = aLogger;
    }

    public void debug(String aMessage) {
        if (this.isDebugEnabled()) {
            MDC.MDCCloseable closeable = this.setLineNumber();
            if (this.hasI18nKey(aMessage)) {
                this.myLogger.debug(this.getI18n(aMessage));
            } else {
                this.myLogger.debug(aMessage);
            }
            this.clearLineNumber(closeable);
        }
    }

    public void debug(String aMessage, Object aDetail) {
        if (this.isDebugEnabled()) {
            MDC.MDCCloseable closeable = this.setLineNumber();
            if (this.hasI18nKey(aMessage)) {
                this.myLogger.debug(this.getI18n(aMessage), aDetail);
            } else {
                this.myLogger.debug(aMessage, aDetail);
            }
            this.clearLineNumber(closeable);
        }
    }

    public void debug(String aMessage, Object ... aDetails) {
        if (this.isDebugEnabled()) {
            MDC.MDCCloseable closeable = this.setLineNumber();
            if (this.hasI18nKey(aMessage)) {
                this.myLogger.debug(this.getI18n(aMessage), aDetails);
            } else {
                this.myLogger.debug(aMessage, aDetails);
            }
            this.clearLineNumber(closeable);
        }
    }

    public void debug(String aMessage, Throwable aThrowable) {
        if (this.isDebugEnabled()) {
            MDC.MDCCloseable closeable = this.setLineNumber();
            if (this.hasI18nKey(aMessage)) {
                if (aThrowable != null) {
                    this.myLogger.debug(this.getI18n(aMessage), aThrowable);
                } else {
                    this.myLogger.debug(this.getI18n(aMessage));
                }
            } else if (aThrowable != null) {
                this.myLogger.debug(aMessage, aThrowable);
            } else {
                this.myLogger.debug(aMessage);
            }
            this.clearLineNumber(closeable);
        }
    }

    public void debug(Marker aMarker, String aMessage) {
        if (this.isDebugEnabled()) {
            MDC.MDCCloseable closeable = this.setLineNumber();
            this.addMarker(aMarker);
            if (this.hasI18nKey(aMessage)) {
                this.myLogger.debug(aMarker, this.updateMessage(this.getI18n(aMessage)));
            } else {
                this.myLogger.debug(aMarker, this.updateMessage(aMessage));
            }
            this.clearMarker();
            this.clearLineNumber(closeable);
        }
    }

    public void debug(String aMessage, Object a1stDetail, Object a2ndDetail) {
        if (this.isDebugEnabled()) {
            MDC.MDCCloseable closeable = this.setLineNumber();
            if (this.hasI18nKey(aMessage)) {
                this.myLogger.debug(this.getI18n(aMessage), a1stDetail, a2ndDetail);
            } else {
                this.myLogger.debug(aMessage, a1stDetail, a2ndDetail);
            }
            this.clearLineNumber(closeable);
        }
    }

    public void debug(Marker aMarker, String aMessage, Object aDetail) {
        if (this.isDebugEnabled()) {
            MDC.MDCCloseable closeable = this.setLineNumber();
            this.addMarker(aMarker);
            if (this.hasI18nKey(aMessage)) {
                String message = this.updateMessage(aDetail.toString());
                this.myLogger.debug(aMarker, this.updateMessage(this.getI18n(aMessage)), (Object)message);
            } else {
                this.myLogger.debug(aMarker, this.updateMessage(aMessage), (Object)this.updateMessage(aDetail.toString()));
            }
            this.clearMarker();
            this.clearLineNumber(closeable);
        }
    }

    public void debug(Marker aMarker, String aMessage, Object ... aDetails) {
        if (this.isDebugEnabled()) {
            MDC.MDCCloseable closeable = this.setLineNumber();
            Object[] details = new String[aDetails.length];
            this.addMarker(aMarker);
            for (int index = 0; index < aDetails.length; ++index) {
                details[index] = this.updateMessage(aDetails[index].toString());
            }
            if (this.hasI18nKey(aMessage)) {
                this.myLogger.debug(aMarker, this.updateMessage(this.getI18n(aMessage)), details);
            } else {
                this.myLogger.debug(aMarker, this.updateMessage(aMessage), details);
            }
            this.clearMarker();
            this.clearLineNumber(closeable);
        }
    }

    public void debug(Marker aMarker, String aMessage, Throwable aThrowable) {
        if (this.isDebugEnabled()) {
            MDC.MDCCloseable closeable = this.setLineNumber();
            this.addMarker(aMarker);
            if (this.hasI18nKey(aMessage)) {
                if (aThrowable != null) {
                    this.myLogger.debug(aMarker, this.updateMessage(this.getI18n(aMessage)), aThrowable);
                } else {
                    this.myLogger.debug(aMarker, this.updateMessage(this.getI18n(aMessage)));
                }
            } else if (aThrowable != null) {
                this.myLogger.debug(aMarker, this.updateMessage(aMessage), aThrowable);
            } else {
                this.myLogger.debug(aMarker, this.updateMessage(aMessage));
            }
            this.clearMarker();
            this.clearLineNumber(closeable);
        }
    }

    public void debug(Marker aMarker, String aMessage, Object a1stDetail, Object a2ndDetail) {
        if (this.isDebugEnabled()) {
            MDC.MDCCloseable closeable = this.setLineNumber();
            String detail1 = a1stDetail.toString();
            String detail2 = a2ndDetail.toString();
            this.addMarker(aMarker);
            if (this.hasI18nKey(aMessage)) {
                this.myLogger.debug(aMarker, this.updateMessage(this.getI18n(aMessage)), (Object)this.updateMessage(detail1), (Object)this.updateMessage(detail2));
            } else {
                this.myLogger.debug(aMarker, this.updateMessage(aMessage), (Object)this.updateMessage(detail1), (Object)this.updateMessage(detail2));
            }
            this.clearMarker();
            this.clearLineNumber(closeable);
        }
    }

    public void error(String aMessage) {
        if (this.isErrorEnabled()) {
            MDC.MDCCloseable closeable = this.setLineNumber();
            if (this.hasI18nKey(aMessage)) {
                this.myLogger.error(this.getI18n(aMessage));
            } else {
                this.myLogger.error(aMessage);
            }
            this.clearLineNumber(closeable);
        }
    }

    public void error(String aMessage, Object aDetail) {
        if (this.isErrorEnabled()) {
            MDC.MDCCloseable closeable = this.setLineNumber();
            if (this.hasI18nKey(aMessage)) {
                this.myLogger.error(this.getI18n(aMessage), aDetail);
            } else {
                this.myLogger.error(aMessage, aDetail);
            }
            this.clearLineNumber(closeable);
        }
    }

    public void error(String aMessage, Object ... aDetails) {
        if (this.isErrorEnabled()) {
            MDC.MDCCloseable closeable = this.setLineNumber();
            if (this.hasI18nKey(aMessage)) {
                this.myLogger.error(this.getI18n(aMessage), aDetails);
            } else {
                this.myLogger.error(aMessage, aDetails);
            }
            this.clearLineNumber(closeable);
        }
    }

    public void error(String aMessage, Throwable aThrowable) {
        if (this.isErrorEnabled()) {
            MDC.MDCCloseable closeable = this.setLineNumber();
            if (this.hasI18nKey(aMessage)) {
                if (aThrowable != null) {
                    this.myLogger.error(this.getI18n(aMessage), aThrowable);
                } else {
                    this.myLogger.error(this.getI18n(aMessage));
                }
            } else if (aThrowable != null) {
                this.myLogger.error(aMessage, aThrowable);
            } else {
                this.myLogger.error(aMessage);
            }
            this.clearLineNumber(closeable);
        }
    }

    public void error(Throwable aThrowable, String aMessage) {
        if (this.isErrorEnabled()) {
            MDC.MDCCloseable closeable = this.setLineNumber();
            if (this.hasI18nKey(aMessage)) {
                if (aThrowable != null) {
                    this.myLogger.error(this.getI18n(aMessage), aThrowable);
                } else {
                    this.myLogger.error(this.getI18n(aMessage));
                }
            } else if (aThrowable != null) {
                this.myLogger.error(aMessage, aThrowable);
            } else {
                this.myLogger.error(aMessage);
            }
            this.clearLineNumber(closeable);
        }
    }

    public void error(Throwable aThrowable, String aMessage, Object ... aVarargs) {
        if (this.isErrorEnabled()) {
            MDC.MDCCloseable closeable = this.setLineNumber();
            if (this.hasI18nKey(aMessage)) {
                if (aThrowable != null) {
                    this.myLogger.error(this.getI18n(aMessage, aVarargs), aThrowable);
                } else {
                    this.myLogger.error(this.getI18n(aMessage, aVarargs));
                }
            } else if (aThrowable != null) {
                if (aVarargs.length == 0) {
                    this.myLogger.error(aMessage, aThrowable);
                } else {
                    this.myLogger.error(StringUtils.format(aMessage, aVarargs), aThrowable);
                }
            } else if (aVarargs.length == 0) {
                this.myLogger.error(aMessage);
            } else {
                this.myLogger.error(aMessage, aVarargs);
            }
            this.clearLineNumber(closeable);
        }
    }

    public void error(Marker aMarker, String aMessage) {
        if (this.isErrorEnabled()) {
            MDC.MDCCloseable closeable = this.setLineNumber();
            this.addMarker(aMarker);
            if (this.hasI18nKey(aMessage)) {
                this.myLogger.error(aMarker, this.updateMessage(this.getI18n(aMessage)));
            } else {
                this.myLogger.error(aMarker, this.updateMessage(aMessage));
            }
            this.clearMarker();
            this.clearLineNumber(closeable);
        }
    }

    public void error(String aMessage, Object a1stDetail, Object a2ndDetail) {
        if (this.isErrorEnabled()) {
            MDC.MDCCloseable closeable = this.setLineNumber();
            if (this.hasI18nKey(aMessage)) {
                this.myLogger.error(this.getI18n(aMessage), a1stDetail, a2ndDetail);
            } else {
                this.myLogger.error(aMessage, a1stDetail, a2ndDetail);
            }
            this.clearLineNumber(closeable);
        }
    }

    public void error(Marker aMarker, String aMessage, Object aDetail) {
        if (this.isErrorEnabled()) {
            MDC.MDCCloseable closeable = this.setLineNumber();
            String detail = aDetail.toString();
            this.addMarker(aMarker);
            if (this.hasI18nKey(aMessage)) {
                this.myLogger.error(aMarker, this.updateMessage(this.getI18n(aMessage)), (Object)this.updateMessage(detail));
            } else {
                this.myLogger.error(aMarker, this.updateMessage(aMessage), (Object)this.updateMessage(detail));
            }
            this.clearMarker();
            this.clearLineNumber(closeable);
        }
    }

    public void error(Marker aMarker, String aMessage, Object ... aDetails) {
        if (this.isErrorEnabled()) {
            MDC.MDCCloseable closeable = this.setLineNumber();
            Object[] details = new String[aDetails.length];
            this.addMarker(aMarker);
            for (int index = 0; index < details.length; ++index) {
                details[index] = this.updateMessage(aDetails[index].toString());
            }
            if (this.hasI18nKey(aMessage)) {
                this.myLogger.error(aMarker, this.updateMessage(this.getI18n(aMessage)), details);
            } else {
                this.myLogger.error(aMarker, this.updateMessage(aMessage), details);
            }
            this.clearMarker();
            this.clearLineNumber(closeable);
        }
    }

    public void error(Marker aMarker, String aMessage, Throwable aThrowable) {
        if (this.isErrorEnabled()) {
            MDC.MDCCloseable closeable = this.setLineNumber();
            this.addMarker(aMarker);
            if (this.hasI18nKey(aMessage)) {
                if (aThrowable != null) {
                    this.myLogger.error(aMarker, this.updateMessage(this.getI18n(aMessage)), aThrowable);
                } else {
                    this.myLogger.error(aMarker, this.updateMessage(this.getI18n(aMessage)));
                }
            } else if (aThrowable != null) {
                this.myLogger.error(aMarker, this.updateMessage(aMessage), aThrowable);
            } else {
                this.myLogger.error(aMarker, this.updateMessage(aMessage));
            }
            this.clearMarker();
            this.clearLineNumber(closeable);
        }
    }

    public void error(Marker aMarker, String aMessage, Object a1stDetail, Object a2ndDetail) {
        if (this.isErrorEnabled()) {
            MDC.MDCCloseable closeable = this.setLineNumber();
            String detail1 = a1stDetail.toString();
            String detail2 = a2ndDetail.toString();
            this.addMarker(aMarker);
            if (this.hasI18nKey(aMessage)) {
                this.myLogger.error(aMarker, this.updateMessage(this.getI18n(aMessage)), (Object)this.updateMessage(detail1), (Object)this.updateMessage(detail2));
            } else {
                this.myLogger.error(aMarker, this.updateMessage(aMessage), (Object)this.updateMessage(detail1), (Object)this.updateMessage(detail2));
            }
            this.clearMarker();
            this.clearLineNumber(closeable);
        }
    }

    public String getName() {
        return this.myLogger.getName();
    }

    public void info(String aMessage) {
        if (this.isInfoEnabled()) {
            MDC.MDCCloseable closeable = this.setDebugLineNumber();
            if (this.hasI18nKey(aMessage)) {
                this.myLogger.info(this.getI18n(aMessage));
            } else {
                this.myLogger.info(aMessage);
            }
            this.clearLineNumber(closeable);
        }
    }

    public void info(String aMessage, Object aDetail) {
        if (this.isInfoEnabled()) {
            MDC.MDCCloseable closeable = this.setDebugLineNumber();
            if (this.hasI18nKey(aMessage)) {
                this.myLogger.info(this.getI18n(aMessage), aDetail);
            } else {
                this.myLogger.info(aMessage, aDetail);
            }
            this.clearLineNumber(closeable);
        }
    }

    public void info(String aMessage, Object ... aDetails) {
        if (this.isInfoEnabled()) {
            MDC.MDCCloseable closeable = this.setDebugLineNumber();
            if (this.hasI18nKey(aMessage)) {
                this.myLogger.info(this.getI18n(aMessage), aDetails);
            } else {
                this.myLogger.info(aMessage, aDetails);
            }
            this.clearLineNumber(closeable);
        }
    }

    public void info(String aMessage, Throwable aThrowable) {
        if (this.isInfoEnabled()) {
            MDC.MDCCloseable closeable = this.setDebugLineNumber();
            if (this.hasI18nKey(aMessage)) {
                if (aThrowable != null) {
                    this.myLogger.info(this.getI18n(aMessage), aThrowable);
                } else {
                    this.myLogger.info(this.getI18n(aMessage));
                }
            } else if (aThrowable != null) {
                this.myLogger.info(aMessage, aThrowable);
            } else {
                this.myLogger.info(aMessage);
            }
            this.clearLineNumber(closeable);
        }
    }

    public void info(Marker aMarker, String aMessage) {
        if (this.isInfoEnabled()) {
            MDC.MDCCloseable closeable = this.setDebugLineNumber();
            this.addMarker(aMarker);
            if (this.hasI18nKey(aMessage)) {
                this.myLogger.info(aMarker, this.updateMessage(this.getI18n(aMessage)));
            } else {
                this.myLogger.info(aMarker, this.updateMessage(aMessage));
            }
            this.clearMarker();
            this.clearLineNumber(closeable);
        }
    }

    public void info(String aMessage, Object a1stDetail, Object a2ndDetail) {
        if (this.isInfoEnabled()) {
            MDC.MDCCloseable closeable = this.setDebugLineNumber();
            if (this.hasI18nKey(aMessage)) {
                this.myLogger.info(this.getI18n(aMessage), a1stDetail, a2ndDetail);
            } else {
                this.myLogger.info(aMessage, a1stDetail, a2ndDetail);
            }
            this.clearLineNumber(closeable);
        }
    }

    public void info(Marker aMarker, String aMessage, Object aDetail) {
        if (this.isInfoEnabled()) {
            MDC.MDCCloseable closeable = this.setDebugLineNumber();
            String detail = aDetail.toString();
            this.addMarker(aMarker);
            if (this.hasI18nKey(aMessage)) {
                this.myLogger.info(aMarker, this.updateMessage(this.getI18n(aMessage)), (Object)this.updateMessage(detail));
            } else {
                this.myLogger.info(aMarker, this.updateMessage(aMessage), (Object)this.updateMessage(detail));
            }
            this.clearMarker();
            this.clearLineNumber(closeable);
        }
    }

    public void info(Marker aMarker, String aMessage, Object ... aDetails) {
        if (this.isInfoEnabled()) {
            MDC.MDCCloseable closeable = this.setDebugLineNumber();
            Object[] details = new String[aDetails.length];
            this.addMarker(aMarker);
            for (int index = 0; index < details.length; ++index) {
                details[index] = this.updateMessage(aDetails[index].toString());
            }
            if (this.hasI18nKey(aMessage)) {
                this.myLogger.info(aMarker, this.updateMessage(this.getI18n(aMessage)), details);
            } else {
                this.myLogger.info(aMarker, this.updateMessage(aMessage), details);
            }
            this.clearMarker();
            this.clearLineNumber(closeable);
        }
    }

    public void info(Marker aMarker, String aMessage, Throwable aThrowable) {
        if (this.isInfoEnabled()) {
            MDC.MDCCloseable closeable = this.setDebugLineNumber();
            this.addMarker(aMarker);
            if (this.hasI18nKey(aMessage)) {
                if (aThrowable != null) {
                    this.myLogger.info(aMarker, this.updateMessage(this.getI18n(aMessage)), aThrowable);
                } else {
                    this.myLogger.info(aMarker, this.updateMessage(this.getI18n(aMessage)));
                }
            } else if (aThrowable != null) {
                this.myLogger.info(aMarker, this.updateMessage(aMessage), aThrowable);
            } else {
                this.myLogger.info(aMarker, this.updateMessage(aMessage));
            }
            this.clearMarker();
            this.clearLineNumber(closeable);
        }
    }

    public void info(Marker aMarker, String aMessage, Object a1stDetail, Object a2ndDetail) {
        if (this.isInfoEnabled()) {
            MDC.MDCCloseable closeable = this.setDebugLineNumber();
            String detail1 = a1stDetail.toString();
            String detail2 = a2ndDetail.toString();
            this.addMarker(aMarker);
            if (this.hasI18nKey(aMessage)) {
                this.myLogger.info(aMarker, this.updateMessage(this.getI18n(aMessage)), (Object)this.updateMessage(detail1), (Object)this.updateMessage(detail2));
            } else {
                this.myLogger.info(aMarker, this.updateMessage(aMessage), (Object)this.updateMessage(detail1), (Object)this.updateMessage(detail2));
            }
            this.clearMarker();
            this.clearLineNumber(closeable);
        }
    }

    public boolean isDebugEnabled() {
        return this.myLogger.isDebugEnabled();
    }

    public boolean isDebugEnabled(Marker aMarker) {
        return this.myLogger.isDebugEnabled(aMarker);
    }

    public boolean isErrorEnabled() {
        return this.myLogger.isErrorEnabled();
    }

    public boolean isErrorEnabled(Marker aMarker) {
        return this.myLogger.isErrorEnabled(aMarker);
    }

    public boolean isInfoEnabled() {
        return this.myLogger.isInfoEnabled();
    }

    public boolean isInfoEnabled(Marker aMarker) {
        return this.myLogger.isInfoEnabled(aMarker);
    }

    public boolean isTraceEnabled() {
        return this.myLogger.isTraceEnabled();
    }

    public boolean isTraceEnabled(Marker aMarker) {
        return this.myLogger.isTraceEnabled(aMarker);
    }

    public boolean isWarnEnabled() {
        return this.myLogger.isWarnEnabled();
    }

    public boolean isWarnEnabled(Marker aMarker) {
        return this.myLogger.isWarnEnabled(aMarker);
    }

    public void trace(String aMessage) {
        if (this.isTraceEnabled()) {
            MDC.MDCCloseable closeable = this.setLineNumber();
            if (this.hasI18nKey(aMessage)) {
                this.myLogger.trace(this.getI18n(aMessage));
            } else {
                this.myLogger.trace(aMessage);
            }
            this.clearLineNumber(closeable);
        }
    }

    public void trace(String aMessage, Object aDetail) {
        if (this.isTraceEnabled()) {
            MDC.MDCCloseable closeable = this.setLineNumber();
            if (this.hasI18nKey(aMessage)) {
                this.myLogger.trace(this.getI18n(aMessage), aDetail);
            } else {
                this.myLogger.trace(aMessage, aDetail);
            }
            this.clearLineNumber(closeable);
        }
    }

    public void trace(String aMessage, Object ... aDetails) {
        if (this.isTraceEnabled()) {
            MDC.MDCCloseable closeable = this.setLineNumber();
            if (this.hasI18nKey(aMessage)) {
                this.myLogger.trace(this.getI18n(aMessage), aDetails);
            } else {
                this.myLogger.trace(aMessage, aDetails);
            }
            this.clearLineNumber(closeable);
        }
    }

    public void trace(String aMessage, Throwable aThrowable) {
        if (this.isTraceEnabled()) {
            MDC.MDCCloseable closeable = this.setLineNumber();
            if (this.hasI18nKey(aMessage)) {
                if (aThrowable != null) {
                    this.myLogger.trace(this.getI18n(aMessage), aThrowable);
                } else {
                    this.myLogger.trace(this.getI18n(aMessage));
                }
            } else if (aThrowable != null) {
                this.myLogger.trace(aMessage, aThrowable);
            } else {
                this.myLogger.trace(aMessage);
            }
            this.clearLineNumber(closeable);
        }
    }

    public void trace(Marker aMarker, String aMessage) {
        if (this.isTraceEnabled()) {
            MDC.MDCCloseable closeable = this.setLineNumber();
            this.addMarker(aMarker);
            if (this.hasI18nKey(aMessage)) {
                this.myLogger.trace(aMarker, this.updateMessage(this.getI18n(aMessage)));
            } else {
                this.myLogger.trace(aMarker, this.updateMessage(aMessage));
            }
            this.clearMarker();
            this.clearLineNumber(closeable);
        }
    }

    public void trace(String aMessage, Object a1stDetail, Object a2ndDetail) {
        if (this.isTraceEnabled()) {
            MDC.MDCCloseable closeable = this.setLineNumber();
            if (this.hasI18nKey(aMessage)) {
                this.myLogger.trace(this.getI18n(aMessage), a1stDetail, a2ndDetail);
            } else {
                this.myLogger.trace(aMessage, a1stDetail, a2ndDetail);
            }
            this.clearLineNumber(closeable);
        }
    }

    public void trace(Marker aMarker, String aMessage, Object aDetail) {
        if (this.isTraceEnabled()) {
            MDC.MDCCloseable closeable = this.setLineNumber();
            String detail = aDetail.toString();
            this.addMarker(aMarker);
            if (this.hasI18nKey(aMessage)) {
                this.myLogger.trace(aMarker, this.updateMessage(this.getI18n(aMessage)), (Object)this.updateMessage(detail));
            } else {
                this.myLogger.trace(aMarker, this.updateMessage(aMessage), (Object)this.updateMessage(detail));
            }
            this.clearMarker();
            this.clearLineNumber(closeable);
        }
    }

    public void trace(Marker aMarker, String aMessage, Object ... aDetails) {
        if (this.isTraceEnabled()) {
            MDC.MDCCloseable closeable = this.setLineNumber();
            Object[] details = new String[aDetails.length];
            this.addMarker(aMarker);
            for (int index = 0; index < details.length; ++index) {
                details[index] = this.updateMessage(aDetails[index].toString());
            }
            if (this.hasI18nKey(aMessage)) {
                this.myLogger.trace(aMarker, this.updateMessage(this.getI18n(aMessage)), details);
            } else {
                this.myLogger.trace(aMarker, this.updateMessage(aMessage), details);
            }
            this.clearMarker();
            this.clearLineNumber(closeable);
        }
    }

    public void trace(Marker aMarker, String aMessage, Throwable aThrowable) {
        if (this.isTraceEnabled()) {
            MDC.MDCCloseable closeable = this.setLineNumber();
            this.addMarker(aMarker);
            if (this.hasI18nKey(aMessage)) {
                if (aThrowable != null) {
                    this.myLogger.trace(aMarker, this.updateMessage(this.getI18n(aMessage)), aThrowable);
                } else {
                    this.myLogger.trace(aMarker, this.updateMessage(this.getI18n(aMessage)));
                }
            } else if (aThrowable != null) {
                this.myLogger.trace(aMarker, this.updateMessage(aMessage), aThrowable);
            } else {
                this.myLogger.trace(aMarker, this.updateMessage(aMessage));
            }
            this.clearMarker();
            this.clearLineNumber(closeable);
        }
    }

    public void trace(Marker aMarker, String aMessage, Object a1stDetail, Object a2ndDetail) {
        if (this.isTraceEnabled()) {
            MDC.MDCCloseable closeable = this.setLineNumber();
            String detail1 = a1stDetail.toString();
            String detail2 = a2ndDetail.toString();
            this.addMarker(aMarker);
            if (this.hasI18nKey(aMessage)) {
                this.myLogger.trace(aMarker, this.updateMessage(this.getI18n(aMessage)), (Object)this.updateMessage(detail1), (Object)this.updateMessage(detail2));
            } else {
                this.myLogger.trace(aMarker, this.updateMessage(aMessage), (Object)this.updateMessage(detail1), (Object)this.updateMessage(detail2));
            }
            this.clearMarker();
            this.clearLineNumber(closeable);
        }
    }

    public void warn(String aMessage) {
        if (this.isWarnEnabled()) {
            MDC.MDCCloseable closeable = this.setDebugLineNumber();
            if (this.hasI18nKey(aMessage)) {
                this.myLogger.warn(this.getI18n(aMessage));
            } else {
                this.myLogger.warn(aMessage);
            }
            this.clearLineNumber(closeable);
        }
    }

    public void warn(String aMessage, Object aDetail) {
        if (this.isWarnEnabled()) {
            MDC.MDCCloseable closeable = this.setDebugLineNumber();
            if (this.hasI18nKey(aMessage)) {
                this.myLogger.warn(this.getI18n(aMessage), aDetail);
            } else {
                this.myLogger.warn(aMessage, aDetail);
            }
            this.clearLineNumber(closeable);
        }
    }

    public void warn(String aMessage, Object ... aDetails) {
        if (this.isWarnEnabled()) {
            MDC.MDCCloseable closeable = this.setDebugLineNumber();
            if (this.hasI18nKey(aMessage)) {
                this.myLogger.warn(this.getI18n(aMessage), aDetails);
            } else {
                this.myLogger.warn(aMessage, aDetails);
            }
            this.clearLineNumber(closeable);
        }
    }

    public void warn(String aMessage, Throwable aThrowable) {
        if (this.isWarnEnabled()) {
            MDC.MDCCloseable closeable = this.setDebugLineNumber();
            if (this.hasI18nKey(aMessage)) {
                if (aThrowable != null) {
                    this.myLogger.warn(this.getI18n(aMessage), aThrowable);
                } else {
                    this.myLogger.warn(this.getI18n(aMessage));
                }
            } else if (aThrowable != null) {
                this.myLogger.warn(aMessage, aThrowable);
            } else {
                this.myLogger.warn(aMessage);
            }
            this.clearLineNumber(closeable);
        }
    }

    public void warn(Marker aMarker, String aMessage) {
        if (this.isWarnEnabled()) {
            MDC.MDCCloseable closeable = this.setDebugLineNumber();
            this.addMarker(aMarker);
            if (this.hasI18nKey(aMessage)) {
                this.myLogger.warn(aMarker, this.updateMessage(this.getI18n(aMessage)));
            } else {
                this.myLogger.warn(aMarker, this.updateMessage(aMessage));
            }
            this.clearMarker();
            this.clearLineNumber(closeable);
        }
    }

    public void warn(String aMessage, Object a1stDetail, Object a2ndDetail) {
        if (this.isWarnEnabled()) {
            MDC.MDCCloseable closeable = this.setDebugLineNumber();
            if (this.hasI18nKey(aMessage)) {
                this.myLogger.warn(this.getI18n(aMessage), a1stDetail, a2ndDetail);
            } else {
                this.myLogger.warn(aMessage, a1stDetail, a2ndDetail);
            }
            this.clearLineNumber(closeable);
        }
    }

    public void warn(Marker aMarker, String aMessage, Object aDetail) {
        if (this.isWarnEnabled()) {
            MDC.MDCCloseable closeable = this.setDebugLineNumber();
            String detail = aDetail.toString();
            this.addMarker(aMarker);
            if (this.hasI18nKey(aMessage)) {
                this.myLogger.warn(aMarker, this.updateMessage(this.getI18n(aMessage)), (Object)this.updateMessage(detail));
            } else {
                this.myLogger.warn(aMarker, this.updateMessage(aMessage), (Object)this.updateMessage(detail));
            }
            this.clearMarker();
            this.clearLineNumber(closeable);
        }
    }

    public void warn(Marker aMarker, String aMessage, Object ... aDetails) {
        if (this.isWarnEnabled()) {
            MDC.MDCCloseable closeable = this.setDebugLineNumber();
            Object[] details = new String[aDetails.length];
            this.addMarker(aMarker);
            for (int index = 0; index < details.length; ++index) {
                details[index] = this.updateMessage(aDetails[index].toString());
            }
            if (this.hasI18nKey(aMessage)) {
                this.myLogger.warn(aMarker, this.updateMessage(this.getI18n(aMessage)), details);
            } else {
                this.myLogger.warn(aMarker, this.updateMessage(aMessage), details);
            }
            this.clearMarker();
            this.clearLineNumber(closeable);
        }
    }

    public void warn(Marker aMarker, String aMessage, Throwable aThrowable) {
        if (this.isWarnEnabled()) {
            MDC.MDCCloseable closeable = this.setDebugLineNumber();
            this.addMarker(aMarker);
            if (this.hasI18nKey(aMessage)) {
                if (aThrowable != null) {
                    this.myLogger.warn(aMarker, this.updateMessage(this.getI18n(aMessage)), aThrowable);
                } else {
                    this.myLogger.warn(aMarker, this.updateMessage(this.getI18n(aMessage)));
                }
            } else if (aThrowable != null) {
                this.myLogger.warn(aMarker, this.updateMessage(aMessage), aThrowable);
            } else {
                this.myLogger.warn(aMarker, this.updateMessage(aMessage));
            }
            this.clearMarker();
            this.clearLineNumber(closeable);
        }
    }

    public void warn(Marker aMarker, String aMessage, Object a1stDetail, Object a2ndDetail) {
        if (this.isWarnEnabled()) {
            MDC.MDCCloseable closeable = this.setDebugLineNumber();
            String detail1 = a1stDetail.toString();
            String detail2 = a2ndDetail.toString();
            this.addMarker(aMarker);
            if (this.hasI18nKey(aMessage)) {
                this.myLogger.warn(aMarker, this.updateMessage(this.getI18n(aMessage)), (Object)this.updateMessage(detail1), (Object)this.updateMessage(detail2));
            } else {
                this.myLogger.warn(aMarker, this.updateMessage(aMessage), (Object)this.updateMessage(detail1), (Object)this.updateMessage(detail2));
            }
            this.clearMarker();
            this.clearLineNumber(closeable);
        }
    }

    public String getMessage(String aMessage, Object ... aDetails) {
        if (this.hasI18nKey(aMessage)) {
            return this.getI18n(aMessage, aDetails);
        }
        if (aDetails.length == 0) {
            return aMessage;
        }
        return StringUtils.format(aMessage, aDetails);
    }

    public String getMessage(Marker aMarker, String aMessage, Object ... aDetails) {
        String[] details = new String[aDetails.length];
        this.addMarker(aMarker);
        for (int index = 0; index < details.length; ++index) {
            details[index] = this.updateMessage(aDetails[index].toString());
        }
        String message = this.hasI18nKey(aMessage) ? this.updateMessage(this.getI18n(aMessage, details)) : (details.length == 0 ? this.updateMessage(aMessage) : this.updateMessage(StringUtils.format(aMessage, details)));
        this.clearMarker();
        return message;
    }

    public org.slf4j.Logger getLoggerImpl() {
        return this.myLogger;
    }

    private MDC.MDCCloseable setDebugLineNumber() {
        if (this.isDebugEnabled()) {
            return this.setLineNumber();
        }
        return null;
    }

    private MDC.MDCCloseable setLineNumber() {
        int lineNum = Thread.currentThread().getStackTrace()[3].getLineNumber();
        return MDC.putCloseable((String)LINE_NUM, (String)Integer.toString(lineNum));
    }

    private void clearLineNumber(MDC.MDCCloseable aCloseable) {
        if (aCloseable != null) {
            aCloseable.close();
        }
    }

    private void addMarker(Marker aMarker) {
        if (aMarker.contains("eol-to-space")) {
            MDC.put((String)"eol-to-space", (String)Boolean.TRUE.toString());
        } else if (aMarker.contains("eol-to-crlf")) {
            MDC.put((String)"eol-to-crlf", (String)Boolean.TRUE.toString());
        } else if (aMarker.contains("eol-to-cr")) {
            MDC.put((String)"eol-to-cr", (String)Boolean.TRUE.toString());
        } else if (aMarker.contains("eol-to-lf")) {
            MDC.put((String)"eol-to-lf", (String)Boolean.TRUE.toString());
        }
    }

    private String updateMessage(String aMessage) {
        if (MDC.get((String)"eol-to-space") != null) {
            return aMessage.replaceAll(EOL_RE, " ");
        }
        if (MDC.get((String)"eol-to-crlf") != null) {
            return aMessage.replaceAll(EOL_RE, "\r\n");
        }
        if (MDC.get((String)"eol-to-cr") != null) {
            return aMessage.replaceAll(EOL_RE, "\r");
        }
        if (MDC.get((String)"eol-to-lf") != null) {
            return aMessage.replaceAll(EOL_RE, "\n");
        }
        return aMessage;
    }

    private void clearMarker() {
        if (MDC.get((String)"eol-to-space") != null) {
            MDC.remove((String)"eol-to-space");
        } else if (MDC.get((String)"eol-to-crlf") != null) {
            MDC.remove((String)"eol-to-crlf");
        } else if (MDC.get((String)"eol-to-lf") != null) {
            MDC.remove((String)"eol-to-lf");
        } else if (MDC.get((String)"eol-to-cr") != null) {
            MDC.remove((String)"eol-to-cr");
        }
    }
}

