/*
 * Decompiled with CFR 0.152.
 */
package info.freelibrary.util;

import java.io.File;
import java.io.FilenameFilter;
import java.util.regex.Pattern;

public class RegexFileFilter
implements FilenameFilter {
    private Pattern myPattern;

    public RegexFileFilter(String aPattern) {
        this(aPattern, false);
    }

    public RegexFileFilter(String aPattern, boolean aCaseInsensitivePattern) {
        this.myPattern = aCaseInsensitivePattern ? Pattern.compile(aPattern, 2) : Pattern.compile(aPattern);
    }

    @Override
    public boolean accept(File aDir, String aFilename) {
        return new File(aDir, aFilename).isFile() && this.myPattern.matcher(aFilename).matches();
    }

    public String toString() {
        return this.myPattern.pattern();
    }
}

