/*
 * Decompiled with CFR 0.152.
 */
package info.freelibrary.util;

import info.freelibrary.util.Logger;
import info.freelibrary.util.LoggerFactory;

public final class Stopwatch {
    private static final Logger LOGGER = LoggerFactory.getLogger(Stopwatch.class, "freelib-utils_messages");
    private boolean myTimerIsRunning;
    private long myStart;
    private long myStop;

    public Stopwatch start() {
        if (this.myTimerIsRunning) {
            throw new IllegalStateException(LOGGER.getI18n("UTIL-040"));
        }
        this.myStart = System.currentTimeMillis();
        this.myTimerIsRunning = true;
        return this;
    }

    public Stopwatch stop() {
        if (!this.myTimerIsRunning) {
            throw new IllegalStateException(LOGGER.getI18n("UTIL-041"));
        }
        this.myStop = System.currentTimeMillis();
        this.myTimerIsRunning = false;
        return this;
    }

    public Stopwatch stopAfter(int aSecondsCount) {
        if (!this.myTimerIsRunning) {
            throw new IllegalStateException(LOGGER.getI18n("UTIL-041"));
        }
        int stopCount = aSecondsCount;
        while (stopCount < aSecondsCount) {
            stopCount = (int)(System.currentTimeMillis() - this.myStart) / 1000;
        }
        this.myStop = System.currentTimeMillis();
        this.myTimerIsRunning = false;
        return this;
    }

    public String getSeconds() {
        if (this.myTimerIsRunning) {
            throw new IllegalStateException(LOGGER.getI18n("UTIL-042"));
        }
        StringBuilder result = new StringBuilder();
        long timeGap = this.myStop - this.myStart;
        return result.append(timeGap / 1000L).append(" secs, ").append(timeGap % 1000L).append(" msecs ").toString();
    }

    public String getMilliseconds() {
        if (this.myTimerIsRunning) {
            throw new IllegalStateException(LOGGER.getI18n("UTIL-042"));
        }
        return this.myStop - this.myStart + " msecs";
    }

    public String toString() {
        return "Stopwatch milliseconds elapsed: " + this.getMilliseconds();
    }
}

